/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.ApiContract;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.exceptions.ApiRetiredException;
import io.apiman.gateway.engine.beans.exceptions.ClientNotFoundException;
import io.apiman.gateway.engine.beans.exceptions.NoContractFoundException;
import io.apiman.gateway.engine.es.EsRegistry;
import io.apiman.gateway.engine.es.i18n.Messages;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class CachingEsRegistry
extends EsRegistry {
    private Map<String, Api> apiCache = new ConcurrentHashMap<String, Api>();
    private Map<String, Client> clientCache = new ConcurrentHashMap<String, Client>();
    private Object mutex = new Object();

    public CachingEsRegistry(Map<String, String> config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateCache() {
        Object object = this.mutex;
        synchronized (object) {
            this.clientCache.clear();
            this.apiCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getContract(String apiOrganizationId, String apiId, String apiVersion, String apiKey, IAsyncResultHandler<ApiContract> handler) {
        Client client = null;
        Api api = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                client = this.getClient(apiKey);
                api = this.getApi(apiOrganizationId, apiId, apiVersion);
            }
            if (client == null) {
                ClientNotFoundException error = new ClientNotFoundException(Messages.i18n.format("EsRegistry.NoClientForAPIKey", new Object[]{apiKey}));
                handler.handle((Object)AsyncResultImpl.create((Throwable)error, ApiContract.class));
                return;
            }
            if (api == null) {
                throw new ApiRetiredException(Messages.i18n.format("EsRegistry.ApiWasRetired", new Object[]{apiId, apiOrganizationId}));
            }
            Contract matchedContract = null;
            for (Contract contract : client.getContracts()) {
                if (!contract.matches(apiOrganizationId, apiId, apiVersion)) continue;
                matchedContract = contract;
                break;
            }
            if (matchedContract == null) {
                throw new NoContractFoundException(Messages.i18n.format("EsRegistry.NoContractFound", new Object[]{client.getClientId(), api.getApiId()}));
            }
            ApiContract contract = new ApiContract(api, client, matchedContract.getPlan(), matchedContract.getPolicies());
            handler.handle((Object)AsyncResultImpl.create((Object)contract));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, ApiContract.class));
        }
    }

    @Override
    public void getApi(String organizationId, String apiId, String apiVersion, IAsyncResultHandler<Api> handler) {
        try {
            Api api = this.getApi(organizationId, apiId, apiVersion);
            handler.handle((Object)AsyncResultImpl.create((Object)api));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Api.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Api getApi(String orgId, String apiId, String version) throws IOException {
        Api api;
        String apiIdx = this.getApiIdx(orgId, apiId, version);
        Object object = this.mutex;
        synchronized (object) {
            api = this.apiCache.get(apiIdx);
        }
        if (api == null) {
            api = super.getApi(this.getApiId(orgId, apiId, version));
            object = this.mutex;
            synchronized (object) {
                if (api != null) {
                    this.apiCache.put(apiIdx, api);
                }
            }
        }
        return api;
    }

    @Override
    public void getClient(String apiKey, IAsyncResultHandler<Client> handler) {
        try {
            Client client = this.getClient(apiKey);
            handler.handle((Object)AsyncResultImpl.create((Object)client));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Client.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Client getClient(String apiKey) throws IOException {
        Client client;
        Object object = this.mutex;
        synchronized (object) {
            client = this.clientCache.get(apiKey);
        }
        if (client == null) {
            client = super.getClient(apiKey);
            object = this.mutex;
            synchronized (object) {
                if (client != null) {
                    this.clientCache.put(apiKey, client);
                }
            }
        }
        return client;
    }

    private String getApiIdx(String orgId, String apiId, String version) {
        return "API::" + orgId + "|" + apiId + "|" + version;
    }
}

