/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.common.es.util.AbstractEsComponent;
import io.apiman.gateway.engine.DependsOnComponents;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IBufferFactoryComponent;
import io.apiman.gateway.engine.components.ICacheStoreComponent;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalReadStream;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.apiman.gateway.engine.storage.model.CacheEntry;
import io.apiman.gateway.engine.storage.util.BackingStoreUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.xcontent.XContentType;

@DependsOnComponents(value={IBufferFactoryComponent.class})
public class EsCacheStoreComponent
extends AbstractEsComponent
implements ICacheStoreComponent {
    private IBufferFactoryComponent bufferFactory;

    public EsCacheStoreComponent(Map<String, String> config) {
        super(config);
    }

    public void setBufferFactory(IBufferFactoryComponent bufferFactory) {
        this.bufferFactory = bufferFactory;
    }

    public <T> void put(String cacheKey, T jsonObject, long timeToLive) throws IOException {
        CacheEntry entry = new CacheEntry();
        entry.setData(null);
        entry.setExpiresOn(System.currentTimeMillis() + timeToLive * 1000L);
        entry.setHead(BackingStoreUtil.JSON_MAPPER.writeValueAsString((Object)entry));
        IndexRequest indexRequest = new IndexRequest(this.getFullIndexName()).source(BackingStoreUtil.JSON_MAPPER.writeValueAsBytes((Object)entry), XContentType.JSON).id(cacheKey);
        try {
            this.getClient().index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public <T> ISignalWriteStream putBinary(final String cacheKey, T jsonObject, long timeToLive) throws IOException {
        final CacheEntry entry = new CacheEntry();
        entry.setExpiresOn(System.currentTimeMillis() + timeToLive * 1000L);
        entry.setHead(BackingStoreUtil.JSON_MAPPER.writeValueAsString(jsonObject));
        final IApimanBuffer data = this.bufferFactory.createBuffer();
        return new ISignalWriteStream(){
            boolean finished = false;
            boolean aborted = false;

            public void abort(Throwable t) {
                this.finished = true;
                this.aborted = false;
            }

            public boolean isFinished() {
                return this.finished;
            }

            public void write(IApimanBuffer chunk) {
                data.append(chunk);
            }

            public void end() {
                if (!this.aborted) {
                    entry.setData(Base64.encodeBase64String((byte[])data.getBytes()));
                    try {
                        IndexRequest indexRequest = new IndexRequest(EsCacheStoreComponent.this.getFullIndexName()).source(BackingStoreUtil.JSON_MAPPER.writeValueAsBytes((Object)entry), XContentType.JSON).id(cacheKey);
                        EsCacheStoreComponent.this.getClient().index(indexRequest, RequestOptions.DEFAULT);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.finished = true;
            }
        };
    }

    public <T> void get(String cacheKey, Class<T> type, IAsyncResultHandler<T> handler) {
        try {
            GetResponse response = this.getClient().get(new GetRequest(this.getFullIndexName()).id(cacheKey), RequestOptions.DEFAULT);
            if (response.isExists()) {
                String sourceAsString = response.getSourceAsString();
                CacheEntry cacheEntry = (CacheEntry)BackingStoreUtil.JSON_MAPPER.readValue(sourceAsString, CacheEntry.class);
                try {
                    Object rval = BackingStoreUtil.JSON_MAPPER.reader(type).readValue(cacheEntry.getHead());
                    handler.handle((Object)AsyncResultImpl.create((Object)rval));
                }
                catch (IOException e) {
                    handler.handle((Object)AsyncResultImpl.create(null));
                }
            } else {
                handler.handle((Object)AsyncResultImpl.create(null));
            }
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, type));
        }
    }

    public <T> void getBinary(String cacheKey, Class<T> type, IAsyncResultHandler<ISignalReadStream<T>> handler) {
        try {
            GetResponse response = this.getClient().get(new GetRequest(this.getFullIndexName()).id(cacheKey), RequestOptions.DEFAULT);
            if (!response.isExists()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
                return;
            }
            String sourceAsString = response.getSourceAsString();
            CacheEntry cacheEntry = (CacheEntry)BackingStoreUtil.JSON_MAPPER.readValue(sourceAsString, CacheEntry.class);
            if (System.currentTimeMillis() > cacheEntry.getExpiresOn()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
                return;
            }
            try {
                final Object head = BackingStoreUtil.JSON_MAPPER.reader(type).readValue(cacheEntry.getHead());
                String b64Data = cacheEntry.getData();
                final IApimanBuffer data = this.bufferFactory.createBuffer(Base64.decodeBase64((String)b64Data));
                ISignalReadStream rval = new ISignalReadStream<T>(){
                    IAsyncHandler<IApimanBuffer> bodyHandler;
                    IAsyncHandler<Void> endHandler;
                    boolean finished = false;
                    boolean aborted = false;

                    public void bodyHandler(IAsyncHandler<IApimanBuffer> bodyHandler) {
                        this.bodyHandler = bodyHandler;
                    }

                    public void endHandler(IAsyncHandler<Void> endHandler) {
                        this.endHandler = endHandler;
                    }

                    public T getHead() {
                        return head;
                    }

                    public boolean isFinished() {
                        return this.finished;
                    }

                    public void abort(Throwable t) {
                        this.finished = true;
                        this.aborted = true;
                    }

                    public void transmit() {
                        if (!this.aborted) {
                            this.bodyHandler.handle((Object)data);
                            this.endHandler.handle(null);
                        }
                        this.finished = true;
                    }
                };
                handler.handle((Object)AsyncResultImpl.create((Object)rval));
            }
            catch (Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
    }

    protected String getDefaultIndexPrefix() {
        return "apiman_cache";
    }

    protected List<String> getDefaultIndices() {
        String[] indices = new String[]{"cacheEntry"};
        return Arrays.asList(indices);
    }

    private String getFullIndexName() {
        return (this.getIndexPrefix() + "cacheEntry").toLowerCase();
    }
}

