/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apiman.common.es.util.AbstractEsComponent;
import io.apiman.common.logging.DefaultDelegateFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.es.PollCachingEsRegistry;
import io.apiman.gateway.engine.metrics.RequestMetric;
import io.apiman.gateway.engine.storage.util.BackingStoreUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.xcontent.XContentType;

public class EsMetrics
extends AbstractEsComponent
implements IMetrics {
    private static final int DEFAULT_QUEUE_SIZE = 10000;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    protected IComponentRegistry componentRegistry;
    private final BlockingQueue<RequestMetric> queue;
    private final int batchSize;
    private IApimanLogger logger = new DefaultDelegateFactory().createLogger(PollCachingEsRegistry.class);

    public EsMetrics(Map<String, String> config) {
        super(config);
        int queueSize = 10000;
        String queueSizeConfig = config.get("queue.size");
        if (queueSizeConfig != null) {
            queueSize = new Integer(queueSizeConfig);
        }
        this.queue = new LinkedBlockingDeque<RequestMetric>(queueSize);
        int batchSize = 1000;
        String batchSizeConfig = config.get("batch.size");
        if (batchSizeConfig != null) {
            batchSize = new Integer(batchSizeConfig);
        }
        this.batchSize = batchSize;
        this.startConsumerThread();
    }

    public void setComponentRegistry(IComponentRegistry registry) {
        this.componentRegistry = registry;
    }

    public void record(RequestMetric metric) {
        try {
            this.queue.put(metric);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startConsumerThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (Boolean.TRUE.booleanValue()) {
                    EsMetrics.this.processQueue();
                }
            }
        }, "EsMetricsConsumer");
        thread.setDaemon(true);
        thread.start();
    }

    protected void processQueue() {
        try {
            ArrayList<RequestMetric> batch = new ArrayList<RequestMetric>(this.batchSize);
            RequestMetric rm = this.queue.take();
            batch.add(rm);
            this.queue.drainTo(batch, this.batchSize - 1);
            BulkRequest request = new BulkRequest();
            for (RequestMetric metric : batch) {
                IndexRequest index = new IndexRequest(this.getDefaultIndexPrefix());
                index.source(BackingStoreUtil.JSON_MAPPER.writeValueAsString((Object)metric), XContentType.JSON);
                request.add(index);
            }
            ActionListener<BulkResponse> listener = new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse bulkItemResponses) {
                }

                public void onFailure(Exception e) {
                    EsMetrics.this.logger.error("Failed to add metric(s) to ES", (Throwable)e);
                }
            };
            this.getClient().bulkAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
        }
        catch (JsonProcessingException | InterruptedException e) {
            this.logger.error("Failed to add metric(s) to ES", e);
        }
    }

    protected String getDefaultIndexPrefix() {
        return "apiman_metrics";
    }

    protected List<String> getDefaultIndices() {
        String[] indices = new String[]{""};
        return Arrays.asList(indices);
    }
}

