/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.common.es.util.AbstractEsComponent;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.rate.RateLimitResponse;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import io.apiman.gateway.engine.storage.util.BackingStoreUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;

public class EsRateLimiterComponent
extends AbstractEsComponent
implements IRateLimiterComponent {
    public EsRateLimiterComponent(Map<String, String> config) {
        super(config);
    }

    public void accept(String bucketId, RateBucketPeriod period, long limit, long increment, IAsyncResultHandler<RateLimitResponse> handler) {
        String id = this.id(bucketId);
        try {
            RateLimiterBucket bucket;
            long version;
            GetResponse response = this.getClient().get(new GetRequest(this.getFullIndexName()).id(id), RequestOptions.DEFAULT);
            if (response.isExists()) {
                version = response.getVersion();
                String sourceAsString = response.getSourceAsString();
                bucket = (RateLimiterBucket)BackingStoreUtil.JSON_MAPPER.readValue(sourceAsString, RateLimiterBucket.class);
            } else {
                version = 0L;
                bucket = new RateLimiterBucket();
            }
            bucket.resetIfNecessary(period);
            RateLimitResponse rlr = new RateLimitResponse();
            if (bucket.getCount() > limit) {
                rlr.setAccepted(false);
            } else {
                rlr.setAccepted(bucket.getCount() < limit);
                bucket.setCount(bucket.getCount() + increment);
                bucket.setLast(System.currentTimeMillis());
            }
            int reset = (int)(bucket.getResetMillis(period) / 1000L);
            rlr.setReset((long)reset);
            rlr.setRemaining(limit - bucket.getCount());
            this.updateBucketAndReturn(id, bucket, rlr, version, bucketId, period, limit, increment, handler);
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, RateLimitResponse.class));
        }
    }

    protected void updateBucketAndReturn(String id, RateLimiterBucket bucket, RateLimitResponse rlr, long version, String bucketId, RateBucketPeriod period, long limit, long increment, IAsyncResultHandler<RateLimitResponse> handler) {
        try {
            IndexRequest indexRequest = new IndexRequest(this.getFullIndexName()).source(BackingStoreUtil.JSON_MAPPER.writeValueAsBytes((Object)bucket), XContentType.JSON).id(id);
            IndexResponse response = this.getClient().index(indexRequest, RequestOptions.DEFAULT);
            if (!response.status().equals((Object)RestStatus.CREATED) && !response.status().equals((Object)RestStatus.OK) && response.status().equals((Object)RestStatus.CONFLICT)) {
                this.accept(bucketId, period, limit, increment, handler);
            } else {
                handler.handle((Object)AsyncResultImpl.create((Object)rlr));
            }
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private String id(String bucketId) {
        return Base64.encodeBase64String((byte[])bucketId.getBytes());
    }

    protected String getDefaultIndexPrefix() {
        return "apiman_gateway";
    }

    protected List<String> getDefaultIndices() {
        String[] indices = new String[]{"ratebucket"};
        return Arrays.asList(indices);
    }

    private String getFullIndexName() {
        return this.getIndexPrefix() + "ratebucket";
    }
}

