/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.common.es.util.AbstractEsComponent;
import io.apiman.common.es.util.EsUtils;
import io.apiman.common.logging.DefaultDelegateFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.ApiContract;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.exceptions.ApiNotFoundException;
import io.apiman.gateway.engine.beans.exceptions.ApiRetiredException;
import io.apiman.gateway.engine.beans.exceptions.ClientNotFoundException;
import io.apiman.gateway.engine.beans.exceptions.NoContractFoundException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.es.i18n.Messages;
import io.apiman.gateway.engine.storage.util.BackingStoreUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class EsRegistry
extends AbstractEsComponent
implements IRegistry {
    private IApimanLogger logger = new DefaultDelegateFactory().createLogger(EsRegistry.class);

    public EsRegistry(Map<String, String> config) {
        super(config);
    }

    public void publishApi(Api api, IAsyncResultHandler<Void> handler) {
        try {
            String id = this.getApiId(api);
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(this.getIndexPrefix() + "apis").id(id).source(BackingStoreUtil.JSON_MAPPER.writeValueAsBytes((Object)api), XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            IndexResponse response = this.getClient().index(indexRequest, RequestOptions.DEFAULT);
            if (!response.status().equals((Object)RestStatus.CREATED) && !response.status().equals((Object)RestStatus.OK)) {
                throw new IOException(response.getResult().toString());
            }
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("EsRegistry.ErrorPublishingApi", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void retireApi(Api api, IAsyncResultHandler<Void> handler) {
        String id = this.getApiId(api);
        try {
            DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(this.getIndexPrefix() + "apis").id(id).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            DeleteResponse response = this.getClient().delete(deleteRequest, RequestOptions.DEFAULT);
            if (response.status().equals((Object)RestStatus.OK)) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            } else {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new ApiNotFoundException(Messages.i18n.format("EsRegistry.ApiNotFound", new Object[0]))));
            }
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("EsRegistry.ErrorRetiringApi", new Object[0]), (Throwable)e)));
        }
    }

    public void registerClient(Client client, IAsyncResultHandler<Void> handler) {
        try {
            this.validateClient(client);
            String id = this.getClientId(client);
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(this.getIndexPrefix() + "clients").source(BackingStoreUtil.JSON_MAPPER.writeValueAsBytes((Object)client), XContentType.JSON).id(id).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            IndexResponse response = this.getClient().index(indexRequest, RequestOptions.DEFAULT);
            if (!response.status().equals((Object)RestStatus.CREATED) && !response.status().equals((Object)RestStatus.OK)) {
                throw new IOException("Response status was " + response.status() + " instead of " + RestStatus.CREATED + " or " + RestStatus.OK);
            }
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("EsRegistry.ErrorRegisteringClient", new Object[0]), (Throwable)e), Void.class));
        }
        catch (RuntimeException re) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)re, Void.class));
        }
    }

    private void validateClient(Client client) throws RegistrationException {
        Set contracts = client.getContracts();
        if (contracts.isEmpty()) {
            throw new NoContractFoundException(Messages.i18n.format("EsRegistry.NoContracts", new Object[0]));
        }
        for (Contract contract : contracts) {
            this.validateContract(contract);
        }
    }

    private void validateContract(Contract contract) throws RegistrationException {
        String id = this.getApiId(contract);
        try {
            GetRequest getRequest = new GetRequest(this.getIndexPrefix() + "apis").id(id);
            GetResponse response = this.getClient().get(getRequest, RequestOptions.DEFAULT);
            if (!response.isExists()) {
                String apiId = contract.getApiId();
                String orgId = contract.getApiOrgId();
                throw new ApiNotFoundException(Messages.i18n.format("EsRegistry.ApiNotFoundInOrg", new Object[]{apiId, orgId}));
            }
        }
        catch (IOException e) {
            throw new RegistrationException(Messages.i18n.format("EsRegistry.ErrorValidatingClient", new Object[0]), (Throwable)e);
        }
    }

    public void unregisterClient(Client client, IAsyncResultHandler<Void> handler) {
        try {
            Client lclient = this.lookupClient(client.getOrganizationId(), client.getClientId(), client.getVersion());
            String id = this.getClientId(lclient);
            DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(this.getIndexPrefix() + "clients").id(id).setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            DeleteResponse response = this.getClient().delete(deleteRequest, RequestOptions.DEFAULT);
            if (response.status().equals((Object)RestStatus.OK)) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            } else {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new ApiNotFoundException(Messages.i18n.format("EsRegistry.ClientNotFound", new Object[0]))));
            }
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("EsRegistry.ErrorUnregisteringClient", new Object[0]), (Throwable)e), Void.class));
        }
        catch (RuntimeException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private Client lookupClient(String orgId, String clientId, String version) {
        Client client;
        String query = "{  \"query\": {        \"bool\": {            \"filter\": [{                    \"term\": {                        \"organizationId\": \"{{organizationId}}\"                     }          },          {                    \"term\": {                        \"clientId\": \"{{clientId}}\"                     }          },          {                    \"term\": {                        \"version\": \"{{version}}\"           }      }            ]    }  }}";
        SearchTemplateRequest searchTemplateRequest = new SearchTemplateRequest();
        searchTemplateRequest.setRequest(new SearchRequest(new String[]{this.getIndexPrefix() + "clients"}));
        searchTemplateRequest.setScriptType(ScriptType.INLINE);
        searchTemplateRequest.setScript(query);
        HashMap<String, String> scriptParams = new HashMap<String, String>();
        scriptParams.put("organizationId", orgId);
        scriptParams.put("clientId", clientId);
        scriptParams.put("version", version);
        searchTemplateRequest.setScriptParams(scriptParams);
        try {
            SearchTemplateResponse response = this.getClient().searchTemplate(searchTemplateRequest, RequestOptions.DEFAULT);
            SearchResponse searchResponse = response.getResponse();
            SearchHits hits = searchResponse.getHits();
            if (hits.getTotalHits().value < 0L) {
                throw new IOException("No result hits found");
            }
            String sourceAsString = response.getResponse().getHits().getAt(0).getSourceAsString();
            client = (Client)BackingStoreUtil.JSON_MAPPER.readValue(sourceAsString, Client.class);
        }
        catch (IOException e) {
            throw new ClientNotFoundException(Messages.i18n.format("EsRegistry.ClientNotFound", new Object[0]), (Exception)e);
        }
        return client;
    }

    public void getApi(String organizationId, String apiId, String apiVersion, IAsyncResultHandler<Api> handler) {
        String id = this.getApiId(organizationId, apiId, apiVersion);
        try {
            Api api = this.getApi(id);
            handler.handle((Object)AsyncResultImpl.create((Object)api));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Api.class));
        }
    }

    public void getClient(String organizationId, String clientId, String clientVersion, IAsyncResultHandler<Client> handler) {
        try {
            Client client = this.lookupClient(organizationId, clientId, clientVersion);
            handler.handle((Object)AsyncResultImpl.create((Object)client));
        }
        catch (ClientNotFoundException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Client.class));
        }
    }

    protected Api getApi(String id) throws IOException {
        GetRequest getRequest = new GetRequest(this.getIndexPrefix() + "apis", id);
        GetResponse result = this.getClient().get(getRequest, RequestOptions.DEFAULT);
        if (result.isExists()) {
            Api api = (Api)BackingStoreUtil.JSON_MAPPER.readValue(result.getSourceAsString(), Api.class);
            return api;
        }
        return null;
    }

    public void getClient(String apiKey, IAsyncResultHandler<Client> handler) {
        String id = apiKey;
        try {
            Client client = this.getClient(id);
            handler.handle((Object)AsyncResultImpl.create((Object)client));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Client.class));
        }
    }

    protected Client getClient(String id) throws IOException {
        GetRequest getRequest = new GetRequest(this.getIndexPrefix() + "clients", id);
        GetResponse result = this.getClient().get(getRequest, RequestOptions.DEFAULT);
        if (result.isExists()) {
            Client client = (Client)BackingStoreUtil.JSON_MAPPER.readValue(result.getSourceAsString(), Client.class);
            return client;
        }
        return null;
    }

    public void getContract(String apiOrganizationId, String apiId, String apiVersion, String apiKey, IAsyncResultHandler<ApiContract> handler) {
        try {
            Client client = this.getClient(apiKey);
            Api api = this.getApi(this.getApiId(apiOrganizationId, apiId, apiVersion));
            if (client == null) {
                ClientNotFoundException error = new ClientNotFoundException(Messages.i18n.format("EsRegistry.NoClientForAPIKey", new Object[]{apiKey}));
                handler.handle((Object)AsyncResultImpl.create((Throwable)error, ApiContract.class));
                return;
            }
            if (api == null) {
                ApiRetiredException error = new ApiRetiredException(Messages.i18n.format("EsRegistry.ApiWasRetired", new Object[]{apiId, apiOrganizationId}));
                handler.handle((Object)AsyncResultImpl.create((Throwable)error, ApiContract.class));
                return;
            }
            Contract matchedContract = null;
            for (Contract contract : client.getContracts()) {
                if (!contract.matches(apiOrganizationId, apiId, apiVersion)) continue;
                matchedContract = contract;
                break;
            }
            if (matchedContract == null) {
                NoContractFoundException error = new NoContractFoundException(Messages.i18n.format("EsRegistry.NoContractFound", new Object[]{client.getClientId(), api.getApiId()}));
                handler.handle((Object)AsyncResultImpl.create((Throwable)error, ApiContract.class));
                return;
            }
            ApiContract contract = new ApiContract(api, client, matchedContract.getPlan(), matchedContract.getPolicies());
            handler.handle((Object)AsyncResultImpl.create((Object)contract));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, ApiContract.class));
        }
    }

    public void listClients(String organizationId, int page, int pageSize, IAsyncResultHandler<List<String>> handler) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            MatchQueryBuilder query = QueryBuilders.matchQuery((String)"organizationId", (Object)organizationId);
            TermsAggregationBuilder aggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)"clients").field("clientId");
            SearchResponse searchResponse = this.getClient().search(new SearchRequest(new String[]{this.getIndexPrefix() + "clients"}).source(searchSourceBuilder.query((QueryBuilder)query).aggregation((AggregationBuilder)aggregation)), RequestOptions.DEFAULT);
            List terms = ((ParsedTerms)searchResponse.getAggregations().asMap().get("clients")).getBuckets();
            List results = terms.stream().map(o -> ((ParsedTerms.ParsedBucket)o).getKey()).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void listApis(String organizationId, int page, int pageSize, IAsyncResultHandler<List<String>> handler) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            MatchQueryBuilder query = QueryBuilders.matchQuery((String)"organizationId", (Object)organizationId);
            TermsAggregationBuilder aggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)"apis").field("apiId");
            SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexPrefix() + "apis"}).source(searchSourceBuilder.query((QueryBuilder)query).aggregation((AggregationBuilder)aggregation));
            SearchResponse searchResponse = this.getClient().search(searchRequest, RequestOptions.DEFAULT);
            List terms = ((ParsedTerms)searchResponse.getAggregations().asMap().get("apis")).getBuckets();
            List results = terms.stream().map(o -> ((ParsedTerms.ParsedBucket)o).getKey()).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void listOrgs(IAsyncResultHandler<List<String>> handler) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder aggregation = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_orgs").field("organizationId");
            String[] indices = new String[]{this.getIndexPrefix() + "apis", this.getIndexPrefix() + "clients"};
            SearchRequest searchRequest = new SearchRequest(indices).source(searchSourceBuilder.aggregation((AggregationBuilder)aggregation));
            SearchResponse searchResponse = this.getClient().search(searchRequest, RequestOptions.DEFAULT);
            List terms = ((ParsedTerms)searchResponse.getAggregations().asMap().get("all_orgs")).getBuckets();
            List results = terms.stream().map(o -> ((ParsedTerms.ParsedBucket)o).getKey()).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void listClientVersions(String organizationId, String clientId, int page, int pageSize, IAsyncResultHandler<List<String>> handler) {
        String query = "{  \"query\": {    \"bool\": {      \"filter\": [        {          \"term\": {            \"organizationId\": \"{{organizationId}}\"          }        },        {          \"term\": {            \"clientId\": \"{{clientId}}\"          }        }      ]    }  },    \"aggs\": {      \"client_versions\": {        \"terms\": {          \"field\": \"version\"        }      }    }}";
        SearchTemplateRequest searchTemplateRequest = new SearchTemplateRequest();
        searchTemplateRequest.setRequest(new SearchRequest(new String[]{this.getIndexPrefix() + "clients"}));
        searchTemplateRequest.setScriptType(ScriptType.INLINE);
        searchTemplateRequest.setScript(query);
        HashMap<String, String> scriptParams = new HashMap<String, String>();
        scriptParams.put("organizationId", organizationId);
        scriptParams.put("clientId", clientId);
        searchTemplateRequest.setScriptParams(scriptParams);
        try {
            SearchTemplateResponse response = this.getClient().searchTemplate(searchTemplateRequest, RequestOptions.DEFAULT);
            SearchResponse searchResponse = response.getResponse();
            List terms = ((ParsedTerms)searchResponse.getAggregations().asMap().get("client_versions")).getBuckets();
            List results = terms.stream().map(o -> ((ParsedTerms.ParsedBucket)o).getKey()).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void listApiVersions(String organizationId, String apiId, int page, int pageSize, IAsyncResultHandler<List<String>> handler) {
        String query = "{  \"query\": {    \"bool\": {      \"filter\": [        {          \"term\": {            \"organizationId\": \"{{organizationId}}\"          }        },        {          \"term\": {            \"apiId\": \"{{apiId}}\"          }        }      ]    }  },    \"aggs\": {      \"api_versions\": {        \"terms\": {          \"field\": \"version\"        }      }    }}";
        SearchTemplateRequest searchTemplateRequest = new SearchTemplateRequest();
        searchTemplateRequest.setRequest(new SearchRequest(new String[]{this.getIndexPrefix() + "apis"}));
        searchTemplateRequest.setScriptType(ScriptType.INLINE);
        searchTemplateRequest.setScript(query);
        HashMap<String, String> scriptParams = new HashMap<String, String>();
        scriptParams.put("organizationId", organizationId);
        scriptParams.put("apiId", apiId);
        searchTemplateRequest.setScriptParams(scriptParams);
        try {
            SearchTemplateResponse response = this.getClient().searchTemplate(searchTemplateRequest, RequestOptions.DEFAULT);
            SearchResponse searchResponse = response.getResponse();
            List terms = ((ParsedTerms)searchResponse.getAggregations().asMap().get("api_versions")).getBuckets();
            List results = terms.stream().map(o -> ((ParsedTerms.ParsedBucket)o).getKey()).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getApiId(Api api) {
        return this.getApiId(api.getOrganizationId(), api.getApiId(), api.getVersion());
    }

    private String getApiId(Contract contract) {
        return this.getApiId(contract.getApiOrgId(), contract.getApiId(), contract.getApiVersion());
    }

    protected String getApiId(String orgId, String apiId, String version) {
        return EsUtils.escape((String)(orgId + ":" + apiId + ":" + version));
    }

    protected String getClientId(Client client) {
        return client.getApiKey();
    }

    protected String getDefaultIndexPrefix() {
        return "apiman_gateway";
    }

    protected List<String> getDefaultIndices() {
        String[] indices = new String[]{"apis", "clients"};
        return Arrays.asList(indices);
    }
}

