/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.common.es.util.AbstractEsComponent;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.es.beans.PrimitiveBean;
import io.apiman.gateway.engine.storage.util.BackingStoreUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.xcontent.XContentType;

public class EsSharedStateComponent
extends AbstractEsComponent
implements ISharedStateComponent {
    public EsSharedStateComponent(Map<String, String> config) {
        super(config);
    }

    public <T> void getProperty(String namespace, String propertyName, T defaultValue, IAsyncResultHandler<T> handler) {
        if (defaultValue == null) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new Exception("Null defaultValue is not allowed.")));
            return;
        }
        String id = this.getPropertyId(namespace, propertyName);
        try {
            GetResponse response = this.getClient().get(new GetRequest(this.getFullIndexName()).id(id), RequestOptions.DEFAULT);
            if (response.isExists()) {
                try {
                    Object value;
                    if (defaultValue.getClass().isPrimitive() || defaultValue instanceof String) {
                        value = this.readPrimitive(response);
                    } else {
                        String sourceAsString = response.getSourceAsString();
                        value = BackingStoreUtil.JSON_MAPPER.readValue(sourceAsString, defaultValue.getClass());
                    }
                    handler.handle((Object)AsyncResultImpl.create((Object)value));
                }
                catch (Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e));
                }
            } else {
                handler.handle((Object)AsyncResultImpl.create(defaultValue));
            }
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public <T> void setProperty(String namespace, String propertyName, T value, IAsyncResultHandler<Void> handler) {
        String source;
        if (value == null) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new Exception("Null value is not allowed.")));
            return;
        }
        try {
            if (value.getClass().isPrimitive() || value instanceof String) {
                PrimitiveBean pb = new PrimitiveBean();
                pb.setValue(String.valueOf(value));
                pb.setType(value.getClass().getName());
                source = BackingStoreUtil.JSON_MAPPER.writeValueAsString((Object)pb);
            } else {
                source = BackingStoreUtil.JSON_MAPPER.writeValueAsString(value);
            }
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            return;
        }
        String id = this.getPropertyId(namespace, propertyName);
        String json = source;
        IndexRequest indexRequest = new IndexRequest(this.getFullIndexName()).source(json, XContentType.JSON).id(id);
        try {
            this.getClient().index(indexRequest, RequestOptions.DEFAULT);
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public <T> void clearProperty(String namespace, String propertyName, IAsyncResultHandler<Void> handler) {
        String id = this.getPropertyId(namespace, propertyName);
        DeleteRequest deleteRequest = new DeleteRequest(this.getFullIndexName(), id);
        try {
            this.getClient().delete(deleteRequest, RequestOptions.DEFAULT);
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private String getPropertyId(String namespace, String propertyName) {
        String qn = new QName(namespace, propertyName).toString();
        return Base64.encodeBase64String((byte[])qn.getBytes());
    }

    protected Object readPrimitive(GetResponse response) throws Exception {
        String sourceAsString = response.getSourceAsString();
        PrimitiveBean pb = (PrimitiveBean)BackingStoreUtil.JSON_MAPPER.readValue(sourceAsString, PrimitiveBean.class);
        String value = pb.getValue();
        Class<?> c = Class.forName(pb.getType());
        return BackingStoreUtil.readPrimitive(c, (String)value);
    }

    protected String getDefaultIndexPrefix() {
        return "apiman_gateway";
    }

    protected List<String> getDefaultIndices() {
        String[] indices = new String[]{"sharedstateproperty"};
        return Arrays.asList(indices);
    }

    private String getFullIndexName() {
        return (this.getIndexPrefix() + "sharedstateproperty").toLowerCase();
    }
}

