/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.common.logging.DefaultDelegateFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.es.CachingEsRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;

public class PollCachingEsRegistry
extends CachingEsRegistry {
    private static final int DEFAULT_POLLING_INTERVAL = 10;
    private static final int DEFAULT_STARTUP_DELAY = 30;
    private int pollIntervalMillis;
    private int startupDelayMillis;
    private boolean polling = false;
    private String dataVersion = null;
    private IApimanLogger logger = new DefaultDelegateFactory().createLogger(PollCachingEsRegistry.class);

    public PollCachingEsRegistry(Map<String, String> config) {
        super(config);
        String intervalVal = config.get("cache-polling-interval");
        String startupVal = config.get("cache-polling-startup-delay");
        this.pollIntervalMillis = intervalVal != null ? new Integer(intervalVal) * 1000 : 10000;
        this.startupDelayMillis = startupVal != null ? new Integer(startupVal) * 1000 : 30000;
        this.startCacheInvalidator();
    }

    @Override
    public void publishApi(Api api, final IAsyncResultHandler<Void> handler) {
        super.publishApi(api, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingEsRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void retireApi(Api api, final IAsyncResultHandler<Void> handler) {
        super.retireApi(api, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingEsRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void registerClient(Client client, final IAsyncResultHandler<Void> handler) {
        super.registerClient(client, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingEsRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void unregisterClient(Client client, final IAsyncResultHandler<Void> handler) {
        super.unregisterClient(client, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingEsRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    protected void updateDataVersion() {
        ActionListener listener = new ActionListener(){

            public void onResponse(Object o) {
                PollCachingEsRegistry.this.dataVersion = null;
            }

            public void onFailure(Exception e) {
                PollCachingEsRegistry.this.dataVersion = null;
            }
        };
        IndexRequest request = new IndexRequest(this.getIndexPrefix() + "dataversion");
        request.id("instance");
        request.source(new Object[]{"updatedOn", System.currentTimeMillis()});
        this.getClient().indexAsync(request, RequestOptions.DEFAULT, listener);
    }

    protected void startCacheInvalidator() {
        this.polling = true;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(PollCachingEsRegistry.this.startupDelayMillis);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                while (PollCachingEsRegistry.this.polling) {
                    try {
                        Thread.sleep(PollCachingEsRegistry.this.pollIntervalMillis);
                        PollCachingEsRegistry.this.checkCacheVersion();
                    }
                    catch (Exception e) {
                        PollCachingEsRegistry.this.logger.warn(e.getMessage());
                    }
                }
            }
        }, "EsRegistryCacheInvalidator");
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.polling = false;
    }

    protected void checkCacheVersion() throws IOException {
        boolean invalidate = true;
        GetResponse result = this.getClient().get(new GetRequest(this.getIndexPrefix() + "dataversion", "instance"), RequestOptions.DEFAULT);
        if (result.isExists()) {
            String latestDV = Long.toString(result.getVersion());
            if (latestDV != null && this.dataVersion != null && latestDV.equals(this.dataVersion)) {
                invalidate = false;
            } else {
                this.dataVersion = latestDV;
            }
        }
        if (invalidate) {
            this.invalidateCache();
        }
    }

    @Override
    protected String getDefaultIndexPrefix() {
        return "apiman_gateway";
    }

    @Override
    protected List<String> getDefaultIndices() {
        String[] indices = new String[]{"dataversion"};
        return Arrays.asList(indices);
    }
}

