/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.war;

import io.apiman.common.config.ConfigFactory;
import io.apiman.common.logging.DefaultDelegateFactory;
import io.apiman.common.logging.IDelegateFactory;
import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.util.ReflectionUtils;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.gateway.engine.EngineConfigTuple;
import io.apiman.gateway.engine.IApiRequestPathParser;
import io.apiman.gateway.engine.IComponent;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngineConfig;
import io.apiman.gateway.engine.IGatewayInitializer;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.IPolicyErrorWriter;
import io.apiman.gateway.engine.IPolicyFailureWriter;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.impl.DefaultPolicyErrorWriter;
import io.apiman.gateway.engine.impl.DefaultPolicyFailureWriter;
import io.apiman.gateway.engine.impl.DefaultRequestPathParser;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.configuration.Configuration;

public class WarEngineConfig
implements IEngineConfig {
    public static final Configuration config = ConfigFactory.createConfig();

    public Configuration getConfig() {
        return config;
    }

    public String getConfigProperty(String propertyName, String defaultValue) {
        return this.getConfig().getString(propertyName, defaultValue);
    }

    public Class<? extends IRegistry> getRegistryClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.registry", IRegistry.class, pluginRegistry);
    }

    public Map<String, String> getRegistryConfig() {
        return this.getConfigMap("apiman-gateway.registry");
    }

    public Class<IPluginRegistry> getPluginRegistryClass() {
        return this.loadConfigClass("apiman-gateway.plugin-registry", IPluginRegistry.class, null);
    }

    public Map<String, String> getPluginRegistryConfig() {
        Map<String, String> configMap = this.getConfigMap("apiman-gateway.plugin-registry");
        String pluginsDirOverride = System.getProperty("apiman-gateway.plugin-registry.pluginsDir");
        if (pluginsDirOverride != null) {
            configMap.put("pluginsDir", pluginsDirOverride);
        }
        return configMap;
    }

    public Class<? extends IConnectorFactory> getConnectorFactoryClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.connector-factory", IConnectorFactory.class, pluginRegistry);
    }

    public Map<String, String> getConnectorFactoryConfig() {
        return this.getConfigMap("apiman-gateway.connector-factory");
    }

    public Class<? extends IPolicyFactory> getPolicyFactoryClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.policy-factory", IPolicyFactory.class, pluginRegistry);
    }

    public Map<String, String> getPolicyFactoryConfig() {
        return this.getConfigMap("apiman-gateway.policy-factory");
    }

    public Class<? extends IMetrics> getMetricsClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.metrics", IMetrics.class, pluginRegistry);
    }

    public Map<String, String> getMetricsConfig() {
        return this.getConfigMap("apiman-gateway.metrics");
    }

    public <T extends IComponent> Class<? extends T> getComponentClass(Class<? extends T> componentType, IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.components." + componentType.getSimpleName(), componentType, pluginRegistry);
    }

    public <T extends IComponent> Map<String, String> getComponentConfig(Class<T> componentType) {
        return this.getConfigMap("apiman-gateway.components." + componentType.getSimpleName());
    }

    public Class<? extends IDataEncrypter> getDataEncrypterClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman.encrypter.type", IDataEncrypter.class, pluginRegistry);
    }

    public Map<String, String> getDataEncrypterConfig() {
        return this.getConfigMap("apiman.encrypter");
    }

    public Class<IPolicyFailureWriter> getPolicyFailureWriterClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.writers.policy-failure", IPolicyFailureWriter.class, pluginRegistry, DefaultPolicyFailureWriter.class);
    }

    public Map<String, String> getPolicyFailureWriterConfig() {
        return this.getConfigMap("apiman-gateway.writers.policy-failure");
    }

    public Class<IPolicyErrorWriter> getPolicyErrorWriterClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.writers.error", IPolicyErrorWriter.class, pluginRegistry, DefaultPolicyErrorWriter.class);
    }

    public Map<String, String> getPolicyErrorWriterConfig() {
        return this.getConfigMap("apiman-gateway.writers.error");
    }

    public Class<? extends IDelegateFactory> getLoggerFactoryClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.logger-factory", IDelegateFactory.class, pluginRegistry, DefaultDelegateFactory.class);
    }

    public Map<String, String> getLoggerFactoryConfig() {
        return this.getConfigMap("apiman-gateway.logger-factory");
    }

    public Class<? extends IApiRequestPathParser> getApiRequestPathParserClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass("apiman-gateway.request-parser", IApiRequestPathParser.class, pluginRegistry, DefaultRequestPathParser.class);
    }

    public Map<String, String> getApiRequestPathParserConfig() {
        return this.getConfigMap("apiman-gateway.request-parser");
    }

    public List<EngineConfigTuple<? extends IGatewayInitializer>> getGatewayInitializers(IPluginRegistry pluginRegistry) {
        ArrayList<EngineConfigTuple<? extends IGatewayInitializer>> rval = new ArrayList<EngineConfigTuple<? extends IGatewayInitializer>>();
        String initializerIds = this.getConfig().getString("apiman-gateway.initializers");
        if (initializerIds != null) {
            for (String initializerId : initializerIds.split(",")) {
                String initializerClassProp = "apiman-gateway.initializers." + initializerId;
                Class<IGatewayInitializer> initializerClass = this.loadConfigClass(initializerClassProp, IGatewayInitializer.class, pluginRegistry);
                Map<String, String> configMap = this.getConfigMap(initializerClassProp);
                rval.add((EngineConfigTuple<? extends IGatewayInitializer>)new EngineConfigTuple(initializerClass, configMap));
            }
        }
        return rval;
    }

    private <T> Class<? extends T> loadConfigClass(String property, Class<T> type, IPluginRegistry pluginRegistry) {
        Class<T> rval = this.loadConfigClass(property, type, pluginRegistry, null);
        if (rval == null) {
            throw new RuntimeException("No " + type.getSimpleName() + " class configured.");
        }
        return rval;
    }

    private <T> Class<? extends T> loadConfigClass(String property, Class<T> type, IPluginRegistry pluginRegistry, Class<? extends T> defaultClass) {
        String componentSpec = this.getConfig().getString(property);
        if (componentSpec == null) {
            return defaultClass;
        }
        try {
            if (componentSpec.startsWith("class:")) {
                Class c = ReflectionUtils.loadClass((String)componentSpec.substring("class:".length()));
                return c;
            }
            if (componentSpec.startsWith("plugin:")) {
                PluginCoordinates coordinates = PluginCoordinates.fromPolicySpec((String)componentSpec);
                if (coordinates == null) {
                    throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
                }
                int ssidx = componentSpec.indexOf(47);
                if (ssidx == -1) {
                    throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
                }
                String classname = componentSpec.substring(ssidx + 1);
                Future pluginF = pluginRegistry.loadPlugin(coordinates, null);
                IAsyncResult pluginR = (IAsyncResult)pluginF.get();
                if (pluginR.isError()) {
                    throw new RuntimeException(pluginR.getError());
                }
                Plugin plugin = (Plugin)pluginR.getResult();
                PluginClassLoader classLoader = plugin.getLoader();
                Class class1 = classLoader.loadClass(classname);
                return class1;
            }
            Class c = ReflectionUtils.loadClass((String)componentSpec);
            return c;
        }
        catch (ClassNotFoundException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getConfigMap(String prefix) {
        HashMap<String, String> rval = new HashMap<String, String>();
        Iterator keys = config.getKeys(prefix);
        while (keys.hasNext()) {
            String key = String.valueOf(keys.next());
            if (key.equals(prefix)) continue;
            String shortKey = key.substring(prefix.length() + 1);
            rval.put(shortKey, config.getString(key));
        }
        return rval;
    }
}

