/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.war;

import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineConfig;
import io.apiman.gateway.engine.IPolicyErrorWriter;
import io.apiman.gateway.engine.IPolicyFailureWriter;
import io.apiman.gateway.engine.impl.ConfigDrivenEngineFactory;
import io.apiman.gateway.engine.impl.DefaultPolicyErrorWriter;
import io.apiman.gateway.engine.impl.DefaultPolicyFailureWriter;
import io.apiman.gateway.platforms.war.WarEngineConfig;
import java.util.Map;

public class WarGateway {
    public static WarEngineConfig config;
    public static IEngine engine;
    public static IPolicyFailureWriter failureFormatter;
    public static IPolicyErrorWriter errorFormatter;

    public static void init() {
        String propVal;
        config = new WarEngineConfig();
        if (System.getProperty("apiman-gateway.max-payload-buffer-size") == null && (propVal = config.getConfigProperty("apiman-gateway.max-payload-buffer-size", null)) != null) {
            System.setProperty("apiman-gateway.max-payload-buffer-size", propVal);
        }
        ConfigDrivenEngineFactory factory = new ConfigDrivenEngineFactory((IEngineConfig)config);
        engine = factory.createEngine();
        failureFormatter = WarGateway.loadFailureFormatter();
        errorFormatter = WarGateway.loadErrorFormatter();
    }

    private static IPolicyErrorWriter loadErrorFormatter() {
        Class<IPolicyErrorWriter> clazz = config.getPolicyErrorWriterClass(engine.getPluginRegistry());
        if (clazz == null) {
            clazz = DefaultPolicyErrorWriter.class;
        }
        Map<String, String> conf = config.getPolicyErrorWriterConfig();
        return (IPolicyErrorWriter)ConfigDrivenEngineFactory.instantiate(clazz, conf);
    }

    private static IPolicyFailureWriter loadFailureFormatter() {
        Class<IPolicyFailureWriter> clazz = config.getPolicyFailureWriterClass(engine.getPluginRegistry());
        if (clazz == null) {
            clazz = DefaultPolicyFailureWriter.class;
        }
        Map<String, String> conf = config.getPolicyFailureWriterConfig();
        return (IPolicyFailureWriter)ConfigDrivenEngineFactory.instantiate(clazz, conf);
    }

    public static void shutdown() {
        engine = null;
    }
}

