/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa;

import io.apiman.manager.api.beans.apps.ApplicationBean;
import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntityType;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.gateways.GatewayType;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plugins.PluginBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.services.ServiceBean;
import io.apiman.manager.api.beans.services.ServiceGatewayBean;
import io.apiman.manager.api.beans.services.ServicePlanBean;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import io.apiman.manager.api.beans.summary.ApiEntryBean;
import io.apiman.manager.api.beans.summary.ApiRegistryBean;
import io.apiman.manager.api.beans.summary.ApplicationSummaryBean;
import io.apiman.manager.api.beans.summary.ApplicationVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PluginSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyFormType;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.beans.summary.ServicePlanSummaryBean;
import io.apiman.manager.api.beans.summary.ServiceSummaryBean;
import io.apiman.manager.api.beans.summary.ServiceVersionSummaryBean;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.util.PolicyTemplateUtil;
import io.apiman.manager.api.jpa.AbstractJpaStorage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JpaStorage
extends AbstractJpaStorage
implements IStorage,
IStorageQuery,
IApiKeyGenerator {
    private static Logger logger = LoggerFactory.getLogger(JpaStorage.class);

    @Override
    public void beginTx() throws StorageException {
        super.beginTx();
    }

    @Override
    public void commitTx() throws StorageException {
        super.commitTx();
    }

    @Override
    public void rollbackTx() {
        super.rollbackTx();
    }

    public void createApplication(ApplicationBean application) throws StorageException {
        super.create(application);
    }

    public void createApplicationVersion(ApplicationVersionBean version) throws StorageException {
        super.create(version);
    }

    public void createContract(ContractBean contract) throws StorageException {
        super.create(contract);
    }

    public void createGateway(GatewayBean gateway) throws StorageException {
        super.create(gateway);
    }

    public void createPlugin(PluginBean plugin) throws StorageException {
        super.create(plugin);
    }

    public void createOrganization(OrganizationBean organization) throws StorageException {
        super.create(organization);
    }

    public void createPlan(PlanBean plan) throws StorageException {
        super.create(plan);
    }

    public void createPlanVersion(PlanVersionBean version) throws StorageException {
        super.create(version);
    }

    public void createPolicy(PolicyBean policy) throws StorageException {
        super.create(policy);
    }

    public void createPolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        super.create(policyDef);
    }

    public void createRole(RoleBean role) throws StorageException {
        super.create(role);
    }

    public void createService(ServiceBean service) throws StorageException {
        super.create(service);
    }

    public void createServiceVersion(ServiceVersionBean version) throws StorageException {
        super.create(version);
    }

    public void updateApplication(ApplicationBean application) throws StorageException {
        super.update(application);
    }

    public void updateApplicationVersion(ApplicationVersionBean version) throws StorageException {
        super.update(version);
    }

    public void updateContract(ContractBean contract) throws StorageException {
        super.update(contract);
    }

    public void updateGateway(GatewayBean gateway) throws StorageException {
        super.update(gateway);
    }

    public void updateOrganization(OrganizationBean organization) throws StorageException {
        super.update(organization);
    }

    public void updatePlan(PlanBean plan) throws StorageException {
        super.update(plan);
    }

    public void updatePlanVersion(PlanVersionBean version) throws StorageException {
        super.update(version);
    }

    public void updatePolicy(PolicyBean policy) throws StorageException {
        super.update(policy);
    }

    public void updatePolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        super.update(policyDef);
    }

    public void updateRole(RoleBean role) throws StorageException {
        super.update(role);
    }

    public void updateService(ServiceBean service) throws StorageException {
        super.update(service);
    }

    public void updateServiceVersion(ServiceVersionBean version) throws StorageException {
        super.update(version);
    }

    public void deleteOrganization(OrganizationBean organization) throws StorageException {
        super.delete(organization);
    }

    public void deleteApplication(ApplicationBean application) throws StorageException {
        super.delete(application);
    }

    public void deleteApplicationVersion(ApplicationVersionBean version) throws StorageException {
        super.delete(version);
    }

    public void deleteContract(ContractBean contract) throws StorageException {
        super.delete(contract);
    }

    public void deleteService(ServiceBean service) throws StorageException {
        super.delete(service);
    }

    public void deleteServiceVersion(ServiceVersionBean version) throws StorageException {
        super.delete(version);
    }

    public void deletePlan(PlanBean plan) throws StorageException {
        super.delete(plan);
    }

    public void deletePlanVersion(PlanVersionBean version) throws StorageException {
        super.delete(version);
    }

    public void deletePolicy(PolicyBean policy) throws StorageException {
        super.delete(policy);
    }

    public void deleteGateway(GatewayBean gateway) throws StorageException {
        super.delete(gateway);
    }

    public void deletePlugin(PluginBean plugin) throws StorageException {
        super.delete(plugin);
    }

    public void deletePolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        super.delete(policyDef);
    }

    public void deleteRole(RoleBean role) throws StorageException {
        super.delete(role);
    }

    public OrganizationBean getOrganization(String id) throws StorageException {
        return super.get(id, OrganizationBean.class);
    }

    public ApplicationBean getApplication(String organizationId, String id) throws StorageException {
        return super.get(organizationId, id, ApplicationBean.class);
    }

    public ContractBean getContract(Long id) throws StorageException {
        return super.get(id, ContractBean.class);
    }

    public ServiceBean getService(String organizationId, String id) throws StorageException {
        return super.get(organizationId, id, ServiceBean.class);
    }

    public PlanBean getPlan(String organizationId, String id) throws StorageException {
        return super.get(organizationId, id, PlanBean.class);
    }

    public PolicyBean getPolicy(Long id) throws StorageException {
        return super.get(id, PolicyBean.class);
    }

    public GatewayBean getGateway(String id) throws StorageException {
        return super.get(id, GatewayBean.class);
    }

    public PluginBean getPlugin(long id) throws StorageException {
        return super.get(id, PluginBean.class);
    }

    public PluginBean getPlugin(String groupId, String artifactId) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String sql = "SELECT p.id, p.artifactId, p.groupId, p.version, p.classifier, p.type, p.name, p.description, p.createdBy, p.createdOn  FROM plugins p WHERE p.groupId = ? AND p.artifactId = ?";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, (Object)groupId);
            query.setParameter(2, (Object)artifactId);
            List rows = query.getResultList();
            if (rows.size() > 0) {
                Object[] row = (Object[])rows.get(0);
                PluginBean plugin = new PluginBean();
                plugin.setId(Long.valueOf(((Number)row[0]).longValue()));
                plugin.setArtifactId(String.valueOf(row[1]));
                plugin.setGroupId(String.valueOf(row[2]));
                plugin.setVersion(String.valueOf(row[3]));
                plugin.setClassifier((String)row[4]);
                plugin.setType((String)row[5]);
                plugin.setName(String.valueOf(row[6]));
                plugin.setDescription(String.valueOf(row[7]));
                plugin.setCreatedBy(String.valueOf(row[8]));
                plugin.setCreatedOn((Date)row[9]);
                return plugin;
            }
            return null;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public PolicyDefinitionBean getPolicyDefinition(String id) throws StorageException {
        return super.get(id, PolicyDefinitionBean.class);
    }

    public RoleBean getRole(String id) throws StorageException {
        return super.get(id, RoleBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> SearchResultsBean<T> find(SearchCriteriaBean criteria, Class<T> type) throws StorageException {
        this.beginTx();
        try {
            SearchResultsBean<T> rval;
            SearchResultsBean<T> searchResultsBean = rval = super.find(criteria, type);
            return searchResultsBean;
        }
        finally {
            this.commitTx();
        }
    }

    public SearchResultsBean<OrganizationSummaryBean> findOrganizations(SearchCriteriaBean criteria) throws StorageException {
        SearchResultsBean<OrganizationBean> orgs = this.find(criteria, OrganizationBean.class);
        SearchResultsBean rval = new SearchResultsBean();
        rval.setTotalSize(orgs.getTotalSize());
        List beans = orgs.getBeans();
        for (OrganizationBean bean : beans) {
            OrganizationSummaryBean osb = new OrganizationSummaryBean();
            osb.setId(bean.getId());
            osb.setName(bean.getName());
            osb.setDescription(bean.getDescription());
            rval.getBeans().add(osb);
        }
        return rval;
    }

    public SearchResultsBean<ApplicationSummaryBean> findApplications(SearchCriteriaBean criteria) throws StorageException {
        SearchResultsBean<ApplicationBean> result = this.find(criteria, ApplicationBean.class);
        SearchResultsBean rval = new SearchResultsBean();
        rval.setTotalSize(result.getTotalSize());
        List beans = result.getBeans();
        rval.setBeans(new ArrayList(beans.size()));
        for (ApplicationBean application : beans) {
            ApplicationSummaryBean summary = new ApplicationSummaryBean();
            OrganizationBean organization = application.getOrganization();
            summary.setId(application.getId());
            summary.setName(application.getName());
            summary.setDescription(application.getDescription());
            summary.setNumContracts(0);
            summary.setOrganizationId(application.getOrganization().getId());
            summary.setOrganizationName(organization.getName());
            rval.getBeans().add(summary);
        }
        return rval;
    }

    public SearchResultsBean<ServiceSummaryBean> findServices(SearchCriteriaBean criteria) throws StorageException {
        SearchResultsBean<ServiceBean> result = this.find(criteria, ServiceBean.class);
        SearchResultsBean rval = new SearchResultsBean();
        rval.setTotalSize(result.getTotalSize());
        List beans = result.getBeans();
        rval.setBeans(new ArrayList(beans.size()));
        for (ServiceBean service : beans) {
            ServiceSummaryBean summary = new ServiceSummaryBean();
            OrganizationBean organization = service.getOrganization();
            summary.setId(service.getId());
            summary.setName(service.getName());
            summary.setDescription(service.getDescription());
            summary.setCreatedOn(service.getCreatedOn());
            summary.setOrganizationId(service.getOrganization().getId());
            summary.setOrganizationName(organization.getName());
            rval.getBeans().add(summary);
        }
        return rval;
    }

    public SearchResultsBean<PlanSummaryBean> findPlans(String organizationId, SearchCriteriaBean criteria) throws StorageException {
        criteria.addFilter("organization.id", organizationId, "eq");
        SearchResultsBean<PlanBean> result = this.find(criteria, PlanBean.class);
        SearchResultsBean rval = new SearchResultsBean();
        rval.setTotalSize(result.getTotalSize());
        List plans = result.getBeans();
        rval.setBeans(new ArrayList(plans.size()));
        for (PlanBean plan : plans) {
            PlanSummaryBean summary = new PlanSummaryBean();
            OrganizationBean organization = plan.getOrganization();
            summary.setId(plan.getId());
            summary.setName(plan.getName());
            summary.setDescription(plan.getDescription());
            summary.setOrganizationId(plan.getOrganization().getId());
            summary.setOrganizationName(organization.getName());
            rval.getBeans().add(summary);
        }
        return rval;
    }

    public void createAuditEntry(AuditEntryBean entry) throws StorageException {
        super.create(entry);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditEntity(String organizationId, String entityId, String entityVersion, Class<T> type, PagingBean paging) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        if (paging != null) {
            criteria.setPaging(paging);
        } else {
            criteria.setPage(1);
            criteria.setPageSize(20);
        }
        criteria.setOrder("id", false);
        if (organizationId != null) {
            criteria.addFilter("organizationId", organizationId, "eq");
        }
        if (entityId != null) {
            criteria.addFilter("entityId", entityId, "eq");
        }
        if (entityVersion != null) {
            criteria.addFilter("entityVersion", entityVersion, "eq");
        }
        if (type != null) {
            AuditEntityType entityType = null;
            if (type == OrganizationBean.class) {
                entityType = AuditEntityType.Organization;
            } else if (type == ApplicationBean.class) {
                entityType = AuditEntityType.Application;
            } else if (type == ServiceBean.class) {
                entityType = AuditEntityType.Service;
            } else if (type == PlanBean.class) {
                entityType = AuditEntityType.Plan;
            }
            if (entityType != null) {
                criteria.addFilter("entityType", entityType.name(), "eq");
            }
        }
        return this.find(criteria, AuditEntryBean.class);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditUser(String userId, PagingBean paging) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        if (paging != null) {
            criteria.setPaging(paging);
        } else {
            criteria.setPage(1);
            criteria.setPageSize(20);
        }
        criteria.setOrder("createdOn", false);
        if (userId != null) {
            criteria.addFilter("who", userId, "eq");
        }
        return this.find(criteria, AuditEntryBean.class);
    }

    public List<GatewaySummaryBean> listGateways() throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String sql = "SELECT g.id, g.name, g.description, g.type  FROM gateways g ORDER BY g.name ASC";
            Query query = entityManager.createNativeQuery(sql);
            List rows = query.getResultList();
            ArrayList<GatewaySummaryBean> gateways = new ArrayList<GatewaySummaryBean>(rows.size());
            for (Object[] row : rows) {
                GatewaySummaryBean gateway = new GatewaySummaryBean();
                gateway.setId(String.valueOf(row[0]));
                gateway.setName(String.valueOf(row[1]));
                gateway.setDescription(String.valueOf(row[2]));
                gateway.setType(GatewayType.valueOf((String)String.valueOf(row[3])));
                gateways.add(gateway);
            }
            ArrayList<GatewaySummaryBean> arrayList = gateways;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<PluginSummaryBean> listPlugins() throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String sql = "SELECT p.id, p.artifactId, p.groupId, p.version, p.classifier, p.type, p.name, p.description, p.createdBy, p.createdOn  FROM plugins p ORDER BY p.name ASC";
            Query query = entityManager.createNativeQuery(sql);
            List rows = query.getResultList();
            ArrayList<PluginSummaryBean> plugins = new ArrayList<PluginSummaryBean>(rows.size());
            for (Object[] row : rows) {
                PluginSummaryBean plugin = new PluginSummaryBean();
                plugin.setId(Long.valueOf(((Number)row[0]).longValue()));
                plugin.setArtifactId(String.valueOf(row[1]));
                plugin.setGroupId(String.valueOf(row[2]));
                plugin.setVersion(String.valueOf(row[3]));
                plugin.setClassifier((String)row[4]);
                plugin.setType((String)row[5]);
                plugin.setName(String.valueOf(row[6]));
                plugin.setDescription(String.valueOf(row[7]));
                plugin.setCreatedBy(String.valueOf(row[8]));
                plugin.setCreatedOn((Date)row[9]);
                plugins.add(plugin);
            }
            ArrayList<PluginSummaryBean> arrayList = plugins;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<PolicyDefinitionSummaryBean> listPolicyDefinitions() throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String sql = "SELECT pd.id, pd.policyImpl, pd.name, pd.description, pd.icon, pd.pluginId, pd.formType  FROM policydefs pd ORDER BY pd.name ASC";
            Query query = entityManager.createNativeQuery(sql);
            List rows = query.getResultList();
            ArrayList<PolicyDefinitionSummaryBean> rval = new ArrayList<PolicyDefinitionSummaryBean>(rows.size());
            for (Object[] row : rows) {
                PolicyDefinitionSummaryBean bean = new PolicyDefinitionSummaryBean();
                bean.setId(String.valueOf(row[0]));
                bean.setPolicyImpl(String.valueOf(row[1]));
                bean.setName(String.valueOf(row[2]));
                bean.setDescription(String.valueOf(row[3]));
                bean.setIcon(String.valueOf(row[4]));
                if (row[5] != null) {
                    bean.setPluginId(Long.valueOf(((Number)row[5]).longValue()));
                }
                if (row[6] != null) {
                    bean.setFormType(PolicyFormType.valueOf((String)String.valueOf(row[6])));
                }
                rval.add(bean);
            }
            ArrayList<PolicyDefinitionSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<OrganizationSummaryBean> getOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<OrganizationSummaryBean> orgs = new ArrayList<OrganizationSummaryBean>();
        if (orgIds == null || orgIds.isEmpty()) {
            return orgs;
        }
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT o from OrganizationBean o WHERE o.id IN :orgs ORDER BY o.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgs", orgIds);
            List qr = query.getResultList();
            for (OrganizationBean bean : qr) {
                OrganizationSummaryBean summary = new OrganizationSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                orgs.add(summary);
            }
            ArrayList<OrganizationSummaryBean> arrayList = orgs;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ApplicationSummaryBean> getApplicationsInOrg(String orgId) throws StorageException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        return this.getApplicationsInOrgs(orgIds);
    }

    public List<ApplicationSummaryBean> getApplicationsInOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<ApplicationSummaryBean> rval = new ArrayList<ApplicationSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT a FROM ApplicationBean a JOIN a.organization o WHERE o.id IN :orgs ORDER BY a.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgs", orgIds);
            List qr = query.getResultList();
            for (ApplicationBean bean : qr) {
                ApplicationSummaryBean summary = new ApplicationSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                summary.setNumContracts(0);
                OrganizationBean org = bean.getOrganization();
                summary.setOrganizationId(org.getId());
                summary.setOrganizationName(org.getName());
                rval.add(summary);
            }
            ArrayList<ApplicationSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ServiceSummaryBean> getServicesInOrg(String orgId) throws StorageException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        return this.getServicesInOrgs(orgIds);
    }

    public List<ServiceSummaryBean> getServicesInOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<ServiceSummaryBean> rval = new ArrayList<ServiceSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT s FROM ServiceBean s JOIN s.organization o WHERE o.id IN :orgs ORDER BY s.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgs", orgIds);
            List qr = query.getResultList();
            for (ServiceBean bean : qr) {
                ServiceSummaryBean summary = new ServiceSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                summary.setCreatedOn(bean.getCreatedOn());
                OrganizationBean org = bean.getOrganization();
                summary.setOrganizationId(org.getId());
                summary.setOrganizationName(org.getName());
                rval.add(summary);
            }
            ArrayList<ServiceSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public ServiceVersionBean getServiceVersion(String orgId, String serviceId, String version) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ServiceVersionBean v JOIN v.service s JOIN s.organization o WHERE o.id = :orgId AND s.id = :serviceId AND v.version = :version";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("serviceId", (Object)serviceId);
            query.setParameter("version", (Object)version);
            return (ServiceVersionBean)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<ServiceVersionSummaryBean> getServiceVersions(String orgId, String serviceId) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v   FROM ServiceVersionBean v  JOIN v.service s  JOIN s.organization o WHERE o.id = :orgId  AND s.id = :serviceId ORDER BY v.id DESC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("serviceId", (Object)serviceId);
            List serviceVersions = query.getResultList();
            ArrayList<ServiceVersionSummaryBean> rval = new ArrayList<ServiceVersionSummaryBean>(serviceVersions.size());
            for (ServiceVersionBean serviceVersion : serviceVersions) {
                ServiceVersionSummaryBean svsb = new ServiceVersionSummaryBean();
                svsb.setOrganizationId(serviceVersion.getService().getOrganization().getId());
                svsb.setOrganizationName(serviceVersion.getService().getOrganization().getName());
                svsb.setId(serviceVersion.getService().getId());
                svsb.setName(serviceVersion.getService().getName());
                svsb.setDescription(serviceVersion.getService().getDescription());
                svsb.setVersion(serviceVersion.getVersion());
                svsb.setStatus(serviceVersion.getStatus());
                rval.add(svsb);
            }
            ArrayList<ServiceVersionSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ServicePlanSummaryBean> getServiceVersionPlans(String organizationId, String serviceId, String version) throws StorageException {
        ArrayList<ServicePlanSummaryBean> plans = new ArrayList<ServicePlanSummaryBean>();
        this.beginTx();
        try {
            ServiceVersionBean versionBean = this.getServiceVersion(organizationId, serviceId, version);
            Set servicePlans = versionBean.getPlans();
            if (servicePlans != null) {
                for (ServicePlanBean spb : servicePlans) {
                    PlanVersionBean planVersion = this.getPlanVersion(organizationId, spb.getPlanId(), spb.getVersion());
                    ServicePlanSummaryBean summary = new ServicePlanSummaryBean();
                    summary.setPlanId(planVersion.getPlan().getId());
                    summary.setPlanName(planVersion.getPlan().getName());
                    summary.setPlanDescription(planVersion.getPlan().getDescription());
                    summary.setVersion(spb.getVersion());
                    plans.add(summary);
                }
            }
            ArrayList<ServicePlanSummaryBean> arrayList = plans;
            return arrayList;
        }
        catch (StorageException e) {
            this.rollbackTx();
            throw e;
        }
        finally {
            this.commitTx();
        }
    }

    public List<ContractSummaryBean> getServiceContracts(String organizationId, String serviceId, String version, int page, int pageSize) throws StorageException {
        int start = (page - 1) * pageSize;
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT c from ContractBean c   JOIN c.service svcv   JOIN svcv.service svc   JOIN c.application appv   JOIN appv.application app   JOIN svc.organization sorg  JOIN app.organization aorg WHERE svc.id = :serviceId    AND sorg.id = :orgId    AND svcv.version = :version  ORDER BY aorg.id, app.name ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)organizationId);
            query.setParameter("serviceId", (Object)serviceId);
            query.setParameter("version", (Object)version);
            query.setFirstResult(start);
            query.setMaxResults(pageSize);
            List contracts = query.getResultList();
            ArrayList<ContractSummaryBean> rval = new ArrayList<ContractSummaryBean>(contracts.size());
            for (ContractBean contractBean : contracts) {
                ApplicationBean application = contractBean.getApplication().getApplication();
                ServiceBean service = contractBean.getService().getService();
                PlanBean plan = contractBean.getPlan().getPlan();
                OrganizationBean appOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)application.getOrganization().getId());
                OrganizationBean svcOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)service.getOrganization().getId());
                ContractSummaryBean csb = new ContractSummaryBean();
                csb.setAppId(application.getId());
                csb.setApikey(contractBean.getApikey());
                csb.setAppOrganizationId(application.getOrganization().getId());
                csb.setAppOrganizationName(appOrg.getName());
                csb.setAppName(application.getName());
                csb.setAppVersion(contractBean.getApplication().getVersion());
                csb.setContractId(contractBean.getId());
                csb.setCreatedOn(contractBean.getCreatedOn());
                csb.setPlanId(plan.getId());
                csb.setPlanName(plan.getName());
                csb.setPlanVersion(contractBean.getPlan().getVersion());
                csb.setServiceDescription(service.getDescription());
                csb.setServiceId(service.getId());
                csb.setServiceName(service.getName());
                csb.setServiceOrganizationId(svcOrg.getId());
                csb.setServiceOrganizationName(svcOrg.getName());
                csb.setServiceVersion(contractBean.getService().getVersion());
                rval.add(csb);
            }
            ArrayList<ContractSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public ApplicationVersionBean getApplicationVersion(String orgId, String applicationId, String version) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ApplicationVersionBean v JOIN v.application a JOIN a.organization o WHERE o.id = :orgId AND a.id = :applicationId AND v.version = :version";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("applicationId", (Object)applicationId);
            query.setParameter("version", (Object)version);
            return (ApplicationVersionBean)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<ApplicationVersionSummaryBean> getApplicationVersions(String orgId, String applicationId) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v  FROM ApplicationVersionBean v  JOIN v.application a  JOIN a.organization o WHERE o.id = :orgId   AND a.id = :applicationId ORDER BY v.id DESC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("applicationId", (Object)applicationId);
            List appVersions = query.getResultList();
            ArrayList<ApplicationVersionSummaryBean> rval = new ArrayList<ApplicationVersionSummaryBean>();
            for (ApplicationVersionBean appVersion : appVersions) {
                ApplicationVersionSummaryBean avsb = new ApplicationVersionSummaryBean();
                avsb.setOrganizationId(appVersion.getApplication().getOrganization().getId());
                avsb.setOrganizationName(appVersion.getApplication().getOrganization().getName());
                avsb.setId(appVersion.getApplication().getId());
                avsb.setName(appVersion.getApplication().getName());
                avsb.setDescription(appVersion.getApplication().getDescription());
                avsb.setVersion(appVersion.getVersion());
                avsb.setStatus(appVersion.getStatus());
                rval.add(avsb);
            }
            ArrayList<ApplicationVersionSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ContractSummaryBean> getApplicationContracts(String organizationId, String applicationId, String version) throws StorageException {
        ArrayList<ContractSummaryBean> rval = new ArrayList<ContractSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT c from ContractBean c   JOIN c.application appv   JOIN appv.application app   JOIN app.organization aorg WHERE app.id = :applicationId    AND aorg.id = :orgId    AND appv.version = :version  ORDER BY c.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)organizationId);
            query.setParameter("applicationId", (Object)applicationId);
            query.setParameter("version", (Object)version);
            List contracts = query.getResultList();
            for (ContractBean contractBean : contracts) {
                ApplicationBean application = contractBean.getApplication().getApplication();
                ServiceBean service = contractBean.getService().getService();
                PlanBean plan = contractBean.getPlan().getPlan();
                OrganizationBean appOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)application.getOrganization().getId());
                OrganizationBean svcOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)service.getOrganization().getId());
                ContractSummaryBean csb = new ContractSummaryBean();
                csb.setAppId(application.getId());
                csb.setApikey(contractBean.getApikey());
                csb.setAppOrganizationId(application.getOrganization().getId());
                csb.setAppOrganizationName(appOrg.getName());
                csb.setAppName(application.getName());
                csb.setAppVersion(contractBean.getApplication().getVersion());
                csb.setContractId(contractBean.getId());
                csb.setCreatedOn(contractBean.getCreatedOn());
                csb.setPlanId(plan.getId());
                csb.setPlanName(plan.getName());
                csb.setPlanVersion(contractBean.getPlan().getVersion());
                csb.setServiceDescription(service.getDescription());
                csb.setServiceId(service.getId());
                csb.setServiceName(service.getName());
                csb.setServiceOrganizationId(svcOrg.getId());
                csb.setServiceOrganizationName(svcOrg.getName());
                csb.setServiceVersion(contractBean.getService().getVersion());
                rval.add(csb);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
        return rval;
    }

    public ApiRegistryBean getApiRegistry(String organizationId, String applicationId, String version) throws StorageException {
        ApiRegistryBean rval = new ApiRegistryBean();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT c from ContractBean c   JOIN c.application appv   JOIN appv.application app   JOIN app.organization aorg WHERE app.id = :applicationId    AND aorg.id = :orgId    AND appv.version = :version  ORDER BY c.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)organizationId);
            query.setParameter("applicationId", (Object)applicationId);
            query.setParameter("version", (Object)version);
            List contracts = query.getResultList();
            for (ContractBean contractBean : contracts) {
                ServiceVersionBean svb = contractBean.getService();
                ServiceBean service = svb.getService();
                PlanBean plan = contractBean.getPlan().getPlan();
                OrganizationBean svcOrg = service.getOrganization();
                ApiEntryBean entry = new ApiEntryBean();
                entry.setServiceId(service.getId());
                entry.setServiceName(service.getName());
                entry.setServiceOrgId(svcOrg.getId());
                entry.setServiceOrgName(svcOrg.getName());
                entry.setServiceVersion(svb.getVersion());
                entry.setPlanId(plan.getId());
                entry.setPlanName(plan.getName());
                entry.setPlanVersion(contractBean.getPlan().getVersion());
                entry.setApiKey(contractBean.getApikey());
                Set gateways = svb.getGateways();
                if (gateways != null && gateways.size() > 0) {
                    ServiceGatewayBean sgb = (ServiceGatewayBean)gateways.iterator().next();
                    entry.setGatewayId(sgb.getGatewayId());
                }
                rval.getApis().add(entry);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
        return rval;
    }

    public List<PlanSummaryBean> getPlansInOrg(String orgId) throws StorageException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        return this.getPlansInOrgs(orgIds);
    }

    public List<PlanSummaryBean> getPlansInOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<PlanSummaryBean> rval = new ArrayList<PlanSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT p FROM PlanBean p JOIN p.organization o WHERE o.id IN :orgs ORDER BY p.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgs", orgIds);
            List qr = query.getResultList();
            for (PlanBean bean : qr) {
                PlanSummaryBean summary = new PlanSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                OrganizationBean org = bean.getOrganization();
                summary.setOrganizationId(org.getId());
                summary.setOrganizationName(org.getName());
                rval.add(summary);
            }
            ArrayList<PlanSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public PlanVersionBean getPlanVersion(String orgId, String planId, String version) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from PlanVersionBean v JOIN v.plan p JOIN p.organization o WHERE o.id = :orgId AND p.id = :planId AND v.version = :version";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("planId", (Object)planId);
            query.setParameter("version", (Object)version);
            return (PlanVersionBean)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<PlanVersionSummaryBean> getPlanVersions(String orgId, String planId) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from PlanVersionBean v  JOIN v.plan p  JOIN p.organization o WHERE o.id = :orgId   AND p.id = :planId ORDER BY v.id DESC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("planId", (Object)planId);
            List planVersions = query.getResultList();
            ArrayList<PlanVersionSummaryBean> rval = new ArrayList<PlanVersionSummaryBean>(planVersions.size());
            for (PlanVersionBean planVersion : planVersions) {
                PlanVersionSummaryBean pvsb = new PlanVersionSummaryBean();
                pvsb.setOrganizationId(planVersion.getPlan().getOrganization().getId());
                pvsb.setOrganizationName(planVersion.getPlan().getOrganization().getName());
                pvsb.setId(planVersion.getPlan().getId());
                pvsb.setName(planVersion.getPlan().getName());
                pvsb.setDescription(planVersion.getPlan().getDescription());
                pvsb.setVersion(planVersion.getVersion());
                pvsb.setStatus(planVersion.getStatus());
                rval.add(pvsb);
            }
            ArrayList<PlanVersionSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<PolicySummaryBean> getPolicies(String organizationId, String entityId, String version, PolicyType type) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT p from PolicyBean p  WHERE p.organizationId = :orgId    AND p.entityId = :entityId    AND p.entityVersion = :entityVersion    AND p.type = :type ORDER BY p.orderIndex ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)organizationId);
            query.setParameter("entityId", (Object)entityId);
            query.setParameter("entityVersion", (Object)version);
            query.setParameter("type", (Object)type);
            List policyBeans = query.getResultList();
            ArrayList<PolicySummaryBean> rval = new ArrayList<PolicySummaryBean>(policyBeans.size());
            for (PolicyBean policyBean : policyBeans) {
                PolicyTemplateUtil.generatePolicyDescription((PolicyBean)policyBean);
                PolicySummaryBean psb = new PolicySummaryBean();
                psb.setId(policyBean.getId());
                psb.setName(policyBean.getName());
                psb.setDescription(policyBean.getDescription());
                psb.setPolicyDefinitionId(policyBean.getDefinition().getId());
                psb.setIcon(policyBean.getDefinition().getIcon());
                psb.setCreatedBy(policyBean.getCreatedBy());
                psb.setCreatedOn(policyBean.getCreatedOn());
                rval.add(psb);
            }
            ArrayList<PolicySummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public int getMaxPolicyOrderIndex(String organizationId, String entityId, String entityVersion, PolicyType type) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        criteria.addFilter("organizationId", organizationId, "eq");
        criteria.addFilter("entityId", entityId, "eq");
        criteria.addFilter("entityVersion", entityVersion, "eq");
        criteria.addFilter("type", type.name(), "eq");
        criteria.setOrder("orderIndex", false);
        criteria.setPage(1);
        criteria.setPageSize(1);
        SearchResultsBean<PolicyBean> resultsBean = this.find(criteria, PolicyBean.class);
        if (resultsBean.getBeans() == null || resultsBean.getBeans().isEmpty()) {
            return 0;
        }
        return ((PolicyBean)resultsBean.getBeans().get(0)).getOrderIndex();
    }

    public List<PolicyDefinitionSummaryBean> listPluginPolicyDefs(Long pluginId) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String sql = "SELECT pd.id, pd.policyImpl, pd.name, pd.description, pd.icon, pd.pluginId, pd.formType  FROM policydefs pd WHERE pd.pluginId = ? ORDER BY pd.name ASC";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, (Object)pluginId);
            List rows = query.getResultList();
            ArrayList<PolicyDefinitionSummaryBean> beans = new ArrayList<PolicyDefinitionSummaryBean>(rows.size());
            for (Object[] row : rows) {
                PolicyDefinitionSummaryBean bean = new PolicyDefinitionSummaryBean();
                bean.setId(String.valueOf(row[0]));
                bean.setPolicyImpl(String.valueOf(row[1]));
                bean.setName(String.valueOf(row[2]));
                bean.setDescription(String.valueOf(row[3]));
                bean.setIcon(String.valueOf(row[4]));
                if (row[5] != null) {
                    bean.setPluginId(Long.valueOf(((Number)row[5]).longValue()));
                }
                if (row[6] != null) {
                    bean.setFormType(PolicyFormType.valueOf((String)String.valueOf(row[6])));
                }
                beans.add(bean);
            }
            ArrayList<PolicyDefinitionSummaryBean> arrayList = beans;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public String generate() {
        return UUID.randomUUID().toString();
    }
}

