/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.EscapeBuilder;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.Path;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.orgs.OrganizationBasedCompositeId;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.search.OrderByBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.jpa.EntityManagerFactoryAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.jdbi.v3.core.Jdbi;

public abstract class AbstractJpaStorage {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(AbstractJpaStorage.class);
    @Inject
    private EntityManagerFactoryAccessor emf;
    @Inject
    private ApiManagerConfig config;
    @Inject
    private CriteriaBuilderFactory criteriaBuilderFactory;

    protected Jdbi getJdbi() {
        return Jdbi.create((DataSource)AbstractJpaStorage.lookupDS(this.config.getHibernateDataSource()));
    }

    protected CriteriaBuilderFactory getCriteriaBuilderFactory() {
        return this.criteriaBuilderFactory;
    }

    public EntityManager getActiveEntityManager() {
        return this.emf.getEntityManager();
    }

    public Session getSession() {
        return (Session)this.getActiveEntityManager().unwrap(Session.class);
    }

    private static DataSource lookupDS(String dsJndiLocation) {
        DataSource ds;
        try {
            InitialContext ctx = new InitialContext();
            ds = (DataSource)ctx.lookup(dsJndiLocation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ds == null) {
            throw new RuntimeException("Datasource not found: " + dsJndiLocation);
        }
        return ds;
    }

    public <T> void create(T bean) throws StorageException {
        if (bean == null) {
            return;
        }
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            entityManager.persist(bean);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public <T> void update(T bean) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            if (!entityManager.contains(bean)) {
                entityManager.merge(bean);
            }
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public <T> void delete(T bean) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            entityManager.remove(bean);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public <T> T get(Long id, Class<T> type) throws StorageException {
        Object rval;
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            rval = entityManager.find(type, (Object)id);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        return (T)rval;
    }

    public <T> T get(String id, Class<T> type) throws StorageException {
        Object rval;
        EntityManager entityManager = this.getActiveEntityManager();
        try {
            rval = entityManager.find(type, (Object)id);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        return (T)rval;
    }

    protected <T> Iterator<T> getAll(Class<T> type, Query query) throws StorageException {
        return new EntityIterator<T>(type, query);
    }

    public <T> T get(String organizationId, String id, Class<T> type) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            OrganizationBean orgBean = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)organizationId);
            OrganizationBasedCompositeId key = new OrganizationBasedCompositeId(orgBean, id);
            return (T)entityManager.find(type, (Object)key);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    protected <T> SearchResultsBean<T> find(SearchCriteriaBean criteria, List<OrderByBean> uniqueOrderIdentifiers, Class<T> type, boolean paginate) throws StorageException {
        return this.find(criteria, uniqueOrderIdentifiers, criteriaBuilder -> {}, type, type.getSimpleName(), paginate);
    }

    protected <T> SearchResultsBean<T> find(SearchCriteriaBean criteria, List<OrderByBean> uniqueOrderIdentifiers, Consumer<CriteriaBuilder<T>> builderCallback, Class<T> type, String typeAlias, boolean paginate) throws StorageException {
        try {
            PagingBean paging = criteria.getPaging();
            if (paging == null) {
                paging = PagingBean.create((int)1, (int)20);
            }
            int page = paging.getPage();
            int pageSize = paging.getPageSize();
            int start = (page - 1) * pageSize;
            CriteriaBuilder cb = (CriteriaBuilder)this.criteriaBuilderFactory.create(this.getActiveEntityManager(), type).from(type, typeAlias);
            cb = this.applySearchCriteriaToQuery(typeAlias, criteria, cb, false);
            builderCallback.accept(cb);
            if (paginate) {
                PaginatedCriteriaBuilder paginatedCb = cb.page(start, pageSize);
                for (OrderByBean order : uniqueOrderIdentifiers) {
                    paginatedCb = (PaginatedCriteriaBuilder)paginatedCb.orderBy(order.getName(), order.isAscending());
                }
                PagedList resultList = paginatedCb.getResultList();
                return new SearchResultsBean().setTotalSize(Math.toIntExact(resultList.getTotalSize())).setBeans((List)resultList);
            }
            for (OrderByBean order : uniqueOrderIdentifiers) {
                cb = (CriteriaBuilder)cb.orderBy(order.getName(), order.isAscending());
            }
            List resultList = cb.getResultList();
            return new SearchResultsBean().setTotalSize(Math.toIntExact(resultList.size())).setBeans(resultList);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    protected <T> CriteriaBuilder<T> applySearchCriteriaToQuery(String rootAlias, SearchCriteriaBean criteria, CriteriaBuilder<T> cb, boolean countOnly) {
        OrderByBean orderBy;
        List filters = criteria.getFilters();
        if (filters != null && !filters.isEmpty()) {
            for (SearchCriteriaFilterBean filter : filters) {
                Path path = cb.getPath(filter.getName());
                Class pathKlazz = path.getJavaType();
                String name = cb.getPath(filter.getName()).getPath();
                if (filter.getOperator() == SearchCriteriaFilterOperator.eq) {
                    if (pathKlazz.isEnum()) {
                        cb = (CriteriaBuilder)cb.where(name).eq(Enum.valueOf(pathKlazz, filter.getValue()));
                        continue;
                    }
                    cb = (CriteriaBuilder)cb.where(name).eq((Object)filter.getValue());
                    continue;
                }
                if (filter.getOperator() == SearchCriteriaFilterOperator.bool_eq) {
                    cb = (CriteriaBuilder)cb.where(name).eq((Object)Boolean.valueOf(filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == SearchCriteriaFilterOperator.gt) {
                    cb = (CriteriaBuilder)cb.where(name).gt((Object)this.numberValueOf(pathKlazz, filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == SearchCriteriaFilterOperator.gte) {
                    cb = (CriteriaBuilder)cb.where(name).ge((Object)this.numberValueOf(pathKlazz, filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == SearchCriteriaFilterOperator.lt) {
                    cb = (CriteriaBuilder)cb.where(name).lt((Object)this.numberValueOf(pathKlazz, filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == SearchCriteriaFilterOperator.lte) {
                    cb = (CriteriaBuilder)cb.where(name).le((Object)this.numberValueOf(pathKlazz, filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == SearchCriteriaFilterOperator.neq) {
                    cb = (CriteriaBuilder)cb.where(name).notEq((Object)this.numberValueOf(pathKlazz, filter.getValue()));
                    continue;
                }
                if (filter.getOperator() != SearchCriteriaFilterOperator.like) continue;
                cb = (CriteriaBuilder)((EscapeBuilder)cb.where(name).like(false).value((Object)filter.getValue().toUpperCase().replace('*', '%'))).noEscape();
            }
        }
        if ((orderBy = criteria.getOrderBy()) != null && !countOnly) {
            cb = orderBy.isAscending() ? (CriteriaBuilder)cb.orderByAsc(orderBy.getName()) : (CriteriaBuilder)cb.orderByDesc(orderBy.getName());
        }
        return cb;
    }

    private Number numberValueOf(Class<?> klazz, String value) {
        if (klazz.equals(Long.TYPE) || klazz.equals(Long.class)) {
            return Long.valueOf(value);
        }
        if (klazz.equals(Integer.TYPE) || klazz.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (klazz.equals(Byte.TYPE) || klazz.equals(Byte.class)) {
            return Byte.valueOf(value);
        }
        throw new IllegalArgumentException("This method accepts only Integer/int, Long/long, or Byte/byte");
    }

    protected <T> Optional<T> getOne(TypedQuery<T> query) {
        List resultList = query.getResultList();
        if (resultList.size() > 1) {
            throw new IllegalStateException("More than one result for query");
        }
        if (resultList.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(resultList.get(0));
    }

    public String getDialect() {
        return (String)this.getActiveEntityManager().getEntityManagerFactory().getProperties().get("hibernate.dialect");
    }

    private static class EntityIterator<T>
    implements Iterator<T> {
        private Query query;
        private int pageIndex = 0;
        private int pageSize = 100;
        private int resultIndex;
        private List<T> results;

        public EntityIterator(Class<T> type, Query query) throws StorageException {
            this.query = query;
            this.fetch();
        }

        private void fetch() {
            if (this.results != null && this.results.size() < this.pageSize) {
                this.results = new ArrayList<T>();
            } else {
                this.query.setFirstResult(this.pageIndex);
                this.query.setMaxResults(this.pageSize);
                this.results = this.query.getResultList();
            }
            this.resultIndex = 0;
            this.pageIndex += this.pageSize;
        }

        @Override
        public boolean hasNext() {
            return this.resultIndex < this.results.size();
        }

        @Override
        public T next() {
            T rval = this.results.get(this.resultIndex++);
            if (this.resultIndex >= this.results.size()) {
                this.fetch();
            }
            return rval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

