/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa;

import io.apiman.manager.api.jpa.IEntityManagerFactoryAccessor;
import io.apiman.manager.api.jpa.IJpaProperties;
import io.apiman.manager.api.jpa.JpaDialectMapper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.hibernate.jpa.HibernatePersistenceProvider;

@ApplicationScoped
public class EntityManagerFactoryAccessor
implements IEntityManagerFactoryAccessor {
    @Inject
    private IJpaProperties jpaProperties;
    private EntityManagerFactory emf;
    private final ThreadLocal<EntityManager> threadLocal = new ThreadLocal();

    @PostConstruct
    public void postConstruct() {
        String s;
        HashMap<String, String> properties = new HashMap<String, String>();
        Map<String, String> cp = this.jpaProperties.getAllHibernateProperties();
        if (cp != null) {
            properties.putAll(cp);
        }
        if ((s = (String)properties.get("hibernate.hbm2ddl.auto")) == null) {
            s = "validate";
        }
        String autoValue = System.getProperty("apiman.hibernate.hbm2ddl.auto", s);
        s = (String)properties.get("hibernate.dialect");
        if (s == null) {
            s = "org.hibernate.dialect.H2Dialect";
        }
        String apimanDialect = System.getProperty("apiman.hibernate.dialect", s);
        String dialect = JpaDialectMapper.lookupFqdn(apimanDialect);
        properties.put("hibernate.hbm2ddl.auto", autoValue);
        properties.put("hibernate.dialect", dialect);
        try {
            this.emf = Persistence.createEntityManagerFactory((String)"apiman-manager-api-jpa", properties);
        }
        catch (Throwable t1) {
            try {
                this.emf = new HibernatePersistenceProvider().createEntityManagerFactory("apiman-manager-api-jpa", properties);
            }
            catch (Throwable t3) {
                throw t1;
            }
        }
    }

    @Override
    @Produces
    public EntityManagerFactory getEntityManagerFactory() {
        return this.getEntityManager().getEntityManagerFactory();
    }

    @Produces
    public EntityManager getEntityManager() {
        EntityManager threadLocalEm = this.threadLocal.get();
        if (threadLocalEm != null && threadLocalEm.isOpen()) {
            return threadLocalEm;
        }
        EntityManager newEm = this.emf.createEntityManager();
        this.threadLocal.set(newEm);
        return newEm;
    }
}

