/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.jpa.ApimanH2Dialect;
import io.apiman.manager.api.jpa.ApimanMySQL8Dialect;
import io.apiman.manager.api.jpa.ApimanOracle19Dialect;
import io.apiman.manager.api.jpa.ApimanPostgreSQLDialect;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQL91Dialect;
import org.hibernate.dialect.PostgreSQL92Dialect;
import org.hibernate.dialect.PostgreSQL93Dialect;
import org.hibernate.dialect.PostgreSQL94Dialect;
import org.hibernate.dialect.PostgreSQL95Dialect;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.dialect.SQLServerDialect;

public class JpaDialectMapper {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(JpaDialectMapper.class);
    public static final Map<String, NamePair> DB_TYPE_MAP = new HashMap<String, NamePair>();
    private final DataSource ds;
    private final NamePair namePair;

    public JpaDialectMapper(String dsJndiLocation, String hibernateDialect) {
        if (dsJndiLocation == null) {
            throw new RuntimeException("Missing datasource JNDI location from JPA storage configuration.");
        }
        this.ds = JpaDialectMapper.lookupDS(dsJndiLocation);
        this.namePair = DB_TYPE_MAP.get(hibernateDialect);
        if (this.namePair == null) {
            throw new RuntimeException("Unknown hibernate dialect configured: " + hibernateDialect);
        }
    }

    public static String lookupFqdn(String apimanDialect) {
        NamePair pair = DB_TYPE_MAP.get(apimanDialect);
        if (pair != null) {
            return pair.fqdn;
        }
        return apimanDialect;
    }

    public String getSimpleName() {
        return this.namePair.simpleName;
    }

    public String getResolvedDialect() {
        return this.namePair.fqdn;
    }

    public static DataSource lookupDS(String dsJndiLocation) {
        DataSource ds;
        try {
            InitialContext ctx = new InitialContext();
            ds = (DataSource)ctx.lookup(dsJndiLocation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ds == null) {
            throw new RuntimeException("Datasource not found: " + dsJndiLocation);
        }
        return ds;
    }

    static {
        DB_TYPE_MAP.put("h2", NamePair.of("h2", ApimanH2Dialect.class.getName()));
        DB_TYPE_MAP.put(H2Dialect.class.getName(), NamePair.of("h2", H2Dialect.class.getName()));
        DB_TYPE_MAP.put(ApimanH2Dialect.class.getName(), NamePair.of("h2", ApimanH2Dialect.class.getName()));
        DB_TYPE_MAP.put("mysql8", NamePair.of("mysql8", ApimanMySQL8Dialect.class.getName()));
        DB_TYPE_MAP.put("io.apiman.manager.api.jpa.ApimanMySQL5Dialect", NamePair.of("mysql8", ApimanMySQL8Dialect.class.getName()));
        DB_TYPE_MAP.put(ApimanMySQL8Dialect.class.getName(), NamePair.of("mysql8", ApimanMySQL8Dialect.class.getName()));
        DB_TYPE_MAP.put(MySQLDialect.class.getName(), NamePair.of("mysql8", MySQLDialect.class.getName()));
        DB_TYPE_MAP.put(MySQL8Dialect.class.getName(), NamePair.of("mysql8", MySQL8Dialect.class.getName()));
        DB_TYPE_MAP.put("oracle19", NamePair.of("oracle19", ApimanOracle19Dialect.class.getName()));
        DB_TYPE_MAP.put(ApimanOracle19Dialect.class.getName(), NamePair.of("oracle19", ApimanOracle19Dialect.class.getName()));
        DB_TYPE_MAP.put(OracleDialect.class.getName(), NamePair.of("oracle19", OracleDialect.class.getName()));
        DB_TYPE_MAP.put(Oracle8iDialect.class.getName(), NamePair.of("oracle19", Oracle8iDialect.class.getName()));
        DB_TYPE_MAP.put(Oracle9iDialect.class.getName(), NamePair.of("oracle19", Oracle9iDialect.class.getName()));
        DB_TYPE_MAP.put("postgresql11", NamePair.of("postgresql11", ApimanPostgreSQLDialect.class.getName()));
        DB_TYPE_MAP.put(ApimanPostgreSQLDialect.class.getName(), NamePair.of("postgresql11", ApimanPostgreSQLDialect.class.getName()));
        DB_TYPE_MAP.put(PostgreSQLDialect.class.getName(), NamePair.of("postgresql11", PostgreSQLDialect.class.getName()));
        DB_TYPE_MAP.put(PostgreSQL9Dialect.class.getName(), NamePair.of("postgresql11", PostgreSQL9Dialect.class.getName()));
        DB_TYPE_MAP.put(PostgreSQL91Dialect.class.getName(), NamePair.of("postgresql11", PostgreSQL91Dialect.class.getName()));
        DB_TYPE_MAP.put(PostgreSQL92Dialect.class.getName(), NamePair.of("postgresql11", PostgreSQL92Dialect.class.getName()));
        DB_TYPE_MAP.put(PostgreSQL93Dialect.class.getName(), NamePair.of("postgresql11", PostgreSQL93Dialect.class.getName()));
        DB_TYPE_MAP.put(PostgreSQL94Dialect.class.getName(), NamePair.of("postgresql11", PostgreSQL94Dialect.class.getName()));
        DB_TYPE_MAP.put(PostgreSQL95Dialect.class.getName(), NamePair.of("postgresql11", PostgreSQL95Dialect.class.getName()));
        DB_TYPE_MAP.put("mssql15", NamePair.of(SQLServerDialect.class.getName(), "mssql15"));
        DB_TYPE_MAP.put(SQLServerDialect.class.getName(), NamePair.of("mssql15", SQLServerDialect.class.getName()));
        DB_TYPE_MAP.put(SQLServer2012Dialect.class.getName(), NamePair.of("mssql15", SQLServer2012Dialect.class.getName()));
    }

    private static final class NamePair {
        public String simpleName;
        public String fqdn;

        private NamePair() {
        }

        static NamePair of(String simpleName, String fqdn) {
            NamePair np = new NamePair();
            np.simpleName = simpleName;
            np.fqdn = fqdn;
            return np;
        }
    }
}

