/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.EscapeBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.WhereOrBuilder;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.crypt.DataEncryptionContext;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.manager.api.beans.apis.ApiBean;
import io.apiman.manager.api.beans.apis.ApiDefinitionBean;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiPlanBean;
import io.apiman.manager.api.beans.apis.ApiStatus;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntityType;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.clients.ClientBean;
import io.apiman.manager.api.beans.clients.ClientStatus;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.developers.DeveloperBean;
import io.apiman.manager.api.beans.download.DownloadBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.gateways.GatewayType;
import io.apiman.manager.api.beans.idm.DiscoverabilityEntity;
import io.apiman.manager.api.beans.idm.DiscoverabilityLevel;
import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.PermissionConstraint;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanStatus;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plugins.PluginBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.search.OrderByBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiEntryBean;
import io.apiman.manager.api.beans.summary.ApiPlanSummaryBean;
import io.apiman.manager.api.beans.summary.ApiRegistryBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.ClientVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PluginSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.beans.summary.mappers.ApiMapper;
import io.apiman.manager.api.beans.system.MetadataBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.util.PolicyTemplateUtil;
import io.apiman.manager.api.jpa.AbstractJpaStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.Query;

@ApplicationScoped
@Alternative
@Transactional
public class JpaStorage
extends AbstractJpaStorage
implements IStorage,
IStorageQuery {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(JpaStorage.class);
    private IDataEncrypter encrypter;
    private final ApiMapper apiMapper = ApiMapper.INSTANCE;

    @Inject
    public JpaStorage(IDataEncrypter encrypter) {
        this.encrypter = encrypter;
    }

    public JpaStorage() {
    }

    @PostConstruct
    public void postConstruct() {
        this.encrypter.encrypt("", new DataEncryptionContext());
    }

    public void createClient(ClientBean client) throws StorageException {
        super.create(client);
    }

    public void createClientVersion(ClientVersionBean version) throws StorageException {
        super.create(version);
    }

    public void createContract(ContractBean contract) throws StorageException {
        List<ContractSummaryBean> contracts = this.getClientContractsInternal(contract.getClient().getClient().getOrganization().getId(), contract.getClient().getClient().getId(), contract.getClient().getVersion());
        for (ContractSummaryBean csb : contracts) {
            if (!csb.getApiOrganizationId().equals(contract.getApi().getApi().getOrganization().getId()) || !csb.getApiId().equals(contract.getApi().getApi().getId()) || !csb.getApiVersion().equals(contract.getApi().getVersion())) continue;
            throw new IllegalStateException("Error creating contract: duplicate contract detected.");
        }
        super.create(contract);
    }

    public void createGateway(GatewayBean gateway) throws StorageException {
        super.create(gateway);
    }

    public void createDownload(DownloadBean download) throws StorageException {
        super.create(download);
    }

    public void createDeveloper(DeveloperBean developerBean) throws StorageException {
        super.create(developerBean);
    }

    public void createMetadata(MetadataBean metadata) throws StorageException {
        super.create(metadata);
    }

    public void createPlugin(PluginBean plugin) throws StorageException {
        super.create(plugin);
    }

    public void beginTx() throws StorageException {
        if (!this.getSession().getTransaction().isActive()) {
            this.getSession().beginTransaction();
        }
    }

    public void commitTx() throws StorageException {
        this.getSession().getTransaction().commit();
    }

    public void rollbackTx() {
        this.getSession().getTransaction().rollback();
    }

    public void createOrganization(OrganizationBean organization) throws StorageException {
        super.create(organization);
    }

    public void createPlan(PlanBean plan) throws StorageException {
        super.create(plan);
    }

    public void createPlanVersion(PlanVersionBean version) throws StorageException {
        super.create(version);
    }

    public void createPolicy(PolicyBean policy) throws StorageException {
        super.create(policy);
    }

    public void createPolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        super.create(policyDef);
    }

    public void createApi(ApiBean api) throws StorageException {
        super.create(api);
    }

    public void createApiVersion(ApiVersionBean version) throws StorageException {
        super.create(version);
    }

    public void updateClient(ClientBean client) throws StorageException {
        super.update(client);
    }

    public void updateClientVersion(ClientVersionBean version) throws StorageException {
        LOGGER.debug("Updating client version: {0}", new Object[]{version});
        super.update(version);
    }

    public void updateContract(ContractBean contract) throws StorageException {
        super.update(contract);
    }

    public void updateGateway(GatewayBean gateway) throws StorageException {
        super.update(gateway);
    }

    public void updateOrganization(OrganizationBean organization) throws StorageException {
        super.update(organization);
    }

    public void updatePlan(PlanBean plan) throws StorageException {
        super.update(plan);
    }

    public void updatePlanVersion(PlanVersionBean version) throws StorageException {
        super.update(version);
    }

    public void updatePolicy(PolicyBean policy) throws StorageException {
        super.update(policy);
    }

    public void updatePolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        super.update(policyDef);
    }

    public void updatePlugin(PluginBean pluginBean) throws StorageException {
        super.update(pluginBean);
    }

    public void updateDeveloper(DeveloperBean developer) throws StorageException {
        super.update(developer);
    }

    public void updateApi(ApiBean api) throws StorageException {
        super.update(api);
    }

    public void updateApiVersion(ApiVersionBean version) throws StorageException {
        super.update(version);
    }

    public void updateApiDefinition(ApiVersionBean version, InputStream definitionStream) throws StorageException {
        try {
            ApiDefinitionBean bean = super.get(version.getId(), ApiDefinitionBean.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)definitionStream, (OutputStream)baos);
            byte[] data = baos.toByteArray();
            if (bean != null) {
                bean.setData(data);
                super.update(bean);
            } else {
                bean = new ApiDefinitionBean();
                bean.setId(version.getId().longValue());
                bean.setData(data);
                bean.setApiVersion(version);
                super.create(bean);
            }
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteOrganization(OrganizationBean organization) throws StorageException {
        this.deleteAllMemberships(organization);
        this.deleteAllAuditEntries(organization);
        this.deleteAllContracts(organization);
        this.deleteAllPolicies(organization);
        this.remove(organization);
    }

    public void deleteClient(ClientBean client) throws StorageException {
        this.deleteAllAuditEntries(client);
        this.deleteAllContracts(client);
        this.deleteAllPolicies(client);
        this.remove(client);
    }

    public void deleteClientVersion(ClientVersionBean version) throws StorageException {
        this.remove(version);
    }

    public void deleteContract(ContractBean contract) throws StorageException {
        this.remove(contract);
    }

    public void deleteApi(ApiBean api) throws StorageException {
        this.deleteAllAuditEntries(api);
        this.deleteAllContracts(api);
        this.deleteAllPolicies(api);
        this.remove(api);
    }

    public void deleteApiVersion(ApiVersionBean version) throws StorageException {
        this.remove(version);
    }

    public void deleteApiDefinition(ApiVersionBean version) throws StorageException {
        ApiDefinitionBean bean = super.get(version.getId(), ApiDefinitionBean.class);
        if (bean == null) {
            throw new StorageException("No definition found.");
        }
        super.delete(bean);
    }

    public void deletePlan(PlanBean plan) throws StorageException {
        this.deleteAllPolicies(plan);
        this.deleteAllAuditEntries(plan);
        super.delete(plan);
    }

    public void deletePlanVersion(PlanVersionBean version) throws StorageException {
        super.delete(version);
    }

    public void deletePolicy(PolicyBean policy) throws StorageException {
        super.delete(policy);
    }

    public void deleteGateway(GatewayBean gateway) throws StorageException {
        super.delete(gateway);
    }

    public void deleteDownload(DownloadBean download) throws StorageException {
        super.delete(download);
    }

    public void deleteDeveloper(DeveloperBean developer) throws StorageException {
        super.delete(developer);
    }

    public void deletePlugin(PluginBean plugin) throws StorageException {
        super.delete(plugin);
    }

    public void deletePolicyDefinition(PolicyDefinitionBean policyDef) throws StorageException {
        super.delete(policyDef);
    }

    public OrganizationBean getOrganization(String id) throws StorageException {
        return super.get(id, OrganizationBean.class);
    }

    public ClientBean getClient(String organizationId, String id) throws StorageException {
        return super.get(organizationId, id, ClientBean.class);
    }

    public ContractBean getContract(Long id) throws StorageException {
        return super.get(id, ContractBean.class);
    }

    public ApiBean getApi(String organizationId, String id) throws StorageException {
        return super.get(organizationId, id, ApiBean.class);
    }

    public PlanBean getPlan(String organizationId, String id) throws StorageException {
        return super.get(organizationId, id, PlanBean.class);
    }

    public PolicyBean getPolicy(PolicyType type, String organizationId, String entityId, String version, Long id) throws StorageException {
        PolicyBean policyBean = super.get(id, PolicyBean.class);
        if (policyBean == null || policyBean.getType() != type) {
            return null;
        }
        if (!policyBean.getOrganizationId().equals(organizationId)) {
            return null;
        }
        if (!policyBean.getEntityId().equals(entityId)) {
            return null;
        }
        if (!policyBean.getEntityVersion().equals(version)) {
            return null;
        }
        return policyBean;
    }

    public GatewayBean getGateway(String id) throws StorageException {
        return super.get(id, GatewayBean.class);
    }

    public List<GatewayBean> getGateways(Set<String> ids) throws StorageException {
        return this.getActiveEntityManager().createQuery("SELECT g FROM GatewayBean g WHERE g.id IN (:ids)", GatewayBean.class).setParameter("ids", ids).getResultList();
    }

    public DownloadBean getDownload(String id) throws StorageException {
        return super.get(id, DownloadBean.class);
    }

    public DeveloperBean getDeveloper(String id) throws StorageException {
        return super.get(id, DeveloperBean.class);
    }

    public MetadataBean getMetadata(Long id) throws StorageException {
        return super.get(id, MetadataBean.class);
    }

    public PluginBean getPlugin(long id) throws StorageException {
        return super.get(id, PluginBean.class);
    }

    public PluginBean getPlugin(String groupId, String artifactId) throws StorageException {
        try {
            TypedQuery query = this.getActiveEntityManager().createQuery("SELECT p FROM PluginBean p  WHERE p.groupId = :groupId     AND p.artifactId = :artifactId", PluginBean.class).setParameter("groupId", (Object)groupId).setParameter("artifactId", (Object)artifactId);
            return super.getOne(query).orElse(null);
        }
        catch (Throwable t) {
            LOGGER.error(t, t.getMessage(), new Object[0]);
            throw new StorageException(t);
        }
    }

    public PolicyDefinitionBean getPolicyDefinition(String id) throws StorageException {
        return super.get(id, PolicyDefinitionBean.class);
    }

    public void reorderPolicies(PolicyType type, String organizationId, String entityId, String entityVersion, List<Long> newOrder) throws StorageException {
        int orderIndex = 0;
        for (Long policyId : newOrder) {
            PolicyBean storedPolicy = this.getPolicy(type, organizationId, entityId, entityVersion, policyId);
            if (storedPolicy == null) {
                throw new StorageException("Invalid policy id: " + policyId);
            }
            storedPolicy.setOrderIndex(orderIndex++);
            this.updatePolicy(storedPolicy);
        }
    }

    public SearchResultsBean<OrganizationSummaryBean> findOrganizations(SearchCriteriaBean criteria, PermissionConstraint permissionConstraint) throws StorageException {
        Consumer constraintFunc = builder -> {};
        if (permissionConstraint.isConstrained()) {
            constraintFunc = builder -> ((WhereOrBuilder)((SubqueryBuilder)((SubqueryBuilder)((SubqueryBuilder)((WhereOrBuilder)builder.whereOr().where("id").in((Collection)permissionConstraint.getPermittedOrgs())).where("org.id").in().from(DiscoverabilityEntity.class, "d").select("d.orgId")).where("d.discoverability").isNotNull()).where("d.discoverability").in((Collection)permissionConstraint.getAllowedDiscoverabilities())).end()).endOr();
        }
        SearchResultsBean<OrganizationBean> orgs = this.find(criteria, List.of(new OrderByBean(true, "id")), constraintFunc, OrganizationBean.class, "org", true);
        SearchResultsBean rval = new SearchResultsBean();
        rval.setTotalSize(orgs.getTotalSize());
        List beans = orgs.getBeans();
        for (OrganizationBean bean : beans) {
            OrganizationSummaryBean osb = new OrganizationSummaryBean();
            osb.setId(bean.getId());
            osb.setName(bean.getName());
            osb.setDescription(bean.getDescription());
            rval.getBeans().add(osb);
        }
        return rval;
    }

    public SearchResultsBean<ClientSummaryBean> findClients(SearchCriteriaBean criteria, PermissionConstraint permissionConstraint) throws StorageException {
        Consumer constraintFunc = builder -> {};
        if (permissionConstraint.isConstrained()) {
            constraintFunc = builder -> builder.where("organization.id").in((Collection)permissionConstraint.getPermittedOrgs());
        }
        SearchResultsBean<ClientBean> result = this.find(criteria, List.of(new OrderByBean(true, "id"), new OrderByBean(true, "organization.id")), constraintFunc, ClientBean.class, "client", true);
        SearchResultsBean rval = new SearchResultsBean();
        rval.setTotalSize(result.getTotalSize());
        List beans = result.getBeans();
        rval.setBeans(new ArrayList(beans.size()));
        for (ClientBean client : beans) {
            ClientSummaryBean summary = new ClientSummaryBean();
            OrganizationBean organization = client.getOrganization();
            summary.setId(client.getId());
            summary.setName(client.getName());
            summary.setDescription(client.getDescription());
            summary.setImage(client.getImage());
            summary.setNumContracts(0);
            summary.setOrganizationId(client.getOrganization().getId());
            summary.setOrganizationName(organization.getName());
            rval.getBeans().add(summary);
        }
        return rval;
    }

    public SearchResultsBean<ApiSummaryBean> findApis(SearchCriteriaBean criteria, PermissionConstraint permissionConstraint, boolean paginate) throws StorageException {
        Consumer constraintFunc = builder -> {};
        if (permissionConstraint.isConstrained()) {
            constraintFunc = builder -> ((WhereOrBuilder)((SubqueryBuilder)((SubqueryBuilder)((SubqueryBuilder)((WhereOrBuilder)builder.whereOr().where("api.organization.id").in((Collection)permissionConstraint.getPermittedOrgs())).where("api.id").in().from(DiscoverabilityEntity.class, "d").select("d.apiId")).whereExpression("d.orgId = api.organization.id")).where("d.discoverability").in((Collection)permissionConstraint.getAllowedDiscoverabilities())).end()).endOr();
        }
        SearchResultsBean<ApiBean> result = this.find(criteria, List.of(new OrderByBean(true, "api.id"), new OrderByBean(true, "api.organization.id")), constraintFunc, ApiBean.class, "api", paginate);
        List beans = result.getBeans().stream().map(arg_0 -> ((ApiMapper)this.apiMapper).toSummary(arg_0)).collect(Collectors.toList());
        return new SearchResultsBean().setTotalSize(result.getTotalSize()).setBeans(beans);
    }

    public SearchResultsBean<PlanSummaryBean> findPlans(String organizationId, SearchCriteriaBean criteria, PermissionConstraint permissionConstraint) throws StorageException {
        Consumer constraintFunc = builder -> {};
        if (permissionConstraint.isConstrained()) {
            constraintFunc = builder -> ((WhereOrBuilder)((SubqueryBuilder)((SubqueryBuilder)((SubqueryBuilder)((SubqueryBuilder)((WhereOrBuilder)builder.whereOr().where("plan.organization.id").in((Collection)permissionConstraint.getPermittedOrgs())).where("plan.id").in().from(DiscoverabilityEntity.class, "d").select("d.planId")).where("d.orgId").eq((Object)organizationId)).where("d.planId").isNotNull()).where("d.discoverability").in((Collection)permissionConstraint.getAllowedDiscoverabilities())).end()).endOr();
        }
        SearchResultsBean<PlanBean> result = this.find(criteria, List.of(new OrderByBean(true, "id"), new OrderByBean(true, "organization.id")), constraintFunc, PlanBean.class, "plan", true);
        SearchResultsBean rval = new SearchResultsBean();
        rval.setTotalSize(result.getTotalSize());
        List plans = result.getBeans();
        rval.setBeans(new ArrayList(plans.size()));
        for (PlanBean plan : plans) {
            PlanSummaryBean summary = new PlanSummaryBean();
            OrganizationBean organization = plan.getOrganization();
            summary.setId(plan.getId());
            summary.setName(plan.getName());
            summary.setDescription(plan.getDescription());
            summary.setOrganizationId(plan.getOrganization().getId());
            summary.setOrganizationName(organization.getName());
            rval.getBeans().add(summary);
        }
        return rval;
    }

    public void createAuditEntry(AuditEntryBean entry) throws StorageException {
        super.create(entry);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditEntity(String organizationId, String entityId, String entityVersion, Class<T> type, PagingBean paging) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        if (paging != null) {
            criteria.setPaging(paging);
        } else {
            criteria.setPage(1);
            criteria.setPageSize(20);
        }
        criteria.setOrder("id", false);
        if (organizationId != null) {
            criteria.addFilter("organizationId", organizationId, SearchCriteriaFilterOperator.eq);
        }
        if (entityId != null) {
            criteria.addFilter("entityId", entityId, SearchCriteriaFilterOperator.eq);
        }
        if (entityVersion != null) {
            criteria.addFilter("entityVersion", entityVersion, SearchCriteriaFilterOperator.eq);
        }
        if (type != null) {
            AuditEntityType entityType = null;
            if (type == OrganizationBean.class) {
                entityType = AuditEntityType.Organization;
            } else if (type == ClientBean.class) {
                entityType = AuditEntityType.Client;
            } else if (type == ApiBean.class) {
                entityType = AuditEntityType.Api;
            } else if (type == PlanBean.class) {
                entityType = AuditEntityType.Plan;
            }
            if (entityType != null) {
                criteria.addFilter("entityType", entityType.name(), SearchCriteriaFilterOperator.eq);
            }
        }
        return this.find(criteria, List.of(new OrderByBean(true, "id")), AuditEntryBean.class, true);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditUser(String userId, PagingBean paging) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        if (paging != null) {
            criteria.setPaging(paging);
        } else {
            criteria.setPage(1);
            criteria.setPageSize(20);
        }
        criteria.setOrder("createdOn", false);
        if (userId != null) {
            criteria.addFilter("who", userId, SearchCriteriaFilterOperator.eq);
        }
        return this.find(criteria, List.of(new OrderByBean(true, "id")), AuditEntryBean.class, true);
    }

    public List<GatewaySummaryBean> listGateways() throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String sql = "SELECT g.id, g.name, g.description, g.type  FROM gateways g ORDER BY g.name ASC";
            javax.persistence.Query query = entityManager.createNativeQuery(sql);
            List rows = query.getResultList();
            ArrayList<GatewaySummaryBean> gateways = new ArrayList<GatewaySummaryBean>(rows.size());
            for (Object[] row : rows) {
                GatewaySummaryBean gateway = new GatewaySummaryBean();
                gateway.setId(String.valueOf(row[0]));
                gateway.setName(String.valueOf(row[1]));
                gateway.setDescription(String.valueOf(row[2]));
                gateway.setType(GatewayType.valueOf((String)String.valueOf(row[3])));
                gateways.add(gateway);
            }
            return gateways;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<PluginSummaryBean> listPlugins() throws StorageException {
        try {
            String sql = "SELECT p.id, p.artifact_id, p.group_id, p.version, p.classifier, p.type, p.name, p.description, p.created_by, p.created_on  FROM plugins p WHERE p.deleted IS NULL OR p.deleted = 0 ORDER BY p.name ASC";
            return (List)this.getJdbi().withHandle(handle -> handle.createQuery(sql).mapToBean(PluginSummaryBean.class).list());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<PolicyDefinitionSummaryBean> listPolicyDefinitions() throws StorageException {
        try {
            String sql = "SELECT pd.id, pd.policy_impl, pd.name, pd.description, pd.icon, pd.plugin_id, pd.form_type  FROM policydefs pd WHERE pd.deleted IS NULL OR pd.deleted = 0 ORDER BY pd.name ASC";
            return (List)this.getJdbi().withHandle(handle -> handle.createQuery(sql).mapToBean(PolicyDefinitionSummaryBean.class).list());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<OrganizationSummaryBean> getOrgs(Set<String> orgIds) throws StorageException {
        if (orgIds == null || orgIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return (List)this.getJdbi().withHandle(handle -> ((Query)handle.createQuery("SELECT * FROM ORGANIZATIONS org WHERE org.ID IN (<orgIds>) ORDER BY org.id ASC").bindList("orgIds", (Iterable)orgIds)).mapToBean(OrganizationSummaryBean.class).list());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<ClientSummaryBean> getClientsInOrg(String orgId) throws StorageException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        return this.getClientsInOrgs(orgIds);
    }

    public List<ClientSummaryBean> getClientsInOrgs(Set<String> orgIds) throws StorageException {
        if (orgIds == null || orgIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            String sql = "SELECT client.*,        (SELECT COUNT(*)         FROM CONTRACTS contract                  JOIN CLIENT_VERSIONS clientVersion on contract.CLIENTV_ID = clientVersion.ID         WHERE clientVersion.CLIENT_ID = client.ID) AS NUM_CONTRACTS,        (SELECT NAME         FROM ORGANIZATIONS org         WHERE client.ORGANIZATION_ID = org.ID)     AS ORGANIZATION_NAME FROM CLIENTS client WHERE client.ORGANIZATION_ID IN (<orgIds>) ORDER BY client.ID ASC";
            return (List)this.getJdbi().withHandle(handle -> ((Query)handle.createQuery(sql).bindList("orgIds", (Iterable)orgIds)).mapToBean(ClientSummaryBean.class).list());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<ApiSummaryBean> getApisInOrg(String orgId) throws StorageException {
        return this.getApisInOrgs(Set.of(orgId));
    }

    public List<ApiSummaryBean> getApisInOrgs(Set<String> orgIds) throws StorageException {
        if (orgIds == null || orgIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT a FROM ApiBean a JOIN a.organization o WHERE o.id IN :orgs ORDER BY a.id ASC";
            TypedQuery query = entityManager.createQuery(jpql, ApiBean.class);
            query.setParameter("orgs", orgIds);
            return query.getResultList().stream().map(arg_0 -> ((ApiMapper)this.apiMapper).toSummary(arg_0)).collect(Collectors.toList());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public ApiVersionBean getApiVersion(String orgId, String apiId, String apiVersion) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ApiVersionBean v JOIN v.api s JOIN s.organization o WHERE o.id = :orgId AND s.id = :apiId AND v.version = :version";
            TypedQuery query = entityManager.createQuery(jpql, ApiVersionBean.class).setParameter("orgId", (Object)orgId).setParameter("apiId", (Object)apiId).setParameter("version", (Object)apiVersion);
            return super.getOne(query).orElse(null);
        }
        catch (Throwable t) {
            throw new StorageException(t);
        }
    }

    public InputStream getApiDefinition(ApiVersionBean apiVersion) throws StorageException {
        ApiDefinitionBean bean = super.get(apiVersion.getId(), ApiDefinitionBean.class);
        if (bean == null) {
            return null;
        }
        return new ByteArrayInputStream(bean.getData());
    }

    public InputStream getApiDefinition(String apiOrgId, String apiId, String apiVersion) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ApiDefinitionBean v JOIN v.apiVersion av JOIN av.api api JOIN api.organization org WHERE org.id = :apiOrgId AND api.id = :apiId AND av.version = :apiVersion ";
            TypedQuery query = entityManager.createQuery(jpql, ApiDefinitionBean.class).setParameter("apiOrgId", (Object)apiOrgId).setParameter("apiId", (Object)apiId).setParameter("apiVersion", (Object)apiVersion);
            ApiDefinitionBean apiDef = (ApiDefinitionBean)query.getSingleResult();
            return new ByteArrayInputStream(apiDef.getData());
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<ApiVersionSummaryBean> getApiVersions(String orgId, String apiId) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v   FROM ApiVersionBean v  JOIN v.api s  JOIN s.organization o WHERE o.id = :orgId  AND s.id = :apiId ORDER BY v.createdOn DESC";
            TypedQuery query = entityManager.createQuery(jpql, ApiVersionBean.class).setMaxResults(500).setParameter("orgId", (Object)orgId).setParameter("apiId", (Object)apiId);
            List apiVersions = query.getResultList();
            return apiVersions.stream().map(e -> this.apiMapper.toSummary(e)).collect(Collectors.toList());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<ApiBean> getApisByTagNameAndValue(String tagKey, String tagValue) {
        TypedQuery query = this.getActiveEntityManager().createQuery("SELECT avb FROM ApiBean avb JOIN avb.tags tag WHERE tag.key = :key AND tag.value = :value", ApiBean.class).setParameter("key", (Object)tagKey).setParameter("value", (Object)tagValue);
        return query.getResultList();
    }

    public List<ApiBean> getApisByTagName(String tagKey) {
        TypedQuery query = this.getActiveEntityManager().createQuery("SELECT ab FROM ApiBean ab JOIN ab.tags tag WHERE tag.key = :key", ApiBean.class).setParameter("key", (Object)tagKey);
        return query.getResultList();
    }

    public List<ApiPlanSummaryBean> getApiVersionPlans(String organizationId, String apiId, String version) throws StorageException {
        ApiVersionBean versionBean = this.getApiVersion(organizationId, apiId, version);
        ArrayList<ApiPlanBean> apiPlans = new ArrayList<ApiPlanBean>(versionBean.getPlans());
        apiPlans.sort(Comparator.comparingInt(apb -> apb.getOrderIndex()));
        ArrayList<ApiPlanSummaryBean> plans = new ArrayList<ApiPlanSummaryBean>(apiPlans.size());
        if (apiPlans != null) {
            for (ApiPlanBean apb2 : apiPlans) {
                PlanVersionBean planVersion = this.getPlanVersion(organizationId, apb2.getPlanId(), apb2.getVersion());
                ApiPlanSummaryBean summary = new ApiPlanSummaryBean();
                summary.setPlanId(planVersion.getPlan().getId());
                summary.setPlanName(planVersion.getPlan().getName());
                summary.setPlanDescription(planVersion.getPlan().getDescription());
                summary.setVersion(apb2.getVersion());
                summary.setRequiresApproval(apb2.getRequiresApproval());
                summary.setDiscoverability(apb2.getDiscoverability());
                plans.add(summary);
            }
        }
        return plans;
    }

    public List<ContractSummaryBean> getContracts(String organizationId, String apiId, String version, int page, int pageSize) throws StorageException {
        int start = (page - 1) * pageSize;
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT c from ContractBean c   JOIN c.api apiv   JOIN apiv.api api   JOIN c.client clientv   JOIN clientv.client client   JOIN api.organization sorg  JOIN client.organization aorg WHERE api.id = :apiId    AND sorg.id = :orgId    AND apiv.version = :version  ORDER BY sorg.id, api.id ASC";
            javax.persistence.Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)organizationId);
            query.setParameter("apiId", (Object)apiId);
            query.setParameter("version", (Object)version);
            query.setFirstResult(start);
            query.setMaxResults(pageSize);
            List contracts = query.getResultList();
            ArrayList<ContractSummaryBean> rval = new ArrayList<ContractSummaryBean>(contracts.size());
            for (ContractBean contractBean : contracts) {
                ClientBean client = contractBean.getClient().getClient();
                ApiBean api = contractBean.getApi().getApi();
                PlanBean plan = contractBean.getPlan().getPlan();
                OrganizationBean clientOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)client.getOrganization().getId());
                OrganizationBean apiOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)api.getOrganization().getId());
                ContractSummaryBean csb = new ContractSummaryBean();
                csb.setStatus(contractBean.getStatus());
                csb.setClientId(client.getId());
                csb.setClientOrganizationId(client.getOrganization().getId());
                csb.setClientOrganizationName(clientOrg.getName());
                csb.setClientName(client.getName());
                csb.setClientVersion(contractBean.getClient().getVersion());
                csb.setContractId(contractBean.getId());
                csb.setCreatedOn(contractBean.getCreatedOn());
                csb.setPlanId(plan.getId());
                csb.setPlanName(plan.getName());
                csb.setPlanVersion(contractBean.getPlan().getVersion());
                csb.setApiDescription(api.getDescription());
                csb.setApiId(api.getId());
                csb.setApiName(api.getName());
                csb.setApiOrganizationId(apiOrg.getId());
                csb.setApiOrganizationName(apiOrg.getName());
                csb.setApiVersion(contractBean.getApi().getVersion());
                rval.add(csb);
            }
            return rval;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public ClientVersionBean getClientVersion(String orgId, String clientId, String version) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ClientVersionBean v JOIN v.client a JOIN a.organization o WHERE o.id = :orgId AND a.id = :clientId AND v.version = :version";
            return (ClientVersionBean)entityManager.createQuery(jpql, ClientVersionBean.class).setParameter("orgId", (Object)orgId).setParameter("clientId", (Object)clientId).setParameter("version", (Object)version).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<ClientVersionSummaryBean> getClientVersions(String orgId, String clientId) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v  FROM ClientVersionBean v  JOIN v.client a  JOIN a.organization o WHERE o.id = :orgId   AND a.id = :clientId ORDER BY v.createdOn DESC";
            TypedQuery query = entityManager.createQuery(jpql, ClientVersionBean.class).setMaxResults(500).setParameter("orgId", (Object)orgId).setParameter("clientId", (Object)clientId);
            List clientVersions = query.getResultList();
            ArrayList<ClientVersionSummaryBean> rval = new ArrayList<ClientVersionSummaryBean>();
            for (ClientVersionBean clientVersion : clientVersions) {
                ClientVersionSummaryBean avsb = new ClientVersionSummaryBean();
                avsb.setOrganizationId(clientVersion.getClient().getOrganization().getId());
                avsb.setOrganizationName(clientVersion.getClient().getOrganization().getName());
                avsb.setId(clientVersion.getClient().getId());
                avsb.setName(clientVersion.getClient().getName());
                avsb.setDescription(clientVersion.getClient().getDescription());
                avsb.setVersion(clientVersion.getVersion());
                avsb.setApiKey(clientVersion.getApikey());
                avsb.setStatus(clientVersion.getStatus());
                rval.add(avsb);
            }
            return rval;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<ContractSummaryBean> getClientContracts(String organizationId, String clientId, String version) throws StorageException {
        try {
            return this.getClientContractsInternal(organizationId, clientId, version);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    protected List<ContractSummaryBean> getClientContractsInternal(String organizationId, String clientId, String version) throws StorageException {
        ArrayList<ContractSummaryBean> rval = new ArrayList<ContractSummaryBean>();
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT c from ContractBean c   JOIN c.client clientv   JOIN clientv.client client   JOIN client.organization aorg WHERE client.id = :clientId    AND aorg.id = :orgId    AND clientv.version = :version  ORDER BY aorg.id, client.id ASC";
        TypedQuery query = entityManager.createQuery(jpql, ContractBean.class).setParameter("orgId", (Object)organizationId).setParameter("clientId", (Object)clientId).setParameter("version", (Object)version);
        List contracts = query.getResultList();
        for (ContractBean contractBean : contracts) {
            ClientBean client = contractBean.getClient().getClient();
            ApiBean api = contractBean.getApi().getApi();
            PlanBean plan = contractBean.getPlan().getPlan();
            OrganizationBean clientOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)client.getOrganization().getId());
            OrganizationBean apiOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)api.getOrganization().getId());
            ContractSummaryBean csb = new ContractSummaryBean();
            csb.setStatus(contractBean.getStatus());
            csb.setClientId(client.getId());
            csb.setClientOrganizationId(client.getOrganization().getId());
            csb.setClientOrganizationName(clientOrg.getName());
            csb.setClientName(client.getName());
            csb.setClientVersion(contractBean.getClient().getVersion());
            csb.setContractId(contractBean.getId());
            csb.setCreatedOn(contractBean.getCreatedOn());
            csb.setPlanId(plan.getId());
            csb.setPlanName(plan.getName());
            csb.setPlanVersion(contractBean.getPlan().getVersion());
            csb.setApiDescription(api.getDescription());
            csb.setApiId(api.getId());
            csb.setApiName(api.getName());
            csb.setApiOrganizationId(apiOrg.getId());
            csb.setApiOrganizationName(apiOrg.getName());
            csb.setApiVersion(contractBean.getApi().getVersion());
            rval.add(csb);
        }
        return rval;
    }

    public ApiRegistryBean getApiRegistry(String organizationId, String clientId, String version) throws StorageException {
        ApiRegistryBean rval = new ApiRegistryBean();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT c from ContractBean c   JOIN c.client clientv   JOIN clientv.client client   JOIN client.organization aorg WHERE client.id = :clientId    AND aorg.id = :orgId    AND clientv.version = :version  ORDER BY c.id ASC";
            TypedQuery query = entityManager.createQuery(jpql, ContractBean.class).setParameter("orgId", (Object)organizationId).setParameter("clientId", (Object)clientId).setParameter("version", (Object)version);
            List contracts = query.getResultList();
            for (ContractBean contractBean : contracts) {
                ApiVersionBean svb = contractBean.getApi();
                ApiBean api = svb.getApi();
                PlanBean plan = contractBean.getPlan().getPlan();
                OrganizationBean apiOrg = api.getOrganization();
                ApiEntryBean entry = new ApiEntryBean();
                entry.setApiId(api.getId());
                entry.setApiName(api.getName());
                entry.setApiOrgId(apiOrg.getId());
                entry.setApiOrgName(apiOrg.getName());
                entry.setApiVersion(svb.getVersion());
                entry.setPlanId(plan.getId());
                entry.setPlanName(plan.getName());
                entry.setPlanVersion(contractBean.getPlan().getVersion());
                Set gateways = svb.getGateways();
                if (gateways != null && !gateways.isEmpty()) {
                    ApiGatewayBean sgb = (ApiGatewayBean)gateways.iterator().next();
                    entry.setGatewayId(sgb.getGatewayId());
                }
                rval.getApis().add(entry);
            }
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        return rval;
    }

    public List<PlanSummaryBean> getPlansInOrg(String orgId) throws StorageException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        return this.getPlansInOrgs(orgIds);
    }

    public List<PlanSummaryBean> getPlansInOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<PlanSummaryBean> rval = new ArrayList<PlanSummaryBean>();
        if (orgIds == null || orgIds.isEmpty()) {
            return rval;
        }
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT p FROM PlanBean p JOIN p.organization o WHERE o.id IN :orgs ORDER BY p.id ASC";
            TypedQuery query = entityManager.createQuery(jpql, PlanBean.class).setParameter("orgs", orgIds).setMaxResults(500);
            List qr = query.getResultList();
            for (PlanBean bean : qr) {
                PlanSummaryBean summary = new PlanSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                OrganizationBean org = bean.getOrganization();
                summary.setOrganizationId(org.getId());
                summary.setOrganizationName(org.getName());
                rval.add(summary);
            }
            return rval;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public PlanVersionBean getPlanVersion(String orgId, String planId, String version) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from PlanVersionBean v JOIN v.plan p JOIN p.organization o WHERE o.id = :orgId AND p.id = :planId AND v.version = :version";
            TypedQuery query = entityManager.createQuery(jpql, PlanVersionBean.class).setParameter("orgId", (Object)orgId).setParameter("planId", (Object)planId).setParameter("version", (Object)version);
            return (PlanVersionBean)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<PlanVersionSummaryBean> getPlanVersions(String orgId, String planId) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from PlanVersionBean v  JOIN v.plan p  JOIN p.organization o WHERE o.id = :orgId   AND p.id = :planId ORDER BY v.createdOn DESC";
            TypedQuery query = entityManager.createQuery(jpql, PlanVersionBean.class).setMaxResults(500).setParameter("orgId", (Object)orgId).setParameter("planId", (Object)planId);
            List planVersions = query.getResultList();
            ArrayList<PlanVersionSummaryBean> rval = new ArrayList<PlanVersionSummaryBean>(planVersions.size());
            for (PlanVersionBean planVersion : planVersions) {
                PlanVersionSummaryBean pvsb = new PlanVersionSummaryBean();
                pvsb.setOrganizationId(planVersion.getPlan().getOrganization().getId());
                pvsb.setOrganizationName(planVersion.getPlan().getOrganization().getName());
                pvsb.setId(planVersion.getPlan().getId());
                pvsb.setName(planVersion.getPlan().getName());
                pvsb.setDescription(planVersion.getPlan().getDescription());
                pvsb.setVersion(planVersion.getVersion());
                pvsb.setStatus(planVersion.getStatus());
                rval.add(pvsb);
            }
            return rval;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public List<PolicySummaryBean> getPolicies(String organizationId, String entityId, String version, PolicyType type) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT p from PolicyBean p  WHERE p.organizationId = :orgId    AND p.entityId = :entityId    AND p.entityVersion = :entityVersion    AND p.type = :type ORDER BY p.orderIndex ASC";
            TypedQuery query = entityManager.createQuery(jpql, PolicyBean.class).setParameter("orgId", (Object)organizationId).setParameter("entityId", (Object)entityId).setParameter("entityVersion", (Object)version).setParameter("type", (Object)type);
            List policyBeans = query.getResultList();
            ArrayList<PolicySummaryBean> rval = new ArrayList<PolicySummaryBean>(policyBeans.size());
            for (PolicyBean policyBean : policyBeans) {
                PolicyTemplateUtil.generatePolicyDescription((PolicyBean)policyBean);
                PolicySummaryBean psb = new PolicySummaryBean();
                psb.setId(policyBean.getId());
                psb.setName(policyBean.getName());
                psb.setDescription(policyBean.getDescription());
                psb.setPolicyDefinitionId(policyBean.getDefinition().getId());
                psb.setIcon(policyBean.getDefinition().getIcon());
                psb.setCreatedBy(policyBean.getCreatedBy());
                psb.setCreatedOn(policyBean.getCreatedOn());
                rval.add(psb);
            }
            return rval;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public int getMaxPolicyOrderIndex(String organizationId, String entityId, String entityVersion, PolicyType type) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        criteria.addFilter("organizationId", organizationId, SearchCriteriaFilterOperator.eq);
        criteria.addFilter("entityId", entityId, SearchCriteriaFilterOperator.eq);
        criteria.addFilter("entityVersion", entityVersion, SearchCriteriaFilterOperator.eq);
        criteria.addFilter("type", type.name(), SearchCriteriaFilterOperator.eq);
        criteria.setOrder("orderIndex", false);
        criteria.setPage(1);
        criteria.setPageSize(1);
        SearchResultsBean<PolicyBean> resultsBean = this.find(criteria, List.of(new OrderByBean(true, "id")), PolicyBean.class, true);
        if (resultsBean.getBeans() == null || resultsBean.getBeans().isEmpty()) {
            return 0;
        }
        return ((PolicyBean)resultsBean.getBeans().get(0)).getOrderIndex();
    }

    public List<PolicyDefinitionSummaryBean> listPluginPolicyDefs(Long pluginId) throws StorageException {
        try {
            String sql = "SELECT pd.id, pd.policy_impl, pd.name, pd.description, pd.icon, pd.plugin_id, pd.form_type  FROM policydefs pd WHERE pd.plugin_id = :pluginId ORDER BY pd.name ASC";
            return (List)this.getJdbi().withHandle(handle -> ((Query)handle.createQuery(sql).bind("pluginId", pluginId)).mapToBean(PolicyDefinitionSummaryBean.class).list());
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public void createUser(UserBean user) throws StorageException {
        super.create(user);
    }

    public UserBean getUser(String userId) throws StorageException {
        return super.get(userId, UserBean.class);
    }

    public void updateUser(UserBean user) throws StorageException {
        super.update(user);
    }

    public SearchResultsBean<UserBean> findUsers(SearchCriteriaBean criteria) throws StorageException {
        return super.find(criteria, List.of(new OrderByBean(true, "username")), UserBean.class, true);
    }

    public void createRole(RoleBean role) throws StorageException {
        super.create(role);
    }

    public void updateRole(RoleBean role) throws StorageException {
        super.update(role);
    }

    public void deleteRole(RoleBean role) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            RoleBean prole = this.get(role.getId(), RoleBean.class);
            entityManager.createQuery("DELETE from RoleMembershipBean m WHERE m.roleId = :roleId").setParameter("roleId", (Object)role.getId()).executeUpdate();
            super.delete(prole);
        }
        catch (Throwable t) {
            throw new StorageException(t);
        }
    }

    public RoleBean getRole(String roleId) throws StorageException {
        return this.getRoleInternal(roleId);
    }

    public SearchResultsBean<RoleBean> findRoles(SearchCriteriaBean criteria) throws StorageException {
        return super.find(criteria, List.of(new OrderByBean(true, "id")), RoleBean.class, true);
    }

    public void createMembership(RoleMembershipBean membership) throws StorageException {
        super.create(membership);
    }

    public RoleMembershipBean getMembership(String userId, String roleId, String organizationId) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            TypedQuery query = entityManager.createQuery("SELECT m FROM RoleMembershipBean m WHERE m.roleId = :roleId AND m.userId = :userId AND m.organizationId = :orgId", RoleMembershipBean.class).setParameter("roleId", (Object)roleId).setParameter("userId", (Object)userId).setParameter("orgId", (Object)organizationId);
            return query.getResultStream().findFirst().orElse(null);
        }
        catch (Throwable t) {
            throw new StorageException(t);
        }
    }

    public void deleteMembership(String userId, String roleId, String organizationId) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            entityManager.createQuery("DELETE FROM RoleMembershipBean m WHERE m.roleId = :roleId AND m.userId = :userId AND m.organizationId = :orgId").setParameter("roleId", (Object)roleId).setParameter("userId", (Object)userId).setParameter("orgId", (Object)organizationId).executeUpdate();
        }
        catch (Throwable t) {
            throw new StorageException(t);
        }
    }

    public void deleteMemberships(String userId, String organizationId) throws StorageException {
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            entityManager.createQuery("DELETE FROM RoleMembershipBean m WHERE m.userId = :userId AND m.organizationId = :orgId").setParameter("userId", (Object)userId).setParameter("orgId", (Object)organizationId).executeUpdate();
        }
        catch (Throwable t) {
            throw new StorageException(t);
        }
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId) throws StorageException {
        try {
            List memberships = ((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), RoleMembershipBean.class).where("userId").eq((Object)userId)).getResultList();
            return Set.copyOf(memberships);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId, String organizationId) throws StorageException {
        try {
            List memberships = ((CriteriaBuilder)((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), RoleMembershipBean.class).where("userId").eq((Object)userId)).where("organizationId").eq((Object)organizationId)).getResultList();
            return Set.copyOf(memberships);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public Set<RoleMembershipBean> getOrgMemberships(String organizationId) throws StorageException {
        try {
            List memberships = ((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), RoleMembershipBean.class).where("organizationId").eq((Object)organizationId)).getResultList();
            return Set.copyOf(memberships);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    public Set<PermissionBean> getPermissions(String userId) throws StorageException {
        try {
            List resultList = ((CriteriaBuilder)((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), RoleMembershipBean.class).where("userId").eq((Object)userId)).setMaxResults(500)).getResultList();
            List<String> roleIds = resultList.stream().map(RoleMembershipBean::getRoleId).collect(Collectors.toList());
            Map<String, RoleBean> roleMap = this.getRolesById(roleIds).stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
            HashSet<PermissionBean> permissions = new HashSet<PermissionBean>(resultList.size());
            for (RoleMembershipBean membership : resultList) {
                String qualifier = membership.getOrganizationId();
                for (PermissionType permission : roleMap.get(membership.getRoleId()).getPermissions()) {
                    PermissionBean p = new PermissionBean();
                    p.setName(permission);
                    p.setOrganizationId(qualifier);
                    permissions.add(p);
                }
            }
            return permissions;
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw new StorageException(t);
        }
    }

    private List<RoleBean> getRolesById(List<String> roleIds) {
        return ((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), RoleBean.class).where("id").in(roleIds)).getResultList();
    }

    protected RoleBean getRoleInternal(String roleId) throws StorageException {
        return super.get(roleId, RoleBean.class);
    }

    public List<DiscoverabilityEntity> getOrgApiPlansWithDiscoverability(String orgId, Set<DiscoverabilityLevel> discoverabilities) {
        return ((CriteriaBuilder)((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), DiscoverabilityEntity.class, "discoverability").where("orgId").eqExpression(":apiOrgId")).setParameter("apiOrgId", (Object)orgId)).getResultList();
    }

    public List<DiscoverabilityEntity> getDiscoverabilities(String apiOrgId, String apiId, String apiVersion) {
        return ((CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), DiscoverabilityEntity.class, "discoverability").where("orgId").eqExpression(":apiOrgId")).where("apiId").eqExpression(":apiId")).where("apiVersion").eqExpression(":apiVersion")).setParameter("apiOrgId", (Object)apiOrgId)).setParameter("apiId", (Object)apiId)).setParameter("apiVersion", (Object)apiVersion)).getResultList();
    }

    public List<DiscoverabilityEntity> getDiscoverabilityById(String id) {
        return ((CriteriaBuilder)((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), DiscoverabilityEntity.class, "discoverability").where("id").eqExpression(":id")).setParameter("id", (Object)id)).getResultList();
    }

    public List<DiscoverabilityEntity> getDiscoverabilityByIdPrefix(String idPrefix) {
        return ((CriteriaBuilder)((CriteriaBuilder)((EscapeBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), DiscoverabilityEntity.class, "discoverability").where("id").like().expression(":idPrefix%")).noEscape()).setParameter("idPrefix", (Object)idPrefix)).getResultList();
    }

    public Iterator<OrganizationBean> getAllOrganizations() throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jqpl = "SELECT b FROM OrganizationBean b ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jqpl);
        return super.getAll(OrganizationBean.class, query);
    }

    public Iterator<PlanBean> getAllPlans(String organizationId) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM PlanBean b WHERE b.organization.id = :orgId ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)organizationId);
        return super.getAll(PlanBean.class, query);
    }

    public Iterator<ApiBean> getAllApis(String organizationId) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM ApiBean b WHERE b.organization.id = :orgId ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)organizationId);
        return super.getAll(ApiBean.class, query);
    }

    public Iterator<ClientBean> getAllClients(String organizationId) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM ClientBean b WHERE b.organization.id = :orgId ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)organizationId);
        return super.getAll(ClientBean.class, query);
    }

    public Iterator<ClientVersionBean> getAllClientVersions(String organizationId, String clientId) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT v    FROM ClientVersionBean v    JOIN v.client a    JOIN a.organization o   WHERE o.id = :orgId     AND a.id = :clientId  ORDER BY v.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)organizationId);
        query.setParameter("clientId", (Object)clientId);
        return super.getAll(ClientVersionBean.class, query);
    }

    public Iterator<ContractBean> getAllContracts(String organizationId, String clientId, String version) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT c from ContractBean c   JOIN c.client clientv   JOIN clientv.client client   JOIN client.organization aorg WHERE client.id = :clientId    AND aorg.id = :orgId    AND clientv.version = :version  ORDER BY c.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)organizationId);
        query.setParameter("clientId", (Object)clientId);
        query.setParameter("version", (Object)version);
        return this.getAll(ContractBean.class, query);
    }

    public Iterator<PolicyBean> getAllPolicies(String organizationId, String entityId, String version, PolicyType type) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT p from PolicyBean p  WHERE p.organizationId = :orgId    AND p.entityId = :entityId    AND p.entityVersion = :entityVersion    AND p.type = :type ORDER BY p.orderIndex ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)organizationId);
        query.setParameter("entityId", (Object)entityId);
        query.setParameter("entityVersion", (Object)version);
        query.setParameter("type", (Object)type);
        return this.getAll(PolicyBean.class, query);
    }

    public Iterator<PlanVersionBean> getAllPlanVersions(String organizationId, String planId) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT v    FROM PlanVersionBean v    JOIN v.plan p    JOIN p.organization o   WHERE o.id = :orgId     AND p.id = :planId  ORDER BY v.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)organizationId);
        query.setParameter("planId", (Object)planId);
        return super.getAll(PlanVersionBean.class, query);
    }

    public Iterator<ApiVersionBean> getAllApiVersions(String organizationId, String apiId) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT v    FROM ApiVersionBean v    JOIN v.api s    JOIN s.organization o   WHERE o.id = :orgId     AND s.id = :apiId  ORDER BY v.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql).setParameter("orgId", (Object)organizationId).setParameter("apiId", (Object)apiId);
        return super.getAll(ApiVersionBean.class, query);
    }

    public Iterator<GatewayBean> getAllGateways() throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM GatewayBean b ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        return super.getAll(GatewayBean.class, query);
    }

    public Iterator<AuditEntryBean> getAllAuditEntries(String orgId) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM AuditEntryBean b WHERE b.organizationId = :orgId ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)orgId);
        return super.getAll(AuditEntryBean.class, query);
    }

    public Iterator<PluginBean> getAllPlugins() throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM PluginBean b ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        return super.getAll(PluginBean.class, query);
    }

    public Iterator<PolicyDefinitionBean> getAllPolicyDefinitions() throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM PolicyDefinitionBean b ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        return super.getAll(PolicyDefinitionBean.class, query);
    }

    public Iterator<RoleMembershipBean> getAllMemberships(String orgId) throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM RoleMembershipBean b WHERE b.organizationId = :orgId ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        query.setParameter("orgId", (Object)orgId);
        return super.getAll(RoleMembershipBean.class, query);
    }

    public Iterator<UserBean> getAllUsers() throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM UserBean b ORDER BY b.username ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        return super.getAll(UserBean.class, query);
    }

    public Iterator<RoleBean> getAllRoles() throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT b FROM RoleBean b ORDER BY b.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        return super.getAll(RoleBean.class, query);
    }

    public Iterator<DeveloperBean> getDevelopers() throws StorageException {
        EntityManager entityManager = this.getActiveEntityManager();
        String jpql = "SELECT db FROM DeveloperBean db ORDER BY db.id ASC";
        javax.persistence.Query query = entityManager.createQuery(jpql);
        return super.getAll(DeveloperBean.class, query);
    }

    public Iterator<ContractBean> getAllContracts(OrganizationBean organizationBean, int lim) throws StorageException {
        String jpql = " SELECT contractBean  FROM ContractBean contractBean  JOIN contractBean.api apiVersion  JOIN apiVersion.api api  JOIN api.organization apiOrg  JOIN contractBean.client clientVersion  JOIN clientVersion.client client  JOIN api.organization clientOrg  WHERE (apiOrg.id = :orgId AND apiVersion.status = :apiStatus) OR (clientOrg.id = :orgId AND clientVersion.status = :clientStatus)";
        javax.persistence.Query query = this.getActiveEntityManager().createQuery(jpql);
        query.setParameter("orgId", (Object)organizationBean.getId());
        query.setParameter("clientStatus", (Object)ClientStatus.Registered);
        query.setParameter("apiStatus", (Object)ApiStatus.Published);
        if (lim > 0) {
            query.setMaxResults(lim);
        }
        return super.getAll(ContractBean.class, query);
    }

    public Iterator<ClientVersionBean> getAllClientVersions(OrganizationBean organizationBean, int lim) throws StorageException {
        return this.getAllClientVersions(organizationBean, null, lim);
    }

    public Iterator<ClientVersionBean> getAllClientVersions(OrganizationBean organizationBean, ClientStatus status, int lim) throws StorageException {
        CriteriaBuilder builder = (CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), ClientVersionBean.class, "v").innerJoin("v.client", "c")).innerJoin("c.organization", "o")).where("o.id").eq((Object)organizationBean.getId());
        if (status != null) {
            builder = (CriteriaBuilder)builder.where("v.status").eq((Object)status);
        }
        if (lim > 0) {
            builder.setMaxResults(lim);
        }
        return super.getAll(ClientVersionBean.class, (javax.persistence.Query)builder.getQuery());
    }

    public Iterator<ApiVersionBean> getAllApiVersions(OrganizationBean organizationBean, int lim) throws StorageException {
        return this.getAllApiVersions(organizationBean, null, lim);
    }

    public Iterator<ApiVersionBean> getAllApiVersions(OrganizationBean organizationBean, ApiStatus status, int lim) throws StorageException {
        CriteriaBuilder builder = (CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), ApiVersionBean.class, "v").innerJoin("v.api", "a")).innerJoin("a.organization", "o")).where("o.id").eq((Object)organizationBean.getId());
        if (status != null) {
            builder = (CriteriaBuilder)builder.where("v.status").eq((Object)status);
        }
        if (lim > 0) {
            builder.setMaxResults(lim);
        }
        return super.getAll(ApiVersionBean.class, (javax.persistence.Query)builder.getQuery());
    }

    public Iterator<PlanVersionBean> getAllPlanVersions(OrganizationBean organizationBean, int lim) throws StorageException {
        return this.getAllPlanVersions(organizationBean, null, lim);
    }

    public Iterator<PlanVersionBean> getAllPlanVersions(OrganizationBean organizationBean, PlanStatus status, int lim) throws StorageException {
        CriteriaBuilder builder = (CriteriaBuilder)((CriteriaBuilder)((CriteriaBuilder)this.getCriteriaBuilderFactory().create(this.getActiveEntityManager(), PlanVersionBean.class, "v").innerJoin("v.plan", "p")).innerJoin("p.organization", "o")).where("o.id").eq((Object)organizationBean.getId());
        if (status != null) {
            builder = (CriteriaBuilder)builder.where("v.status").eq((Object)status);
        }
        if (lim > 0) {
            builder.setMaxResults(lim);
        }
        return super.getAll(PlanVersionBean.class, (javax.persistence.Query)builder.getQuery());
    }

    public Iterator<ApiVersionBean> getAllPublicApiVersions() throws StorageException {
        String jpql = "SELECT v   FROM ApiVersionBean v   WHERE v.publicAPI = true";
        javax.persistence.Query query = this.getActiveEntityManager().createQuery(jpql);
        this.getActiveEntityManager().createQuery(jpql);
        return super.getAll(ApiVersionBean.class, query);
    }

    public List<UserBean> getAllUsersWithPermission(PermissionType permission, String orgName) throws StorageException {
        return (List)this.getJdbi().withHandle(h -> ((Query)((Query)((Query)h.createQuery("SELECT DISTINCT u.* FROM USERS u      INNER JOIN MEMBERSHIPS m ON m.USER_ID = u.USERNAME      INNER JOIN PERMISSIONS p ON p.ROLE_ID = m.ROLE_ID      INNER JOIN USERS ON u.USERNAME = m.USER_ID WHERE p.PERMISSIONS = :permissionType   AND m.ORG_ID = :orgName").bind("permissionType", permission.ordinal())).bind("orgName", orgName)).registerColumnMapper(QualifiedType.of(Locale.class), (resultSet, columnNumber, ctx) -> new Locale.Builder().setLanguageTag(resultSet.getString(columnNumber)).build())).mapToBean(UserBean.class).list());
    }

    public List<UserBean> getAllUsersWithRole(String roleName, String orgName) throws StorageException {
        return (List)this.getJdbi().withHandle(h -> ((Query)((Query)h.createQuery("SELECT DISTINCT u.*  FROM USERS u       INNER JOIN MEMBERSHIPS m ON m.USER_ID = u.USERNAME      INNER JOIN USERS ON u.USERNAME = m.USER_ID WHERE m.ORG_ID = :orgName   AND m.ROLE_ID = :roleName").bind("orgName", orgName)).bind("roleName", roleName)).mapToBean(UserBean.class).list());
    }

    public void flush() {
        this.getActiveEntityManager().flush();
    }

    public <T> T merge(T o) {
        return (T)this.getActiveEntityManager().merge(o);
    }

    public <T> T getEntityObjectReference(Class<T> klazz, Object primaryKey) {
        return (T)this.getActiveEntityManager().getReference(klazz, primaryKey);
    }

    private void deleteAllPolicies(OrganizationBean organizationBean) throws StorageException {
        this.deleteAllPolicies(organizationBean, null, null);
    }

    private void deleteAllPolicies(PlanBean planBean) throws StorageException {
        this.deleteAllPolicies(planBean.getOrganization(), planBean.getId(), PolicyType.Plan);
    }

    private void deleteAllPolicies(ApiBean apiBean) throws StorageException {
        this.deleteAllPolicies(apiBean.getOrganization(), apiBean.getId(), PolicyType.Api);
    }

    private void deleteAllPolicies(ClientBean clientBean) throws StorageException {
        this.deleteAllPolicies(clientBean.getOrganization(), clientBean.getId(), PolicyType.Client);
    }

    private void deleteAllPolicies(OrganizationBean organizationBean, String entityId, PolicyType type) throws StorageException {
        DeleteCriteriaBuilder builder = (DeleteCriteriaBuilder)this.getCriteriaBuilderFactory().delete(this.getActiveEntityManager(), PolicyBean.class, "b").where("b.organizationId").eq((Object)organizationBean.getId());
        if (entityId != null) {
            builder = (DeleteCriteriaBuilder)builder.where("b.entityId").eq((Object)entityId);
        }
        if (type != null) {
            builder = (DeleteCriteriaBuilder)builder.where("b.type").eq((Object)type);
        }
        builder.executeUpdate();
    }

    private void deleteAllMemberships(OrganizationBean organizationBean) throws StorageException {
        String jpql = "DELETE FROM RoleMembershipBean b    WHERE b.organizationId = :orgId ";
        javax.persistence.Query query = this.getActiveEntityManager().createQuery(jpql);
        query.setParameter("orgId", (Object)organizationBean.getId());
        query.executeUpdate();
    }

    private void deleteAllAuditEntries(PlanBean plan) throws StorageException {
        this.deleteAllAuditEntries(plan.getOrganization(), AuditEntityType.Plan, plan.getId());
    }

    private void deleteAllAuditEntries(ApiBean apiBean) throws StorageException {
        this.deleteAllAuditEntries(apiBean.getOrganization(), AuditEntityType.Api, apiBean.getId());
    }

    private void deleteAllAuditEntries(ClientBean clientBean) throws StorageException {
        this.deleteAllAuditEntries(clientBean.getOrganization(), AuditEntityType.Client, clientBean.getId());
    }

    private void deleteAllAuditEntries(OrganizationBean organizationBean) throws StorageException {
        this.deleteAllAuditEntries(organizationBean, null, null);
    }

    private void deleteAllAuditEntries(OrganizationBean organizationBean, AuditEntityType entityType, String entityId) throws StorageException {
        DeleteCriteriaBuilder builder = (DeleteCriteriaBuilder)this.getCriteriaBuilderFactory().delete(this.getActiveEntityManager(), AuditEntryBean.class, "b").where("b.organizationId").eq((Object)organizationBean.getId());
        if (entityId != null) {
            builder = (DeleteCriteriaBuilder)builder.where("b.entityId").eq((Object)entityId);
        }
        if (entityType != null) {
            builder = (DeleteCriteriaBuilder)builder.where("b.entityType").eq((Object)entityType);
        }
        builder.executeUpdate();
    }

    private void deleteAllContracts(ApiBean apiBean) throws StorageException {
        String jpql = "DELETE FROM ContractBean deleteBean    WHERE deleteBean IN (        SELECT b            FROM ContractBean b            JOIN b.api apiVersion            JOIN apiVersion.api api            JOIN api.organization o        WHERE o.id = :orgId        AND api.id = :apiId    )";
        javax.persistence.Query query = this.getActiveEntityManager().createQuery(jpql);
        query.setParameter("orgId", (Object)apiBean.getOrganization().getId());
        query.setParameter("apiId", (Object)apiBean.getId());
        query.executeUpdate();
    }

    private void deleteAllContracts(ClientBean clientBean) throws StorageException {
        String jpql = "DELETE FROM ContractBean deleteBean    WHERE deleteBean IN (        SELECT b            FROM ContractBean b            JOIN b.client clientVersion            JOIN clientVersion.client client            JOIN client.organization o        WHERE o.id = :orgId        AND client.id = :clientId    )";
        javax.persistence.Query query = this.getActiveEntityManager().createQuery(jpql);
        query.setParameter("orgId", (Object)clientBean.getOrganization().getId());
        query.setParameter("clientId", (Object)clientBean.getId());
        query.executeUpdate();
    }

    private void deleteAllContracts(OrganizationBean organizationBean) throws StorageException {
        String jpql = "DELETE FROM ContractBean deleteBean    WHERE deleteBean IN (        SELECT b            FROM ContractBean b            JOIN b.api apiVersion            JOIN apiVersion.api api            JOIN api.organization o        WHERE o.id = :orgId    )";
        javax.persistence.Query query = this.getActiveEntityManager().createQuery(jpql);
        query.setParameter("orgId", (Object)organizationBean.getId());
        query.executeUpdate();
    }

    private <T> void remove(T entity) throws StorageException {
        EntityManager em;
        em.remove((em = this.getActiveEntityManager()).contains(entity) ? entity : em.merge(entity));
    }

    public void deleteAllPlans(OrganizationBean organizationBean) throws StorageException {
        this.deleteAllPlanVersions(organizationBean);
        String jpql = "DELETE FROM PlanBean p      WHERE p.organization.id = :orgId ";
        javax.persistence.Query query = this.getActiveEntityManager().createQuery(jpql);
        query.setParameter("orgId", (Object)organizationBean.getId());
        query.executeUpdate();
    }

    private void deleteAllPlanVersions(OrganizationBean organizationBean) throws StorageException {
        String jpql = "DELETE FROM PlanVersionBean deleteBean  WHERE deleteBean IN (SELECT v  FROM PlanVersionBean v   JOIN v.plan p   JOIN p.organization o  WHERE o.id = :orgId )";
        javax.persistence.Query query = this.getActiveEntityManager().createQuery(jpql);
        query.setParameter("orgId", (Object)organizationBean.getId());
        query.executeUpdate();
    }
}

