/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa;

import io.apiman.manager.api.core.config.ApiManagerConfig;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import liquibase.integration.cdi.CDILiquibaseConfig;
import liquibase.integration.cdi.annotations.LiquibaseType;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class LiquibaseProducer {
    @Inject
    private ApiManagerConfig config;

    @Produces
    @LiquibaseType
    public CDILiquibaseConfig createConfig() {
        CDILiquibaseConfig config = new CDILiquibaseConfig();
        config.setChangeLog("/liquibase/master.xml");
        return config;
    }

    @Produces
    @LiquibaseType
    public DataSource createDataSource() throws NamingException {
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)ctx.lookup(this.config.getHibernateDataSource());
        if (ds == null) {
            throw new RuntimeException("Datasource not found: " + this.config.getHibernateDataSource());
        }
        return ds;
    }

    @Produces
    @LiquibaseType
    public ResourceAccessor create() {
        return new ClassLoaderResourceAccessor(this.getClass().getClassLoader());
    }
}

