/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.notifications.NotificationEntity;
import io.apiman.manager.api.beans.notifications.NotificationPreferenceEntity;
import io.apiman.manager.api.beans.notifications.NotificationStatus;
import io.apiman.manager.api.beans.notifications.NotificationType;
import io.apiman.manager.api.beans.search.OrderByBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.core.INotificationRepository;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.jpa.AbstractJpaStorage;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.TypedQuery;
import org.jdbi.v3.core.statement.Query;
import org.jetbrains.annotations.Nullable;

@ApplicationScoped
@ParametersAreNonnullByDefault
public class NotificationRepositoryImpl
extends AbstractJpaStorage
implements INotificationRepository {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(NotificationRepositoryImpl.class);

    public NotificationEntity getNotificationById(Long notificationId) throws StorageException {
        return super.get(notificationId, NotificationEntity.class);
    }

    public SearchResultsBean<NotificationEntity> searchNotificationsByUser(String recipientUserId, SearchCriteriaBean searchCriteria) throws StorageException {
        SearchCriteriaFilterBean recipientFilter = new SearchCriteriaFilterBean().setName("recipient").setOperator(SearchCriteriaFilterOperator.eq).setValue(recipientUserId);
        searchCriteria.getFilters().add(recipientFilter);
        return super.find(searchCriteria, List.of(new OrderByBean(true, "id")), NotificationEntity.class, true);
    }

    public SearchResultsBean<NotificationEntity> getLatestNotificationsByRecipientId(String recipientUserId, @Nullable PagingBean paging) throws StorageException {
        SearchCriteriaFilterBean filter = new SearchCriteriaFilterBean().setName("recipient").setOperator(SearchCriteriaFilterOperator.eq).setValue(recipientUserId);
        SearchCriteriaBean searchCriteria = new SearchCriteriaBean().setFilters(List.of(filter)).setPaging(paging).setOrder("id", false);
        return super.find(searchCriteria, List.of(new OrderByBean(true, "id")), NotificationEntity.class, true);
    }

    public void create(NotificationEntity entity) throws StorageException {
        super.create(entity);
    }

    public void update(NotificationEntity entity) throws StorageException {
        super.update(entity);
    }

    public void delete(NotificationEntity entity) throws StorageException {
        super.delete(entity);
    }

    public void deleteById(Long id) throws StorageException {
        this.delete(super.get(id, NotificationEntity.class));
    }

    public void deleteAll() {
        int n = this.getActiveEntityManager().createQuery("DELETE FROM NotificationEntity").executeUpdate();
        LOGGER.debug("Deleted all Notifications, this resulted in {0} records being removed.", new Object[]{n});
    }

    public void deleteByUserId(String recipientUserId) {
        int n = this.getActiveEntityManager().createQuery("DELETE FROM NotificationEntity n WHERE n.recipient = :recipientId").setParameter("recipientId", (Object)recipientUserId).executeUpdate();
        LOGGER.debug("Deleted all Notifications for recipient {0}, this resulted in {1} records being removed.", new Object[]{recipientUserId, n});
    }

    public int countNotificationsByUserId(String recipientUserId, List<NotificationStatus> notificationStatus) {
        List statusNames = notificationStatus.stream().map(Enum::name).collect(Collectors.toList());
        return (Integer)this.getJdbi().withHandle(jdbi -> (Integer)((Query)((Query)jdbi.createQuery("SELECT COUNT(n.id) FROM NOTIFICATIONS n WHERE n.recipient = :userId AND n.status IN (<status>)").bind("userId", recipientUserId)).bindList("status", (Iterable)statusNames)).mapTo(Integer.TYPE).one());
    }

    public void markNotificationsWithStatusById(String recipientUserId, List<Long> idList, NotificationStatus status) throws StorageException {
        int n = this.getActiveEntityManager().createQuery("UPDATE NotificationEntity n SET n.status = :newStatus,     n.modifiedOn = :now WHERE n.recipient = :recipientId AND n.id IN :idList").setParameter("newStatus", (Object)status).setParameter("now", (Object)OffsetDateTime.now()).setParameter("recipientId", (Object)recipientUserId).setParameter("idList", idList).executeUpdate();
        LOGGER.debug("Marked all unread notifications for recipient {0} to status {1}, this affected {2} records.", new Object[]{recipientUserId, status, n});
    }

    public void markAllNotificationsReadByUserId(String recipientUserId, NotificationStatus status) {
        int n = this.getActiveEntityManager().createQuery("UPDATE NotificationEntity n SET n.status = :newStatus,     n.modifiedOn = :now WHERE n.recipient = :recipientId AND n.status = 'OPEN'").setParameter("newStatus", (Object)status).setParameter("recipientId", (Object)recipientUserId).setParameter("now", (Object)OffsetDateTime.now()).executeUpdate();
        LOGGER.debug("Marked all unread notifications for recipient {0} to status {1}, this affected {2} records.", new Object[]{recipientUserId, status, n});
    }

    public Optional<NotificationPreferenceEntity> getNotificationPreferenceByUserId(String userId) {
        TypedQuery query = this.getActiveEntityManager().createQuery("SELECT pref FROM NotificationPreferenceEntity pref WHERE pref.user.username = :userId", NotificationPreferenceEntity.class).setParameter("userId", (Object)userId);
        return super.getOne(query);
    }

    public Optional<NotificationPreferenceEntity> getNotificationPreferenceByUserIdAndType(String userId, NotificationType notificationType) {
        TypedQuery query = this.getActiveEntityManager().createQuery("SELECT pref FROM NotificationPreferenceEntity pref WHERE pref.user.username = :userId AND pref.type = :notificationType", NotificationPreferenceEntity.class).setParameter("userId", (Object)userId).setParameter("notificationType", (Object)notificationType);
        return super.getOne(query);
    }

    public void create(NotificationPreferenceEntity entity) throws StorageException {
        super.create(entity);
    }

    public void update(NotificationPreferenceEntity entity) throws StorageException {
        super.update(entity);
    }

    public void delete(NotificationPreferenceEntity entity) throws StorageException {
        super.update(entity);
    }
}

