/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa.blobstore;

import io.apiman.common.util.Preconditions;
import io.apiman.manager.api.beans.blobs.BlobEntity;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.jpa.AbstractJpaStorage;
import java.time.OffsetDateTime;
import java.util.Iterator;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.Transactional;
import org.jetbrains.annotations.NotNull;

@ApplicationScoped
public class BlobStoreRepository
extends AbstractJpaStorage {
    public void create(@NotNull BlobEntity bean) throws StorageException {
        Preconditions.requireNonBlank((String)bean.getId(), (String)"Caller must set ID for blob before storing to ensure they are able to look it up");
        super.create(bean);
    }

    public BlobEntity getById(@NotNull String uid) throws StorageException {
        Preconditions.requireNonBlank((String)uid, (String)"uid must be non-blank");
        return super.get(uid, BlobEntity.class);
    }

    public void deleteById(@NotNull String uid) throws StorageException {
        Preconditions.requireNonBlank((String)uid, (String)"uid must be non-blank");
        EntityManager em = super.getActiveEntityManager();
        em.flush();
        em.createQuery("DELETE FROM BlobEntity b WHERE b.refCount <= 1 AND b.id = :uid").setParameter("uid", (Object)uid).executeUpdate();
        em.createQuery("UPDATE BlobEntity b SET b.refCount = b.refCount-1WHERE b.id = :uid").setParameter("uid", (Object)uid).executeUpdate();
    }

    public BlobEntity getByHash(@NotNull String hash) {
        Preconditions.requireNonBlank((String)hash, (String)"hash must be non-blank");
        return (BlobEntity)this.getActiveEntityManager().createQuery("SELECT b FROM BlobEntity b WHERE b.hash = :hashCode", BlobEntity.class).setParameter("hashCode", (Object)hash).getSingleResult();
    }

    public BlobEntity getByNaturalId(@NotNull String name, @NotNull String mimeType, @NotNull Long hash) {
        Preconditions.requireNonBlank((String)name, (String)"name must be non-blank");
        Preconditions.requireNonBlank((String)mimeType, (String)"mimeType must be non-blank");
        Objects.requireNonNull(hash, "hash must be non-null");
        return (BlobEntity)this.getSession().byNaturalId(BlobEntity.class).using("hash", (Object)hash).using("name", (Object)name).using("mimeType", (Object)mimeType).load();
    }

    public void increaseRefCount(@NotNull String uid) {
        Preconditions.requireNonBlank((String)uid, (String)"uid must be non-blank");
        this.getActiveEntityManager().createQuery("UPDATE BlobEntity b SET b.refCount = b.refCount+1WHERE b.id = :uid").setParameter("uid", (Object)uid).executeUpdate();
    }

    @Transactional
    public void deleteUnattachedByAge(@NotNull OffsetDateTime timeThreshold) {
        Objects.requireNonNull(timeThreshold, "time threshold must be non-null");
        this.getActiveEntityManager().createQuery("DELETE FROM BlobEntity b WHERE b.createdOn < :timeThreshold AND b.refCount <= 0").setParameter("timeThreshold", (Object)timeThreshold).executeUpdate();
    }

    public Iterator<BlobEntity> getAll() throws StorageException {
        Query allBlobsQuery = this.getActiveEntityManager().createQuery("SELECT b FROM BlobEntity b");
        return super.getAll(BlobEntity.class, allBlobsQuery);
    }
}

