/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa.h2;

import io.apiman.manager.api.beans.idm.DiscoverabilityLevel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.h2.tools.TriggerAdapter;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;

public class ApiPlanDiscoverabilityTrigger
extends TriggerAdapter {
    public void fire(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
        if (this.type == 1 || this.type == 2) {
            this.insertOrUpdate(conn, oldRow, newRow);
            return;
        }
        if (this.type == 4) {
            this.delete(conn, oldRow, newRow);
            return;
        }
        throw new IllegalArgumentException("ApiPlanDiscoverabilityTrigger: Unexpected operation type " + this.type);
    }

    private void delete(Connection conn, ResultSet oldRow, ResultSet ignored) throws SQLException {
        Jdbi jdbi = Jdbi.create((Connection)conn);
        Long apiVersionId = oldRow.getLong("api_version_id");
        String planId = oldRow.getString("plan_id");
        String planVersion = oldRow.getString("version");
        FlatApiVersionBeanView av = (FlatApiVersionBeanView)((Query)jdbi.withHandle(h -> (Query)h.createQuery("select avb.* FROM api_versions avb WHERE avb.id = :id").bind("id", apiVersionId))).mapToBean(FlatApiVersionBeanView.class).first();
        ((Update)((Update)((Update)((Update)((Update)((Update)jdbi.withHandle(h -> h.createUpdate("DELETE FROM discoverability d WHERE d.api_id = :apiId AND d.org_id = :orgId AND d.api_version = :apiVersion AND d.plan_id = :planId AND d.plan_version = :planVersion "))).bind("orgId", av.getApiOrgId())).bind("apiId", av.getApiId())).bind("apiVersion", av.getVersion())).bind("planId", planId)).bind("planVersion", planVersion)).execute();
    }

    private void insertOrUpdate(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
        DiscoverabilityLevel oldLevel;
        Long apiVersionId = newRow.getLong("api_version_id");
        String planId = newRow.getString("plan_id");
        String planVersion = newRow.getString("version");
        DiscoverabilityLevel level = Optional.ofNullable(newRow.getString("discoverability")).map(DiscoverabilityLevel::valueOf).orElse(DiscoverabilityLevel.ORG_MEMBERS);
        Jdbi jdbi = Jdbi.create((Connection)conn);
        FlatApiVersionBeanView av = (FlatApiVersionBeanView)((Query)jdbi.withHandle(h -> (Query)h.createQuery("select avb.* FROM api_versions avb WHERE avb.id = :id").bind("id", apiVersionId))).mapToBean(FlatApiVersionBeanView.class).first();
        String pdeKey = String.join((CharSequence)":", av.getApiOrgId(), av.getApiId(), av.getVersion(), planId, planVersion);
        if (oldRow != null && (oldLevel = Optional.ofNullable(oldRow.getString("discoverability")).map(DiscoverabilityLevel::valueOf).orElse(DiscoverabilityLevel.ORG_MEMBERS)) == level) {
            return;
        }
        jdbi.withHandle(h -> ((Update)((Update)((Update)((Update)((Update)((Update)((Update)h.createUpdate("MERGE INTO discoverability(id, org_id, api_id, api_version, plan_id, plan_version, discoverability) KEY(id) VALUES (:id, :orgId, :apiId, :apiVersion, :planId, :planVersion, :discoverability)").bind("id", pdeKey)).bind("orgId", av.getApiOrgId())).bind("apiId", av.getApiId())).bind("apiVersion", av.getVersion())).bind("planId", planId)).bind("planVersion", planVersion)).bind("discoverability", (Object)level)).execute());
    }

    public static class FlatApiVersionBeanView {
        private String apiOrgId;
        private String apiId;
        private String version;

        public FlatApiVersionBeanView() {
        }

        public FlatApiVersionBeanView(String apiOrgId, String apiId, String version) {
            this.apiOrgId = apiOrgId;
            this.apiId = apiId;
            this.version = version;
        }

        public String getApiOrgId() {
            return this.apiOrgId;
        }

        public void setApiOrgId(String apiOrgId) {
            this.apiOrgId = apiOrgId;
        }

        public String getApiId() {
            return this.apiId;
        }

        public void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlatApiVersionBeanView that = (FlatApiVersionBeanView)o;
            return Objects.equals(this.apiOrgId, that.apiOrgId) && Objects.equals(this.apiId, that.apiId) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.apiOrgId, this.apiId, this.version);
        }

        public String toString() {
            return new StringJoiner(", ", FlatApiVersionBeanView.class.getSimpleName() + "[", "]").add("apiorgId='" + this.apiOrgId + "'").add("apiId='" + this.apiId + "'").add("version='" + this.version + "'").toString();
        }
    }
}

