/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa.h2;

import io.apiman.manager.api.beans.idm.DiscoverabilityLevel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.h2.tools.TriggerAdapter;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Update;

public class ApiVersionDiscoverabilityTrigger
extends TriggerAdapter {
    public void fire(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
        if (this.type == 1 || this.type == 2) {
            this.insertOrUpdate(conn, oldRow, newRow);
            return;
        }
        if (this.type == 4) {
            this.delete(conn, oldRow, newRow);
            return;
        }
        throw new IllegalArgumentException("ApiVersionDiscoverabilityTrigger: Unexpected operation type " + this.type);
    }

    private void delete(Connection conn, ResultSet oldRow, ResultSet ignored) throws SQLException {
        String apiOrgId = oldRow.getString("api_org_id");
        String apiId = oldRow.getString("api_id");
        String apiVersion = oldRow.getString("version");
        ((Update)((Update)((Update)((Update)Jdbi.create((Connection)conn).withHandle(h -> h.createUpdate("DELETE FROM discoverability d WHERE d.api_id = :apiId AND d.org_id = :orgId AND d.api_version = :apiVersion "))).bind("orgId", apiOrgId)).bind("apiId", apiId)).bind("apiVersion", apiVersion)).execute();
    }

    private void insertOrUpdate(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
        DiscoverabilityLevel oldLevel;
        String apiOrgId = newRow.getString("api_org_id");
        String apiId = newRow.getString("api_id");
        String apiVersion = newRow.getString("version");
        DiscoverabilityLevel level = Optional.ofNullable(newRow.getString("discoverability")).map(DiscoverabilityLevel::valueOf).orElse(DiscoverabilityLevel.ORG_MEMBERS);
        String pdeKey = String.join((CharSequence)":", apiOrgId, apiId, apiVersion);
        if (oldRow != null && (oldLevel = Optional.ofNullable(oldRow.getString("discoverability")).map(DiscoverabilityLevel::valueOf).orElse(DiscoverabilityLevel.ORG_MEMBERS)) == level) {
            return;
        }
        Jdbi.create((Connection)conn).withHandle(h -> ((Update)((Update)((Update)((Update)((Update)h.createUpdate("MERGE INTO discoverability(id, org_id, api_id, api_version, plan_id, plan_version, discoverability) KEY(id) VALUES (:id, :orgId, :apiId, :apiVersion, NULL, NULL, :discoverability)").bind("id", pdeKey)).bind("orgId", apiOrgId)).bind("apiId", apiId)).bind("apiVersion", apiVersion)).bind("discoverability", (Object)level)).execute());
    }
}

