/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.jpa.model.outbox;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.events.ApimanEventHeaders;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.apiman.manager.api.jpa.AbstractJpaStorage;
import io.apiman.manager.api.jpa.model.outbox.OutboxEventEntity;
import java.text.DateFormat;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
@Transactional
public class TransactionalOutboxService
extends AbstractJpaStorage {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(TransactionalOutboxService.class);
    private static final ObjectMapper OM = new ObjectMapper().findAndRegisterModules().setDateFormat((DateFormat)new StdDateFormat());
    private boolean outboxActive = true;

    public void onEvent(@Observes IVersionedApimanEvent apimanEvent) {
        if (!this.outboxActive) {
            LOGGER.trace("Outbox has been set as inactive, skipping event: {0}", new Object[]{apimanEvent});
            return;
        }
        ApimanEventHeaders headers = apimanEvent.getHeaders();
        String eventType = this.getType(apimanEvent);
        OutboxEventEntity outboxEvent = new OutboxEventEntity().setEventVersion(headers.getEventVersion()).setType(eventType).setSource(headers.getSource().toString()).setSubject(headers.getSubject()).setTime(headers.getTime()).setPayload(this.serializeWithoutHeaders(apimanEvent));
        EntityManager em = this.getActiveEntityManager();
        em.persist((Object)outboxEvent);
        em.remove((Object)outboxEvent);
        LOGGER.debug("Persisted event to transactional outbox & immediately deleted {0}", new Object[]{outboxEvent});
    }

    public TransactionalOutboxService disable() {
        this.outboxActive = false;
        return this;
    }

    public TransactionalOutboxService enable() {
        this.outboxActive = true;
        return this;
    }

    private JsonNode serializeWithoutHeaders(IVersionedApimanEvent apimanEvent) {
        OM.addMixIn(apimanEvent.getClass(), IgnoreHeadersMixin.class);
        return OM.valueToTree((Object)apimanEvent);
    }

    private String getType(IVersionedApimanEvent apimanEvent) {
        String currentValue = apimanEvent.getHeaders().getType();
        if (StringUtils.isEmpty((CharSequence)currentValue)) {
            return apimanEvent.getClass().getCanonicalName();
        }
        return currentValue;
    }

    private static abstract class IgnoreHeadersMixin {
        private IgnoreHeadersMixin() {
        }

        @JsonIgnore
        public abstract ApimanEventHeaders getHeaders();
    }
}

