/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.micro;

import io.apiman.common.es.util.DefaultEsClientFactory;
import io.apiman.common.es.util.EsUtils;
import io.apiman.common.es.util.IEsClientFactory;
import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.util.ReflectionUtils;
import io.apiman.common.util.crypt.CurrentDataEncrypter;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.core.IApiCatalog;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.core.INewUserBootstrapper;
import io.apiman.manager.api.core.IPluginRegistry;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.UuidApiKeyGenerator;
import io.apiman.manager.api.core.crypt.DefaultDataEncrypter;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.noop.NoOpMetricsAccessor;
import io.apiman.manager.api.es.EsMetricsAccessor;
import io.apiman.manager.api.jpa.JpaStorage;
import io.apiman.manager.api.micro.ManagerApiMicroServiceConfig;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.security.impl.DefaultSecurityContext;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.inject.Named;

@ApplicationScoped
public class ManagerApiMicroServiceCdiFactory {
    private static IEsClientFactory sStorageESClientFactory;

    @Produces
    @ApplicationScoped
    public static INewUserBootstrapper provideNewUserBootstrapper(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry) {
        String type = config.getNewUserBootstrapperType();
        if (type == null) {
            return new INewUserBootstrapper(){

                public void bootstrapUser(UserBean user, IStorage storage) throws StorageException {
                }
            };
        }
        try {
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(INewUserBootstrapper.class, config.getNewUserBootstrapperType(), config.getNewUserBootstrapperProperties(), pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown user bootstrapper type: " + config.getNewUserBootstrapperType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static IStorage provideStorage(ManagerApiMicroServiceConfig config, @New JpaStorage jpaStorage, IPluginRegistry pluginRegistry) {
        return jpaStorage;
    }

    @Produces
    @ApplicationScoped
    public static ISecurityContext provideSecurityContext(@New DefaultSecurityContext defaultSC) {
        return defaultSC;
    }

    @Produces
    @ApplicationScoped
    public static IStorageQuery provideStorageQuery(ManagerApiMicroServiceConfig config, @New JpaStorage jpaStorage, IPluginRegistry pluginRegistry) {
        return jpaStorage;
    }

    @Produces
    @ApplicationScoped
    public static IMetricsAccessor provideMetricsAccessor(ManagerApiMicroServiceConfig config, @New NoOpMetricsAccessor noopMetrics, IPluginRegistry pluginRegistry) {
        EsMetricsAccessor metrics;
        if (EsUtils.isEsOrJest((String)config.getMetricsType())) {
            metrics = new EsMetricsAccessor(config.getMetricsESClientFactoryConfig());
        } else {
            try {
                metrics = ManagerApiMicroServiceCdiFactory.createCustomComponent(IMetricsAccessor.class, config.getMetricsType(), config.getMetricsProperties(), pluginRegistry);
            }
            catch (Throwable t) {
                System.err.println("Unknown apiman metrics accessor type: " + config.getMetricsType());
                metrics = noopMetrics;
            }
        }
        return metrics;
    }

    @Produces
    @ApplicationScoped
    public static IApiKeyGenerator provideApiKeyGenerator(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry, @New UuidApiKeyGenerator uuidApiKeyGen) {
        UuidApiKeyGenerator apiKeyGenerator;
        String type = config.getApiKeyGeneratorType();
        if ("uuid".equals(type)) {
            apiKeyGenerator = uuidApiKeyGen;
        } else {
            try {
                apiKeyGenerator = ManagerApiMicroServiceCdiFactory.createCustomComponent(IApiKeyGenerator.class, type, config.getApiKeyGeneratorProperties(), pluginRegistry);
            }
            catch (Exception e) {
                System.err.println("Unknown apiman API key generator type: " + type);
                System.err.println("Automatically falling back to UUID style API Keys.");
                apiKeyGenerator = uuidApiKeyGen;
            }
        }
        return apiKeyGenerator;
    }

    @Produces
    @ApplicationScoped
    public static IDataEncrypter provideDataEncrypter(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry, @New DefaultDataEncrypter defaultEncrypter) {
        try {
            IDataEncrypter encrypter;
            CurrentDataEncrypter.instance = encrypter = (IDataEncrypter)ManagerApiMicroServiceCdiFactory.createCustomComponent(IDataEncrypter.class, config.getDataEncrypterType(), config.getDataEncrypterProperties(), pluginRegistry, defaultEncrypter);
            return encrypter;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown data encrypter type: " + config.getDataEncrypterType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    public static IApiCatalog provideApiCatalog(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry) {
        try {
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(IApiCatalog.class, config.getApiCatalogType(), config.getApiCatalogProperties(), pluginRegistry);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error or unknown API catalog type: " + config.getApiCatalogType(), t);
        }
    }

    @Produces
    @ApplicationScoped
    @Named(value="storage-factory")
    public static IEsClientFactory provideStorageESClientFactory(ManagerApiMicroServiceConfig config, IPluginRegistry pluginRegistry) {
        if (EsUtils.isEsOrJest((String)config.getStorageType()) && sStorageESClientFactory == null) {
            try {
                String factoryClass = config.getStorageESClientFactory();
                if (factoryClass == null) {
                    factoryClass = DefaultEsClientFactory.class.getName();
                }
                sStorageESClientFactory = ManagerApiMicroServiceCdiFactory.createCustomComponent(IEsClientFactory.class, factoryClass, null, pluginRegistry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sStorageESClientFactory;
    }

    private static <T> T createCustomComponent(Class<T> componentType, String componentSpec, Map<String, String> configProperties, IPluginRegistry pluginRegistry) throws Exception {
        return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, componentSpec, configProperties, pluginRegistry, null);
    }

    private static <T> T createCustomComponent(Class<T> componentType, String componentSpec, Map<String, String> configProperties, IPluginRegistry pluginRegistry, T defaultComponent) throws Exception {
        if (componentSpec == null && defaultComponent == null) {
            throw new IllegalArgumentException("Null component type.");
        }
        if (componentSpec == null && defaultComponent != null) {
            return defaultComponent;
        }
        if (componentSpec.startsWith("class:")) {
            Class c = ReflectionUtils.loadClass((String)componentSpec.substring("class:".length()));
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, c, configProperties);
        }
        if (componentSpec.startsWith("plugin:")) {
            PluginCoordinates coordinates = PluginCoordinates.fromPolicySpec((String)componentSpec);
            if (coordinates == null) {
                throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
            }
            int ssidx = componentSpec.indexOf(47);
            if (ssidx == -1) {
                throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
            }
            String classname = componentSpec.substring(ssidx + 1);
            Plugin plugin = pluginRegistry.loadPlugin(coordinates);
            PluginClassLoader classLoader = plugin.getLoader();
            Class class1 = classLoader.loadClass(classname);
            return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, class1, configProperties);
        }
        Class c = ReflectionUtils.loadClass((String)componentSpec);
        return ManagerApiMicroServiceCdiFactory.createCustomComponent(componentType, c, configProperties);
    }

    private static <T> T createCustomComponent(Class<T> componentType, Class<?> componentClass, Map<String, String> configProperties) throws Exception {
        if (componentClass == null) {
            throw new IllegalArgumentException("Invalid component spec (class not found).");
        }
        try {
            Constructor<?> constructor = componentClass.getConstructor(Map.class);
            return (T)constructor.newInstance(configProperties);
        }
        catch (Exception exception) {
            return (T)componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }
}

