/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.migrator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.logging.impl.DoubleLogger;
import io.apiman.manager.api.config.Version;
import io.apiman.manager.api.migrator.IDataMigratorWriter;
import io.apiman.manager.api.migrator.IReaderHandler;
import io.apiman.manager.api.migrator.JsonDataMigratorReader;
import io.apiman.manager.api.migrator.JsonDataMigratorWriter;
import io.apiman.manager.api.migrator.VersionMigratorChain;
import io.apiman.manager.api.migrator.VersionMigrators;
import io.apiman.manager.api.migrator.i18n.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Dependent
public class DataMigrator
implements IReaderHandler {
    private IApimanLogger logger = ApimanLoggerFactory.getLogger(DataMigrator.class);
    @Inject
    private Version version;
    private IDataMigratorWriter writer;
    private VersionMigratorChain chain;

    public void migrate(File fromSource, File toDest, IApimanLogger extraLogger) {
        this.logger = new DoubleLogger(this.logger, extraLogger);
        this.migrate(fromSource, toDest);
    }

    public void migrate(File fromSource, File toDest) {
        DataMigrator readerHandler = this;
        try (JsonDataMigratorReader reader = new JsonDataMigratorReader(fromSource);
             JsonDataMigratorWriter writer = new JsonDataMigratorWriter(toDest);){
            this.writer = writer;
            reader.read(readerHandler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void migrate(InputStream fromSource, OutputStream toDest, IApimanLogger extraLogger) {
        this.logger = new DoubleLogger(this.logger, extraLogger);
        this.migrate(fromSource, toDest);
    }

    public void migrate(InputStream fromSource, OutputStream toDest) {
        DataMigrator readerHandler = this;
        try (JsonDataMigratorReader reader = new JsonDataMigratorReader(fromSource);
             JsonDataMigratorWriter writer = new JsonDataMigratorWriter(toDest);){
            this.writer = writer;
            reader.read(readerHandler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage:  DataMigrator <pathToSourceFile> <pathToDestFile>");
            return;
        }
        String frompath = args[0];
        String topath = args[1];
        File from = new File(frompath);
        File to = new File(topath);
        System.out.println("Starting data migration.");
        System.out.println("  From: " + from);
        System.out.println("  To:   " + to);
        DataMigrator migrator = new DataMigrator();
        Version version = new Version();
        migrator.setVersion(version);
        migrator.migrate(from, to);
    }

    @Override
    public void onMetaData(ObjectNode node) throws IOException {
        String fromVersion = node.get("apimanVersion").asText();
        String toVersion = this.getVersion().getVersionString();
        this.chain = VersionMigrators.chain(fromVersion, toVersion);
        if (this.chain.hasMigrators()) {
            this.logger.info(Messages.i18n.format("DataMigrator.MigratingNow", new Object[]{fromVersion}));
            this.chain.migrateMetaData(node);
            node.put("apimanVersion", toVersion);
        }
        this.writer.writeMetaData(node);
    }

    @Override
    public void onUser(ObjectNode node) throws IOException {
        if (this.chain.hasMigrators()) {
            this.logger.info(Messages.i18n.format("DataMigrator.MigratingUser", new Object[]{node.get("username")}));
            this.chain.migrateUser(node);
        }
        this.writer.writeUser(node);
    }

    @Override
    public void onGateway(ObjectNode node) throws IOException {
        if (this.chain.hasMigrators()) {
            this.logger.info(Messages.i18n.format("DataMigrator.MigratingGateway", new Object[]{node.get("name")}));
            this.chain.migrateGateway(node);
        }
        this.writer.writeGateway(node);
    }

    @Override
    public void onPlugin(ObjectNode node) throws IOException {
        if (this.chain.hasMigrators()) {
            this.logger.info(Messages.i18n.format("DataMigrator.MigratingPlugin", new Object[]{node.get("name")}));
            this.chain.migratePlugin(node);
        }
        this.writer.writePlugin(node);
    }

    @Override
    public void onRole(ObjectNode node) throws IOException {
        if (this.chain.hasMigrators()) {
            this.logger.info(Messages.i18n.format("DataMigrator.MigratingRole", new Object[]{node.get("name")}));
            this.chain.migrateRole(node);
        }
        this.writer.writeRole(node);
    }

    @Override
    public void onPolicyDefinition(ObjectNode node) throws IOException {
        if (this.chain.hasMigrators()) {
            this.logger.info(Messages.i18n.format("DataMigrator.MigratingPolicyDef", new Object[]{node.get("name")}));
            this.chain.migratePolicyDefinition(node);
        }
        this.writer.writePolicyDefinition(node);
    }

    @Override
    public void onOrg(ObjectNode node) throws IOException {
        if (this.chain.hasMigrators()) {
            this.logger.info(Messages.i18n.format("DataMigrator.MigratingOrg", new Object[]{node.get("OrganizationBean").get("name")}));
            this.chain.migrateOrg(node);
        }
        this.writer.writeOrg(node);
    }

    @Override
    public void onDeveloper(ObjectNode node) throws IOException {
        if (this.chain.hasMigrators()) {
            this.logger.info(Messages.i18n.format("DataMigrator.MigratingDeveloper", new Object[]{node.get("name")}));
            this.chain.migrateDeveloper(node);
        }
        this.writer.writeDeveloper(node);
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

