/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.migrator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apiman.manager.api.migrator.IDataMigratorReader;
import io.apiman.manager.api.migrator.IReaderHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class JsonDataMigratorReader
implements IDataMigratorReader {
    private final JsonParser jp;
    private final InputStream in;

    public JsonDataMigratorReader(File fromSource) throws IOException {
        this(new FileInputStream(fromSource));
    }

    public JsonDataMigratorReader(InputStream fromSource) throws IOException {
        this.in = fromSource;
        this.jp = new JsonFactory().createParser(this.in);
        this.jp.setCodec((ObjectCodec)new ObjectMapper());
    }

    @Override
    public void close() throws Exception {
        IOUtils.closeQuietly((InputStream)this.in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(IReaderHandler readerHandler) throws IOException {
        try {
            JsonToken current = this.jp.nextToken();
            if (current != JsonToken.START_OBJECT) {
                throw new IOException("Expected start object at root.");
            }
            while (this.jp.nextToken() != JsonToken.END_OBJECT) {
                ObjectNode obj;
                String name = this.jp.getCurrentName();
                current = this.jp.nextToken();
                if (name.equals("Metadata")) {
                    obj = this.readObjectNode();
                    readerHandler.onMetaData(obj);
                    continue;
                }
                if (name.equals("Gateways")) {
                    this.readArrayStart();
                    while (this.jp.getCurrentToken() == JsonToken.START_OBJECT) {
                        obj = this.readObjectNode();
                        readerHandler.onGateway(obj);
                        this.jp.nextToken();
                    }
                    continue;
                }
                if (name.equals("Plugins")) {
                    this.readArrayStart();
                    while (this.jp.getCurrentToken() == JsonToken.START_OBJECT) {
                        obj = this.readObjectNode();
                        readerHandler.onPlugin(obj);
                        this.jp.nextToken();
                    }
                    continue;
                }
                if (name.equals("Roles")) {
                    this.readArrayStart();
                    while (this.jp.getCurrentToken() == JsonToken.START_OBJECT) {
                        obj = this.readObjectNode();
                        readerHandler.onRole(obj);
                        this.jp.nextToken();
                    }
                    continue;
                }
                if (name.equals("PolicyDefinitions")) {
                    this.readArrayStart();
                    while (this.jp.getCurrentToken() == JsonToken.START_OBJECT) {
                        obj = this.readObjectNode();
                        readerHandler.onPolicyDefinition(obj);
                        this.jp.nextToken();
                    }
                    continue;
                }
                if (name.equals("Users")) {
                    this.readArrayStart();
                    while (this.jp.getCurrentToken() == JsonToken.START_OBJECT) {
                        obj = this.readObjectNode();
                        readerHandler.onUser(obj);
                        this.jp.nextToken();
                    }
                    continue;
                }
                if (name.equals("Orgs")) {
                    this.readArrayStart();
                    while (this.jp.getCurrentToken() == JsonToken.START_OBJECT) {
                        obj = this.readObjectNode();
                        readerHandler.onOrg(obj);
                        this.jp.nextToken();
                    }
                    continue;
                }
                if (name.equals("Developers")) {
                    this.readArrayStart();
                    while (this.jp.getCurrentToken() == JsonToken.START_OBJECT) {
                        obj = this.readObjectNode();
                        readerHandler.onDeveloper(obj);
                        this.jp.nextToken();
                    }
                    continue;
                }
                if (!name.equals("Blobs")) continue;
                this.readArrayStart();
                while (this.jp.getCurrentToken() == JsonToken.START_OBJECT) {
                    obj = this.readObjectNode();
                    readerHandler.onBlob(obj);
                    this.jp.nextToken();
                }
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.in);
        }
    }

    private void readArrayStart() throws IOException, JsonParseException {
        JsonToken token = this.jp.getCurrentToken();
        if (token != JsonToken.START_ARRAY) {
            throw new IOException("Unexpected token (array start expected).");
        }
        this.jp.nextToken();
    }

    private ObjectNode readObjectNode() throws IOException {
        return (ObjectNode)this.jp.readValueAsTree();
    }
}

