/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.migrator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apiman.manager.api.migrator.IDataMigratorWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class JsonDataMigratorWriter
implements IDataMigratorWriter {
    private final OutputStream os;
    private final JsonFactory jsonFactory = new JsonFactory();
    private final JsonGenerator jg;
    private final ObjectMapper om = new ObjectMapper();
    private final Set<String> sections = new HashSet<String>();
    private boolean arrayFieldOpen = false;

    public JsonDataMigratorWriter(File toDest) throws IOException {
        this(new FileOutputStream(toDest));
    }

    public JsonDataMigratorWriter(OutputStream output) throws IOException {
        this.os = output;
        this.om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.jg = this.jsonFactory.createGenerator(output, JsonEncoding.UTF8);
        this.jg.useDefaultPrettyPrinter();
        this.jg.setCodec((ObjectCodec)this.om);
        this.jg.writeStartObject();
    }

    @Override
    public void close() throws Exception {
        this.closeFieldArray();
        this.jg.writeEndObject();
        this.jg.flush();
        IOUtils.closeQuietly((OutputStream)this.os);
    }

    @Override
    public void writeMetaData(ObjectNode node) throws IOException {
        this.jg.writeObjectField("Metadata", (Object)node);
    }

    @Override
    public void writeUser(ObjectNode node) throws IOException {
        if (!this.sections.contains("Users")) {
            this.jg.writeArrayFieldStart("Users");
            this.arrayFieldOpen = true;
            this.sections.add("Users");
        }
        this.jg.writeObject((Object)node);
    }

    @Override
    public void writeGateway(ObjectNode node) throws IOException {
        if (!this.sections.contains("Gateways")) {
            this.closeFieldArray();
            this.jg.writeArrayFieldStart("Gateways");
            this.arrayFieldOpen = true;
            this.sections.add("Gateways");
        }
        this.jg.writeObject((Object)node);
    }

    @Override
    public void writePlugin(ObjectNode node) throws IOException {
        if (!this.sections.contains("Plugins")) {
            this.closeFieldArray();
            this.jg.writeArrayFieldStart("Plugins");
            this.arrayFieldOpen = true;
            this.sections.add("Plugins");
        }
        this.jg.writeObject((Object)node);
    }

    @Override
    public void writeRole(ObjectNode node) throws IOException {
        if (!this.sections.contains("Roles")) {
            this.closeFieldArray();
            this.jg.writeArrayFieldStart("Roles");
            this.arrayFieldOpen = true;
            this.sections.add("Roles");
        }
        this.jg.writeObject((Object)node);
    }

    @Override
    public void writePolicyDefinition(ObjectNode node) throws IOException {
        if (!this.sections.contains("PolicyDefinitions")) {
            this.closeFieldArray();
            this.jg.writeArrayFieldStart("PolicyDefinitions");
            this.arrayFieldOpen = true;
            this.sections.add("PolicyDefinitions");
        }
        this.jg.writeObject((Object)node);
    }

    @Override
    public void writeOrg(ObjectNode node) throws IOException {
        if (!this.sections.contains("Orgs")) {
            this.closeFieldArray();
            this.jg.writeArrayFieldStart("Orgs");
            this.arrayFieldOpen = true;
            this.sections.add("Orgs");
        }
        this.jg.writeObject((Object)node);
    }

    @Override
    public void writeDeveloper(ObjectNode node) throws IOException {
        if (!this.sections.contains("Developers")) {
            this.closeFieldArray();
            this.jg.writeArrayFieldStart("Developers");
            this.arrayFieldOpen = true;
            this.sections.add("Developers");
        }
        this.jg.writeObject((Object)node);
    }

    @Override
    public void writerBlob(ObjectNode node) throws IOException {
        if (!this.sections.contains("Blobs")) {
            this.closeFieldArray();
            this.jg.writeArrayFieldStart("Blobs");
            this.arrayFieldOpen = true;
            this.sections.add("Blobs");
        }
        this.jg.writeObject((Object)node);
    }

    private void closeFieldArray() throws IOException {
        if (this.arrayFieldOpen) {
            this.jg.writeEndArray();
            this.arrayFieldOpen = false;
        }
    }
}

