/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.migrator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apiman.manager.api.migrator.IVersionMigrator;
import java.util.List;

public class VersionMigratorChain
implements IVersionMigrator {
    private final List<IVersionMigrator> migrators;

    public VersionMigratorChain(List<IVersionMigrator> migrators) {
        this.migrators = migrators;
    }

    @Override
    public void migrateMetaData(ObjectNode node) {
        for (IVersionMigrator migrator : this.migrators) {
            migrator.migrateMetaData(node);
        }
    }

    @Override
    public void migrateUser(ObjectNode node) {
        for (IVersionMigrator migrator : this.migrators) {
            migrator.migrateUser(node);
        }
    }

    @Override
    public void migrateGateway(ObjectNode node) {
        for (IVersionMigrator migrator : this.migrators) {
            migrator.migrateGateway(node);
        }
    }

    @Override
    public void migratePlugin(ObjectNode node) {
        for (IVersionMigrator migrator : this.migrators) {
            migrator.migratePlugin(node);
        }
    }

    @Override
    public void migrateRole(ObjectNode node) {
        for (IVersionMigrator migrator : this.migrators) {
            migrator.migrateRole(node);
        }
    }

    @Override
    public void migratePolicyDefinition(ObjectNode node) {
        for (IVersionMigrator migrator : this.migrators) {
            migrator.migratePolicyDefinition(node);
        }
    }

    @Override
    public void migrateOrg(ObjectNode node) {
        for (IVersionMigrator migrator : this.migrators) {
            migrator.migrateOrg(node);
        }
    }

    @Override
    public void migrateDeveloper(ObjectNode node) {
        for (IVersionMigrator migrator : this.migrators) {
            migrator.migrateDeveloper(node);
        }
    }

    public boolean hasMigrators() {
        return !this.migrators.isEmpty();
    }
}

