/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.migrator;

import io.apiman.manager.api.migrator.IVersionMigrator;
import io.apiman.manager.api.migrator.VersionMigratorChain;
import io.apiman.manager.api.migrator.vms.Version122FinalMigrator;
import java.util.ArrayList;
import java.util.List;

public class VersionMigrators {
    private static final List<Entry> migrators = new ArrayList<Entry>();

    public static VersionMigratorChain chain(String fromVersion, String toVersion) {
        ArrayList<IVersionMigrator> matchedMigrators = new ArrayList<IVersionMigrator>();
        for (Entry entry : migrators) {
            if (!entry.isBetween(fromVersion, toVersion)) continue;
            matchedMigrators.add(entry.migrator);
        }
        return new VersionMigratorChain(matchedMigrators);
    }

    static {
        migrators.add(new Entry("1.2.2.Final", new Version122FinalMigrator()));
    }

    private static class VersionComponents
    implements Comparable<VersionComponents> {
        public int major;
        public int minor;
        public int patch;

        public VersionComponents(String version) {
            String[] split = version.replace("-SNAPSHOT", "").split("\\.");
            this.major = Integer.parseInt(split[0]);
            this.minor = Integer.parseInt(split[1]);
            this.patch = Integer.parseInt(split[2]);
        }

        @Override
        public int compareTo(VersionComponents other) {
            if (this.major < other.major) {
                return -1;
            }
            if (this.major > other.major) {
                return 1;
            }
            if (this.minor < other.minor) {
                return -1;
            }
            if (this.minor > other.minor) {
                return 1;
            }
            if (this.patch < other.patch) {
                return -1;
            }
            if (this.patch > other.patch) {
                return 1;
            }
            return 0;
        }
    }

    protected static class Entry {
        public final String version;
        public final IVersionMigrator migrator;

        public Entry(String version, IVersionMigrator migrator) {
            this.version = version;
            this.migrator = migrator;
        }

        public boolean isBetween(String from, String to) {
            VersionComponents fromV = new VersionComponents(from);
            VersionComponents toV = new VersionComponents(to);
            VersionComponents v = new VersionComponents(this.version);
            return v.compareTo(fromV) >= 0 && v.compareTo(toV) < 0;
        }
    }
}

