/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.idm.CurrentUserBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.UpdateUserBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.INewUserBootstrapper;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.rest.contract.ICurrentUserResource;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class CurrentUserResourceImpl
implements ICurrentUserResource {
    @Inject
    private IStorage storage;
    @Inject
    private IStorageQuery query;
    @Inject
    private ISecurityContext securityContext;
    @Inject
    @ApimanLogger(value=CurrentUserResourceImpl.class)
    private IApimanLogger log;
    @Inject
    private INewUserBootstrapper userBootstrapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrentUserBean getInfo() {
        String userId = this.securityContext.getCurrentUser();
        try {
            UserBean user;
            CurrentUserBean rval = new CurrentUserBean();
            this.storage.beginTx();
            try {
                user = this.storage.getUser(userId);
            }
            finally {
                this.storage.rollbackTx();
            }
            if (user == null) {
                user = new UserBean();
                user.setUsername(userId);
                if (this.securityContext.getFullName() != null) {
                    user.setFullName(this.securityContext.getFullName());
                } else {
                    user.setFullName(userId);
                }
                if (this.securityContext.getEmail() != null) {
                    user.setEmail(this.securityContext.getEmail());
                } else {
                    user.setEmail("");
                }
                user.setJoinedOn(new Date());
                this.storage.beginTx();
                try {
                    this.storage.createUser(user);
                    this.userBootstrapper.bootstrapUser(user, this.storage);
                    this.storage.commitTx();
                }
                catch (StorageException e1) {
                    this.storage.rollbackTx();
                    throw new SystemErrorException((Throwable)e1);
                }
                rval.initFromUser(user);
                rval.setAdmin(this.securityContext.isAdmin());
                rval.setPermissions(new HashSet());
            } else {
                rval.initFromUser(user);
                Set permissions = this.query.getPermissions(userId);
                rval.setPermissions(permissions);
                rval.setAdmin(this.securityContext.isAdmin());
            }
            this.log.debug(String.format("Getting info for user %s", user.getUsername()));
            return rval;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void updateInfo(UpdateUserBean info) {
        try {
            this.storage.beginTx();
            UserBean user = this.storage.getUser(this.securityContext.getCurrentUser());
            if (user == null) {
                throw new StorageException("User not found: " + this.securityContext.getCurrentUser());
            }
            if (info.getEmail() != null) {
                user.setEmail(info.getEmail());
            }
            if (info.getFullName() != null) {
                user.setFullName(info.getFullName());
            }
            this.storage.updateUser(user);
            this.storage.commitTx();
            this.log.debug(String.format("Successfully updated user %s: %s", user.getUsername(), user));
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<OrganizationSummaryBean> getClientOrganizations() {
        Set permittedOrganizations = this.securityContext.getPermittedOrganizations(PermissionType.clientEdit);
        try {
            return this.query.getOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<OrganizationSummaryBean> getPlanOrganizations() {
        Set permittedOrganizations = this.securityContext.getPermittedOrganizations(PermissionType.planEdit);
        try {
            return this.query.getOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<OrganizationSummaryBean> getApiOrganizations() {
        Set permittedOrganizations = this.securityContext.getPermittedOrganizations(PermissionType.apiEdit);
        try {
            return this.query.getOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ClientSummaryBean> getClients() {
        Set permittedOrganizations = this.securityContext.getPermittedOrganizations(PermissionType.clientView);
        try {
            return this.query.getClientsInOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ApiSummaryBean> getApis() {
        Set permittedOrganizations = this.securityContext.getPermittedOrganizations(PermissionType.apiView);
        try {
            return this.query.getApisInOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public IStorageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IStorageQuery query) {
        this.query = query;
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }
}

