/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.crypt.DataEncryptionContext;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.gateway.engine.beans.SystemStatus;
import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.gateways.GatewayType;
import io.apiman.manager.api.beans.gateways.NewGatewayBean;
import io.apiman.manager.api.beans.gateways.RestGatewayConfigBean;
import io.apiman.manager.api.beans.gateways.UpdateGatewayBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.GatewayTestResultBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.rest.contract.IGatewayResource;
import io.apiman.manager.api.rest.contract.exceptions.AbstractRestException;
import io.apiman.manager.api.rest.contract.exceptions.GatewayAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.impl.i18n.Messages;
import io.apiman.manager.api.rest.impl.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class GatewayResourceImpl
implements IGatewayResource {
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    ISecurityContext securityContext;
    @Inject
    IGatewayLinkFactory gatewayLinkFactory;
    @Inject
    @ApimanLogger(value=GatewayResourceImpl.class)
    IApimanLogger log;
    @Inject
    IDataEncrypter encrypter;
    private static final ObjectMapper mapper = new ObjectMapper();

    public GatewayTestResultBean test(NewGatewayBean bean) throws NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        GatewayTestResultBean rval = new GatewayTestResultBean();
        try {
            GatewayBean testGateway = new GatewayBean();
            testGateway.setName(bean.getName());
            testGateway.setType(bean.getType());
            testGateway.setConfiguration(bean.getConfiguration());
            IGatewayLink gatewayLink = this.gatewayLinkFactory.create(testGateway);
            SystemStatus status = gatewayLink.getStatus();
            String detail = mapper.writer().writeValueAsString((Object)status);
            rval.setSuccess(true);
            rval.setDetail(detail);
        }
        catch (GatewayAuthenticationException e) {
            rval.setSuccess(false);
            rval.setDetail(Messages.i18n.format("GatewayResourceImpl.AuthenticationFailed", new Object[0]));
        }
        catch (Exception e) {
            rval.setSuccess(false);
            rval.setDetail(e.getMessage());
        }
        return rval;
    }

    public List<GatewaySummaryBean> list() throws NotAuthorizedException {
        try {
            return this.query.listGateways();
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public GatewayBean create(NewGatewayBean bean) throws GatewayAlreadyExistsException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        Date now = new Date();
        GatewayBean gateway = new GatewayBean();
        gateway.setId(BeanUtils.idFromName((String)bean.getName()));
        gateway.setName(bean.getName());
        gateway.setDescription(bean.getDescription());
        gateway.setType(bean.getType());
        gateway.setConfiguration(bean.getConfiguration());
        gateway.setCreatedBy(this.securityContext.getCurrentUser());
        gateway.setCreatedOn(now);
        gateway.setModifiedBy(this.securityContext.getCurrentUser());
        gateway.setModifiedOn(now);
        try {
            this.storage.beginTx();
            if (this.storage.getGateway(gateway.getId()) != null) {
                throw ExceptionFactory.gatewayAlreadyExistsException(gateway.getName());
            }
            this.encryptPasswords(gateway);
            this.storage.createGateway(gateway);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        this.decryptPasswords(gateway);
        this.log.debug(String.format("Successfully created new gateway %s: %s", gateway.getName(), gateway));
        return gateway;
    }

    public GatewayBean get(String gatewayId) throws GatewayNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            GatewayBean bean = this.storage.getGateway(gatewayId);
            if (bean == null) {
                throw ExceptionFactory.gatewayNotFoundException(gatewayId);
            }
            if (!this.securityContext.isAdmin()) {
                bean.setConfiguration(null);
            } else {
                this.decryptPasswords(bean);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Successfully fetched gateway %s: %s", bean.getName(), bean));
            return bean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void update(String gatewayId, UpdateGatewayBean bean) throws GatewayNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            Date now = new Date();
            GatewayBean gbean = this.storage.getGateway(gatewayId);
            if (gbean == null) {
                throw ExceptionFactory.gatewayNotFoundException(gatewayId);
            }
            gbean.setModifiedBy(this.securityContext.getCurrentUser());
            gbean.setModifiedOn(now);
            if (bean.getDescription() != null) {
                gbean.setDescription(bean.getDescription());
            }
            if (bean.getType() != null) {
                gbean.setType(bean.getType());
            }
            if (bean.getConfiguration() != null) {
                gbean.setConfiguration(bean.getConfiguration());
            }
            this.encryptPasswords(gbean);
            this.storage.updateGateway(gbean);
            this.storage.commitTx();
            this.log.debug(String.format("Successfully updated gateway %s: %s", gbean.getName(), gbean));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void delete(String gatewayId) throws GatewayNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            GatewayBean gbean = this.storage.getGateway(gatewayId);
            if (gbean == null) {
                throw ExceptionFactory.gatewayNotFoundException(gatewayId);
            }
            this.storage.deleteGateway(gbean);
            this.storage.commitTx();
            this.log.debug(String.format("Successfully deleted gateway %s: %s", gbean.getName(), gbean));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    private void encryptPasswords(GatewayBean bean) {
        if (bean.getConfiguration() == null) {
            return;
        }
        try {
            if (bean.getType() == GatewayType.REST) {
                RestGatewayConfigBean configBean = (RestGatewayConfigBean)mapper.readValue(bean.getConfiguration(), RestGatewayConfigBean.class);
                configBean.setPassword(this.encrypter.encrypt(configBean.getPassword(), new DataEncryptionContext()));
                bean.setConfiguration(mapper.writeValueAsString((Object)configBean));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void decryptPasswords(GatewayBean bean) {
        if (bean.getConfiguration() == null) {
            return;
        }
        try {
            if (bean.getType() == GatewayType.REST) {
                RestGatewayConfigBean configBean = (RestGatewayConfigBean)mapper.readValue(bean.getConfiguration(), RestGatewayConfigBean.class);
                configBean.setPassword(this.encrypter.decrypt(configBean.getPassword(), new DataEncryptionContext()));
                bean.setConfiguration(mapper.writeValueAsString((Object)configBean));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }
}

