/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.crypt.DataEncryptionContext;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.gateway.engine.beans.ApiEndpoint;
import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.apis.ApiBean;
import io.apiman.manager.api.beans.apis.ApiDefinitionType;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiPlanBean;
import io.apiman.manager.api.beans.apis.ApiStatus;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.apis.ApiVersionStatusBean;
import io.apiman.manager.api.beans.apis.NewApiBean;
import io.apiman.manager.api.beans.apis.NewApiDefinitionBean;
import io.apiman.manager.api.beans.apis.NewApiVersionBean;
import io.apiman.manager.api.beans.apis.UpdateApiBean;
import io.apiman.manager.api.beans.apis.UpdateApiVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.audit.data.EntityUpdatedData;
import io.apiman.manager.api.beans.audit.data.MembershipData;
import io.apiman.manager.api.beans.clients.ApiKeyBean;
import io.apiman.manager.api.beans.clients.ClientBean;
import io.apiman.manager.api.beans.clients.ClientStatus;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.clients.NewClientBean;
import io.apiman.manager.api.beans.clients.NewClientVersionBean;
import io.apiman.manager.api.beans.clients.UpdateClientBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.contracts.NewContractBean;
import io.apiman.manager.api.beans.download.DownloadBean;
import io.apiman.manager.api.beans.download.DownloadType;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.idm.GrantRolesBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.members.MemberBean;
import io.apiman.manager.api.beans.members.MemberRoleBean;
import io.apiman.manager.api.beans.metrics.ClientUsagePerApiBean;
import io.apiman.manager.api.beans.metrics.HistogramIntervalType;
import io.apiman.manager.api.beans.metrics.ResponseStatsHistogramBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsPerClientBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsPerPlanBean;
import io.apiman.manager.api.beans.metrics.ResponseStatsSummaryBean;
import io.apiman.manager.api.beans.metrics.UsageHistogramBean;
import io.apiman.manager.api.beans.metrics.UsagePerClientBean;
import io.apiman.manager.api.beans.metrics.UsagePerPlanBean;
import io.apiman.manager.api.beans.orgs.NewOrganizationBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.orgs.UpdateOrganizationBean;
import io.apiman.manager.api.beans.plans.NewPlanBean;
import io.apiman.manager.api.beans.plans.NewPlanVersionBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanStatus;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.plans.UpdatePlanBean;
import io.apiman.manager.api.beans.policies.NewPolicyBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyChainBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.policies.UpdatePolicyBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiEntryBean;
import io.apiman.manager.api.beans.summary.ApiPlanSummaryBean;
import io.apiman.manager.api.beans.summary.ApiRegistryBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionEndpointSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.ClientVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IApiValidator;
import io.apiman.manager.api.core.IClientValidator;
import io.apiman.manager.api.core.IDownloadManager;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.core.util.PolicyTemplateUtil;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.rest.contract.IOrganizationResource;
import io.apiman.manager.api.rest.contract.IRoleResource;
import io.apiman.manager.api.rest.contract.IUserResource;
import io.apiman.manager.api.rest.contract.exceptions.AbstractRestException;
import io.apiman.manager.api.rest.contract.exceptions.ApiAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ApiDefinitionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ApiNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ApiVersionAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ApiVersionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ClientAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ClientNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ClientVersionAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ClientVersionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ContractAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ContractNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.EntityStillActiveException;
import io.apiman.manager.api.rest.contract.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidApiStatusException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidClientStatusException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidMetricCriteriaException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidParameterException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidPlanStatusException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidVersionException;
import io.apiman.manager.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.contract.exceptions.OrganizationAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PlanAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.PlanNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PlanVersionAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.PlanVersionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PolicyDefinitionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PolicyNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.RoleNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.contract.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.impl.audit.AuditUtils;
import io.apiman.manager.api.rest.impl.i18n.Messages;
import io.apiman.manager.api.rest.impl.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.FieldValidator;
import io.apiman.manager.api.security.ISecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

@RequestScoped
public class OrganizationResourceImpl
implements IOrganizationResource {
    private static final long ONE_MINUTE_MILLIS = 60000L;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final long ONE_WEEK_MILLIS = 604800000L;
    private static final long ONE_MONTH_MILLIS = 2592000000L;
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    IMetricsAccessor metrics;
    @Inject
    IClientValidator clientValidator;
    @Inject
    IApiValidator apiValidator;
    @Inject
    IApiKeyGenerator apiKeyGenerator;
    @Inject
    IDataEncrypter encrypter;
    @Inject
    IDownloadManager downloadManager;
    @Inject
    IUserResource users;
    @Inject
    IRoleResource roles;
    @Inject
    ISecurityContext securityContext;
    @Inject
    IGatewayLinkFactory gatewayLinkFactory;
    @Context
    HttpServletRequest request;
    @Inject
    @ApimanLogger(value=OrganizationResourceImpl.class)
    IApimanLogger log;

    public OrganizationBean create(NewOrganizationBean bean) throws OrganizationAlreadyExistsException, InvalidNameException {
        List autoGrantedRoles;
        FieldValidator.validateName(bean.getName());
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        criteria.setPage(1);
        criteria.setPageSize(100);
        criteria.addFilter("autoGrant", "true", SearchCriteriaFilterOperator.bool_eq);
        try {
            autoGrantedRoles = this.query.findRoles(criteria).getBeans();
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
        if ("true".equals(System.getProperty("apiman.manager.require-auto-granted-org", "true")) && autoGrantedRoles.isEmpty()) {
            throw new SystemErrorException(Messages.i18n.format("OrganizationResourceImpl.NoAutoGrantRoleAvailable", new Object[0]));
        }
        OrganizationBean orgBean = new OrganizationBean();
        orgBean.setName(bean.getName());
        orgBean.setDescription(bean.getDescription());
        orgBean.setId(BeanUtils.idFromName((String)bean.getName()));
        orgBean.setCreatedOn(new Date());
        orgBean.setCreatedBy(this.securityContext.getCurrentUser());
        orgBean.setModifiedOn(new Date());
        orgBean.setModifiedBy(this.securityContext.getCurrentUser());
        try {
            this.storage.beginTx();
            if (this.storage.getOrganization(orgBean.getId()) != null) {
                throw ExceptionFactory.organizationAlreadyExistsException(bean.getName());
            }
            this.storage.createOrganization(orgBean);
            this.storage.createAuditEntry(AuditUtils.organizationCreated(orgBean, this.securityContext));
            for (RoleBean roleBean : autoGrantedRoles) {
                String currentUser = this.securityContext.getCurrentUser();
                String orgId = orgBean.getId();
                RoleMembershipBean membership = RoleMembershipBean.create((String)currentUser, (String)roleBean.getId(), (String)orgId);
                membership.setCreatedOn(new Date());
                this.storage.createMembership(membership);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Created organization %s: %s", orgBean.getName(), orgBean));
            return orgBean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void delete(@PathParam(value="organizationId") String organizationId) throws OrganizationNotFoundException, NotAuthorizedException, EntityStillActiveException {
        try {
            if (!this.securityContext.hasPermission(PermissionType.orgAdmin, organizationId)) {
                throw ExceptionFactory.notAuthorizedException();
            }
            this.storage.beginTx();
            OrganizationBean organizationBean = this.storage.getOrganization(organizationId);
            if (organizationBean == null) {
                throw ExceptionFactory.organizationNotFoundException(organizationId);
            }
            Iterator clientAppsVers = this.storage.getAllClientVersions(organizationBean, ClientStatus.Registered, 5);
            if (clientAppsVers.hasNext()) {
                throw ExceptionFactory.entityStillActiveExceptionClientVersions(clientAppsVers);
            }
            Iterator apiVers = this.storage.getAllApiVersions(organizationBean, ApiStatus.Published, 5);
            if (apiVers.hasNext()) {
                throw ExceptionFactory.entityStillActiveExceptionApiVersions(apiVers);
            }
            Iterator contracts = this.storage.getAllContracts(organizationBean, 5);
            if (contracts.hasNext()) {
                throw ExceptionFactory.entityStillActiveExceptionContracts(contracts);
            }
            Iterator planVers = this.storage.getAllPlanVersions(organizationBean, 5);
            if (planVers.hasNext()) {
                this.log.warn("There are locked plans(s): these will be deleted.");
            }
            this.storage.deleteOrganization(organizationBean);
            this.storage.commitTx();
            this.log.debug("Deleted Organization: " + organizationBean.getName());
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void deleteClient(@PathParam(value="organizationId") String organizationId, @PathParam(value="clientId") String clientId) throws OrganizationNotFoundException, NotAuthorizedException, EntityStillActiveException {
        try {
            if (!this.securityContext.hasPermission(PermissionType.clientAdmin, organizationId)) {
                throw ExceptionFactory.notAuthorizedException();
            }
            this.storage.beginTx();
            ClientBean client = this.storage.getClient(organizationId, clientId);
            if (client == null) {
                throw ExceptionFactory.clientNotFoundException(clientId);
            }
            Iterator clientVersions = this.storage.getAllClientVersions(organizationId, clientId);
            Iterable iterable = () -> clientVersions;
            List<ClientVersionBean> registeredElems = StreamSupport.stream(iterable.spliterator(), false).filter(clientVersion -> clientVersion.getStatus() == ClientStatus.Registered).limit(5L).collect(Collectors.toList());
            if (!registeredElems.isEmpty()) {
                throw ExceptionFactory.entityStillActiveExceptionClientVersions(registeredElems);
            }
            this.storage.deleteClient(client);
            this.storage.commitTx();
            this.log.debug("Deleted ClientApp: " + client.getName());
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void deleteApi(@PathParam(value="organizationId") String organizationId, @PathParam(value="apiId") String apiId) throws OrganizationNotFoundException, NotAuthorizedException, EntityStillActiveException {
        try {
            if (!this.securityContext.hasPermission(PermissionType.apiAdmin, organizationId)) {
                throw ExceptionFactory.notAuthorizedException();
            }
            this.storage.beginTx();
            ApiBean api = this.storage.getApi(organizationId, apiId);
            if (api == null) {
                throw ExceptionFactory.apiNotFoundException(apiId);
            }
            Iterator apiVersions = this.storage.getAllApiVersions(organizationId, apiId);
            Iterable iterable = () -> apiVersions;
            List<ApiVersionBean> registeredElems = StreamSupport.stream(iterable.spliterator(), false).filter(clientVersion -> clientVersion.getStatus() == ApiStatus.Published).limit(5L).collect(Collectors.toList());
            if (!registeredElems.isEmpty()) {
                throw ExceptionFactory.entityStillActiveExceptionApiVersions(registeredElems);
            }
            this.storage.deleteApi(api);
            this.storage.commitTx();
            this.log.debug("Deleted API: " + api.getName());
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public OrganizationBean get(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            OrganizationBean organizationBean = this.storage.getOrganization(organizationId);
            if (organizationBean == null) {
                throw ExceptionFactory.organizationNotFoundException(organizationId);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Got organization %s: %s", organizationBean.getName(), organizationBean));
            return organizationBean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void update(String organizationId, UpdateOrganizationBean bean) throws OrganizationNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.orgEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            OrganizationBean orgForUpdate = this.storage.getOrganization(organizationId);
            if (orgForUpdate == null) {
                throw ExceptionFactory.organizationNotFoundException(organizationId);
            }
            EntityUpdatedData auditData = new EntityUpdatedData();
            if (AuditUtils.valueChanged(orgForUpdate.getDescription(), bean.getDescription())) {
                auditData.addChange("description", orgForUpdate.getDescription(), bean.getDescription());
                orgForUpdate.setDescription(bean.getDescription());
            }
            this.storage.updateOrganization(orgForUpdate);
            this.storage.createAuditEntry(AuditUtils.organizationUpdated(orgForUpdate, auditData, this.securityContext));
            this.storage.commitTx();
            this.log.debug(String.format("Updated organization %s: %s", orgForUpdate.getName(), orgForUpdate));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> activity(String organizationId, int page, int pageSize) throws OrganizationNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isMemberOf(organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditEntity(organizationId, null, null, null, paging);
            return rval;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ClientBean createClient(String organizationId, NewClientBean bean) throws OrganizationNotFoundException, ClientAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        FieldValidator.validateName(bean.getName());
        ClientBean newClient = new ClientBean();
        newClient.setId(BeanUtils.idFromName((String)bean.getName()));
        newClient.setName(bean.getName());
        newClient.setDescription(bean.getDescription());
        newClient.setCreatedBy(this.securityContext.getCurrentUser());
        newClient.setCreatedOn(new Date());
        try {
            this.storage.beginTx();
            OrganizationBean org = this.storage.getOrganization(organizationId);
            if (org == null) {
                throw ExceptionFactory.organizationNotFoundException(organizationId);
            }
            newClient.setOrganization(org);
            if (this.storage.getClient(org.getId(), newClient.getId()) != null) {
                throw ExceptionFactory.organizationAlreadyExistsException(bean.getName());
            }
            this.storage.createClient(newClient);
            this.storage.createAuditEntry(AuditUtils.clientCreated(newClient, this.securityContext));
            if (bean.getInitialVersion() != null) {
                NewClientVersionBean newClientVersion = new NewClientVersionBean();
                newClientVersion.setVersion(bean.getInitialVersion());
                this.createClientVersionInternal(newClientVersion, newClient);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Created client %s: %s", newClient.getName(), newClient));
            return newClient;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ClientBean getClient(String organizationId, String clientId) throws ClientNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            ClientBean clientBean = this.storage.getClient(organizationId, clientId);
            if (clientBean == null) {
                throw ExceptionFactory.clientNotFoundException(clientId);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Got client %s: %s", clientBean.getName(), clientBean));
            return clientBean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> getClientActivity(String organizationId, String clientId, int page, int pageSize) throws ClientNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditEntity(organizationId, clientId, null, ClientBean.class, paging);
            return rval;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ClientSummaryBean> listClients(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        this.get(organizationId);
        try {
            return this.query.getClientsInOrg(organizationId);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void updateClient(String organizationId, String clientId, UpdateClientBean bean) throws ClientNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            ClientBean clientForUpdate = this.storage.getClient(organizationId, clientId);
            if (clientForUpdate == null) {
                throw ExceptionFactory.clientNotFoundException(clientId);
            }
            EntityUpdatedData auditData = new EntityUpdatedData();
            if (AuditUtils.valueChanged(clientForUpdate.getDescription(), bean.getDescription())) {
                auditData.addChange("description", clientForUpdate.getDescription(), bean.getDescription());
                clientForUpdate.setDescription(bean.getDescription());
            }
            this.storage.updateClient(clientForUpdate);
            this.storage.createAuditEntry(AuditUtils.clientUpdated(clientForUpdate, auditData, this.securityContext));
            this.storage.commitTx();
            this.log.debug(String.format("Updated client %s: %s", clientForUpdate.getName(), clientForUpdate));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ClientVersionBean createClientVersion(String organizationId, String clientId, NewClientVersionBean bean) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException, ClientVersionAlreadyExistsException {
        ClientVersionBean newVersion;
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        FieldValidator.validateVersion(bean.getVersion());
        try {
            this.storage.beginTx();
            ClientBean client = this.storage.getClient(organizationId, clientId);
            if (client == null) {
                throw ExceptionFactory.clientNotFoundException(clientId);
            }
            if (this.storage.getClientVersion(organizationId, clientId, bean.getVersion()) != null) {
                throw ExceptionFactory.clientVersionAlreadyExistsException(clientId, bean.getVersion());
            }
            newVersion = this.createClientVersionInternal(bean, client);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        if (bean.isClone() && bean.getCloneVersion() != null) {
            try {
                List<ContractSummaryBean> contracts = this.getClientVersionContracts(organizationId, clientId, bean.getCloneVersion());
                for (ContractSummaryBean contract : contracts) {
                    NewContractBean ncb = new NewContractBean();
                    ncb.setPlanId(contract.getPlanId());
                    ncb.setApiId(contract.getApiId());
                    ncb.setApiOrgId(contract.getApiOrganizationId());
                    ncb.setApiVersion(contract.getApiVersion());
                    this.createContract(organizationId, clientId, newVersion.getVersion(), ncb);
                }
                List<PolicySummaryBean> policies = this.listClientPolicies(organizationId, clientId, bean.getCloneVersion());
                for (PolicySummaryBean policySummary : policies) {
                    PolicyBean policy = this.getClientPolicy(organizationId, clientId, bean.getCloneVersion(), policySummary.getId());
                    NewPolicyBean npb = new NewPolicyBean();
                    npb.setDefinitionId(policy.getDefinition().getId());
                    npb.setConfiguration(policy.getConfiguration());
                    this.createClientPolicy(organizationId, clientId, newVersion.getVersion(), npb);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newVersion;
    }

    public ApiKeyBean getClientApiKey(String organizationId, String clientId, String version) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException {
        if (!this.securityContext.hasPermission(PermissionType.clientView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ClientVersionBean client = this.getClientVersionInternal(organizationId, clientId, version, true);
        ApiKeyBean apiKeyBean = new ApiKeyBean();
        apiKeyBean.setApiKey(client.getApikey());
        return apiKeyBean;
    }

    public ApiKeyBean updateClientApiKey(String organizationId, String clientId, String version, ApiKeyBean bean) throws ClientNotFoundException, NotAuthorizedException, InvalidVersionException, InvalidClientStatusException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            ClientVersionBean clientVersion = this.storage.getClientVersion(organizationId, clientId, version);
            if (clientVersion == null) {
                throw ExceptionFactory.clientVersionNotFoundException(clientId, version);
            }
            if (clientVersion.getStatus() == ClientStatus.Registered) {
                throw ExceptionFactory.invalidClientStatusException();
            }
            String newApiKey = bean.getApiKey();
            if (StringUtils.isEmpty((CharSequence)newApiKey)) {
                newApiKey = this.apiKeyGenerator.generate();
            }
            clientVersion.setApikey(newApiKey);
            clientVersion.setModifiedBy(this.securityContext.getCurrentUser());
            clientVersion.setModifiedOn(new Date());
            this.storage.updateClientVersion(clientVersion);
            this.storage.commitTx();
            this.log.debug(String.format("Updated an API Key for client %s version %s", clientVersion.getClient().getName(), clientVersion));
            ApiKeyBean rval = new ApiKeyBean();
            rval.setApiKey(newApiKey);
            return rval;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    protected ClientVersionBean createClientVersionInternal(NewClientVersionBean bean, ClientBean client) throws StorageException {
        if (!BeanUtils.isValidVersion((String)bean.getVersion())) {
            throw new StorageException("Invalid/illegal client version: " + bean.getVersion());
        }
        ClientVersionBean newVersion = new ClientVersionBean();
        newVersion.setClient(client);
        newVersion.setCreatedBy(this.securityContext.getCurrentUser());
        newVersion.setCreatedOn(new Date());
        newVersion.setModifiedBy(this.securityContext.getCurrentUser());
        newVersion.setModifiedOn(new Date());
        newVersion.setStatus(ClientStatus.Created);
        newVersion.setVersion(bean.getVersion());
        newVersion.setApikey(bean.getApiKey());
        if (newVersion.getApikey() == null) {
            newVersion.setApikey(this.apiKeyGenerator.generate());
        }
        this.storage.createClientVersion(newVersion);
        this.storage.createAuditEntry(AuditUtils.clientVersionCreated(newVersion, this.securityContext));
        this.log.debug(String.format("Created new client version %s: %s", newVersion.getClient().getName(), newVersion));
        return newVersion;
    }

    public ClientVersionBean getClientVersion(String organizationId, String clientId, String version) throws ClientVersionNotFoundException, NotAuthorizedException {
        boolean hasPermission = this.securityContext.hasPermission(PermissionType.clientView, organizationId);
        return this.getClientVersionInternal(organizationId, clientId, version, hasPermission);
    }

    protected ClientVersionBean getClientVersionInternal(String organizationId, String clientId, String version, boolean hasPermission) {
        try {
            this.storage.beginTx();
            ClientVersionBean clientVersion = this.storage.getClientVersion(organizationId, clientId, version);
            if (clientVersion == null) {
                throw ExceptionFactory.clientVersionNotFoundException(clientId, version);
            }
            if (!hasPermission) {
                clientVersion.setApikey(null);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Got new client version %s: %s", clientVersion.getClient().getName(), clientVersion));
            return clientVersion;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> getClientVersionActivity(String organizationId, String clientId, String version, int page, int pageSize) throws ClientVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditEntity(organizationId, clientId, version, ClientBean.class, paging);
            return rval;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ClientUsagePerApiBean getClientUsagePerApi(String organizationId, String clientId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (!this.securityContext.hasPermission(PermissionType.clientView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getClientUsagePerApi(organizationId, clientId, version, from, to);
    }

    public List<ClientVersionSummaryBean> listClientVersions(String organizationId, String clientId) throws ClientNotFoundException, NotAuthorizedException {
        this.getClient(organizationId, clientId);
        try {
            List clientVersions = this.query.getClientVersions(organizationId, clientId);
            boolean hasPermission = this.securityContext.hasPermission(PermissionType.clientView, organizationId);
            if (!hasPermission) {
                for (ClientVersionSummaryBean clientVersionSummaryBean : clientVersions) {
                    clientVersionSummaryBean.setApiKey(null);
                }
            }
            return clientVersions;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ContractBean createContract(String organizationId, String clientId, String version, NewContractBean bean) throws OrganizationNotFoundException, ClientNotFoundException, ApiNotFoundException, PlanNotFoundException, ContractAlreadyExistsException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            ContractBean contract = this.createContractInternal(organizationId, clientId, version, bean);
            this.storage.commitTx();
            this.log.debug(String.format("Created new contract %s: %s", contract.getId(), contract));
            return contract;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            if (this.contractAlreadyExists(organizationId, clientId, version, bean)) {
                throw ExceptionFactory.contractAlreadyExistsException();
            }
            throw new SystemErrorException((Throwable)e);
        }
    }

    protected ContractBean createContractInternal(String organizationId, String clientId, String version, NewContractBean bean) throws StorageException, Exception {
        ClientVersionBean cvb = this.storage.getClientVersion(organizationId, clientId, version);
        if (cvb == null) {
            throw ExceptionFactory.clientVersionNotFoundException(clientId, version);
        }
        if (cvb.getStatus() == ClientStatus.Retired) {
            throw ExceptionFactory.invalidClientStatusException();
        }
        ApiVersionBean avb = this.storage.getApiVersion(bean.getApiOrgId(), bean.getApiId(), bean.getApiVersion());
        if (avb == null) {
            throw ExceptionFactory.apiNotFoundException(bean.getApiId());
        }
        if (avb.getStatus() != ApiStatus.Published) {
            throw ExceptionFactory.invalidApiStatusException();
        }
        Set plans = avb.getPlans();
        String planVersion = null;
        if (plans != null) {
            for (ApiPlanBean apiPlanBean : plans) {
                if (!apiPlanBean.getPlanId().equals(bean.getPlanId())) continue;
                planVersion = apiPlanBean.getVersion();
            }
        }
        if (planVersion == null) {
            throw ExceptionFactory.planNotFoundException(bean.getPlanId());
        }
        PlanVersionBean pvb = this.storage.getPlanVersion(bean.getApiOrgId(), bean.getPlanId(), planVersion);
        if (pvb == null) {
            throw ExceptionFactory.planNotFoundException(bean.getPlanId());
        }
        if (pvb.getStatus() != PlanStatus.Locked) {
            throw ExceptionFactory.invalidPlanStatusException();
        }
        ContractBean contract = new ContractBean();
        contract.setClient(cvb);
        contract.setApi(avb);
        contract.setPlan(pvb);
        contract.setCreatedBy(this.securityContext.getCurrentUser());
        contract.setCreatedOn(new Date());
        if (cvb.getStatus() == ClientStatus.Created && this.clientValidator.isReady(cvb, true)) {
            cvb.setStatus(ClientStatus.Ready);
        }
        this.storage.createContract(contract);
        this.storage.createAuditEntry(AuditUtils.contractCreatedFromClient(contract, this.securityContext));
        this.storage.createAuditEntry(AuditUtils.contractCreatedToApi(contract, this.securityContext));
        cvb.setModifiedBy(this.securityContext.getCurrentUser());
        cvb.setModifiedOn(new Date());
        this.storage.updateClientVersion(cvb);
        return contract;
    }

    private boolean contractAlreadyExists(String organizationId, String clientId, String version, NewContractBean bean) {
        try {
            List contracts = this.query.getClientContracts(organizationId, clientId, version);
            for (ContractSummaryBean contract : contracts) {
                if (!contract.getApiOrganizationId().equals(bean.getApiOrgId()) || !contract.getApiId().equals(bean.getApiId()) || !contract.getApiVersion().equals(bean.getApiVersion()) || !contract.getPlanId().equals(bean.getPlanId())) continue;
                return true;
            }
            return false;
        }
        catch (StorageException e) {
            return false;
        }
    }

    public ContractBean getContract(String organizationId, String clientId, String version, Long contractId) throws ClientNotFoundException, ContractNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            ContractBean contract = this.storage.getContract(contractId);
            if (contract == null) {
                throw ExceptionFactory.contractNotFoundException(contractId);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Got contract %s: %s", contract.getId(), contract));
            return contract;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void deleteAllContracts(String organizationId, String clientId, String version) throws ClientNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        List<ContractSummaryBean> contracts = this.getClientVersionContracts(organizationId, clientId, version);
        for (ContractSummaryBean contract : contracts) {
            this.deleteContract(organizationId, clientId, version, contract.getContractId());
        }
    }

    public void deleteContract(String organizationId, String clientId, String version, Long contractId) throws ClientNotFoundException, ContractNotFoundException, NotAuthorizedException, InvalidClientStatusException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            ContractBean contract = this.storage.getContract(contractId);
            if (contract == null) {
                throw ExceptionFactory.contractNotFoundException(contractId);
            }
            if (!contract.getClient().getClient().getOrganization().getId().equals(organizationId)) {
                throw ExceptionFactory.contractNotFoundException(contractId);
            }
            if (!contract.getClient().getClient().getId().equals(clientId)) {
                throw ExceptionFactory.contractNotFoundException(contractId);
            }
            if (!contract.getClient().getVersion().equals(version)) {
                throw ExceptionFactory.contractNotFoundException(contractId);
            }
            if (contract.getClient().getStatus() == ClientStatus.Retired) {
                throw ExceptionFactory.invalidClientStatusException();
            }
            this.storage.deleteContract(contract);
            this.storage.createAuditEntry(AuditUtils.contractBrokenFromClient(contract, this.securityContext));
            this.storage.createAuditEntry(AuditUtils.contractBrokenToApi(contract, this.securityContext));
            ClientVersionBean clientV = this.storage.getClientVersion(organizationId, clientId, version);
            clientV.setModifiedBy(this.securityContext.getCurrentUser());
            clientV.setModifiedOn(new Date());
            this.storage.updateClientVersion(clientV);
            this.storage.commitTx();
            this.log.debug(String.format("Deleted contract: %s", contract));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ContractSummaryBean> getClientVersionContracts(String organizationId, String clientId, String version) throws ClientNotFoundException, NotAuthorizedException {
        this.getClientVersion(organizationId, clientId, version);
        try {
            List contracts = this.query.getClientContracts(organizationId, clientId, version);
            return contracts;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public Response getApiRegistryJSON(String organizationId, String clientId, String version, String download) throws ClientNotFoundException, NotAuthorizedException {
        boolean hasPermission = this.securityContext.hasPermission(PermissionType.clientView, organizationId);
        if ("true".equals(download)) {
            try {
                String path = String.format("%s/%s/%s/%s", organizationId, clientId, version, Character.valueOf(hasPermission ? (char)'+' : '-'));
                DownloadBean dbean = this.downloadManager.createDownload(DownloadType.apiRegistryJson, path);
                return Response.ok((Object)dbean, (String)"application/json").build();
            }
            catch (StorageException e) {
                throw new SystemErrorException((Throwable)e);
            }
        }
        return this.getApiRegistryJSON(organizationId, clientId, version, hasPermission);
    }

    public Response getApiRegistryJSON(String organizationId, String clientId, String version, boolean hasPermission) throws ClientNotFoundException, NotAuthorizedException {
        ApiRegistryBean apiRegistry = this.getApiRegistry(organizationId, clientId, version, hasPermission);
        return Response.ok((Object)apiRegistry, (String)"application/json").header("Content-Disposition", (Object)"attachment; filename=api-registry.json").build();
    }

    public Response getApiRegistryXML(String organizationId, String clientId, String version, String download) throws ClientNotFoundException, NotAuthorizedException {
        boolean hasPermission = this.securityContext.hasPermission(PermissionType.clientView, organizationId);
        if ("true".equals(download)) {
            try {
                String path = String.format("%s/%s/%s/%s", organizationId, clientId, version, Character.valueOf(hasPermission ? (char)'+' : '-'));
                DownloadBean dbean = this.downloadManager.createDownload(DownloadType.apiRegistryXml, path);
                return Response.ok((Object)dbean, (String)"application/json").build();
            }
            catch (StorageException e) {
                throw new SystemErrorException((Throwable)e);
            }
        }
        return this.getApiRegistryXML(organizationId, clientId, version, hasPermission);
    }

    public Response getApiRegistryXML(String organizationId, String clientId, String version, boolean hasPermission) throws ClientNotFoundException, NotAuthorizedException {
        ApiRegistryBean apiRegistry = this.getApiRegistry(organizationId, clientId, version, hasPermission);
        return Response.ok((Object)apiRegistry, (String)"application/xml").header("Content-Disposition", (Object)"attachment; filename=api-registry.xml").build();
    }

    protected ApiRegistryBean getApiRegistry(String organizationId, String clientId, String version, boolean hasPermission) throws ClientNotFoundException, NotAuthorizedException {
        ClientVersionBean clientVersion = this.getClientVersionInternal(organizationId, clientId, version, hasPermission);
        HashMap<String, IGatewayLink> gatewayLinks = new HashMap<String, IGatewayLink>();
        HashMap<String, GatewayBean> gateways = new HashMap<String, GatewayBean>();
        boolean txStarted = false;
        try {
            ApiRegistryBean apiRegistry = this.query.getApiRegistry(organizationId, clientId, version);
            if (hasPermission) {
                apiRegistry.setApiKey(clientVersion.getApikey());
            }
            List apis = apiRegistry.getApis();
            this.storage.beginTx();
            txStarted = true;
            for (ApiEntryBean api : apis) {
                IGatewayLink link;
                String gatewayId = api.getGatewayId();
                api.setGatewayId(null);
                GatewayBean gateway = (GatewayBean)gateways.get(gatewayId);
                if (gateway == null) {
                    gateway = this.storage.getGateway(gatewayId);
                    gateways.put(gatewayId, gateway);
                }
                if ((link = (IGatewayLink)gatewayLinks.get(gatewayId)) == null) {
                    link = this.gatewayLinkFactory.create(gateway);
                    gatewayLinks.put(gatewayId, link);
                }
                ApiEndpoint se = link.getApiEndpoint(api.getApiOrgId(), api.getApiId(), api.getApiVersion());
                String apiEndpoint = se.getEndpoint();
                api.setHttpEndpoint(apiEndpoint);
            }
            ApiRegistryBean apiRegistryBean = apiRegistry;
            return apiRegistryBean;
        }
        catch (StorageException | GatewayAuthenticationException e) {
            throw new SystemErrorException(e);
        }
        finally {
            if (txStarted) {
                this.storage.rollbackTx();
            }
            for (IGatewayLink link : gatewayLinks.values()) {
                link.close();
            }
        }
    }

    public PolicyBean createClientPolicy(String organizationId, String clientId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ClientVersionBean cvb = this.getClientVersion(organizationId, clientId, version);
        PolicyBean policy = this.doCreatePolicy(organizationId, clientId, version, bean, PolicyType.Client);
        try {
            this.storage.beginTx();
            cvb.setModifiedBy(this.securityContext.getCurrentUser());
            cvb.setModifiedOn(new Date());
            this.storage.commitTx();
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            this.log.error((Throwable)e);
        }
        return policy;
    }

    public PolicyBean getClientPolicy(String organizationId, String clientId, String version, long policyId) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        boolean hasPermission = this.securityContext.hasPermission(PermissionType.clientView, organizationId);
        this.getClientVersion(organizationId, clientId, version);
        PolicyBean policy = this.doGetPolicy(PolicyType.Client, organizationId, clientId, version, policyId);
        if (!hasPermission) {
            policy.setConfiguration(null);
        }
        return policy;
    }

    public void updateClientPolicy(String organizationId, String clientId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ClientVersionBean cvb = this.getClientVersion(organizationId, clientId, version);
        try {
            this.storage.beginTx();
            PolicyBean policy = this.storage.getPolicy(PolicyType.Client, organizationId, clientId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            if (AuditUtils.valueChanged(policy.getConfiguration(), bean.getConfiguration())) {
                policy.setConfiguration(bean.getConfiguration());
            }
            policy.setModifiedOn(new Date());
            policy.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updatePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyUpdated(policy, PolicyType.Client, this.securityContext));
            cvb.setModifiedOn(new Date());
            cvb.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updateClientVersion(cvb);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void deleteClientPolicy(String organizationId, String clientId, String version, long policyId) throws OrganizationNotFoundException, ClientVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ClientVersionBean cvb = this.getClientVersion(organizationId, clientId, version);
        try {
            this.storage.beginTx();
            PolicyBean policy = this.storage.getPolicy(PolicyType.Client, organizationId, clientId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            this.storage.deletePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyRemoved(policy, PolicyType.Client, this.securityContext));
            cvb.setModifiedBy(this.securityContext.getCurrentUser());
            cvb.setModifiedOn(new Date());
            this.storage.updateClientVersion(cvb);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<PolicySummaryBean> listClientPolicies(String organizationId, String clientId, String version) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        this.getClientVersion(organizationId, clientId, version);
        try {
            return this.query.getPolicies(organizationId, clientId, version, PolicyType.Client);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void reorderClientPolicies(String organizationId, String clientId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, ClientVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.clientEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ClientVersionBean cvb = this.getClientVersion(organizationId, clientId, version);
        try {
            this.storage.beginTx();
            ArrayList<Long> newOrder = new ArrayList<Long>(policyChain.getPolicies().size());
            for (PolicySummaryBean psb : policyChain.getPolicies()) {
                newOrder.add(psb.getId());
            }
            this.storage.reorderPolicies(PolicyType.Client, organizationId, clientId, version, newOrder);
            this.storage.createAuditEntry(AuditUtils.policiesReordered(cvb, PolicyType.Client, this.securityContext));
            cvb.setModifiedBy(this.securityContext.getCurrentUser());
            cvb.setModifiedOn(new Date());
            this.storage.updateClientVersion(cvb);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ApiBean createApi(String organizationId, NewApiBean bean) throws OrganizationNotFoundException, ApiAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        FieldValidator.validateName(bean.getName());
        ApiBean newApi = new ApiBean();
        newApi.setName(bean.getName());
        newApi.setDescription(bean.getDescription());
        newApi.setId(BeanUtils.idFromName((String)bean.getName()));
        newApi.setCreatedOn(new Date());
        newApi.setCreatedBy(this.securityContext.getCurrentUser());
        try {
            GatewaySummaryBean gateway = this.getSingularGateway();
            this.storage.beginTx();
            OrganizationBean orgBean = this.storage.getOrganization(organizationId);
            if (orgBean == null) {
                throw ExceptionFactory.organizationNotFoundException(organizationId);
            }
            if (this.storage.getApi(orgBean.getId(), newApi.getId()) != null) {
                throw ExceptionFactory.apiAlreadyExistsException(bean.getName());
            }
            newApi.setOrganization(orgBean);
            this.storage.createApi(newApi);
            this.storage.createAuditEntry(AuditUtils.apiCreated(newApi, this.securityContext));
            if (bean.getInitialVersion() != null) {
                NewApiVersionBean newApiVersion = new NewApiVersionBean();
                newApiVersion.setEndpoint(bean.getEndpoint());
                newApiVersion.setEndpointType(bean.getEndpointType());
                newApiVersion.setEndpointContentType(bean.getEndpointContentType());
                newApiVersion.setPlans(bean.getPlans());
                newApiVersion.setPublicAPI(bean.getPublicAPI());
                newApiVersion.setParsePayload(bean.getParsePayload());
                newApiVersion.setVersion(bean.getInitialVersion());
                newApiVersion.setDefinitionUrl(bean.getDefinitionUrl());
                newApiVersion.setDefinitionType(bean.getDefinitionType());
                this.createApiVersionInternal(newApiVersion, newApi, gateway);
            }
            this.storage.commitTx();
            return newApi;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ApiBean getApi(String organizationId, String apiId) throws ApiNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            ApiBean bean = this.storage.getApi(organizationId, apiId);
            if (bean == null) {
                throw ExceptionFactory.apiNotFoundException(apiId);
            }
            this.storage.commitTx();
            return bean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> getApiActivity(String organizationId, String apiId, int page, int pageSize) throws ApiNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditEntity(organizationId, apiId, null, ApiBean.class, paging);
            return rval;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ApiSummaryBean> listApi(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        this.get(organizationId);
        try {
            return this.query.getApisInOrg(organizationId);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void updateApi(String organizationId, String apiId, UpdateApiBean bean) throws ApiNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            ApiBean apiForUpdate = this.storage.getApi(organizationId, apiId);
            if (apiForUpdate == null) {
                throw ExceptionFactory.apiNotFoundException(apiId);
            }
            EntityUpdatedData auditData = new EntityUpdatedData();
            if (AuditUtils.valueChanged(apiForUpdate.getDescription(), bean.getDescription())) {
                auditData.addChange("description", apiForUpdate.getDescription(), bean.getDescription());
                apiForUpdate.setDescription(bean.getDescription());
            }
            this.storage.updateApi(apiForUpdate);
            this.storage.createAuditEntry(AuditUtils.apiUpdated(apiForUpdate, auditData, this.securityContext));
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ApiVersionBean createApiVersion(String organizationId, String apiId, NewApiVersionBean bean) throws ApiNotFoundException, NotAuthorizedException, InvalidVersionException, ApiVersionAlreadyExistsException {
        ApiVersionBean newVersion;
        block25: {
            if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
                throw ExceptionFactory.notAuthorizedException();
            }
            FieldValidator.validateVersion(bean.getVersion());
            try {
                GatewaySummaryBean gateway = this.getSingularGateway();
                this.storage.beginTx();
                ApiBean api = this.storage.getApi(organizationId, apiId);
                if (api == null) {
                    throw ExceptionFactory.apiNotFoundException(apiId);
                }
                if (this.storage.getApiVersion(organizationId, apiId, bean.getVersion()) != null) {
                    throw ExceptionFactory.apiVersionAlreadyExistsException(apiId, bean.getVersion());
                }
                newVersion = this.createApiVersionInternal(bean, api, gateway);
                this.storage.commitTx();
            }
            catch (AbstractRestException e) {
                this.storage.rollbackTx();
                throw e;
            }
            catch (Exception e) {
                this.storage.rollbackTx();
                throw new SystemErrorException((Throwable)e);
            }
            if (bean.isClone() && bean.getCloneVersion() != null) {
                try {
                    block24: {
                        ApiVersionBean cloneSource = this.getApiVersion(organizationId, apiId, bean.getCloneVersion());
                        UpdateApiVersionBean updatedApi = new UpdateApiVersionBean();
                        if (bean.getEndpoint() == null) {
                            updatedApi.setEndpoint(cloneSource.getEndpoint());
                        }
                        if (bean.getEndpointType() == null) {
                            updatedApi.setEndpointType(cloneSource.getEndpointType());
                        }
                        if (bean.getEndpointContentType() == null) {
                            updatedApi.setEndpointContentType(cloneSource.getEndpointContentType());
                        }
                        updatedApi.setEndpointProperties(cloneSource.getEndpointProperties());
                        updatedApi.setGateways(cloneSource.getGateways());
                        if (bean.getPlans() == null) {
                            updatedApi.setPlans(cloneSource.getPlans());
                        }
                        if (bean.getPublicAPI() == null) {
                            updatedApi.setPublicAPI(Boolean.valueOf(cloneSource.isPublicAPI()));
                        }
                        if (bean.getParsePayload() == null) {
                            updatedApi.setParsePayload(bean.getParsePayload());
                        }
                        newVersion = this.updateApiVersion(organizationId, apiId, bean.getVersion(), updatedApi);
                        if (bean.getDefinitionUrl() == null) {
                            InputStream definition = null;
                            try {
                                Response response = this.getApiDefinition(organizationId, apiId, bean.getCloneVersion());
                                definition = (InputStream)response.getEntity();
                                this.storeApiDefinition(organizationId, apiId, newVersion.getVersion(), cloneSource.getDefinitionType(), definition);
                                IOUtils.closeQuietly((InputStream)definition);
                            }
                            catch (ApiDefinitionNotFoundException response) {
                                IOUtils.closeQuietly(definition);
                            }
                            catch (Exception sdnfe) {
                                this.log.error("Unable to create response", (Throwable)sdnfe);
                                break block24;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                            }
                            finally {
                                IOUtils.closeQuietly(definition);
                            }
                        }
                    }
                    List<PolicySummaryBean> policies = this.listApiPolicies(organizationId, apiId, bean.getCloneVersion());
                    for (PolicySummaryBean policySummary : policies) {
                        PolicyBean policy = this.getApiPolicy(organizationId, apiId, bean.getCloneVersion(), policySummary.getId());
                        NewPolicyBean npb = new NewPolicyBean();
                        npb.setDefinitionId(policy.getDefinition().getId());
                        npb.setConfiguration(policy.getConfiguration());
                        this.createApiPolicy(organizationId, apiId, newVersion.getVersion(), npb);
                    }
                }
                catch (Exception e) {
                    Exception t;
                    if (e == null) break block25;
                    e = t = e;
                }
            }
        }
        return newVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiVersionBean createApiVersionInternal(NewApiVersionBean bean, ApiBean api, GatewaySummaryBean gateway) throws Exception, StorageException {
        if (!BeanUtils.isValidVersion((String)bean.getVersion())) {
            throw new StorageException("Invalid/illegal API version: " + bean.getVersion());
        }
        ApiVersionBean newVersion = new ApiVersionBean();
        newVersion.setVersion(bean.getVersion());
        newVersion.setCreatedBy(this.securityContext.getCurrentUser());
        newVersion.setCreatedOn(new Date());
        newVersion.setModifiedBy(this.securityContext.getCurrentUser());
        newVersion.setModifiedOn(new Date());
        newVersion.setStatus(ApiStatus.Created);
        newVersion.setApi(api);
        newVersion.setEndpoint(bean.getEndpoint());
        newVersion.setEndpointType(bean.getEndpointType());
        newVersion.setEndpointContentType(bean.getEndpointContentType());
        if (bean.getPublicAPI() != null) {
            newVersion.setPublicAPI(bean.getPublicAPI().booleanValue());
        }
        if (bean.getParsePayload() != null) {
            newVersion.setParsePayload(bean.getParsePayload().booleanValue());
        }
        if (bean.getPlans() != null) {
            newVersion.setPlans(bean.getPlans());
        }
        if (bean.getDefinitionType() != null) {
            newVersion.setDefinitionType(bean.getDefinitionType());
        }
        if (gateway != null && newVersion.getGateways() == null) {
            newVersion.setGateways(new HashSet());
            ApiGatewayBean sgb = new ApiGatewayBean();
            sgb.setGatewayId(gateway.getId());
            newVersion.getGateways().add(sgb);
        }
        if (this.apiValidator.isReady(newVersion)) {
            newVersion.setStatus(ApiStatus.Ready);
        } else {
            newVersion.setStatus(ApiStatus.Created);
        }
        Set plans = newVersion.getPlans();
        if (plans != null) {
            for (ApiPlanBean splanBean : plans) {
                String orgId = newVersion.getApi().getOrganization().getId();
                PlanVersionBean pvb = this.storage.getPlanVersion(orgId, splanBean.getPlanId(), splanBean.getVersion());
                if (pvb == null) {
                    throw new StorageException(Messages.i18n.format("PlanVersionDoesNotExist", new Object[]{splanBean.getPlanId(), splanBean.getVersion()}));
                }
                if (pvb.getStatus() == PlanStatus.Locked) continue;
                throw new StorageException(Messages.i18n.format("PlanNotLocked", new Object[]{splanBean.getPlanId(), splanBean.getVersion()}));
            }
        }
        this.storage.createApiVersion(newVersion);
        this.storage.createAuditEntry(AuditUtils.apiVersionCreated(newVersion, this.securityContext));
        if (bean.getDefinitionUrl() != null) {
            InputStream definition = null;
            try {
                definition = new URL(bean.getDefinitionUrl()).openStream();
                this.storage.updateApiDefinition(newVersion, definition);
            }
            catch (Exception e) {
                try {
                    this.log.error("Unable to store API definition from: " + bean.getDefinitionUrl(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(definition);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)definition);
            }
            IOUtils.closeQuietly((InputStream)definition);
        }
        return newVersion;
    }

    public ApiVersionBean getApiVersion(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException {
        boolean hasPermission = this.securityContext.hasPermission(PermissionType.apiView, organizationId);
        try {
            this.storage.beginTx();
            ApiVersionBean apiVersion = this.storage.getApiVersion(organizationId, apiId, version);
            if (apiVersion == null) {
                throw ExceptionFactory.apiVersionNotFoundException(apiId, version);
            }
            this.storage.commitTx();
            if (!hasPermission) {
                apiVersion.setGateways(null);
            }
            this.decryptEndpointProperties(apiVersion);
            return apiVersion;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ApiVersionStatusBean getApiVersionStatus(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ApiVersionBean versionBean = this.getApiVersion(organizationId, apiId, version);
        List<PolicySummaryBean> policies = this.listApiPolicies(organizationId, apiId, version);
        return this.apiValidator.getStatus(versionBean, policies);
    }

    public Response getApiDefinition(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            ApiVersionBean apiVersion = this.storage.getApiVersion(organizationId, apiId, version);
            if (apiVersion == null) {
                throw ExceptionFactory.apiVersionNotFoundException(apiId, version);
            }
            if (apiVersion.getDefinitionType() == ApiDefinitionType.None || apiVersion.getDefinitionType() == null) {
                throw ExceptionFactory.apiDefinitionNotFoundException(apiId, version);
            }
            InputStream definition = this.storage.getApiDefinition(apiVersion);
            if (definition == null) {
                throw ExceptionFactory.apiDefinitionNotFoundException(apiId, version);
            }
            Response.ResponseBuilder builder = Response.ok().entity((Object)definition);
            if (apiVersion.getDefinitionType() == ApiDefinitionType.SwaggerJSON) {
                builder.type("application/json");
            } else if (apiVersion.getDefinitionType() == ApiDefinitionType.SwaggerYAML) {
                builder.type("application/x-yaml");
            } else if (apiVersion.getDefinitionType() == ApiDefinitionType.WSDL) {
                builder.type("application/wsdl+xml");
            } else {
                IOUtils.closeQuietly((InputStream)definition);
                throw new Exception("API definition type not supported: " + apiVersion.getDefinitionType());
            }
            this.storage.commitTx();
            return builder.build();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ApiVersionEndpointSummaryBean getApiVersionEndpointInfo(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, InvalidApiStatusException, GatewayNotFoundException {
        try {
            this.storage.beginTx();
            ApiVersionBean apiVersion = this.storage.getApiVersion(organizationId, apiId, version);
            if (apiVersion == null) {
                throw ExceptionFactory.apiVersionNotFoundException(apiId, version);
            }
            if (apiVersion.getStatus() != ApiStatus.Published) {
                throw new InvalidApiStatusException(Messages.i18n.format("ApiNotPublished", new Object[0]));
            }
            Set gateways = apiVersion.getGateways();
            if (gateways.isEmpty()) {
                throw new SystemErrorException("No Gateways for published API!");
            }
            GatewayBean gateway = this.storage.getGateway(((ApiGatewayBean)gateways.iterator().next()).getGatewayId());
            if (gateway == null) {
                throw new GatewayNotFoundException();
            }
            IGatewayLink link = this.gatewayLinkFactory.create(gateway);
            ApiEndpoint endpoint = link.getApiEndpoint(organizationId, apiId, version);
            ApiVersionEndpointSummaryBean rval = new ApiVersionEndpointSummaryBean();
            rval.setManagedEndpoint(endpoint.getEndpoint());
            this.storage.commitTx();
            this.log.debug(String.format("Got endpoint summary: %s", gateway));
            return rval;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> getApiVersionActivity(String organizationId, String apiId, String version, int page, int pageSize) throws ApiVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditEntity(organizationId, apiId, version, ApiBean.class, paging);
            return rval;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ApiVersionBean updateApiVersion(String organizationId, String apiId, String version, UpdateApiVersionBean bean) throws ApiVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ApiVersionBean avb = this.getApiVersion(organizationId, apiId, version);
        if (avb.isPublicAPI() ? avb.getStatus() == ApiStatus.Retired : avb.getStatus() == ApiStatus.Published || avb.getStatus() == ApiStatus.Retired) {
            throw ExceptionFactory.invalidApiStatusException();
        }
        avb.setModifiedBy(this.securityContext.getCurrentUser());
        avb.setModifiedOn(new Date());
        EntityUpdatedData data = new EntityUpdatedData();
        if (AuditUtils.valueChanged(avb.getPlans(), bean.getPlans())) {
            data.addChange("plans", AuditUtils.asString_ApiPlanBeans(avb.getPlans()), AuditUtils.asString_ApiPlanBeans(bean.getPlans()));
            if (avb.getPlans() == null) {
                avb.setPlans(new HashSet());
            }
            avb.getPlans().clear();
            if (bean.getPlans() != null) {
                avb.getPlans().addAll(bean.getPlans());
            }
        }
        if (AuditUtils.valueChanged(avb.getGateways(), bean.getGateways())) {
            data.addChange("gateways", AuditUtils.asString_ApiGatewayBeans(avb.getGateways()), AuditUtils.asString_ApiGatewayBeans(bean.getGateways()));
            if (avb.getGateways() == null) {
                avb.setGateways(new HashSet());
            }
            avb.getGateways().clear();
            avb.getGateways().addAll(bean.getGateways());
        }
        if (AuditUtils.valueChanged(avb.getEndpoint(), bean.getEndpoint())) {
            this.validateEndpoint(bean.getEndpoint());
            data.addChange("endpoint", avb.getEndpoint(), bean.getEndpoint());
            avb.setEndpoint(bean.getEndpoint());
        }
        if (AuditUtils.valueChanged(avb.getEndpointType(), bean.getEndpointType())) {
            data.addChange("endpointType", (Enum)avb.getEndpointType(), (Enum)bean.getEndpointType());
            avb.setEndpointType(bean.getEndpointType());
        }
        if (AuditUtils.valueChanged(avb.getEndpointContentType(), bean.getEndpointContentType())) {
            data.addChange("endpointContentType", (Enum)avb.getEndpointContentType(), (Enum)bean.getEndpointContentType());
            avb.setEndpointContentType(bean.getEndpointContentType());
        }
        if (AuditUtils.valueChanged(avb.getEndpointProperties(), bean.getEndpointProperties())) {
            if (avb.getEndpointProperties() == null) {
                avb.setEndpointProperties(new HashMap());
            } else {
                avb.getEndpointProperties().clear();
            }
            if (bean.getEndpointProperties() != null) {
                avb.getEndpointProperties().putAll(bean.getEndpointProperties());
            }
        }
        if (AuditUtils.valueChanged(avb.isPublicAPI(), bean.getPublicAPI())) {
            data.addChange("publicAPI", String.valueOf(avb.isPublicAPI()), String.valueOf(bean.getPublicAPI()));
            avb.setPublicAPI(bean.getPublicAPI().booleanValue());
        }
        if (AuditUtils.valueChanged(avb.isParsePayload(), bean.getParsePayload())) {
            data.addChange("parsePayload", String.valueOf(avb.isParsePayload()), String.valueOf(bean.getParsePayload()));
            avb.setParsePayload(bean.getParsePayload().booleanValue());
        }
        try {
            GatewaySummaryBean gateway;
            if ((avb.getGateways() == null || avb.getGateways().isEmpty()) && (gateway = this.getSingularGateway()) != null && avb.getGateways() == null) {
                avb.setGateways(new HashSet());
                ApiGatewayBean sgb = new ApiGatewayBean();
                sgb.setGatewayId(gateway.getId());
                avb.getGateways().add(sgb);
            }
            if (avb.getStatus() != ApiStatus.Published) {
                if (this.apiValidator.isReady(avb)) {
                    avb.setStatus(ApiStatus.Ready);
                } else {
                    avb.setStatus(ApiStatus.Created);
                }
            } else if (!this.apiValidator.isReady(avb)) {
                throw ExceptionFactory.invalidApiStatusException();
            }
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
        try {
            this.encryptEndpointProperties(avb);
            this.storage.beginTx();
            Set plans = avb.getPlans();
            if (plans != null) {
                for (ApiPlanBean splanBean : plans) {
                    String orgId = avb.getApi().getOrganization().getId();
                    PlanVersionBean pvb = this.storage.getPlanVersion(orgId, splanBean.getPlanId(), splanBean.getVersion());
                    if (pvb == null) {
                        throw new StorageException(Messages.i18n.format("PlanVersionDoesNotExist", new Object[]{splanBean.getPlanId(), splanBean.getVersion()}));
                    }
                    if (pvb.getStatus() == PlanStatus.Locked) continue;
                    throw new StorageException(Messages.i18n.format("PlanNotLocked", new Object[]{splanBean.getPlanId(), splanBean.getVersion()}));
                }
            }
            this.storage.updateApiVersion(avb);
            this.storage.createAuditEntry(AuditUtils.apiVersionUpdated(avb, data, this.securityContext));
            this.storage.commitTx();
            this.log.debug(String.format("Successfully updated API Version: %s", avb));
            this.decryptEndpointProperties(avb);
            return avb;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApiDefinition(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException, InvalidApiStatusException {
        ServletInputStream data;
        String contentType = this.request.getContentType();
        try {
            data = this.request.getInputStream();
        }
        catch (IOException e) {
            throw new SystemErrorException((Throwable)e);
        }
        try {
            ApiDefinitionType newDefinitionType;
            if (contentType.toLowerCase().contains("application/json")) {
                newDefinitionType = ApiDefinitionType.SwaggerJSON;
            } else if (contentType.toLowerCase().contains("application/x-yaml")) {
                newDefinitionType = ApiDefinitionType.SwaggerYAML;
            } else if (contentType.toLowerCase().contains("application/wsdl+xml")) {
                newDefinitionType = ApiDefinitionType.WSDL;
            } else {
                throw new SystemErrorException(Messages.i18n.format("InvalidApiDefinitionContentType", new Object[]{contentType}));
            }
            this.storeApiDefinition(organizationId, apiId, version, newDefinitionType, (InputStream)data);
            this.log.debug(String.format("Updated API definition for %s", apiId));
        }
        finally {
            IOUtils.closeQuietly((InputStream)data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApiDefinitionFromURL(String organizationId, String apiId, String version, NewApiDefinitionBean bean) throws ApiVersionNotFoundException, NotAuthorizedException, InvalidApiStatusException {
        InputStream data;
        try {
            String definitionURL = bean.getDefinitionUrl();
            URL url = new URL(definitionURL);
            data = url.openStream();
        }
        catch (IOException e) {
            throw new SystemErrorException((Throwable)e);
        }
        try {
            this.storeApiDefinition(organizationId, apiId, version, bean.getDefinitionType(), data);
            this.log.debug(String.format("Updated API definition for %s from URL %s", apiId, bean.getDefinitionUrl()));
        }
        finally {
            IOUtils.closeQuietly((InputStream)data);
        }
    }

    protected void storeApiDefinition(String organizationId, String apiId, String version, ApiDefinitionType definitionType, InputStream data) {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            ApiVersionBean apiVersion = this.storage.getApiVersion(organizationId, apiId, version);
            if (apiVersion == null) {
                throw ExceptionFactory.apiVersionNotFoundException(apiId, version);
            }
            if (apiVersion.getDefinitionType() != definitionType) {
                apiVersion.setDefinitionType(definitionType);
                this.storage.updateApiVersion(apiVersion);
            }
            this.storage.createAuditEntry(AuditUtils.apiDefinitionUpdated(apiVersion, this.securityContext));
            this.storage.updateApiDefinition(apiVersion, data);
            apiVersion.setModifiedOn(new Date());
            apiVersion.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updateApiVersion(apiVersion);
            this.storage.commitTx();
            this.log.debug(String.format("Stored API definition %s: %s", apiId, apiVersion));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ApiVersionSummaryBean> listApiVersions(String organizationId, String apiId) throws ApiNotFoundException, NotAuthorizedException {
        this.getApi(organizationId, apiId);
        try {
            return this.query.getApiVersions(organizationId, apiId);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ApiPlanSummaryBean> getApiVersionPlans(String organizationId, String apiId, String version) throws ApiVersionNotFoundException, NotAuthorizedException {
        this.getApiVersion(organizationId, apiId, version);
        try {
            return this.query.getApiVersionPlans(organizationId, apiId, version);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PolicyBean createApiPolicy(String organizationId, String apiId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ApiVersionBean avb = this.getApiVersion(organizationId, apiId, version);
        if (avb.isPublicAPI() ? avb.getStatus() == ApiStatus.Retired : avb.getStatus() == ApiStatus.Published || avb.getStatus() == ApiStatus.Retired) {
            throw ExceptionFactory.invalidApiStatusException();
        }
        PolicyBean policy = this.doCreatePolicy(organizationId, apiId, version, bean, PolicyType.Api);
        this.log.debug(String.format("Created API policy %s", avb));
        try {
            this.storage.beginTx();
            avb.setModifiedOn(new Date());
            avb.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.commitTx();
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            this.log.error((Throwable)e);
        }
        return policy;
    }

    public PolicyBean getApiPolicy(String organizationId, String apiId, String version, long policyId) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        this.getApiVersion(organizationId, apiId, version);
        PolicyBean policy = this.doGetPolicy(PolicyType.Api, organizationId, apiId, version, policyId);
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            policy.setConfiguration(null);
        }
        return policy;
    }

    public void updateApiPolicy(String organizationId, String apiId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ApiVersionBean avb = this.getApiVersion(organizationId, apiId, version);
        try {
            this.storage.beginTx();
            PolicyBean policy = this.storage.getPolicy(PolicyType.Api, organizationId, apiId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            if (AuditUtils.valueChanged(policy.getConfiguration(), bean.getConfiguration())) {
                policy.setConfiguration(bean.getConfiguration());
            }
            policy.setModifiedOn(new Date());
            policy.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updatePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyUpdated(policy, PolicyType.Api, this.securityContext));
            avb.setModifiedBy(this.securityContext.getCurrentUser());
            avb.setModifiedOn(new Date());
            this.storage.updateApiVersion(avb);
            this.storage.commitTx();
            this.log.debug(String.format("Updated API policy %s", policy));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void deleteApiPolicy(String organizationId, String apiId, String version, long policyId) throws OrganizationNotFoundException, ApiVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ApiVersionBean avb = this.getApiVersion(organizationId, apiId, version);
        if (avb.isPublicAPI() ? avb.getStatus() == ApiStatus.Retired : avb.getStatus() == ApiStatus.Published || avb.getStatus() == ApiStatus.Retired) {
            throw ExceptionFactory.invalidApiStatusException();
        }
        try {
            this.storage.beginTx();
            PolicyBean policy = this.storage.getPolicy(PolicyType.Api, organizationId, apiId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            this.storage.deletePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyRemoved(policy, PolicyType.Api, this.securityContext));
            avb.setModifiedBy(this.securityContext.getCurrentUser());
            avb.setModifiedOn(new Date());
            this.storage.updateApiVersion(avb);
            this.storage.commitTx();
            this.log.debug(String.format("Deleted API %s policy: %s", apiId, policy));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void deleteApiDefinition(String organizationId, String apiId, String version) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            ApiVersionBean apiVersion = this.storage.getApiVersion(organizationId, apiId, version);
            if (apiVersion == null) {
                throw ExceptionFactory.apiVersionNotFoundException(apiId, version);
            }
            apiVersion.setDefinitionType(ApiDefinitionType.None);
            apiVersion.setModifiedBy(this.securityContext.getCurrentUser());
            apiVersion.setModifiedOn(new Date());
            this.storage.createAuditEntry(AuditUtils.apiDefinitionDeleted(apiVersion, this.securityContext));
            this.storage.deleteApiDefinition(apiVersion);
            this.storage.updateApiVersion(apiVersion);
            this.storage.commitTx();
            this.log.debug(String.format("Deleted API %s definition %s", apiId, apiVersion));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<PolicySummaryBean> listApiPolicies(String organizationId, String apiId, String version) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        this.getApiVersion(organizationId, apiId, version);
        try {
            return this.query.getPolicies(organizationId, apiId, version, PolicyType.Api);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void reorderApiPolicies(String organizationId, String apiId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, ApiVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.apiEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        ApiVersionBean avb = this.getApiVersion(organizationId, apiId, version);
        try {
            this.storage.beginTx();
            ArrayList<Long> newOrder = new ArrayList<Long>(policyChain.getPolicies().size());
            for (PolicySummaryBean psb : policyChain.getPolicies()) {
                newOrder.add(psb.getId());
            }
            this.storage.reorderPolicies(PolicyType.Api, organizationId, apiId, version, newOrder);
            this.storage.createAuditEntry(AuditUtils.policiesReordered(avb, PolicyType.Api, this.securityContext));
            avb.setModifiedBy(this.securityContext.getCurrentUser());
            avb.setModifiedOn(new Date());
            this.storage.updateApiVersion(avb);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PolicyChainBean getApiPolicyChain(String organizationId, String apiId, String version, String planId) throws ApiVersionNotFoundException, PlanNotFoundException, NotAuthorizedException {
        ApiVersionBean avb = this.getApiVersion(organizationId, apiId, version);
        try {
            String planVersion = null;
            Set plans = avb.getPlans();
            if (plans != null) {
                for (ApiPlanBean apiPlanBean : plans) {
                    if (!apiPlanBean.getPlanId().equals(planId)) continue;
                    planVersion = apiPlanBean.getVersion();
                    break;
                }
            }
            if (planVersion == null) {
                throw ExceptionFactory.planNotFoundException(planId);
            }
            List apiPolicies = this.query.getPolicies(organizationId, apiId, version, PolicyType.Api);
            List planPolicies = this.query.getPolicies(organizationId, planId, planVersion, PolicyType.Plan);
            PolicyChainBean chain = new PolicyChainBean();
            chain.getPolicies().addAll(planPolicies);
            chain.getPolicies().addAll(apiPolicies);
            return chain;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ContractSummaryBean> getApiVersionContracts(String organizationId, String apiId, String version, int page, int pageSize) throws ApiVersionNotFoundException, NotAuthorizedException {
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        this.getApiVersion(organizationId, apiId, version);
        try {
            List contracts = this.query.getContracts(organizationId, apiId, version, page, pageSize);
            this.log.debug(String.format("Got API %s version %s contracts: %s", apiId, version, contracts));
            return contracts;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public UsageHistogramBean getUsage(String organizationId, String apiId, String version, HistogramIntervalType interval, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        if (interval == null) {
            interval = HistogramIntervalType.day;
        }
        this.validateMetricRange(from, to);
        this.validateTimeSeriesMetric(from, to, interval);
        return this.metrics.getUsage(organizationId, apiId, version, interval, from, to);
    }

    public UsagePerClientBean getUsagePerClient(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getUsagePerClient(organizationId, apiId, version, from, to);
    }

    public UsagePerPlanBean getUsagePerPlan(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getUsagePerPlan(organizationId, apiId, version, from, to);
    }

    public ResponseStatsHistogramBean getResponseStats(String organizationId, String apiId, String version, HistogramIntervalType interval, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        if (interval == null) {
            interval = HistogramIntervalType.day;
        }
        this.validateMetricRange(from, to);
        this.validateTimeSeriesMetric(from, to, interval);
        return this.metrics.getResponseStats(organizationId, apiId, version, interval, from, to);
    }

    public ResponseStatsSummaryBean getResponseStatsSummary(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getResponseStatsSummary(organizationId, apiId, version, from, to);
    }

    public ResponseStatsPerClientBean getResponseStatsPerClient(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getResponseStatsPerClient(organizationId, apiId, version, from, to);
    }

    public ResponseStatsPerPlanBean getResponseStatsPerPlan(String organizationId, String apiId, String version, String fromDate, String toDate) throws NotAuthorizedException, InvalidMetricCriteriaException {
        if (!this.securityContext.hasPermission(PermissionType.apiView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (fromDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"fromDate"}));
        }
        if (toDate == null) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("MissingOrInvalidParam", new Object[]{"toDate"}));
        }
        DateTime from = this.parseFromDate(fromDate);
        DateTime to = this.parseToDate(toDate);
        this.validateMetricRange(from, to);
        return this.metrics.getResponseStatsPerPlan(organizationId, apiId, version, from, to);
    }

    public PlanBean createPlan(String organizationId, NewPlanBean bean) throws OrganizationNotFoundException, PlanAlreadyExistsException, NotAuthorizedException, InvalidNameException {
        if (!this.securityContext.hasPermission(PermissionType.planEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        FieldValidator.validateName(bean.getName());
        PlanBean newPlan = new PlanBean();
        newPlan.setName(bean.getName());
        newPlan.setDescription(bean.getDescription());
        newPlan.setId(BeanUtils.idFromName((String)bean.getName()));
        newPlan.setCreatedOn(new Date());
        newPlan.setCreatedBy(this.securityContext.getCurrentUser());
        try {
            this.storage.beginTx();
            OrganizationBean orgBean = this.storage.getOrganization(organizationId);
            if (orgBean == null) {
                throw ExceptionFactory.organizationNotFoundException(organizationId);
            }
            if (this.storage.getPlan(orgBean.getId(), newPlan.getId()) != null) {
                throw ExceptionFactory.planAlreadyExistsException(newPlan.getName());
            }
            newPlan.setOrganization(orgBean);
            this.storage.createPlan(newPlan);
            this.storage.createAuditEntry(AuditUtils.planCreated(newPlan, this.securityContext));
            if (bean.getInitialVersion() != null) {
                NewPlanVersionBean newPlanVersion = new NewPlanVersionBean();
                newPlanVersion.setVersion(bean.getInitialVersion());
                this.createPlanVersionInternal(newPlanVersion, newPlan);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Created plan: %s", newPlan));
            return newPlan;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PlanBean getPlan(String organizationId, String planId) throws PlanNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            PlanBean bean = this.storage.getPlan(organizationId, planId);
            if (bean == null) {
                throw ExceptionFactory.planNotFoundException(planId);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Got plan: %s", bean));
            return bean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> getPlanActivity(String organizationId, String planId, int page, int pageSize) throws PlanNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.planView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditEntity(organizationId, planId, null, PlanBean.class, paging);
            return rval;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<PlanSummaryBean> listPlans(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        this.get(organizationId);
        try {
            return this.query.getPlansInOrg(organizationId);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void updatePlan(String organizationId, String planId, UpdatePlanBean bean) throws PlanNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.planEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        EntityUpdatedData auditData = new EntityUpdatedData();
        try {
            this.storage.beginTx();
            PlanBean planForUpdate = this.storage.getPlan(organizationId, planId);
            if (planForUpdate == null) {
                throw ExceptionFactory.planNotFoundException(planId);
            }
            if (AuditUtils.valueChanged(planForUpdate.getDescription(), bean.getDescription())) {
                auditData.addChange("description", planForUpdate.getDescription(), bean.getDescription());
                planForUpdate.setDescription(bean.getDescription());
            }
            this.storage.updatePlan(planForUpdate);
            this.storage.createAuditEntry(AuditUtils.planUpdated(planForUpdate, auditData, this.securityContext));
            this.storage.commitTx();
            this.log.debug(String.format("Updated plan: %s", planForUpdate));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PlanVersionBean createPlanVersion(String organizationId, String planId, NewPlanVersionBean bean) throws PlanNotFoundException, NotAuthorizedException, InvalidVersionException, PlanVersionAlreadyExistsException {
        PlanVersionBean newVersion;
        if (!this.securityContext.hasPermission(PermissionType.planEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        FieldValidator.validateVersion(bean.getVersion());
        try {
            this.storage.beginTx();
            PlanBean plan = this.storage.getPlan(organizationId, planId);
            if (plan == null) {
                throw ExceptionFactory.planNotFoundException(planId);
            }
            if (this.storage.getPlanVersion(organizationId, planId, bean.getVersion()) != null) {
                throw ExceptionFactory.planVersionAlreadyExistsException(planId, bean.getVersion());
            }
            newVersion = this.createPlanVersionInternal(bean, plan);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        if (bean.isClone() && bean.getCloneVersion() != null) {
            try {
                List<PolicySummaryBean> policies = this.listPlanPolicies(organizationId, planId, bean.getCloneVersion());
                for (PolicySummaryBean policySummary : policies) {
                    PolicyBean policy = this.getPlanPolicy(organizationId, planId, bean.getCloneVersion(), policySummary.getId());
                    NewPolicyBean npb = new NewPolicyBean();
                    npb.setDefinitionId(policy.getDefinition().getId());
                    npb.setConfiguration(policy.getConfiguration());
                    this.createPlanPolicy(organizationId, planId, newVersion.getVersion(), npb);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log.debug(String.format("Created plan %s version: %s", planId, newVersion));
        return newVersion;
    }

    protected PlanVersionBean createPlanVersionInternal(NewPlanVersionBean bean, PlanBean plan) throws StorageException {
        if (!BeanUtils.isValidVersion((String)bean.getVersion())) {
            throw new StorageException("Invalid/illegal plan version: " + bean.getVersion());
        }
        PlanVersionBean newVersion = new PlanVersionBean();
        newVersion.setCreatedBy(this.securityContext.getCurrentUser());
        newVersion.setCreatedOn(new Date());
        newVersion.setModifiedBy(this.securityContext.getCurrentUser());
        newVersion.setModifiedOn(new Date());
        newVersion.setStatus(PlanStatus.Created);
        newVersion.setPlan(plan);
        newVersion.setVersion(bean.getVersion());
        this.storage.createPlanVersion(newVersion);
        this.storage.createAuditEntry(AuditUtils.planVersionCreated(newVersion, this.securityContext));
        return newVersion;
    }

    public PlanVersionBean getPlanVersion(String organizationId, String planId, String version) throws PlanVersionNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            PlanVersionBean planVersion = this.storage.getPlanVersion(organizationId, planId, version);
            if (planVersion == null) {
                throw ExceptionFactory.planVersionNotFoundException(planId, version);
            }
            this.storage.commitTx();
            this.log.debug(String.format("Got plan %s version: %s", planId, planVersion));
            return planVersion;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> getPlanVersionActivity(String organizationId, String planId, String version, int page, int pageSize) throws PlanVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.planView, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditEntity(organizationId, planId, version, PlanBean.class, paging);
            return rval;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<PlanVersionSummaryBean> listPlanVersions(String organizationId, String planId) throws PlanNotFoundException, NotAuthorizedException {
        this.getPlan(organizationId, planId);
        try {
            return this.query.getPlanVersions(organizationId, planId);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PolicyBean createPlanPolicy(String organizationId, String planId, String version, NewPolicyBean bean) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.planEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        PlanVersionBean pvb = this.getPlanVersion(organizationId, planId, version);
        if (pvb.getStatus() == PlanStatus.Locked) {
            throw ExceptionFactory.invalidPlanStatusException();
        }
        this.log.debug(String.format("Creating plan %s policy %s", planId, pvb));
        PolicyBean policy = this.doCreatePolicy(organizationId, planId, version, bean, PolicyType.Plan);
        try {
            this.storage.beginTx();
            pvb.setModifiedOn(new Date());
            pvb.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.commitTx();
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            this.log.error((Throwable)e);
        }
        return policy;
    }

    public PolicyBean getPlanPolicy(String organizationId, String planId, String version, long policyId) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        boolean hasPermission = this.securityContext.hasPermission(PermissionType.planView, organizationId);
        this.getPlanVersion(organizationId, planId, version);
        PolicyBean policy = this.doGetPolicy(PolicyType.Plan, organizationId, planId, version, policyId);
        if (!hasPermission) {
            policy.setConfiguration(null);
        }
        this.log.debug(String.format("Got plan policy %s", policy));
        return policy;
    }

    public void updatePlanPolicy(String organizationId, String planId, String version, long policyId, UpdatePolicyBean bean) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.planEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        PlanVersionBean pvb = this.getPlanVersion(organizationId, planId, version);
        try {
            this.storage.beginTx();
            PolicyBean policy = this.storage.getPolicy(PolicyType.Plan, organizationId, planId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            if (AuditUtils.valueChanged(policy.getConfiguration(), bean.getConfiguration())) {
                policy.setConfiguration(bean.getConfiguration());
            }
            policy.setModifiedOn(new Date());
            policy.setModifiedBy(this.securityContext.getCurrentUser());
            this.storage.updatePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyUpdated(policy, PolicyType.Plan, this.securityContext));
            pvb.setModifiedBy(this.securityContext.getCurrentUser());
            pvb.setModifiedOn(new Date());
            this.storage.updatePlanVersion(pvb);
            this.storage.commitTx();
            this.log.debug(String.format("Updated plan policy %s", policy));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void deletePlanPolicy(String organizationId, String planId, String version, long policyId) throws OrganizationNotFoundException, PlanVersionNotFoundException, PolicyNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.planEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        PlanVersionBean pvb = this.getPlanVersion(organizationId, planId, version);
        if (pvb.getStatus() == PlanStatus.Locked) {
            throw ExceptionFactory.invalidPlanStatusException();
        }
        try {
            this.storage.beginTx();
            PolicyBean policy = this.storage.getPolicy(PolicyType.Plan, organizationId, planId, version, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            this.storage.deletePolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyRemoved(policy, PolicyType.Plan, this.securityContext));
            pvb.setModifiedBy(this.securityContext.getCurrentUser());
            pvb.setModifiedOn(new Date());
            this.storage.updatePlanVersion(pvb);
            this.storage.commitTx();
            this.log.debug(String.format("Deleted plan policy %s", policy));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void deletePlan(@PathParam(value="organizationId") String organizationId, @PathParam(value="planId") String planId) throws ApiNotFoundException, NotAuthorizedException, InvalidPlanStatusException {
        if (!this.securityContext.hasPermission(PermissionType.planAdmin, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        List<PlanVersionSummaryBean> lockedPlans = this.listPlanVersions(organizationId, planId).stream().filter(summary -> summary.getStatus() == PlanStatus.Locked).collect(Collectors.toList());
        if (!lockedPlans.isEmpty()) {
            throw ExceptionFactory.invalidPlanStatusException(lockedPlans);
        }
        try {
            this.storage.beginTx();
            PlanBean plan = this.storage.getPlan(organizationId, planId);
            this.storage.deletePlan(plan);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<PolicySummaryBean> listPlanPolicies(String organizationId, String planId, String version) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        this.getPlanVersion(organizationId, planId, version);
        try {
            return this.query.getPolicies(organizationId, planId, version, PolicyType.Plan);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void reorderPlanPolicies(String organizationId, String planId, String version, PolicyChainBean policyChain) throws OrganizationNotFoundException, PlanVersionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.planEdit, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        PlanVersionBean pvb = this.getPlanVersion(organizationId, planId, version);
        try {
            this.storage.beginTx();
            ArrayList<Long> newOrder = new ArrayList<Long>(policyChain.getPolicies().size());
            for (PolicySummaryBean psb : policyChain.getPolicies()) {
                newOrder.add(psb.getId());
            }
            this.storage.reorderPolicies(PolicyType.Plan, organizationId, planId, version, newOrder);
            this.storage.createAuditEntry(AuditUtils.policiesReordered(pvb, PolicyType.Plan, this.securityContext));
            pvb.setModifiedBy(this.securityContext.getCurrentUser());
            pvb.setModifiedOn(new Date());
            this.storage.updatePlanVersion(pvb);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    protected PolicyBean doCreatePolicy(String organizationId, String entityId, String entityVersion, NewPolicyBean bean, PolicyType type) throws PolicyDefinitionNotFoundException {
        int newIdx;
        PolicyDefinitionBean def;
        if (bean.getDefinitionId() == null) {
            throw ExceptionFactory.policyDefNotFoundException("null");
        }
        try {
            this.storage.beginTx();
            def = this.storage.getPolicyDefinition(bean.getDefinitionId());
            if (def == null) {
                throw ExceptionFactory.policyDefNotFoundException(bean.getDefinitionId());
            }
            this.storage.rollbackTx();
        }
        catch (AbstractRestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
        try {
            newIdx = this.query.getMaxPolicyOrderIndex(organizationId, entityId, entityVersion, type) + 1;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
        try {
            PolicyBean policy = new PolicyBean();
            policy.setId(null);
            policy.setDefinition(def);
            policy.setName(def.getName());
            policy.setConfiguration(bean.getConfiguration());
            policy.setCreatedBy(this.securityContext.getCurrentUser());
            policy.setCreatedOn(new Date());
            policy.setModifiedBy(this.securityContext.getCurrentUser());
            policy.setModifiedOn(new Date());
            policy.setOrganizationId(organizationId);
            policy.setEntityId(entityId);
            policy.setEntityVersion(entityVersion);
            policy.setType(type);
            policy.setOrderIndex(newIdx);
            this.storage.beginTx();
            if (type == PolicyType.Client) {
                ClientVersionBean cvb = this.storage.getClientVersion(organizationId, entityId, entityVersion);
                cvb.setModifiedBy(this.securityContext.getCurrentUser());
                cvb.setModifiedOn(new Date());
                this.storage.updateClientVersion(cvb);
            } else if (type == PolicyType.Api) {
                ApiVersionBean avb = this.storage.getApiVersion(organizationId, entityId, entityVersion);
                avb.setModifiedBy(this.securityContext.getCurrentUser());
                avb.setModifiedOn(new Date());
                this.storage.updateApiVersion(avb);
            } else if (type == PolicyType.Plan) {
                PlanVersionBean pvb = this.storage.getPlanVersion(organizationId, entityId, entityVersion);
                pvb.setModifiedBy(this.securityContext.getCurrentUser());
                pvb.setModifiedOn(new Date());
                this.storage.updatePlanVersion(pvb);
            }
            this.storage.createPolicy(policy);
            this.storage.createAuditEntry(AuditUtils.policyAdded(policy, type, this.securityContext));
            this.storage.commitTx();
            PolicyTemplateUtil.generatePolicyDescription((PolicyBean)policy);
            this.log.debug(String.format("Created client policy: %s", policy));
            return policy;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void grant(String organizationId, GrantRolesBean bean) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.orgAdmin, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        this.get(organizationId);
        this.users.get(bean.getUserId());
        for (Object roleId : bean.getRoleIds()) {
            this.roles.get((String)roleId);
        }
        MembershipData auditData = new MembershipData();
        auditData.setUserId(bean.getUserId());
        try {
            this.storage.beginTx();
            for (String roleId : bean.getRoleIds()) {
                RoleMembershipBean membership = RoleMembershipBean.create((String)bean.getUserId(), (String)roleId, (String)organizationId);
                membership.setCreatedOn(new Date());
                if (this.storage.getMembership(bean.getUserId(), roleId, organizationId) == null) {
                    this.storage.createMembership(membership);
                }
                auditData.addRole(roleId);
            }
            this.storage.createAuditEntry(AuditUtils.membershipGranted(organizationId, auditData, this.securityContext));
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void revoke(String organizationId, String roleId, String userId) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.orgAdmin, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        this.get(organizationId);
        this.users.get(userId);
        this.roles.get(roleId);
        MembershipData auditData = new MembershipData();
        auditData.setUserId(userId);
        try {
            this.storage.beginTx();
            this.storage.deleteMembership(userId, roleId, organizationId);
            auditData.addRole(roleId);
            this.storage.createAuditEntry(AuditUtils.membershipRevoked(organizationId, auditData, this.securityContext));
            this.storage.commitTx();
            this.log.debug(String.format("Revoked User %s Role %s Org %s", userId, roleId, organizationId));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void revokeAll(String organizationId, String userId) throws OrganizationNotFoundException, RoleNotFoundException, UserNotFoundException, NotAuthorizedException {
        if (!this.securityContext.hasPermission(PermissionType.orgAdmin, organizationId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        this.get(organizationId);
        this.users.get(userId);
        MembershipData auditData = new MembershipData();
        auditData.setUserId(userId);
        auditData.addRole("*");
        try {
            this.storage.beginTx();
            this.storage.deleteMemberships(userId, organizationId);
            this.storage.createAuditEntry(AuditUtils.membershipRevoked(organizationId, auditData, this.securityContext));
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<MemberBean> listMembers(String organizationId) throws OrganizationNotFoundException, NotAuthorizedException {
        this.get(organizationId);
        try {
            Set memberships = this.query.getOrgMemberships(organizationId);
            TreeMap<String, MemberBean> members = new TreeMap<String, MemberBean>();
            this.storage.beginTx();
            for (RoleMembershipBean membershipBean : memberships) {
                String userId = membershipBean.getUserId();
                String roleId = membershipBean.getRoleId();
                RoleBean role = this.storage.getRole(roleId);
                if (role == null) continue;
                MemberBean member = (MemberBean)members.get(userId);
                if (member == null) {
                    UserBean user = this.storage.getUser(userId);
                    member = new MemberBean();
                    member.setEmail(user.getEmail());
                    member.setUserId(userId);
                    member.setUserName(user.getFullName());
                    member.setRoles(new ArrayList());
                    members.put(userId, member);
                }
                MemberRoleBean mrb = new MemberRoleBean();
                mrb.setRoleId(roleId);
                mrb.setRoleName(role.getName());
                member.getRoles().add(mrb);
                if (member.getJoinedOn() != null && membershipBean.getCreatedOn().compareTo(member.getJoinedOn()) >= 0) continue;
                member.setJoinedOn(membershipBean.getCreatedOn());
            }
            ArrayList arrayList = new ArrayList(members.values());
            return arrayList;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
        finally {
            this.storage.rollbackTx();
        }
    }

    protected PolicyBean doGetPolicy(PolicyType type, String organizationId, String entityId, String entityVersion, long policyId) throws PolicyNotFoundException {
        try {
            this.storage.beginTx();
            PolicyBean policy = this.storage.getPolicy(type, organizationId, entityId, entityVersion, Long.valueOf(policyId));
            if (policy == null) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            this.storage.commitTx();
            if (policy.getType() != type) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            if (!policy.getOrganizationId().equals(organizationId)) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            if (!policy.getEntityId().equals(entityId)) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            if (!policy.getEntityVersion().equals(entityVersion)) {
                throw ExceptionFactory.policyNotFoundException(policyId);
            }
            PolicyTemplateUtil.generatePolicyDescription((PolicyBean)policy);
            return policy;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    private GatewaySummaryBean getSingularGateway() throws StorageException {
        List gateways = this.query.listGateways();
        if (gateways != null && gateways.size() == 1) {
            return (GatewaySummaryBean)gateways.get(0);
        }
        return null;
    }

    private void decryptEndpointProperties(ApiVersionBean versionBean) {
        Map endpointProperties = versionBean.getEndpointProperties();
        if (endpointProperties != null) {
            for (Map.Entry entry : endpointProperties.entrySet()) {
                DataEncryptionContext ctx = new DataEncryptionContext(versionBean.getApi().getOrganization().getId(), versionBean.getApi().getId(), versionBean.getVersion(), DataEncryptionContext.EntityType.Api);
                entry.setValue(this.encrypter.decrypt((String)entry.getValue(), ctx));
            }
        }
    }

    private void encryptEndpointProperties(ApiVersionBean versionBean) {
        Map endpointProperties = versionBean.getEndpointProperties();
        if (endpointProperties != null) {
            for (Map.Entry entry : endpointProperties.entrySet()) {
                DataEncryptionContext ctx = new DataEncryptionContext(versionBean.getApi().getOrganization().getId(), versionBean.getApi().getId(), versionBean.getVersion(), DataEncryptionContext.EntityType.Api);
                entry.setValue(this.encrypter.encrypt((String)entry.getValue(), ctx));
            }
        }
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public IUserResource getUsers() {
        return this.users;
    }

    public void setUsers(IUserResource users) {
        this.users = users;
    }

    public IRoleResource getRoles() {
        return this.roles;
    }

    public void setRoles(IRoleResource roles) {
        this.roles = roles;
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public IStorageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IStorageQuery query) {
        this.query = query;
    }

    public IMetricsAccessor getMetrics() {
        return this.metrics;
    }

    public void setMetrics(IMetricsAccessor metrics) {
        this.metrics = metrics;
    }

    public IClientValidator getClientValidator() {
        return this.clientValidator;
    }

    public void setClientValidator(IClientValidator clientValidator) {
        this.clientValidator = clientValidator;
    }

    public IApiValidator getApiValidator() {
        return this.apiValidator;
    }

    public void setApiValidator(IApiValidator apiValidator) {
        this.apiValidator = apiValidator;
    }

    public IApiKeyGenerator getApiKeyGenerator() {
        return this.apiKeyGenerator;
    }

    public void setApiKeyGenerator(IApiKeyGenerator apiKeyGenerator) {
        this.apiKeyGenerator = apiKeyGenerator;
    }

    private DateTime parseFromDate(String fromDate) {
        DateTime defaultFrom = new DateTime().withZone(DateTimeZone.UTC).minusDays(30).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0);
        return OrganizationResourceImpl.parseDate(fromDate, defaultFrom, true);
    }

    private DateTime parseToDate(String toDate) {
        return OrganizationResourceImpl.parseDate(toDate, new DateTime().withZone(DateTimeZone.UTC), false);
    }

    private static DateTime parseDate(String dateStr, DateTime defaultDate, boolean floor) {
        if ("now".equals(dateStr)) {
            return new DateTime();
        }
        if (dateStr.length() == 10) {
            DateTime parsed = ISODateTimeFormat.date().withZone(DateTimeZone.UTC).parseDateTime(dateStr);
            if (!floor) {
                parsed = parsed.plusDays(1).minusMillis(1);
            }
            return parsed;
        }
        if (dateStr.length() == 20) {
            return ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC).parseDateTime(dateStr);
        }
        if (dateStr.length() == 24) {
            return ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC).parseDateTime(dateStr);
        }
        return defaultDate;
    }

    private void validateMetricRange(DateTime from, DateTime to) throws InvalidMetricCriteriaException {
        if (from.isAfter((ReadableInstant)to)) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("OrganizationResourceImpl.InvalidMetricDateRange", new Object[0]));
        }
    }

    private void validateTimeSeriesMetric(DateTime from, DateTime to, HistogramIntervalType interval) throws InvalidMetricCriteriaException {
        long millis = to.getMillis() - from.getMillis();
        long divBy = 86400000L;
        switch (interval) {
            case day: {
                divBy = 86400000L;
                break;
            }
            case hour: {
                divBy = 3600000L;
                break;
            }
            case minute: {
                divBy = 60000L;
                break;
            }
            case month: {
                divBy = 2592000000L;
                break;
            }
            case week: {
                divBy = 604800000L;
                break;
            }
        }
        long totalDataPoints = millis / divBy;
        if (totalDataPoints > 5000L) {
            throw ExceptionFactory.invalidMetricCriteriaException(Messages.i18n.format("OrganizationResourceImpl.MetricDataSetTooLarge", new Object[0]));
        }
    }

    private void validateEndpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new InvalidParameterException(Messages.i18n.format("OrganizationResourceImpl.InvalidEndpointURL", new Object[0]));
        }
    }
}

