/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.idm.UserPermissionsBean;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.contract.IPermissionsResource;
import io.apiman.manager.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.contract.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.impl.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class PermissionsResourceImpl
implements IPermissionsResource {
    @Inject
    IStorageQuery query;
    @Inject
    ISecurityContext securityContext;

    public UserPermissionsBean getPermissionsForUser(String userId) throws UserNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            UserPermissionsBean bean = new UserPermissionsBean();
            bean.setUserId(userId);
            bean.setPermissions(this.query.getPermissions(userId));
            return bean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public UserPermissionsBean getPermissionsForCurrentUser() throws UserNotFoundException {
        try {
            String currentUser = this.securityContext.getCurrentUser();
            UserPermissionsBean bean = new UserPermissionsBean();
            bean.setUserId(currentUser);
            bean.setPermissions(this.query.getPermissions(currentUser));
            return bean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }
}

