/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.idm.NewRoleBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.UpdateRoleBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.contract.IRoleResource;
import io.apiman.manager.api.rest.contract.exceptions.InvalidSearchCriteriaException;
import io.apiman.manager.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.contract.exceptions.RoleAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.RoleNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.impl.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.SearchCriteriaUtil;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class RoleResourceImpl
implements IRoleResource {
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    ISecurityContext securityContext;

    public RoleBean create(NewRoleBean bean) throws RoleAlreadyExistsException, NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        RoleBean role = new RoleBean();
        role.setAutoGrant(bean.getAutoGrant());
        role.setCreatedBy(this.securityContext.getCurrentUser());
        role.setCreatedOn(new Date());
        role.setDescription(bean.getDescription());
        role.setId(BeanUtils.idFromName((String)bean.getName()));
        role.setName(bean.getName());
        role.setPermissions(bean.getPermissions());
        try {
            this.getStorage().beginTx();
            if (this.getStorage().getRole(role.getId()) != null) {
                throw ExceptionFactory.roleAlreadyExistsException(role.getId());
            }
            this.getStorage().createRole(role);
            this.getStorage().commitTx();
            return role;
        }
        catch (StorageException e) {
            this.getStorage().rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public RoleBean get(String roleId) throws RoleNotFoundException, NotAuthorizedException {
        try {
            this.getStorage().beginTx();
            RoleBean role = this.getStorage().getRole(roleId);
            if (role == null) {
                throw ExceptionFactory.roleNotFoundException(roleId);
            }
            RoleBean roleBean = role;
            return roleBean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
        finally {
            this.getStorage().rollbackTx();
        }
    }

    public void update(String roleId, UpdateRoleBean bean) throws RoleNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.getStorage().beginTx();
            RoleBean role = this.getStorage().getRole(roleId);
            if (role == null) {
                throw ExceptionFactory.roleNotFoundException(roleId);
            }
            if (bean.getDescription() != null) {
                role.setDescription(bean.getDescription());
            }
            if (bean.getAutoGrant() != null) {
                role.setAutoGrant(bean.getAutoGrant());
            }
            if (bean.getName() != null) {
                role.setName(bean.getName());
            }
            if (bean.getPermissions() != null) {
                role.getPermissions().clear();
                role.getPermissions().addAll(bean.getPermissions());
            }
            this.getStorage().updateRole(role);
            this.getStorage().commitTx();
        }
        catch (StorageException e) {
            this.getStorage().rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void delete(String roleId) throws RoleNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        RoleBean bean = this.get(roleId);
        try {
            this.getStorage().beginTx();
            this.getStorage().deleteRole(bean);
            this.getStorage().commitTx();
        }
        catch (StorageException e) {
            this.getStorage().rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<RoleBean> list() throws NotAuthorizedException {
        try {
            SearchCriteriaBean criteria = new SearchCriteriaBean();
            criteria.setOrder("name", true);
            return this.getQuery().findRoles(criteria).getBeans();
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<RoleBean> search(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException, NotAuthorizedException {
        try {
            SearchCriteriaUtil.validateSearchCriteria(criteria);
            return this.getQuery().findRoles(criteria);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public IStorageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IStorageQuery query) {
        this.query = query;
    }
}

