/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiNamespaceBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.AvailableApiBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.IApiCatalog;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.contract.ISearchResource;
import io.apiman.manager.api.rest.contract.exceptions.InvalidSearchCriteriaException;
import io.apiman.manager.api.rest.contract.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.impl.util.SearchCriteriaUtil;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class SearchResourceImpl
implements ISearchResource {
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    IApiCatalog apiCatalog;
    @Inject
    ISecurityContext securityContext;

    public SearchResultsBean<OrganizationSummaryBean> searchOrgs(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        try {
            return this.query.findOrganizations(criteria);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<ClientSummaryBean> searchClients(SearchCriteriaBean criteria) throws OrganizationNotFoundException, InvalidSearchCriteriaException {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        try {
            return this.query.findClients(criteria);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<ApiSummaryBean> searchApis(SearchCriteriaBean criteria) throws OrganizationNotFoundException, InvalidSearchCriteriaException {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        try {
            return this.query.findApis(criteria);
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AvailableApiBean> searchApiCatalog(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        int totalSize;
        int pageSize;
        int page;
        int start;
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        SearchResultsBean rval = new SearchResultsBean();
        if (criteria.getFilters().isEmpty()) {
            return rval;
        }
        SearchCriteriaFilterBean bean = (SearchCriteriaFilterBean)criteria.getFilters().get(0);
        if (bean == null) {
            return rval;
        }
        if (!bean.getName().equals("name")) {
            return rval;
        }
        String keyword = bean.getValue();
        String namespace = null;
        if (criteria.getFilters().size() >= 2 && (bean = (SearchCriteriaFilterBean)criteria.getFilters().get(1)) != null && bean.getName().equals("namespace") && bean.getOperator() == SearchCriteriaFilterOperator.eq) {
            namespace = bean.getValue();
        }
        List apis = this.apiCatalog.search(keyword, namespace);
        PagingBean paging = criteria.getPaging();
        if (paging == null) {
            paging = new PagingBean();
            paging.setPage(1);
            paging.setPageSize(500);
        }
        if ((start = ((page = paging.getPage()) - 1) * (pageSize = paging.getPageSize())) <= (totalSize = apis.size())) {
            int end = Math.min(start + pageSize, apis.size());
            rval.getBeans().addAll(apis.subList(start, end));
        }
        rval.setTotalSize(totalSize);
        return rval;
    }

    public List<ApiNamespaceBean> getApiNamespaces() {
        return this.apiCatalog.getNamespaces(this.securityContext.getCurrentUser());
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }
}

