/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UpdateUserBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.contract.IUserResource;
import io.apiman.manager.api.rest.contract.exceptions.InvalidSearchCriteriaException;
import io.apiman.manager.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.contract.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.impl.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class UserResourceImpl
implements IUserResource {
    @Inject
    private IStorage storage;
    @Inject
    ISecurityContext securityContext;
    @Inject
    IStorageQuery query;

    public UserBean get(String userId) throws UserNotFoundException {
        try {
            this.storage.beginTx();
            UserBean user = this.storage.getUser(userId);
            if (user == null) {
                throw ExceptionFactory.userNotFoundException(userId);
            }
            UserBean userBean = user;
            return userBean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
        finally {
            this.storage.rollbackTx();
        }
    }

    public void update(String userId, UpdateUserBean user) throws UserNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isAdmin() && !this.securityContext.getCurrentUser().equals(userId)) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            UserBean updatedUser = this.storage.getUser(userId);
            if (updatedUser == null) {
                throw ExceptionFactory.userNotFoundException(userId);
            }
            if (user.getEmail() != null) {
                updatedUser.setEmail(user.getEmail());
            }
            if (user.getFullName() != null) {
                updatedUser.setFullName(user.getFullName());
            }
            this.storage.updateUser(updatedUser);
            this.storage.commitTx();
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<UserBean> search(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        try {
            return this.query.findUsers(criteria);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<OrganizationSummaryBean> getOrganizations(String userId) {
        HashSet<String> permittedOrganizations = new HashSet<String>();
        try {
            Set memberships = this.query.getUserMemberships(userId);
            for (RoleMembershipBean membership : memberships) {
                permittedOrganizations.add(membership.getOrganizationId());
            }
            return this.query.getOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ClientSummaryBean> getClients(String userId) {
        HashSet<String> permittedOrganizations = new HashSet<String>();
        try {
            Set permissions = this.query.getPermissions(userId);
            for (PermissionBean permission : permissions) {
                if (permission.getName() != PermissionType.clientView) continue;
                permittedOrganizations.add(permission.getOrganizationId());
            }
            return this.query.getClientsInOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ApiSummaryBean> getApis(String userId) {
        HashSet<String> permittedOrganizations = new HashSet<String>();
        try {
            Set permissions = this.query.getPermissions(userId);
            for (PermissionBean permission : permissions) {
                if (permission.getName() != PermissionType.apiView) continue;
                permittedOrganizations.add(permission.getOrganizationId());
            }
            return this.query.getApisInOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> getActivity(String userId, int page, int pageSize) {
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditUser(userId, paging);
            return rval;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public IStorageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IStorageQuery query) {
        this.query = query;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }
}

