/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl.mappers;

import io.apiman.manager.api.beans.exceptions.ErrorBean;
import io.apiman.manager.api.rest.contract.exceptions.AbstractRestException;
import io.apiman.manager.api.security.ISecurityContext;
import java.io.PrintWriter;
import java.io.Writer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.output.StringBuilderWriter;

@Provider
@ApplicationScoped
public class RestExceptionMapper
implements ExceptionMapper<AbstractRestException> {
    @Inject
    ISecurityContext securityContext;

    public Response toResponse(AbstractRestException data) {
        ErrorBean error = new ErrorBean();
        error.setType(((Object)((Object)data)).getClass().getSimpleName());
        error.setErrorCode(data.getErrorCode());
        error.setMessage(data.getMessage());
        error.setMoreInfoUrl(data.getMoreInfoUrl());
        error.setStacktrace(this.getStackTrace(data));
        Response.ResponseBuilder builder = Response.status((int)data.getHttpCode()).header("X-Apiman-Error", (Object)"true");
        builder.type(MediaType.APPLICATION_JSON_TYPE);
        return builder.entity((Object)error).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStackTrace(AbstractRestException data) {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            data.printStackTrace(new PrintWriter((Writer)writer));
            String string = writer.getBuilder().toString();
            return string;
        }
    }
}

