/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.junit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.manager.api.core.util.PolicyTemplateUtil;
import io.apiman.manager.test.junit.ManagerRestTestGatewayLog;
import io.apiman.manager.test.junit.ManagerRestTestPlan;
import io.apiman.manager.test.junit.ManagerRestTestPublishPayload;
import io.apiman.manager.test.junit.RestTestSystemProperties;
import io.apiman.manager.test.server.ManagerApiTestServer;
import io.apiman.manager.test.server.MockGatewayServlet;
import io.apiman.test.common.json.JsonCompare;
import io.apiman.test.common.plan.TestGroupType;
import io.apiman.test.common.plan.TestPlan;
import io.apiman.test.common.plan.TestType;
import io.apiman.test.common.resttest.RestTest;
import io.apiman.test.common.util.TestPlanRunner;
import io.apiman.test.common.util.TestUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerRestTester
extends ParentRunner<TestInfo> {
    private static Logger logger = LoggerFactory.getLogger(TestPlanRunner.class);
    private static ManagerApiTestServer testServer = new ManagerApiTestServer();
    private static final boolean USE_PROXY = false;
    private static final int PROXY_PORT = 7071;
    private List<TestPlanInfo> testPlans = new ArrayList<TestPlanInfo>();
    private Set<String> resetSysProps = new HashSet<String>();

    public ManagerRestTester(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.configureSystemProperties();
        this.loadTestPlans(testClass);
    }

    private void loadTestPlans(Class<?> testClass) throws InitializationError {
        try {
            ManagerRestTestPlan annotation = testClass.getAnnotation(ManagerRestTestPlan.class);
            if (annotation == null) {
                Method[] methods = testClass.getMethods();
                TreeSet<ManagerRestTestPlan> annotations = new TreeSet<ManagerRestTestPlan>(new Comparator<ManagerRestTestPlan>(){

                    @Override
                    public int compare(ManagerRestTestPlan o1, ManagerRestTestPlan o2) {
                        Integer i1 = o1.order();
                        Integer i2 = o2.order();
                        return i1.compareTo(i2);
                    }
                });
                for (Method method : methods) {
                    annotation = method.getAnnotation(ManagerRestTestPlan.class);
                    if (annotation == null) continue;
                    annotations.add(annotation);
                }
                for (ManagerRestTestPlan anno : annotations) {
                    TestPlanInfo planInfo = new TestPlanInfo();
                    planInfo.planPath = anno.value();
                    planInfo.name = new File(planInfo.planPath).getName();
                    planInfo.endpoint = TestUtil.doPropertyReplacement((String)anno.endpoint());
                    planInfo.plan = TestUtil.loadTestPlan((String)planInfo.planPath, (ClassLoader)testClass.getClassLoader());
                    this.testPlans.add(planInfo);
                }
            } else {
                TestPlanInfo planInfo = new TestPlanInfo();
                planInfo.planPath = annotation.value();
                planInfo.name = new File(planInfo.planPath).getName();
                planInfo.plan = TestUtil.loadTestPlan((String)planInfo.planPath, (ClassLoader)testClass.getClassLoader());
                planInfo.endpoint = TestUtil.doPropertyReplacement((String)annotation.endpoint());
                this.testPlans.add(planInfo);
            }
        }
        catch (Throwable e) {
            throw new InitializationError(e);
        }
        if (this.testPlans.isEmpty()) {
            throw new InitializationError("No @ManagerRestTestPlan annotations found on test class: " + testClass);
        }
    }

    public static void setup() {
        if (!"true".equals(System.getProperty("apiman.junit.no-server", "false"))) {
            ManagerRestTester.startServer();
        } else {
            System.out.println("**** APIMan Server suppressed - assuming running tests against a live server. ****");
        }
    }

    public static void shutdown() {
        if (!"true".equals(System.getProperty("apiman.junit.no-server", "false"))) {
            ManagerRestTester.stopServer();
        }
    }

    protected static void startServer() {
        try {
            testServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void stopServer() {
        try {
            testServer.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<TestInfo> getChildren() {
        ManagerRestTestPublishPayload annotation2;
        ArrayList<TestInfo> children = new ArrayList<TestInfo>();
        TestPlanInfo lastPlan = null;
        Iterator<TestPlanInfo> iterator = this.testPlans.iterator();
        while (iterator.hasNext()) {
            TestPlanInfo planInfo;
            lastPlan = planInfo = iterator.next();
            planInfo.runner = new TestPlanRunner();
            List groups = planInfo.plan.getTestGroup();
            for (TestGroupType group : groups) {
                for (TestType test : group.getTest()) {
                    TestInfo testInfo = new TestInfo();
                    testInfo.name = this.testPlans.size() > 1 ? planInfo.name + " / " + test.getName() : test.getName();
                    testInfo.plan = planInfo;
                    testInfo.group = group;
                    testInfo.test = test;
                    children.add(testInfo);
                }
            }
        }
        ManagerRestTestGatewayLog annotation = this.getTestClass().getJavaClass().getAnnotation(ManagerRestTestGatewayLog.class);
        if (annotation != null) {
            GatewayAssertionTestInfo gatewayTest = new GatewayAssertionTestInfo();
            gatewayTest.name = "Assert Gateway Log";
            gatewayTest.plan = lastPlan;
            gatewayTest.expectedLog = annotation.value();
            children.add(gatewayTest);
        }
        if ((annotation2 = this.getTestClass().getJavaClass().getAnnotation(ManagerRestTestPublishPayload.class)) != null) {
            PublishPayloadTestInfo pubTest = new PublishPayloadTestInfo();
            pubTest.name = "Assert Publishing Payloads";
            pubTest.plan = lastPlan;
            pubTest.expectedPayloads = annotation2.value();
            children.add(pubTest);
        }
        return children;
    }

    public void run(RunNotifier notifier) {
        ManagerRestTester.setup();
        PolicyTemplateUtil.clearCache();
        MockGatewayServlet.reset();
        this.log("", new Object[0]);
        this.log("-------------------------------------------------------------------------------", new Object[0]);
        this.log("Executing REST Test", new Object[0]);
        this.log("-------------------------------------------------------------------------------", new Object[0]);
        this.log("", new Object[0]);
        try {
            super.run(notifier);
        }
        finally {
            try {
                testServer.flush();
                ManagerRestTester.shutdown();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.resetSystemProperties();
        }
        this.log("", new Object[0]);
        this.log("-------------------------------------------------------------------------------", new Object[0]);
        this.log("REST Test complete", new Object[0]);
        this.log("-------------------------------------------------------------------------------", new Object[0]);
        this.log("", new Object[0]);
    }

    protected void runChild(final TestInfo testInfo, RunNotifier notifier) {
        this.log("-----------------------------------------------------------", new Object[0]);
        this.log("Starting Test [{0} / {1}]", testInfo.plan.name, testInfo.name);
        this.log("-----------------------------------------------------------", new Object[0]);
        try {
            testServer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Description description = this.describeChild(testInfo);
        if (testInfo instanceof GatewayAssertionTestInfo) {
            this.runLeaf(new Statement(){

                public void evaluate() throws Throwable {
                    String actualGatewayLog = MockGatewayServlet.getRequestLog();
                    Assert.assertEquals((Object)((GatewayAssertionTestInfo)testInfo).expectedLog, (Object)actualGatewayLog);
                }
            }, description, notifier);
        } else if (testInfo instanceof PublishPayloadTestInfo) {
            this.runLeaf(new Statement(){

                public void evaluate() throws Throwable {
                    String[] expectedPayloads = ((PublishPayloadTestInfo)testInfo).expectedPayloads;
                    int index = 0;
                    for (String expectedPayload : expectedPayloads) {
                        if (MockGatewayServlet.getPayloads().isEmpty()) {
                            Assert.fail((String)"Expected a payload but did not find one.");
                        }
                        String actualPayload = MockGatewayServlet.getPayloads().get(index);
                        if (expectedPayload == null || "".equals(expectedPayload)) {
                            Assert.assertNull((Object)actualPayload);
                        } else {
                            ObjectMapper mapper = new ObjectMapper();
                            JsonNode expected = mapper.readTree(expectedPayload);
                            JsonNode actual = mapper.readTree(actualPayload.trim());
                            JsonCompare jsonCompare = new JsonCompare();
                            jsonCompare.assertJson(expected, actual);
                        }
                        ++index;
                    }
                }
            }, description, notifier);
        } else {
            this.runLeaf(new Statement(){

                public void evaluate() throws Throwable {
                    String rtPath = testInfo.test.getValue();
                    Integer delay = testInfo.test.getDelay();
                    if (delay != null) {
                        try {
                            Thread.sleep(delay.intValue());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (rtPath != null && !rtPath.trim().isEmpty()) {
                        RestTest restTest = TestUtil.loadRestTest((String)rtPath, (ClassLoader)ManagerRestTester.this.getTestClass().getJavaClass().getClassLoader());
                        String endpoint = testInfo.plan.endpoint;
                        if (StringUtils.isEmpty((CharSequence)endpoint)) {
                            endpoint = TestUtil.doPropertyReplacement((String)testInfo.test.getEndpoint());
                        }
                        if (StringUtils.isEmpty((CharSequence)endpoint)) {
                            endpoint = TestUtil.doPropertyReplacement((String)testInfo.group.getEndpoint());
                        }
                        if (StringUtils.isEmpty((CharSequence)endpoint)) {
                            endpoint = TestUtil.doPropertyReplacement((String)testInfo.plan.plan.getEndpoint());
                        }
                        if (StringUtils.isEmpty((CharSequence)endpoint)) {
                            endpoint = "http://localhost:" + ManagerRestTester.this.getTestServerPort() + ManagerRestTester.this.getBaseApiContext();
                        }
                        testInfo.plan.runner.runTest(restTest, endpoint);
                    }
                }
            }, description, notifier);
        }
    }

    protected Description describeChild(TestInfo child) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)child.name);
    }

    protected String getBaseApiContext() {
        return System.getProperty("apiman.junit.server-api-context", "/apiman");
    }

    protected int getTestServerPort() {
        String spPort = System.getProperty("apiman.junit.server-port");
        if (spPort != null) {
            return Integer.parseInt(spPort);
        }
        return testServer.serverPort();
    }

    private void configureSystemProperties() {
        TestUtil.setProperty((String)"apiman.test.gateway.endpoint", (String)("http://localhost:" + this.getTestServerPort() + "/mock-gateway"));
        TestUtil.setProperty((String)"apiman.test.gateway.username", (String)"admin");
        TestUtil.setProperty((String)"apiman.test.gateway.password", (String)"admin");
        TestUtil.setProperty((String)"apiman.manager.require-auto-granted-org", (String)"false");
        RestTestSystemProperties annotation = this.getTestClass().getJavaClass().getAnnotation(RestTestSystemProperties.class);
        if (annotation != null) {
            String[] strings = annotation.value();
            for (int idx = 0; idx < strings.length; idx += 2) {
                String pname = strings[idx];
                String pval = strings[idx + 1];
                this.log("Setting system property \"{0}\" to \"{1}\".", pname, pval);
                if (System.getProperty(pname) == null) {
                    this.resetSysProps.add(pname);
                }
                TestUtil.setProperty((String)pname, (String)pval);
            }
        }
    }

    private void resetSystemProperties() {
        for (String propName : this.resetSysProps) {
            System.clearProperty(propName);
        }
        this.resetSysProps.clear();
    }

    public void log(String message, Object ... params) {
        String outmsg = MessageFormat.format(message, params);
        logger.info("    >> " + outmsg);
    }

    public static class PublishPayloadTestInfo
    extends TestInfo {
        String[] expectedPayloads;
    }

    public static class GatewayAssertionTestInfo
    extends TestInfo {
        String expectedLog;
    }

    public static class TestInfo {
        TestGroupType group;
        TestType test;
        String name;
        TestPlanInfo plan;
    }

    public static class TestPlanInfo {
        TestPlan plan;
        String name;
        String planPath;
        String endpoint;
        TestPlanRunner runner;
    }
}

