/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.test.server.DefaultTestDataSeeder;
import io.apiman.manager.test.server.ISeeder;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class DatabaseSeedFilter
implements Filter {
    @Inject
    IStorage storage;

    public void init(FilterConfig filterConfig) throws ServletException {
        String seederClass = System.getProperty("apiman-manager.seeder.class", DefaultTestDataSeeder.class.getName());
        try {
            ISeeder seeder = (ISeeder)Class.forName(seederClass).newInstance();
            this.storage.beginTx();
            seeder.seed(this.storage);
            this.storage.commitTx();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.storage.rollbackTx();
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

