/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.common.es.util.AbstractClientFactory;
import io.apiman.common.es.util.DefaultEsClientFactory;
import io.apiman.common.es.util.EsConstants;
import io.apiman.common.servlet.ApimanCorsFilter;
import io.apiman.common.servlet.AuthenticationFilter;
import io.apiman.common.servlet.DisableCachingFilter;
import io.apiman.common.servlet.RootResourceFilter;
import io.apiman.manager.api.security.impl.DefaultSecurityContextFilter;
import io.apiman.manager.api.war.TransactionWatchdogFilter;
import io.apiman.manager.test.server.DatabaseSeedFilter;
import io.apiman.manager.test.server.MockGatewayServlet;
import io.apiman.manager.test.server.TestManagerApiApplication;
import io.apiman.manager.test.server.TestUsers;
import io.apiman.manager.test.util.ManagerTestUtils;
import io.apiman.test.common.es.EsTestUtil;
import io.apiman.test.common.util.TestUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Credential;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.weld.environment.servlet.BeanManagerResourceBindingListener;
import org.jboss.weld.environment.servlet.Listener;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

public class ManagerApiTestServer {
    public static RestHighLevelClient ES_CLIENT = null;
    private Server server;
    private BasicDataSource ds = null;
    private static ElasticsearchContainer node;
    private static final int ES_CLIENT_TIMEOUT = -1;
    private static final String ES_DEFAULT_INDEX = "apiman_manager";

    public ManagerApiTestServer(Map<String, String> config) {
    }

    public ManagerApiTestServer() {
    }

    public void start() throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("**** Starting Server (" + this.getClass().getSimpleName() + ")");
        this.preStart();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(handlers);
        int serverPort = this.serverPort();
        this.server = new Server(serverPort);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
    }

    private void deleteAndFlush() throws Exception {
        if (ES_CLIENT != null) {
            System.out.println("FLUSH AND DELETE>>>>>>");
            AbstractClientFactory.deleteIndices((RestHighLevelClient)ES_CLIENT);
            DefaultEsClientFactory.clearClientCache();
        }
    }

    public void stop() throws Exception {
        if (node != null) {
            this.deleteAndFlush();
        }
        this.server.stop();
        if (this.ds != null) {
            this.ds.close();
            InitialContext ctx = TestUtil.initialContext();
            ctx.unbind("java:comp/env/jdbc/ApiManagerDS");
        }
    }

    public int serverPort() {
        return 7070;
    }

    protected void preStart() throws Exception {
        if (ManagerTestUtils.getTestType() == ManagerTestUtils.TestType.jpa) {
            TestUtil.setProperty((String)"apiman.hibernate.hbm2ddl.auto", (String)"create-drop");
            TestUtil.setProperty((String)"apiman.hibernate.connection.datasource", (String)"java:/comp/env/jdbc/ApiManagerDS");
            try {
                InitialContext ctx = TestUtil.initialContext();
                TestUtil.ensureCtx((InitialContext)ctx, (String)"java:/comp/env");
                TestUtil.ensureCtx((InitialContext)ctx, (String)"java:/comp/env/jdbc");
                String dbOutputPath = System.getProperty("apiman.test.h2-output-dir", null);
                this.ds = dbOutputPath != null ? ManagerApiTestServer.createFileDatasource(new File(dbOutputPath)) : ManagerApiTestServer.createInMemoryDatasource();
                ctx.bind("java:/comp/env/jdbc/ApiManagerDS", (Object)this.ds);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (ManagerTestUtils.getTestType() == ManagerTestUtils.TestType.es) {
            if (node == null) {
                node = EsTestUtil.provideElasticsearchContainer();
            }
            if (!node.isRunning()) {
                node.start();
            }
            ES_CLIENT = ManagerApiTestServer.createEsClient();
        }
    }

    private static RestHighLevelClient createEsClient() {
        Map<String, String> config = ManagerApiTestServer.getTestClientConfig();
        return new DefaultEsClientFactory().createClient(config, Collections.emptyMap(), ES_DEFAULT_INDEX);
    }

    public static Map<String, String> getTestClientConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("client.type", "es");
        config.put("client.protocol", "http");
        config.put("client.host", node.getContainerIpAddress());
        config.put("client.port", node.getFirstMappedPort().toString());
        config.put("client.timeout", String.valueOf(-1));
        config.put("client.initialize", "true");
        return config;
    }

    private static BasicDataSource createInMemoryDatasource() throws SQLException {
        TestUtil.setProperty((String)"apiman.hibernate.dialect", (String)"org.hibernate.dialect.H2Dialect");
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(Driver.class.getName());
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setUrl("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        Connection connection = ds.getConnection();
        connection.close();
        System.out.println("DataSource created and bound to JNDI.");
        return ds;
    }

    private static BasicDataSource createFileDatasource(File outputDirectory) throws SQLException {
        TestUtil.setProperty((String)"apiman.hibernate.dialect", (String)"org.hibernate.dialect.H2Dialect");
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(Driver.class.getName());
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setUrl("jdbc:h2:" + outputDirectory.toString() + "/apiman-manager-api;MVCC=true");
        Connection connection = ds.getConnection();
        connection.close();
        System.out.println("DataSource created and bound to JNDI.");
        return ds;
    }

    protected void addModulesToJetty(ContextHandlerCollection handlers) throws Exception {
        ServletContextHandler apiManServer = new ServletContextHandler(1);
        apiManServer.setSecurityHandler(this.createSecurityHandler());
        apiManServer.setContextPath("/apiman");
        apiManServer.addEventListener((EventListener)new Listener());
        apiManServer.addEventListener((EventListener)new BeanManagerResourceBindingListener());
        apiManServer.addEventListener((EventListener)new ResteasyBootstrap());
        apiManServer.addFilter(DatabaseSeedFilter.class, "/db-seeder", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(ApimanCorsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(DisableCachingFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.configureAuthentication(apiManServer);
        apiManServer.addFilter(DefaultSecurityContextFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(TransactionWatchdogFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(RootResourceFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder resteasyServlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        resteasyServlet.setInitParameter("javax.ws.rs.Application", TestManagerApiApplication.class.getName());
        apiManServer.addServlet(resteasyServlet, "/*");
        apiManServer.setInitParameter("resteasy.injector.factory", "org.jboss.resteasy.cdi.CdiInjectorFactory");
        apiManServer.setInitParameter("resteasy.scan", "true");
        apiManServer.setInitParameter("resteasy.servlet.mapping.prefix", "");
        handlers.addHandler((Handler)apiManServer);
        ServletContextHandler mockGatewayServer = new ServletContextHandler(1);
        mockGatewayServer.setSecurityHandler(this.createSecurityHandler());
        mockGatewayServer.setContextPath("/mock-gateway");
        ServletHolder mockGatewayServlet = new ServletHolder((Servlet)new MockGatewayServlet());
        mockGatewayServer.addServlet(mockGatewayServlet, "/*");
        handlers.addHandler((Handler)mockGatewayServer);
    }

    private void configureAuthentication(ServletContextHandler apiManServer) {
        apiManServer.addFilter(AuthenticationFilter.class, "/actions/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/system/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/currentuser/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/gateways/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/organizations/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/permissions/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/plugins/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/policyDefs/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/roles/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/search/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/users/*", EnumSet.of(DispatcherType.REQUEST));
        apiManServer.addFilter(AuthenticationFilter.class, "/developer/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private SecurityHandler createSecurityHandler() {
        HashLoginService l = new HashLoginService();
        UserStore userStore = new UserStore();
        l.setUserStore(userStore);
        for (String[] userInfo : TestUsers.USERS) {
            String user = userInfo[0];
            String pwd = userInfo[1];
            String[] roles = new String[]{"apiuser"};
            if (user.startsWith("admin")) {
                roles = new String[]{"apiuser", "apiadmin"};
            }
            userStore.addUser(user, Credential.getCredential((String)pwd), roles);
        }
        l.setName("apimanrealm");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("apimanrealm");
        csh.setLoginService((LoginService)l);
        return csh;
    }

    public void flush() {
        if (ES_CLIENT != null) {
            System.out.println("FLUSH>>>>>>");
            this.flushIndices();
        }
    }

    private void flushIndices() {
        String[] indices = new String[EsConstants.MANAGER_INDEX_POSTFIXES.length];
        int i = 0;
        for (String postfix : EsConstants.MANAGER_INDEX_POSTFIXES) {
            indices[i++] = ("apiman_manager_" + postfix).toLowerCase();
        }
        try {
            ES_CLIENT.indices().flush(new FlushRequest(indices).force(true).waitIfOngoing(true), RequestOptions.DEFAULT);
            ES_CLIENT.indices().clearCache(new ClearIndicesCacheRequest(indices), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            System.err.println("Error flushing indices " + indices);
        }
    }
}

