/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.common.config.SystemPropertiesConfiguration;
import io.apiman.common.util.crypt.CurrentDataEncrypter;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.manager.api.beans.apis.EndpointType;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.summary.ApiNamespaceBean;
import io.apiman.manager.api.beans.summary.AvailableApiBean;
import io.apiman.manager.api.core.IApiCatalog;
import io.apiman.manager.api.core.IApiKeyGenerator;
import io.apiman.manager.api.core.IMetricsAccessor;
import io.apiman.manager.api.core.INewUserBootstrapper;
import io.apiman.manager.api.core.IPluginRegistry;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.UuidApiKeyGenerator;
import io.apiman.manager.api.core.crypt.DefaultDataEncrypter;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.es.EsMetricsAccessor;
import io.apiman.manager.api.es.EsStorage;
import io.apiman.manager.api.jpa.IJpaProperties;
import io.apiman.manager.api.jpa.JpaStorage;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.security.impl.DefaultSecurityContext;
import io.apiman.manager.test.server.ManagerApiTestServer;
import io.apiman.manager.test.server.TestEsStorageQueryWrapper;
import io.apiman.manager.test.server.TestEsStorageWrapper;
import io.apiman.manager.test.server.TestMetricsAccessor;
import io.apiman.manager.test.util.ManagerTestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.inject.Named;

@ApplicationScoped
@Named(value="ApimanLogFactory")
public class TestCdiFactory {
    private static final int JEST_TIMEOUT = -1;

    @Produces
    @ApplicationScoped
    public static ISecurityContext provideSecurityContext(@New DefaultSecurityContext defaultSC) {
        return defaultSC;
    }

    @Produces
    @ApplicationScoped
    public static INewUserBootstrapper provideNewUserBootstrapper() {
        return new INewUserBootstrapper(){

            public void bootstrapUser(UserBean user, IStorage storage) throws StorageException {
            }
        };
    }

    @Produces
    @ApplicationScoped
    public static IJpaProperties provideJpaProperties() {
        return new IJpaProperties(){

            public Map<String, String> getAllHibernateProperties() {
                SystemPropertiesConfiguration config = new SystemPropertiesConfiguration();
                HashMap<String, String> rval = new HashMap<String, String>();
                Iterator keys = config.getKeys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (!key.startsWith("apiman.hibernate.")) continue;
                    String value = config.getString(key);
                    key = key.substring("apiman.".length());
                    rval.put(key, value);
                }
                return rval;
            }
        };
    }

    @Produces
    @ApplicationScoped
    public static IStorage provideStorage(@New JpaStorage jpaStorage) {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return jpaStorage;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            EsStorage esStorage = new EsStorage(ManagerApiTestServer.getTestClientConfig());
            return new TestEsStorageWrapper(esStorage);
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    public static IStorageQuery provideStorageQuery(@New JpaStorage jpaStorage) {
        ManagerTestUtils.TestType testType = ManagerTestUtils.getTestType();
        if (testType == ManagerTestUtils.TestType.jpa) {
            return jpaStorage;
        }
        if (testType == ManagerTestUtils.TestType.es) {
            EsStorage esStorage = new EsStorage(ManagerApiTestServer.getTestClientConfig());
            return new TestEsStorageQueryWrapper(esStorage);
        }
        throw new RuntimeException("Unexpected test type: " + (Object)((Object)testType));
    }

    @Produces
    @ApplicationScoped
    public static IApiKeyGenerator provideApiKeyGenerator(@New UuidApiKeyGenerator uuidApiKeyGen) {
        return uuidApiKeyGen;
    }

    @Produces
    @ApplicationScoped
    public static IDataEncrypter provideDataEncrypter(@New DefaultDataEncrypter defaultEncrypter) {
        CurrentDataEncrypter.instance = defaultEncrypter;
        return defaultEncrypter;
    }

    @Produces
    @ApplicationScoped
    public static IApiCatalog provideApiCatalog(IPluginRegistry pluginRegistry) {
        return new IApiCatalog(){

            public List<AvailableApiBean> search(String keyword, String namespace) {
                ArrayList<AvailableApiBean> rval = new ArrayList<AvailableApiBean>();
                AvailableApiBean asb = new AvailableApiBean();
                asb.setName("Test API 1");
                asb.setDescription("The first test API.");
                asb.setEndpoint("http://api1.example.org/api");
                asb.setEndpointType(EndpointType.rest);
                rval.add(asb);
                asb = new AvailableApiBean();
                asb.setName("Test API 2");
                asb.setDescription("The second test API.");
                asb.setEndpoint("http://api2.example.org/api");
                asb.setEndpointType(EndpointType.rest);
                rval.add(asb);
                return rval;
            }

            public List<ApiNamespaceBean> getNamespaces(String currentUser) {
                ArrayList<ApiNamespaceBean> rval = new ArrayList<ApiNamespaceBean>();
                ApiNamespaceBean bean = new ApiNamespaceBean();
                bean.setCurrent(true);
                bean.setName("current");
                bean.setOwnedByUser(true);
                rval.add(bean);
                bean = new ApiNamespaceBean();
                bean.setCurrent(false);
                bean.setName("ns1");
                bean.setOwnedByUser(true);
                rval.add(bean);
                bean = new ApiNamespaceBean();
                bean.setCurrent(false);
                bean.setName("ns2");
                bean.setOwnedByUser(false);
                rval.add(bean);
                bean = new ApiNamespaceBean();
                bean.setCurrent(false);
                bean.setName("ns3");
                bean.setOwnedByUser(false);
                rval.add(bean);
                return rval;
            }
        };
    }

    @Produces
    @ApplicationScoped
    public static IMetricsAccessor provideMetricsAccessor() {
        boolean enableEsMetrics = "true".equals(System.getProperty("apiman-test.es-metrics", "false"));
        if (enableEsMetrics) {
            return new EsMetricsAccessor(ManagerApiTestServer.ES_CLIENT);
        }
        return new TestMetricsAccessor();
    }
}

