/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.test.server;

import io.apiman.common.es.util.EsConstants;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiPlanSummaryBean;
import io.apiman.manager.api.beans.summary.ApiRegistryBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ApiVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.ClientVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.beans.summary.PluginSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.es.EsStorage;
import java.util.List;
import java.util.Set;

public class TestEsStorageQueryWrapper
implements IStorageQuery {
    private EsStorage delegate;

    public TestEsStorageQueryWrapper(EsStorage delegate) {
        this.delegate = delegate;
    }

    public List<PluginSummaryBean> listPlugins() throws StorageException {
        this.refresh();
        return this.delegate.listPlugins();
    }

    public List<GatewaySummaryBean> listGateways() throws StorageException {
        this.refresh();
        return this.delegate.listGateways();
    }

    public SearchResultsBean<OrganizationSummaryBean> findOrganizations(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findOrganizations(criteria);
    }

    public SearchResultsBean<ClientSummaryBean> findClients(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findClients(criteria);
    }

    public SearchResultsBean<ApiSummaryBean> findApis(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findApis(criteria);
    }

    public SearchResultsBean<PlanSummaryBean> findPlans(String organizationId, SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findPlans(organizationId, criteria);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditEntity(String organizationId, String entityId, String entityVersion, Class<T> type, PagingBean paging) throws StorageException {
        this.refresh();
        return this.delegate.auditEntity(organizationId, entityId, entityVersion, type, paging);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditUser(String userId, PagingBean paging) throws StorageException {
        this.refresh();
        return this.delegate.auditUser(userId, paging);
    }

    public List<OrganizationSummaryBean> getOrgs(Set<String> orgIds) throws StorageException {
        this.refresh();
        return this.delegate.getOrgs(orgIds);
    }

    public List<ClientSummaryBean> getClientsInOrgs(Set<String> orgIds) throws StorageException {
        this.refresh();
        return this.delegate.getClientsInOrgs(orgIds);
    }

    public List<ClientSummaryBean> getClientsInOrg(String orgId) throws StorageException {
        this.refresh();
        return this.delegate.getClientsInOrg(orgId);
    }

    public List<ClientVersionSummaryBean> getClientVersions(String organizationId, String clientId) throws StorageException {
        this.refresh();
        return this.delegate.getClientVersions(organizationId, clientId);
    }

    public List<ContractSummaryBean> getClientContracts(String organizationId, String clientId, String version) throws StorageException {
        this.refresh();
        return this.delegate.getClientContracts(organizationId, clientId, version);
    }

    public ApiRegistryBean getApiRegistry(String organizationId, String clientId, String version) throws StorageException {
        this.refresh();
        return this.delegate.getApiRegistry(organizationId, clientId, version);
    }

    public List<ApiSummaryBean> getApisInOrgs(Set<String> orgIds) throws StorageException {
        this.refresh();
        return this.delegate.getApisInOrgs(orgIds);
    }

    public List<ApiSummaryBean> getApisInOrg(String orgId) throws StorageException {
        this.refresh();
        return this.delegate.getApisInOrg(orgId);
    }

    public List<ApiVersionSummaryBean> getApiVersions(String orgId, String apiId) throws StorageException {
        this.refresh();
        return this.delegate.getApiVersions(orgId, apiId);
    }

    public List<ApiPlanSummaryBean> getApiVersionPlans(String organizationId, String apiId, String version) throws StorageException {
        this.refresh();
        return this.delegate.getApiVersionPlans(organizationId, apiId, version);
    }

    public List<PlanSummaryBean> getPlansInOrgs(Set<String> orgIds) throws StorageException {
        this.refresh();
        return this.delegate.getPlansInOrgs(orgIds);
    }

    public List<PlanSummaryBean> getPlansInOrg(String orgId) throws StorageException {
        this.refresh();
        return this.delegate.getPlansInOrg(orgId);
    }

    public List<PlanVersionSummaryBean> getPlanVersions(String organizationId, String planId) throws StorageException {
        this.refresh();
        return this.delegate.getPlanVersions(organizationId, planId);
    }

    public List<PolicySummaryBean> getPolicies(String organizationId, String entityId, String version, PolicyType type) throws StorageException {
        this.refresh();
        return this.delegate.getPolicies(organizationId, entityId, version, type);
    }

    public List<PolicyDefinitionSummaryBean> listPolicyDefinitions() throws StorageException {
        this.refresh();
        return this.delegate.listPolicyDefinitions();
    }

    public List<ContractSummaryBean> getContracts(String organizationId, String apiId, String version, int page, int pageSize) throws StorageException {
        this.refresh();
        return this.delegate.getContracts(organizationId, apiId, version, page, pageSize);
    }

    public int getMaxPolicyOrderIndex(String organizationId, String entityId, String entityVersion, PolicyType type) throws StorageException {
        this.refresh();
        return this.delegate.getMaxPolicyOrderIndex(organizationId, entityId, entityVersion, type);
    }

    public List<PolicyDefinitionSummaryBean> listPluginPolicyDefs(Long pluginId) throws StorageException {
        this.refresh();
        return this.delegate.listPluginPolicyDefs(pluginId);
    }

    public SearchResultsBean<UserBean> findUsers(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findUsers(criteria);
    }

    public SearchResultsBean<RoleBean> findRoles(SearchCriteriaBean criteria) throws StorageException {
        this.refresh();
        return this.delegate.findRoles(criteria);
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId) throws StorageException {
        this.refresh();
        return this.delegate.getUserMemberships(userId);
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId, String organizationId) throws StorageException {
        this.refresh();
        return this.delegate.getUserMemberships(userId);
    }

    public Set<RoleMembershipBean> getOrgMemberships(String organizationId) throws StorageException {
        this.refresh();
        return this.delegate.getOrgMemberships(organizationId);
    }

    public Set<PermissionBean> getPermissions(String userId) throws StorageException {
        this.refresh();
        return this.delegate.getPermissions(userId);
    }

    private void refresh() {
        try {
            for (String postfix : EsConstants.MANAGER_INDEX_POSTFIXES) {
                this.delegate.refresh(postfix.toLowerCase());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

