/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.configurations.http.client;

import io.apimatic.coreinterfaces.http.LoggingLevel;
import io.apimatic.coreinterfaces.http.LoggingPolicy;
import io.apimatic.coreinterfaces.logger.configuration.ReadonlyLogging;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class ApiLoggingConfiguration
implements ReadonlyLogging {
    private boolean logRequestInfo;
    private boolean logResponseInfo;
    private boolean logRequestHeaders;
    private boolean logResponseHeaders;
    private boolean logRequestBody;
    private boolean logResponseBody;
    private boolean prettyPrintLogs;
    private LoggingLevel level;
    private LoggingPolicy headerLoggingPolicy;
    private Set<String> headerFilters;

    private ApiLoggingConfiguration(boolean logRequestInfo, boolean logResponseInfo, boolean logRequestHeaders, boolean logResponseHeaders, boolean logRequestBody, boolean logResponseBody, boolean prettyPrintLogs, LoggingLevel level, LoggingPolicy headerLoggingPolicy, TreeSet<String> headerFilters) {
        this.logRequestInfo = logRequestInfo;
        this.logResponseInfo = logResponseInfo;
        this.logRequestHeaders = logRequestHeaders;
        this.logResponseHeaders = logResponseHeaders;
        this.logRequestBody = logRequestBody;
        this.logResponseBody = logResponseBody;
        this.prettyPrintLogs = prettyPrintLogs;
        this.level = level;
        this.headerLoggingPolicy = headerLoggingPolicy;
        this.headerFilters = Collections.unmodifiableSet(headerFilters);
    }

    public boolean isLoggingRequestInfo() {
        return this.logRequestInfo;
    }

    public boolean isLoggingResponseInfo() {
        return this.logResponseInfo;
    }

    public boolean isLoggingRequestHeaders() {
        return this.logRequestHeaders;
    }

    public boolean isLoggingResponseHeaders() {
        return this.logResponseHeaders;
    }

    public boolean isLoggingRequestBody() {
        return this.logRequestBody;
    }

    public boolean isLoggingResponseBody() {
        return this.logResponseBody;
    }

    public boolean isPrettyPrinting() {
        return this.prettyPrintLogs;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public LoggingPolicy getHeaderLoggingPolicy() {
        return this.headerLoggingPolicy;
    }

    public Set<String> getHeaderFilters() {
        return this.headerFilters;
    }

    public String toString() {
        return "LoggingConfiguration [logRequestInfo=" + this.logRequestInfo + ", logResponseInfo=" + this.logResponseInfo + ", logRequestHeaders=" + this.logRequestHeaders + ", logResponseHeaders=" + this.logResponseHeaders + ", logRequestBody=" + this.logRequestBody + ", logResponseBody=" + this.logResponseBody + ", prettyPrintLogs=" + this.prettyPrintLogs + ", level=" + this.level + ", headerLoggingPolicy=" + this.headerLoggingPolicy + ", headerFilters=" + this.headerFilters + "]";
    }

    public Builder newBuilder() {
        return new Builder().logRequestInfo(this.logRequestInfo).logRequestHeaders(this.logRequestHeaders).logRequestBody(this.logRequestBody).logResponseInfo(this.logResponseInfo).logResponseHeaders(this.logResponseHeaders).logResponseBody(this.logResponseBody).prettyPrintLogs(this.prettyPrintLogs).level(this.level).headerLoggingPolicy(this.headerLoggingPolicy).headerFilters(this.headerFilters);
    }

    public static class Builder {
        private boolean logRequestInfo;
        private boolean logResponseInfo;
        private boolean logRequestHeaders;
        private boolean logResponseHeaders;
        private boolean logRequestBody;
        private boolean logResponseBody;
        private boolean prettyPrintLogs;
        private LoggingLevel level = LoggingLevel.INFO;
        private LoggingPolicy headerLoggingPolicy = LoggingPolicy.EXCLUDE;
        private TreeSet<String> headerFilters = new TreeSet(String.CASE_INSENSITIVE_ORDER);

        public Builder() {
            this.headerFilters.addAll(Arrays.asList("authorization"));
        }

        public Builder logRequestInfo(boolean logRequestInfo) {
            this.logRequestInfo = logRequestInfo;
            return this;
        }

        public Builder logResponseInfo(boolean logResponseInfo) {
            this.logResponseInfo = logResponseInfo;
            return this;
        }

        public Builder logRequestHeaders(boolean logRequestHeaders) {
            this.logRequestHeaders = logRequestHeaders;
            return this;
        }

        public Builder logResponseHeaders(boolean logResponseHeaders) {
            this.logResponseHeaders = logResponseHeaders;
            return this;
        }

        public Builder logRequestBody(boolean logRequestBody) {
            this.logRequestBody = logRequestBody;
            return this;
        }

        public Builder logResponseBody(boolean logResponseBody) {
            this.logResponseBody = logResponseBody;
            return this;
        }

        public Builder logEverything() {
            this.logRequestInfo = true;
            this.logResponseInfo = true;
            this.logRequestHeaders = true;
            this.logResponseHeaders = true;
            this.logRequestBody = true;
            this.logResponseBody = true;
            return this;
        }

        public Builder logNothing() {
            this.logRequestInfo = false;
            this.logResponseInfo = false;
            this.logRequestHeaders = false;
            this.logResponseHeaders = false;
            this.logRequestBody = false;
            this.logResponseBody = false;
            return this;
        }

        public Builder prettyPrintLogs(boolean prettyPrintLogs) {
            this.prettyPrintLogs = prettyPrintLogs;
            return this;
        }

        public Builder level(LoggingLevel level) {
            this.level = level;
            return this;
        }

        public Builder headerLoggingPolicy(LoggingPolicy headerLoggingPolicy) {
            this.headerLoggingPolicy = headerLoggingPolicy;
            return this;
        }

        public Builder headerFilters(Set<String> headerFilters) {
            this.headerFilters.clear();
            this.headerFilters.addAll(headerFilters);
            return this;
        }

        public Builder clearHeaderFilter() {
            this.headerFilters.clear();
            return this;
        }

        public Builder addHeaderFilter(String header) {
            this.headerFilters.add(header);
            return this;
        }

        public ApiLoggingConfiguration build() {
            return new ApiLoggingConfiguration(this.logRequestInfo, this.logResponseInfo, this.logRequestHeaders, this.logResponseHeaders, this.logRequestBody, this.logResponseBody, this.prettyPrintLogs, this.level, this.headerLoggingPolicy, this.headerFilters);
        }
    }

    public static enum HeaderLoggingPolicy {
        INCLUDE,
        EXCLUDE;

    }

    public static enum Level {
        INFO,
        ERROR,
        WARN,
        DEBUG,
        TRACE;

    }
}

