/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.java.enums;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import io.apisense.generation.dart.adapter.javapoet.JavaPoetGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;

abstract class GenerateEnum
extends JavaPoetGenerator {
    private static final ClassName ENUMSET_CLASS = ClassName.get((String)"java.util", (String)"EnumSet", (String[])new String[0]);

    GenerateEnum(String fileSuffix) {
        super(fileSuffix);
    }

    protected List<FieldSpec> fields() {
        ArrayList<FieldSpec> res = new ArrayList<FieldSpec>();
        res.add(FieldSpec.builder(Integer.TYPE, (String)"value", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        res.add(FieldSpec.builder(String.class, (String)"label", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        return res;
    }

    protected List<MethodSpec> genericMethods(ClassName currentClass) {
        ArrayList<MethodSpec> res = new ArrayList<MethodSpec>();
        res.add(this.constructor());
        res.addAll(this.getters());
        res.add(this.matches());
        res.add(this.equals());
        res.add(this.toStringMethod());
        res.add(this.parseMethod(currentClass));
        res.add(this.parseSet(currentClass));
        return res;
    }

    protected MethodSpec parseMethod(ClassName c) {
        return MethodSpec.methodBuilder((String)"parse").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).returns((TypeName)ParameterizedTypeName.get((ClassName)ENUMSET_CLASS, (TypeName[])new TypeName[]{c})).addParameter(String[].class, "labels", new Modifier[]{Modifier.FINAL}).varargs().addStatement("$T<$T> res = $T.noneOf($T.class)", new Object[]{ENUMSET_CLASS, c, ENUMSET_CLASS, c}).beginControlFlow("for (String label : labels)", new Object[0]).beginControlFlow("for ($T val : values())", new Object[]{c}).beginControlFlow("if (val.equals(label))", new Object[0]).addStatement("res.add(val)", new Object[0]).endControlFlow().endControlFlow().endControlFlow().addStatement("return res", new Object[0]).build();
    }

    protected MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addParameter(String.class, "label", new Modifier[]{Modifier.FINAL}).addStatement("this.value = 1 << this.ordinal()", new Object[0]).addStatement("this.label = label", new Object[0]).build();
    }

    protected List<MethodSpec> getters() {
        ArrayList<MethodSpec> res = new ArrayList<MethodSpec>();
        res.add(MethodSpec.methodBuilder((String)"value").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return this.value", new Object[0]).build());
        return res;
    }

    private MethodSpec matches() {
        ClassName bitMask = ClassName.get((String)"io.apisense.dart.lib", (String)"BitMask", (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"matches").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(Boolean.TYPE).addParameter(Integer.TYPE, "value", new Modifier[]{Modifier.FINAL}).addStatement("return $T.matches(this.value, value)", new Object[]{bitMask}).build();
    }

    private MethodSpec equals() {
        return MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(Boolean.TYPE).addParameter(String.class, "label", new Modifier[]{Modifier.FINAL}).addStatement("return this.label.equalsIgnoreCase(label)", new Object[0]).build();
    }

    private MethodSpec toStringMethod() {
        return MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(String.class).addStatement("return this.label", new Object[0]).build();
    }

    private MethodSpec parseSet(ClassName c) {
        return MethodSpec.methodBuilder((String)"parse").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).returns((TypeName)ParameterizedTypeName.get((ClassName)ENUMSET_CLASS, (TypeName[])new TypeName[]{c})).addParameter(int[].class, "codes", new Modifier[]{Modifier.FINAL}).varargs().addStatement("$T<$T> res = $T.noneOf($T.class)", new Object[]{ENUMSET_CLASS, c, ENUMSET_CLASS, c}).beginControlFlow("for (int code : codes)", new Object[0]).beginControlFlow("for ($T val : values())", new Object[]{c}).beginControlFlow("if (val.matches(code))", new Object[0]).addStatement("res.add(val)", new Object[0]).endControlFlow().endControlFlow().endControlFlow().addStatement("return res", new Object[0]).build();
    }
}

