/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.java.enums;

import com.squareup.javapoet.TypeSpec;
import io.apisense.generation.dart.adapter.javapoet.OneShotGenerator;
import io.apisense.generation.dart.java.enums.GenerateTypedEnum;
import io.apisense.interpretor.main.StringUtils;
import io.apisense.interpretor.structure.Enumeration;
import io.apisense.interpretor.structure.Filter;
import io.apisense.interpretor.structure.Sprout;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class GenerateEventFilter
extends GenerateTypedEnum
implements OneShotGenerator<Sprout> {
    private static final String CLASS_SUFFIX = "Filter";
    private String sproutName;

    public GenerateEventFilter(String dartName) {
        super(CLASS_SUFFIX);
        this.setDartName(dartName);
    }

    @Override
    public String className() {
        if (this.sproutName == null) {
            throw new IllegalStateException("Cannot use className() until sprout set");
        }
        return StringUtils.capitalize(this.sproutName) + CLASS_SUFFIX;
    }

    @Override
    public void generate(Sprout sprout) {
        this.sproutName = sprout.eventName();
        this.contentBuilder = TypeSpec.enumBuilder((String)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.contentBuilder.addFields(this.fields());
        this.addConstants(sprout);
        this.contentBuilder.addMethods(this.genericMethods(this.currentClass()));
    }

    private void addConstants(Sprout sprout) {
        List<Filter> filters = sprout.getFilters();
        for (Filter f : filters) {
            if (f.getType() instanceof Enumeration) continue;
            this.contentBuilder.addEnumConstant(f.getLabel().toUpperCase(), TypeSpec.anonymousClassBuilder((String)"$S, $T.class", (Object[])new Object[]{f.getLabel(), f.getType().generableClass()}).build());
        }
    }
}

