/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.interpretor.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.apisense.generation.dart.GeneratedType;
import io.apisense.interpretor.main.StringUtils;
import io.apisense.interpretor.parser.TypeClass;
import io.apisense.interpretor.structure.Enumeration;
import io.apisense.interpretor.structure.Primitive;
import java.io.IOException;
import java.util.ArrayList;

final class TypeDeserializer
extends JsonDeserializer<GeneratedType> {
    private static final String SELF_REFERENCE_PREFIX = "@";
    private static final String DART_PACKAGE = "io.apisense.dart";
    private final String dartName;

    TypeDeserializer(String dartName) {
        this.dartName = dartName;
    }

    public GeneratedType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.isTextual()) {
            Primitive primitive;
            String canonicalName = node.asText();
            if (canonicalName.startsWith(SELF_REFERENCE_PREFIX)) {
                canonicalName = this.deserializePrimitiveTypeForSeed(canonicalName.substring(1));
            }
            return (primitive = this.getPrimitiveFromBindings(canonicalName)) != null ? primitive : Primitive.forCanonicalName(canonicalName);
        }
        return this.deserializeEnum(node);
    }

    private Primitive getPrimitiveFromBindings(String typeName) {
        Primitive type;
        try {
            type = new Primitive(TypeClass.valueOf(StringUtils.capitalize(typeName)).getType());
        }
        catch (IllegalArgumentException e) {
            type = null;
        }
        return type;
    }

    private String deserializePrimitiveTypeForSeed(String seedName) {
        String packageName = "io.apisense.dart." + this.dartName;
        String className = StringUtils.capitalize(this.dartName) + StringUtils.capitalize(seedName);
        return packageName + "." + className;
    }

    private Enumeration deserializeEnum(JsonNode node) throws IOException {
        ArrayList<String> enumValues = new ArrayList<String>();
        if (node.isArray()) {
            for (JsonNode arrayValue : node) {
                enumValues.add(arrayValue.asText());
            }
        }
        Enumeration result = new Enumeration(enumValues);
        return result;
    }
}

