/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.interpretor.structure;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import io.apisense.generation.dart.GeneratedType;
import java.util.ArrayList;
import java.util.List;

public class Primitive
implements GeneratedType {
    private static final String PACKAGE_DELIMITER = ".";
    private static final String TEMPLATE_START = "<";
    private static final String TEMPLATE_END = ">";
    private static final String ARGS_DELIMITER = ",\\w*";
    private static final List<String> COMMON_PACKAGE = new ArrayList<String>();
    private Class<?> type;
    private String packageName;
    private String className;
    private List<Primitive> templateArgs;

    public Primitive(Class<?> type) {
        this.type = type;
        this.packageName = type.getPackage().getName();
        this.className = type.getSimpleName();
    }

    public Primitive(String packageName, String className, String ... templateArgs) {
        this.packageName = packageName;
        this.className = className;
        this.templateArgs = new ArrayList<Primitive>();
        for (String templateArg : templateArgs) {
            this.templateArgs.add(Primitive.forCanonicalName(templateArg.trim()));
        }
    }

    public static Primitive forCanonicalName(String canonicalName) {
        int packageEnd = canonicalName.lastIndexOf(PACKAGE_DELIMITER);
        int firstTemplateMatcher = canonicalName.indexOf(TEMPLATE_START);
        int lastTemplateMatcher = canonicalName.lastIndexOf(TEMPLATE_END);
        String className = canonicalName.substring(packageEnd + 1);
        String[] args = new String[]{};
        if (firstTemplateMatcher != -1 && lastTemplateMatcher != -1) {
            packageEnd = canonicalName.substring(0, firstTemplateMatcher).lastIndexOf(PACKAGE_DELIMITER);
            args = Primitive.cutDownTemplateArgs(canonicalName.substring(firstTemplateMatcher + 1, lastTemplateMatcher));
            className = canonicalName.substring(packageEnd + 1, firstTemplateMatcher);
        }
        String packageName = packageEnd != -1 ? canonicalName.substring(0, packageEnd) : Primitive.discoverPackage(className);
        return new Primitive(packageName, className, args);
    }

    private static String discoverPackage(String className) {
        for (String pack : COMMON_PACKAGE) {
            try {
                return Class.forName(pack + className).getPackage().getName();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return "";
    }

    private static String[] cutDownTemplateArgs(String argsString) {
        String[] split = argsString.split(ARGS_DELIMITER);
        ArrayList<String> args = new ArrayList<String>();
        String currentArg = "";
        for (String arg : split) {
            if (arg.contains(TEMPLATE_START) && !arg.contains(TEMPLATE_END)) {
                currentArg = arg;
                continue;
            }
            if (arg.contains(TEMPLATE_END)) {
                currentArg = currentArg + "," + arg;
                args.add(currentArg);
                currentArg = "";
                continue;
            }
            if (!currentArg.isEmpty()) {
                currentArg = currentArg + "," + arg;
                continue;
            }
            args.add(arg);
        }
        split = new String[args.size()];
        args.toArray(split);
        return split;
    }

    @Override
    public TypeName generableClass() {
        Object typeName;
        if (this.type != null) {
            typeName = ClassName.get(this.type);
        } else {
            ClassName rawType = ClassName.get((String)this.getPackageName(), (String)this.getClassName(), (String[])new String[0]);
            typeName = this.templateArgs.isEmpty() ? rawType : ParameterizedTypeName.get((ClassName)rawType, (TypeName[])this.templateArgsClassName());
        }
        return typeName;
    }

    private TypeName[] templateArgsClassName() {
        int nbArgs = this.templateArgs.size();
        TypeName[] args = new TypeName[nbArgs];
        for (int i = 0; i < nbArgs; ++i) {
            args[i] = this.templateArgs.get(i).generableClass();
        }
        return args;
    }

    @Override
    public String simpleName() {
        TypeName typeName = this.generableClass();
        ClassName rawType = typeName instanceof ParameterizedTypeName ? ((ParameterizedTypeName)typeName).rawType : (ClassName)typeName;
        return rawType.simpleName();
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<Primitive> getTemplateArgs() {
        return this.templateArgs;
    }

    static {
        COMMON_PACKAGE.add("java.util.");
        COMMON_PACKAGE.add("java.lang.");
    }
}

