/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.aws;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import io.apptik.json.JsonElement;
import io.apptik.json.JsonString;
import io.apptik.json.exception.JsonException;
import io.apptik.json.wrapper.TypedJsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DynamoDb2Item
extends TypedJsonObject<AttributeValue> {
    public static List<DynamoDb2Item> createFromList(List<Map<String, AttributeValue>> vals) {
        ArrayList<DynamoDb2Item> res = new ArrayList<DynamoDb2Item>();
        for (Map<String, AttributeValue> item : vals) {
            res.add(DynamoDb2Item.createFrom(item));
        }
        return res;
    }

    public static DynamoDb2Item createFrom(Map<String, AttributeValue> val) {
        return (DynamoDb2Item)new DynamoDb2Item().putAll(val);
    }

    protected AttributeValue get(JsonElement el, String key) {
        AttributeValue atVal = new AttributeValue();
        if (el.isNumber()) {
            atVal.withN(el.toString());
        } else if (el.isJsonArray()) {
            boolean isNumberArr = true;
            ArrayList<String> attrList = new ArrayList<String>();
            for (JsonElement arrEl : el.asJsonArray()) {
                if (isNumberArr && !arrEl.isNumber()) {
                    isNumberArr = false;
                }
                attrList.add(arrEl.toString());
            }
            if (isNumberArr) {
                atVal.withNS(attrList);
            } else {
                atVal.withSS(attrList);
            }
        } else {
            atVal.withS(el.toString());
        }
        return atVal;
    }

    protected JsonElement to(AttributeValue value) {
        JsonString el = new JsonString("");
        try {
            if (value.getS() != null) {
                el = JsonElement.wrap((Object)value.getS());
            } else if (value.getN() != null) {
                el = JsonElement.wrap((Object)value.getN());
            } else if (value.getSS() != null) {
                el = JsonElement.wrap((Object)value.getSS());
            } else if (value.getNS() != null) {
                el = JsonElement.wrap((Object)value.getNS());
            } else if (value.getB() != null) {
                el = JsonElement.wrap((Object)value.getB());
            } else if (value.getN() != null) {
                el = JsonElement.wrap((Object)value.getBS());
            }
        }
        catch (JsonException e) {
            e.printStackTrace();
        }
        return el;
    }
}

