/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.generators;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonNumber;
import io.apptik.json.generator.JsonGenerator;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.schema.Schema;

public class NumberGenerator
extends JsonGenerator {
    public NumberGenerator(Schema schema, JsonGeneratorConfig configuration) {
        super(schema, configuration);
    }

    public NumberGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        super(schema, configuration, propertyName);
    }

    @Override
    public JsonElement generate() {
        int minValue = 0;
        int maxValue = Integer.MAX_VALUE;
        if (this.configuration != null) {
            if (this.configuration.globalNumberMin != null) {
                minValue = this.configuration.globalNumberMin;
            }
            if (this.configuration.globalNumberMax != null) {
                maxValue = this.configuration.globalNumberMax;
            }
            if (this.propertyName != null) {
                if (this.configuration.numberMin.get(this.propertyName) != null) {
                    minValue = this.configuration.numberMin.get(this.propertyName);
                }
                if (this.configuration.numberMax.get(this.propertyName) != null) {
                    maxValue = this.configuration.numberMax.get(this.propertyName);
                }
            }
        }
        return new JsonNumber((Number)((double)(minValue + rnd.nextInt(maxValue - minValue)) + Math.abs(rnd.nextDouble())));
    }
}

