/*
 * Decompiled with CFR 0.152.
 */
package io.apptik.json.generator.generators;

import io.apptik.json.JsonElement;
import io.apptik.json.JsonObject;
import io.apptik.json.exception.JsonException;
import io.apptik.json.generator.JsonGenerator;
import io.apptik.json.generator.JsonGeneratorConfig;
import io.apptik.json.schema.Schema;
import io.apptik.json.schema.SchemaMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.hamcrest.Matcher;

public class ObjectGenerator
extends JsonGenerator {
    public ObjectGenerator(Schema schema, JsonGeneratorConfig configuration) {
        super(schema, configuration);
    }

    public ObjectGenerator(Schema schema, JsonGeneratorConfig configuration, String propertyName) {
        super(schema, configuration, propertyName);
    }

    public JsonObject generate() {
        JsonObject res = new JsonObject();
        SchemaMap props = this.schema.getProperties();
        if (props != null) {
            block6: for (Map.Entry propItem : props) {
                if (this.configuration.skipObjectProperties.contains(propItem.getKey())) continue;
                Schema propertySchema = (Schema)propItem.getValue();
                for (Map.Entry entry : commonPropertyMatchers.entrySet()) {
                    if (!((Matcher)entry.getKey()).matches((Object)propertySchema)) continue;
                    try {
                        JsonGenerator gen = (JsonGenerator)((Class)entry.getValue()).getDeclaredConstructor(Schema.class, JsonGeneratorConfig.class, String.class).newInstance(propertySchema, this.configuration, propItem.getKey());
                        JsonElement newEl = gen.generate();
                        if (newEl == null) continue;
                        res.put((String)propItem.getKey(), newEl);
                        continue block6;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (JsonException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return res;
    }
}

