/*
 * Decompiled with CFR 0.152.
 */
package arrow.typeclasses;

import arrow.core.Composition;
import arrow.core.Const;
import arrow.core.ConstKt;
import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.Endo;
import arrow.core.IterableKt;
import arrow.core.MapKt;
import arrow.core.None;
import arrow.core.Option;
import arrow.core.OptionKt;
import arrow.core.SequenceKt;
import arrow.core.TupleNKt;
import arrow.core.Validated;
import arrow.core.ValidatedKt;
import arrow.typeclasses.Monoid;
import arrow.typeclasses.Semigroup;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\bf\u0018\u0000 \f*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\fJ\u001b\u0010\u0003\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0017\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0003\u001a\u00028\u0000*\b\u0012\u0004\u0012\u00028\u00000\nH\u0017\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\t\u001a\u00028\u0000*\b\u0012\u0004\u0012\u00028\u00000\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Larrow/typeclasses/Monoid;", "A", "Larrow/typeclasses/Semigroup;", "combineAll", "elems", "", "(Ljava/util/List;)Ljava/lang/Object;", "empty", "()Ljava/lang/Object;", "fold", "", "(Ljava/util/Collection;)Ljava/lang/Object;", "Companion", "arrow-core"})
public interface Monoid<A>
extends Semigroup<A> {
    @NotNull
    public static final Companion Companion = arrow.typeclasses.Monoid$Companion.$$INSTANCE;

    public A empty();

    @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
    public A combineAll(@NotNull Collection<? extends A> var1);

    @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
    public A combineAll(@NotNull List<? extends A> var1);

    public A fold(@NotNull Collection<? extends A> var1);

    public A fold(@NotNull List<? extends A> var1);

    @JvmStatic
    @JvmName(name="Boolean")
    @NotNull
    public static Monoid<Boolean> Boolean() {
        return Companion.Boolean();
    }

    @JvmStatic
    @JvmName(name="Byte")
    @NotNull
    public static Monoid<Byte> Byte() {
        return Companion.Byte();
    }

    @JvmStatic
    @JvmName(name="Integer")
    @NotNull
    public static Monoid<Integer> Integer() {
        return Companion.Integer();
    }

    @JvmStatic
    @JvmName(name="Long")
    @NotNull
    public static Monoid<Long> Long() {
        return Companion.Long();
    }

    @JvmStatic
    @JvmName(name="Short")
    @NotNull
    public static Monoid<Short> Short() {
        return Companion.Short();
    }

    @JvmStatic
    @NotNull
    public static <A> Monoid<List<A>> list() {
        return Companion.list();
    }

    @JvmStatic
    @NotNull
    public static <A> Monoid<Sequence<A>> sequence() {
        return Companion.sequence();
    }

    @JvmStatic
    @NotNull
    public static Monoid<String> string() {
        return Companion.string();
    }

    @JvmStatic
    @NotNull
    public static <A, B> Monoid<Either<A, B>> either(@NotNull Semigroup<A> SGA, @NotNull Monoid<B> MB) {
        return Companion.either(SGA, MB);
    }

    @JvmStatic
    @NotNull
    public static <A> Monoid<Endo<A>> endo() {
        return Companion.endo();
    }

    @JvmStatic
    @JvmName(name="constant")
    @NotNull
    public static <A, T> Monoid<Const<A, T>> constant(@NotNull Monoid<A> MA) {
        return Companion.constant(MA);
    }

    @JvmStatic
    @NotNull
    public static <K, A> Monoid<Map<K, A>> map(@NotNull Semigroup<A> SG) {
        return Companion.map(SG);
    }

    @JvmStatic
    @NotNull
    public static <A> Monoid<Option<A>> option(@NotNull Semigroup<A> MA) {
        return Companion.option(MA);
    }

    @JvmStatic
    @NotNull
    public static <E, A> Monoid<Validated<E, A>> validated(@NotNull Semigroup<E> SE, @NotNull Monoid<A> MA) {
        return Companion.validated(SE, MA);
    }

    @JvmStatic
    @NotNull
    public static <A, B> Monoid<Pair<A, B>> pair(@NotNull Monoid<A> MA, @NotNull Monoid<B> MB) {
        return Companion.pair(MA, MB);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001:\u000f3456789:;<=>?@AB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0002\b\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0007\u00a2\u0006\u0002\b\tJ9\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000b0\u0004\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004H\u0007\u00a2\u0006\u0002\b\u000fJB\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\u00120\u00110\u0004\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0004H\u0007JB\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\u00120\u00110\u0004\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\f0\u00152\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0004H\u0007J\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u00170\u0004\"\u0004\b\u0001\u0010\fH\u0007J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004H\u0007\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u001c0\u0004\"\u0004\b\u0001\u0010\fH\u0007J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0004H\u0007\u00a2\u0006\u0002\b\u001fJ4\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H\f0!0\u0004\"\u0004\b\u0001\u0010\"\"\u0004\b\u0002\u0010\f2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\f0\u0015H\u0007J(\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0%0\u0004\"\u0004\b\u0001\u0010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u0015H\u0007JB\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\u00120'0\u0004\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0004H\u0007J\u001a\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0)0\u0004\"\u0004\b\u0001\u0010\fH\u0007J\u0013\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0004H\u0007\u00a2\u0006\u0002\b,J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0004H\u0007JB\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u0002H\f000\u0004\"\u0004\b\u0001\u00101\"\u0004\b\u0002\u0010\f2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H10\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004H\u0007\u00a8\u0006B"}, d2={"Larrow/typeclasses/Monoid$Companion;", "", "()V", "boolean", "Larrow/typeclasses/Monoid;", "", "Boolean", "byte", "", "Byte", "const", "Larrow/core/Const;", "A", "T", "MA", "constant", "either", "Larrow/core/Either;", "B", "MB", "SGA", "Larrow/typeclasses/Semigroup;", "endo", "Larrow/core/Endo;", "int", "", "Integer", "list", "", "long", "", "Long", "map", "", "K", "SG", "option", "Larrow/core/Option;", "pair", "Lkotlin/Pair;", "sequence", "Lkotlin/sequences/Sequence;", "short", "", "Short", "string", "", "validated", "Larrow/core/Validated;", "E", "SE", "AndMonoid", "ByteMonoid", "DoubleMonoid", "EitherMonoid", "FloatMonoid", "IntMonoid", "ListMonoid", "LongMonoid", "MapMonoid", "OptionMonoid", "PairMonoid", "SequenceMonoid", "ShortMonoid", "StringMonoid", "ValidatedMonoid", "arrow-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @JvmName(name="Boolean")
        @NotNull
        public final Monoid<Boolean> Boolean() {
            return AndMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Byte")
        @NotNull
        public final Monoid<Byte> Byte() {
            return ByteMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Integer")
        @NotNull
        public final Monoid<Integer> Integer() {
            return IntMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Long")
        @NotNull
        public final Monoid<Long> Long() {
            return LongMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Short")
        @NotNull
        public final Monoid<Short> Short() {
            return ShortMonoid.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final <A> Monoid<List<A>> list() {
            ListMonoid listMonoid = ListMonoid.INSTANCE;
            Intrinsics.checkNotNull((Object)listMonoid, (String)"null cannot be cast to non-null type arrow.typeclasses.Monoid<kotlin.collections.List<A of arrow.typeclasses.Monoid.Companion.list>>");
            return listMonoid;
        }

        @JvmStatic
        @NotNull
        public final <A> Monoid<Sequence<A>> sequence() {
            SequenceMonoid sequenceMonoid = SequenceMonoid.INSTANCE;
            Intrinsics.checkNotNull((Object)sequenceMonoid, (String)"null cannot be cast to non-null type arrow.typeclasses.Monoid<kotlin.sequences.Sequence<A of arrow.typeclasses.Monoid.Companion.sequence>>");
            return sequenceMonoid;
        }

        @JvmStatic
        @NotNull
        public final Monoid<String> string() {
            return StringMonoid.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final <A, B> Monoid<Either<A, B>> either(@NotNull Semigroup<A> SGA, @NotNull Monoid<B> MB) {
            Intrinsics.checkNotNullParameter(SGA, (String)"SGA");
            Intrinsics.checkNotNullParameter(MB, (String)"MB");
            return new EitherMonoid<A, B>(SGA, MB);
        }

        @Deprecated(message="For binary compat", level=DeprecationLevel.HIDDEN)
        public final /* synthetic */ Monoid either(Monoid MA, Monoid MB) {
            Intrinsics.checkNotNullParameter((Object)MA, (String)"MA");
            Intrinsics.checkNotNullParameter((Object)MB, (String)"MB");
            return new EitherMonoid(MA, MB);
        }

        @JvmStatic
        @NotNull
        public final <A> Monoid<Endo<A>> endo() {
            return new Monoid<Endo<A>>(){

                @NotNull
                public Endo<A> empty() {
                    return new Endo<A>(endo.empty.1.INSTANCE);
                }

                @NotNull
                public Endo<A> combine(@NotNull Endo<A> $this$combine, @NotNull Endo<A> g) {
                    Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                    Intrinsics.checkNotNullParameter(g, (String)"g");
                    return new Endo<A>(Composition.compose($this$combine.getF(), g.getF()));
                }

                @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
                @NotNull
                public Endo<A> combineAll(@NotNull Collection<Endo<A>> $this$combineAll) {
                    return DefaultImpls.combineAll(this, $this$combineAll);
                }

                @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
                @NotNull
                public Endo<A> combineAll(@NotNull List<Endo<A>> elems) {
                    return DefaultImpls.combineAll(this, elems);
                }

                @NotNull
                public Endo<A> fold(@NotNull Collection<Endo<A>> $this$fold) {
                    return DefaultImpls.fold(this, $this$fold);
                }

                @NotNull
                public Endo<A> fold(@NotNull List<Endo<A>> elems) {
                    return DefaultImpls.fold(this, elems);
                }

                @NotNull
                public Endo<A> plus(@NotNull Endo<A> $this$plus, @NotNull Endo<A> b) {
                    return DefaultImpls.plus(this, $this$plus, b);
                }

                @NotNull
                public Endo<A> maybeCombine(@NotNull Endo<A> $this$maybeCombine, @Nullable Endo<A> b) {
                    return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
                }
            };
        }

        @JvmStatic
        @JvmName(name="constant")
        @NotNull
        public final <A, T> Monoid<Const<A, T>> constant(@NotNull Monoid<A> MA) {
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            return new Monoid<Const<A, ? extends T>>(MA){
                final /* synthetic */ Monoid<A> $MA;
                {
                    this.$MA = $MA;
                }

                @NotNull
                public Const<A, T> empty() {
                    return new Const<A, T>(this.$MA.empty());
                }

                @NotNull
                public Const<A, T> combine(@NotNull Const<A, ? extends T> $this$combine, @NotNull Const<A, ? extends T> b) {
                    Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                    Intrinsics.checkNotNullParameter(b, (String)"b");
                    return ConstKt.combine($this$combine, this.$MA, b);
                }

                @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
                @NotNull
                public Const<A, T> combineAll(@NotNull Collection<? extends Const<A, ? extends T>> $this$combineAll) {
                    return DefaultImpls.combineAll(this, $this$combineAll);
                }

                @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
                @NotNull
                public Const<A, T> combineAll(@NotNull List<? extends Const<A, ? extends T>> elems) {
                    return DefaultImpls.combineAll(this, elems);
                }

                @NotNull
                public Const<A, T> fold(@NotNull Collection<? extends Const<A, ? extends T>> $this$fold) {
                    return DefaultImpls.fold(this, $this$fold);
                }

                @NotNull
                public Const<A, T> fold(@NotNull List<? extends Const<A, ? extends T>> elems) {
                    return DefaultImpls.fold(this, elems);
                }

                @NotNull
                public Const<A, T> plus(@NotNull Const<A, ? extends T> $this$plus, @NotNull Const<A, ? extends T> b) {
                    return DefaultImpls.plus(this, $this$plus, b);
                }

                @NotNull
                public Const<A, T> maybeCombine(@NotNull Const<A, ? extends T> $this$maybeCombine, @Nullable Const<A, ? extends T> b) {
                    return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
                }
            };
        }

        @JvmStatic
        @NotNull
        public final <K, A> Monoid<Map<K, A>> map(@NotNull Semigroup<A> SG) {
            Intrinsics.checkNotNullParameter(SG, (String)"SG");
            return new MapMonoid(SG);
        }

        @JvmStatic
        @NotNull
        public final <A> Monoid<Option<A>> option(@NotNull Semigroup<A> MA) {
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            return new OptionMonoid<A>(MA);
        }

        @JvmStatic
        @NotNull
        public final <E, A> Monoid<Validated<E, A>> validated(@NotNull Semigroup<E> SE, @NotNull Monoid<A> MA) {
            Intrinsics.checkNotNullParameter(SE, (String)"SE");
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            return new ValidatedMonoid<E, A>(SE, MA);
        }

        @JvmStatic
        @NotNull
        public final <A, B> Monoid<Pair<A, B>> pair(@NotNull Monoid<A> MA, @NotNull Monoid<B> MB) {
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            Intrinsics.checkNotNullParameter(MB, (String)"MB");
            return new PairMonoid<A, B>(MA, MB);
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J8\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Larrow/typeclasses/Monoid$Companion$ValidatedMonoid;", "A", "B", "Larrow/typeclasses/Monoid;", "Larrow/core/Validated;", "SA", "Larrow/typeclasses/Semigroup;", "MB", "(Larrow/typeclasses/Semigroup;Larrow/typeclasses/Monoid;)V", "empty", "Larrow/core/Validated$Valid;", "combine", "b", "arrow-core"})
        private static final class ValidatedMonoid<A, B>
        implements Monoid<Validated<? extends A, ? extends B>> {
            @NotNull
            private final Semigroup<A> SA;
            @NotNull
            private final Monoid<B> MB;
            @NotNull
            private final Validated.Valid<B> empty;

            public ValidatedMonoid(@NotNull Semigroup<A> SA, @NotNull Monoid<B> MB) {
                Intrinsics.checkNotNullParameter(SA, (String)"SA");
                Intrinsics.checkNotNullParameter(MB, (String)"MB");
                this.SA = SA;
                this.MB = MB;
                this.empty = new Validated.Valid<B>(this.MB.empty());
            }

            @Override
            @NotNull
            public Validated<A, B> empty() {
                return this.empty;
            }

            @Override
            @NotNull
            public Validated<A, B> combine(@NotNull Validated<? extends A, ? extends B> $this$combine, @NotNull Validated<? extends A, ? extends B> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return ValidatedKt.combine($this$combine, this.SA, this.MB, b);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Validated<A, B> combineAll(@NotNull Collection<? extends Validated<? extends A, ? extends B>> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Validated<A, B> combineAll(@NotNull List<? extends Validated<? extends A, ? extends B>> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Validated<A, B> fold(@NotNull Collection<? extends Validated<? extends A, ? extends B>> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Validated<A, B> fold(@NotNull List<? extends Validated<? extends A, ? extends B>> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Validated<A, B> plus(@NotNull Validated<? extends A, ? extends B> $this$plus, @NotNull Validated<? extends A, ? extends B> b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Validated<A, B> maybeCombine(@NotNull Validated<? extends A, ? extends B> $this$maybeCombine, @Nullable Validated<? extends A, ? extends B> b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J&\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003*\b\u0012\u0004\u0012\u00028\u00010\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J(\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003*\b\u0012\u0004\u0012\u00028\u00010\u00032\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Larrow/typeclasses/Monoid$Companion$OptionMonoid;", "A", "Larrow/typeclasses/Monoid;", "Larrow/core/Option;", "MA", "Larrow/typeclasses/Semigroup;", "(Larrow/typeclasses/Semigroup;)V", "empty", "combine", "b", "maybeCombine", "arrow-core"})
        private static final class OptionMonoid<A>
        implements Monoid<Option<? extends A>> {
            @NotNull
            private final Semigroup<A> MA;

            public OptionMonoid(@NotNull Semigroup<A> MA) {
                Intrinsics.checkNotNullParameter(MA, (String)"MA");
                this.MA = MA;
            }

            @Override
            @NotNull
            public Option<A> combine(@NotNull Option<? extends A> $this$combine, @NotNull Option<? extends A> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return OptionKt.combine($this$combine, this.MA, b);
            }

            @Override
            @NotNull
            public Option<A> maybeCombine(@NotNull Option<? extends A> $this$maybeCombine, @Nullable Option<? extends A> b) {
                Option<? extends A> option2;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"<this>");
                        option2 = b;
                        if (option2 == null) break block2;
                        Option<? extends A> it = option2;
                        boolean bl = false;
                        Option<? extends A> option3 = OptionKt.combine($this$maybeCombine, this.MA, it);
                        option2 = option3;
                        if (option3 != null) break block3;
                    }
                    option2 = $this$maybeCombine;
                }
                return option2;
            }

            @Override
            @NotNull
            public Option<A> empty() {
                return None.INSTANCE;
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Option<A> combineAll(@NotNull Collection<? extends Option<? extends A>> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Option<A> combineAll(@NotNull List<? extends Option<? extends A>> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Option<A> fold(@NotNull Collection<? extends Option<? extends A>> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Option<A> fold(@NotNull List<? extends Option<? extends A>> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Option<A> plus(@NotNull Option<? extends A> $this$plus, @NotNull Option<? extends A> b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J8\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Larrow/typeclasses/Monoid$Companion$MapMonoid;", "K", "A", "Larrow/typeclasses/Monoid;", "", "SG", "Larrow/typeclasses/Semigroup;", "(Larrow/typeclasses/Semigroup;)V", "empty", "combine", "b", "arrow-core"})
        private static final class MapMonoid<K, A>
        implements Monoid<Map<K, ? extends A>> {
            @NotNull
            private final Semigroup<A> SG;

            public MapMonoid(@NotNull Semigroup<A> SG) {
                Intrinsics.checkNotNullParameter(SG, (String)"SG");
                this.SG = SG;
            }

            @Override
            @NotNull
            public Map<K, A> empty() {
                return MapsKt.emptyMap();
            }

            @Override
            @NotNull
            public Map<K, A> combine(@NotNull Map<K, ? extends A> $this$combine, @NotNull Map<K, ? extends A> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return MapKt.combine($this$combine, this.SG, b);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Map<K, A> combineAll(@NotNull Collection<? extends Map<K, ? extends A>> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Map<K, A> combineAll(@NotNull List<? extends Map<K, ? extends A>> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Map<K, A> fold(@NotNull Collection<? extends Map<K, ? extends A>> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Map<K, A> fold(@NotNull List<? extends Map<K, ? extends A>> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Map<K, A> plus(@NotNull Map<K, ? extends A> $this$plus, @NotNull Map<K, ? extends A> b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Map<K, A> maybeCombine(@NotNull Map<K, ? extends A> $this$maybeCombine, @Nullable Map<K, ? extends A> b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$AndMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Boolean;", "combine", "b", "(ZZ)Ljava/lang/Boolean;", "arrow-core"})
        private static final class AndMonoid
        implements Monoid<Boolean> {
            @NotNull
            public static final AndMonoid INSTANCE = new AndMonoid();

            private AndMonoid() {
            }

            @Override
            @NotNull
            public Boolean combine(boolean $this$combine, boolean b) {
                return $this$combine && b;
            }

            @Override
            @NotNull
            public Boolean empty() {
                return true;
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Boolean combineAll(@NotNull Collection<Boolean> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Boolean combineAll(@NotNull List<Boolean> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Boolean fold(@NotNull Collection<Boolean> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Boolean fold(@NotNull List<Boolean> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Boolean plus(boolean $this$plus, boolean b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Boolean maybeCombine(boolean $this$maybeCombine, @Nullable Boolean b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$ByteMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Byte;", "combine", "b", "(BB)Ljava/lang/Byte;", "arrow-core"})
        private static final class ByteMonoid
        implements Monoid<Byte> {
            @NotNull
            public static final ByteMonoid INSTANCE = new ByteMonoid();

            private ByteMonoid() {
            }

            @Override
            @NotNull
            public Byte empty() {
                return (byte)0;
            }

            @Override
            @NotNull
            public Byte combine(byte $this$combine, byte b) {
                return (byte)($this$combine + b);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Byte combineAll(@NotNull Collection<Byte> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Byte combineAll(@NotNull List<Byte> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Byte fold(@NotNull Collection<Byte> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Byte fold(@NotNull List<Byte> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Byte plus(byte $this$plus, byte b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Byte maybeCombine(byte $this$maybeCombine, @Nullable Byte b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$DoubleMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Double;", "combine", "b", "(DD)Ljava/lang/Double;", "arrow-core"})
        private static final class DoubleMonoid
        implements Monoid<Double> {
            @NotNull
            public static final DoubleMonoid INSTANCE = new DoubleMonoid();

            private DoubleMonoid() {
            }

            @Override
            @NotNull
            public Double empty() {
                return 0.0;
            }

            @Override
            @NotNull
            public Double combine(double $this$combine, double b) {
                return $this$combine + b;
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Double combineAll(@NotNull Collection<Double> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Double combineAll(@NotNull List<Double> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Double fold(@NotNull Collection<Double> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Double fold(@NotNull List<Double> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Double plus(double $this$plus, double b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Double maybeCombine(double $this$maybeCombine, @Nullable Double b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$IntMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Integer;", "combine", "b", "(II)Ljava/lang/Integer;", "arrow-core"})
        private static final class IntMonoid
        implements Monoid<Integer> {
            @NotNull
            public static final IntMonoid INSTANCE = new IntMonoid();

            private IntMonoid() {
            }

            @Override
            @NotNull
            public Integer empty() {
                return 0;
            }

            @Override
            @NotNull
            public Integer combine(int $this$combine, int b) {
                return $this$combine + b;
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Integer combineAll(@NotNull Collection<Integer> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Integer combineAll(@NotNull List<Integer> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Integer fold(@NotNull Collection<Integer> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Integer fold(@NotNull List<Integer> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Integer plus(int $this$plus, int b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Integer maybeCombine(int $this$maybeCombine, @Nullable Integer b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$LongMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Long;", "combine", "b", "(JJ)Ljava/lang/Long;", "arrow-core"})
        private static final class LongMonoid
        implements Monoid<Long> {
            @NotNull
            public static final LongMonoid INSTANCE = new LongMonoid();

            private LongMonoid() {
            }

            @Override
            @NotNull
            public Long empty() {
                return 0L;
            }

            @Override
            @NotNull
            public Long combine(long $this$combine, long b) {
                return $this$combine + b;
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Long combineAll(@NotNull Collection<Long> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Long combineAll(@NotNull List<Long> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Long fold(@NotNull Collection<Long> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Long fold(@NotNull List<Long> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Long plus(long $this$plus, long b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Long maybeCombine(long $this$maybeCombine, @Nullable Long b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$ShortMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Short;", "combine", "b", "(SS)Ljava/lang/Short;", "arrow-core"})
        private static final class ShortMonoid
        implements Monoid<Short> {
            @NotNull
            public static final ShortMonoid INSTANCE = new ShortMonoid();

            private ShortMonoid() {
            }

            @Override
            @NotNull
            public Short empty() {
                return (short)0;
            }

            @Override
            @NotNull
            public Short combine(short $this$combine, short b) {
                return (short)($this$combine + b);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Short combineAll(@NotNull Collection<Short> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Short combineAll(@NotNull List<Short> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Short fold(@NotNull Collection<Short> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Short fold(@NotNull List<Short> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Short plus(short $this$plus, short b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Short maybeCombine(short $this$maybeCombine, @Nullable Short b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$FloatMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Float;", "combine", "b", "(FF)Ljava/lang/Float;", "arrow-core"})
        private static final class FloatMonoid
        implements Monoid<Float> {
            @NotNull
            public static final FloatMonoid INSTANCE = new FloatMonoid();

            private FloatMonoid() {
            }

            @Override
            @NotNull
            public Float empty() {
                return Float.valueOf(0.0f);
            }

            @Override
            @NotNull
            public Float combine(float $this$combine, float b) {
                return Float.valueOf($this$combine + b);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Float combineAll(@NotNull Collection<Float> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Float combineAll(@NotNull List<Float> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Float fold(@NotNull Collection<Float> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Float fold(@NotNull List<Float> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Float plus(float $this$plus, float b) {
                return DefaultImpls.plus(this, Float.valueOf($this$plus), Float.valueOf(b));
            }

            @Override
            @NotNull
            public Float maybeCombine(float $this$maybeCombine, @Nullable Float b) {
                return DefaultImpls.maybeCombine(this, Float.valueOf($this$maybeCombine), b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Larrow/typeclasses/Monoid$Companion$StringMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "combine", "b", "arrow-core"})
        private static final class StringMonoid
        implements Monoid<String> {
            @NotNull
            public static final StringMonoid INSTANCE = new StringMonoid();

            private StringMonoid() {
            }

            @Override
            @NotNull
            public String combine(@NotNull String $this$combine, @NotNull String b) {
                Intrinsics.checkNotNullParameter((Object)$this$combine, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return $this$combine + b;
            }

            @Override
            @NotNull
            public String empty() {
                return "";
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public String combineAll(@NotNull Collection<String> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public String combineAll(@NotNull List<String> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public String fold(@NotNull Collection<String> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public String fold(@NotNull List<String> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public String plus(@NotNull String $this$plus, @NotNull String b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public String maybeCombine(@NotNull String $this$maybeCombine, @Nullable String b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016J,\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016\u00a8\u0006\b"}, d2={"Larrow/typeclasses/Monoid$Companion$ListMonoid;", "Larrow/typeclasses/Monoid;", "", "", "()V", "empty", "combine", "b", "arrow-core"})
        private static final class ListMonoid
        implements Monoid<List<? extends Object>> {
            @NotNull
            public static final ListMonoid INSTANCE = new ListMonoid();

            private ListMonoid() {
            }

            @Override
            @NotNull
            public List<Object> empty() {
                return CollectionsKt.emptyList();
            }

            @Override
            @NotNull
            public List<Object> combine(@NotNull List<? extends Object> $this$combine, @NotNull List<? extends Object> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return CollectionsKt.plus((Collection)$this$combine, (Iterable)b);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public List<Object> combineAll(@NotNull Collection<? extends List<? extends Object>> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public List<Object> combineAll(@NotNull List<? extends List<? extends Object>> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public List<Object> fold(@NotNull Collection<? extends List<? extends Object>> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public List<Object> fold(@NotNull List<? extends List<? extends Object>> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public List<Object> plus(@NotNull List<? extends Object> $this$plus, @NotNull List<? extends Object> b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public List<Object> maybeCombine(@NotNull List<? extends Object> $this$maybeCombine, @Nullable List<? extends Object> b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016J,\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016\u00a8\u0006\b"}, d2={"Larrow/typeclasses/Monoid$Companion$SequenceMonoid;", "Larrow/typeclasses/Monoid;", "Lkotlin/sequences/Sequence;", "", "()V", "empty", "combine", "b", "arrow-core"})
        private static final class SequenceMonoid
        implements Monoid<Sequence<? extends Object>> {
            @NotNull
            public static final SequenceMonoid INSTANCE = new SequenceMonoid();

            private SequenceMonoid() {
            }

            @Override
            @NotNull
            public Sequence<Object> empty() {
                return SequencesKt.emptySequence();
            }

            @Override
            @NotNull
            public Sequence<Object> combine(@NotNull Sequence<? extends Object> $this$combine, @NotNull Sequence<? extends Object> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                Object[] objectArray = new Sequence[]{$this$combine, b};
                return SequenceKt.flatten(SequencesKt.sequenceOf((Object[])objectArray));
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Sequence<Object> combineAll(@NotNull Collection<? extends Sequence<? extends Object>> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Sequence<Object> combineAll(@NotNull List<? extends Sequence<? extends Object>> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Sequence<Object> fold(@NotNull Collection<? extends Sequence<? extends Object>> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Sequence<Object> fold(@NotNull List<? extends Sequence<? extends Object>> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Sequence<Object> plus(@NotNull Sequence<? extends Object> $this$plus, @NotNull Sequence<? extends Object> b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Sequence<Object> maybeCombine(@NotNull Sequence<? extends Object> $this$maybeCombine, @Nullable Sequence<? extends Object> b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J.\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00040\fH\u0016J8\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J*\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00040\u000fH\u0016J:\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0004H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Larrow/typeclasses/Monoid$Companion$EitherMonoid;", "L", "R", "Larrow/typeclasses/Monoid;", "Larrow/core/Either;", "SGOL", "Larrow/typeclasses/Semigroup;", "MOR", "(Larrow/typeclasses/Semigroup;Larrow/typeclasses/Monoid;)V", "empty", "fold", "elems", "", "combine", "b", "", "maybeCombine", "arrow-core"})
        private static final class EitherMonoid<L, R>
        implements Monoid<Either<? extends L, ? extends R>> {
            @NotNull
            private final Semigroup<L> SGOL;
            @NotNull
            private final Monoid<R> MOR;

            public EitherMonoid(@NotNull Semigroup<L> SGOL, @NotNull Monoid<R> MOR) {
                Intrinsics.checkNotNullParameter(SGOL, (String)"SGOL");
                Intrinsics.checkNotNullParameter(MOR, (String)"MOR");
                this.SGOL = SGOL;
                this.MOR = MOR;
            }

            @Override
            @NotNull
            public Either<L, R> empty() {
                return new Either.Right<R>(this.MOR.empty());
            }

            @Override
            @NotNull
            public Either<L, R> combine(@NotNull Either<? extends L, ? extends R> $this$combine, @NotNull Either<? extends L, ? extends R> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return EitherKt.combine($this$combine, this.SGOL, (Semigroup)this.MOR, b);
            }

            @Override
            @NotNull
            public Either<L, R> fold(@NotNull Collection<? extends Either<? extends L, ? extends R>> $this$fold) {
                Intrinsics.checkNotNullParameter($this$fold, (String)"<this>");
                return IterableKt.fold((Iterable)$this$fold, $$INSTANCE.either(this.SGOL, this.MOR));
            }

            @Override
            @NotNull
            public Either<L, R> fold(@NotNull List<? extends Either<? extends L, ? extends R>> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return IterableKt.fold((Iterable)elems, $$INSTANCE.either(this.SGOL, this.MOR));
            }

            @Override
            @NotNull
            public Either<L, R> maybeCombine(@NotNull Either<? extends L, ? extends R> $this$maybeCombine, @Nullable Either<? extends L, ? extends R> b) {
                Either<L, R> either2;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"<this>");
                        either2 = b;
                        if (either2 == null) break block2;
                        Either<L, R> it = either2;
                        boolean bl = false;
                        Either<L, R> either3 = EitherKt.combine($this$maybeCombine, this.SGOL, (Semigroup)this.MOR, it);
                        either2 = either3;
                        if (either3 != null) break block3;
                    }
                    either2 = $this$maybeCombine;
                }
                return either2;
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Either<L, R> combineAll(@NotNull Collection<? extends Either<? extends L, ? extends R>> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Either<L, R> combineAll(@NotNull List<? extends Either<? extends L, ? extends R>> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Either<L, R> plus(@NotNull Either<? extends L, ? extends R> $this$plus, @NotNull Either<? extends L, ? extends R> b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J8\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Larrow/typeclasses/Monoid$Companion$PairMonoid;", "A", "B", "Larrow/typeclasses/Monoid;", "Lkotlin/Pair;", "MA", "MB", "(Larrow/typeclasses/Monoid;Larrow/typeclasses/Monoid;)V", "empty", "combine", "b", "arrow-core"})
        private static final class PairMonoid<A, B>
        implements Monoid<Pair<? extends A, ? extends B>> {
            @NotNull
            private final Monoid<A> MA;
            @NotNull
            private final Monoid<B> MB;

            public PairMonoid(@NotNull Monoid<A> MA, @NotNull Monoid<B> MB) {
                Intrinsics.checkNotNullParameter(MA, (String)"MA");
                Intrinsics.checkNotNullParameter(MB, (String)"MB");
                this.MA = MA;
                this.MB = MB;
            }

            @Override
            @NotNull
            public Pair<A, B> empty() {
                return new Pair(this.MA.empty(), this.MB.empty());
            }

            @Override
            @NotNull
            public Pair<A, B> combine(@NotNull Pair<? extends A, ? extends B> $this$combine, @NotNull Pair<? extends A, ? extends B> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"<this>");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return TupleNKt.combine($this$combine, this.MA, (Semigroup)this.MB, b);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
            @NotNull
            public Pair<A, B> combineAll(@NotNull Collection<? extends Pair<? extends A, ? extends B>> $this$combineAll) {
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
            @NotNull
            public Pair<A, B> combineAll(@NotNull List<? extends Pair<? extends A, ? extends B>> elems) {
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Pair<A, B> fold(@NotNull Collection<? extends Pair<? extends A, ? extends B>> $this$fold) {
                return DefaultImpls.fold(this, $this$fold);
            }

            @Override
            @NotNull
            public Pair<A, B> fold(@NotNull List<? extends Pair<? extends A, ? extends B>> elems) {
                return DefaultImpls.fold(this, elems);
            }

            @Override
            @NotNull
            public Pair<A, B> plus(@NotNull Pair<? extends A, ? extends B> $this$plus, @NotNull Pair<? extends A, ? extends B> b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Pair<A, B> maybeCombine(@NotNull Pair<? extends A, ? extends B> $this$maybeCombine, @Nullable Pair<? extends A, ? extends B> b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold()", imports={}))
        public static <A> A combineAll(@NotNull Monoid<A> $this, @NotNull Collection<? extends A> $receiver) {
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            return $this.fold($receiver);
        }

        @Deprecated(message="use fold instead", replaceWith=@ReplaceWith(expression="fold(elems)", imports={}))
        public static <A> A combineAll(@NotNull Monoid<A> $this, @NotNull List<? extends A> elems) {
            Intrinsics.checkNotNullParameter(elems, (String)"elems");
            return $this.fold(elems);
        }

        /*
         * WARNING - void declaration
         */
        public static <A> A fold(@NotNull Monoid<A> $this, @NotNull Collection<? extends A> $receiver) {
            Object object;
            Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
            if ($receiver.isEmpty()) {
                object = $this.empty();
            } else {
                Iterable $this$reduce$iv = $receiver;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void b;
                    Object t = iterator$iv.next();
                    Object a = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = $this.combine((void)a, b);
                }
                object = accumulator$iv;
            }
            return object;
        }

        public static <A> A fold(@NotNull Monoid<A> $this, @NotNull List<? extends A> elems) {
            Intrinsics.checkNotNullParameter(elems, (String)"elems");
            return $this.fold((Collection)elems);
        }

        public static <A> A plus(@NotNull Monoid<A> $this, A $receiver, A b) {
            return Semigroup.DefaultImpls.plus($this, $receiver, b);
        }

        public static <A> A maybeCombine(@NotNull Monoid<A> $this, A $receiver, @Nullable A b) {
            return Semigroup.DefaultImpls.maybeCombine($this, $receiver, b);
        }
    }
}

