/*
 * Decompiled with CFR 0.152.
 */
package astraea.spark.rasterframes.datasource.geotrellis;

import astraea.spark.rasterframes.datasource.geotrellis.GeoTrellisRelation;
import astraea.spark.rasterframes.datasource.geotrellis.GeoTrellisRelation$;
import astraea.spark.rasterframes.datasource.geotrellis.SpatialFilterPushdownRules$;
import astraea.spark.rasterframes.package$;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Tile;
import geotrellis.spark.LayerId;
import geotrellis.spark.SpaceTimeKey;
import geotrellis.spark.SpaceTimeKey$;
import geotrellis.spark.SpatialKey;
import geotrellis.spark.TileLayerMetadata$;
import geotrellis.spark.io.LayerWriter;
import geotrellis.spark.io.LayerWriter$;
import geotrellis.spark.io.avro.AvroRecordCodec;
import geotrellis.spark.io.index.ZCurveKeyIndexMethod;
import geotrellis.spark.io.index.ZCurveKeyIndexMethod$;
import geotrellis.util.GetComponent;
import java.net.URI;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Either;
import scala.util.Try$;
import spray.json.JsonFormat;

@Experimental
@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u001b\tiA)\u001a4bk2$8k\\;sG\u0016T!a\u0001\u0003\u0002\u0015\u001d,w\u000e\u001e:fY2L7O\u0003\u0002\u0006\r\u0005QA-\u0019;bg>,(oY3\u000b\u0005\u001dA\u0011\u0001\u0004:bgR,'O\u001a:b[\u0016\u001c(BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\u0005Y\u0011aB1tiJ\fW-Y\u0002\u0001'\u0015\u0001a\u0002F\u0011%!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QcH\u0007\u0002-)\u0011q\u0003G\u0001\bg>,(oY3t\u0015\tI\"$A\u0002tc2T!!C\u000e\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0005\u0003AY\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011QCI\u0005\u0003GY\u0011\u0001CU3mCRLwN\u001c)s_ZLG-\u001a:\u0011\u0005U)\u0013B\u0001\u0014\u0017\u0005e\u0019%/Z1uC\ndWMU3mCRLwN\u001c)s_ZLG-\u001a:\t\u000b!\u0002A\u0011A\u0015\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0016\u0001\u001b\u0005\u0011\u0001\"B\u0017\u0001\t\u0003q\u0013!C:i_J$h*Y7f)\u0005y\u0003C\u0001\u00194\u001d\ty\u0011'\u0003\u00023!\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u0011\u0004\u0003C\u00038\u0001\u0011\u0005\u0001(\u0001\bde\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8\u0015\u0007eb$\t\u0005\u0002\u0016u%\u00111H\u0006\u0002\r\u0005\u0006\u001cXMU3mCRLwN\u001c\u0005\u0006{Y\u0002\rAP\u0001\u000bgFd7i\u001c8uKb$\bCA A\u001b\u0005A\u0012BA!\u0019\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\u0006\u0007Z\u0002\r\u0001R\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003\u0002\u0019F_=J!AR\u001b\u0003\u00075\u000b\u0007\u000fC\u00038\u0001\u0011\u0005\u0001\nF\u0003:\u0013*{\u0005\u000bC\u0003>\u000f\u0002\u0007a\bC\u0003L\u000f\u0002\u0007A*\u0001\u0003n_\u0012,\u0007CA N\u0013\tq\u0005D\u0001\u0005TCZ,Wj\u001c3f\u0011\u0015\u0019u\t1\u0001E\u0011\u0015\tv\t1\u0001S\u0003\u0011!\u0017\r^1\u0011\u0005M\u000bgB\u0001+`\u001d\t)fL\u0004\u0002W;:\u0011q\u000b\u0018\b\u00031nk\u0011!\u0017\u0006\u000352\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0005qi\u0012BA\u0005\u001c\u0013\tI\"$\u0003\u0002a1\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002a1!\u0012\u0001!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Qj\t!\"\u00198o_R\fG/[8o\u0013\tQwM\u0001\u0007FqB,'/[7f]R\fG\u000e")
public class DefaultSource
implements DataSourceRegister,
RelationProvider,
CreatableRelationProvider {
    public String shortName() {
        return "geotrellis";
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        Predef$.MODULE$.require(parameters.contains((Object)"path"), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'path' parameter required.";
            }
        });
        Predef$.MODULE$.require(parameters.contains((Object)"layer"), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'layer' parameter for raster layer name required.";
            }
        });
        Predef$.MODULE$.require(parameters.contains((Object)"zoom"), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'zoom' parameter for raster layer zoom level required.";
            }
        });
        package$.MODULE$.WithSQLContextMethods(sqlContext).withRasterFrames();
        astraea.spark.rasterframes.rules.package$.MODULE$.registerOptimization(sqlContext, (Rule)SpatialFilterPushdownRules$.MODULE$);
        URI uri = URI.create((String)parameters.apply((Object)"path"));
        LayerId layerId = new LayerId((String)parameters.apply((Object)"layer"), new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)"zoom"))).toInt());
        Option numPartitions = parameters.get((Object)"numPartitions").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        });
        boolean failOnUnrecognizedFilter = parameters.get((Object)"failOnUnrecognizedFilter").exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
            }
        });
        return new GeoTrellisRelation(sqlContext, uri, layerId, (Option<Object>)numPartitions, failOnUnrecognizedFilter, GeoTrellisRelation$.MODULE$.apply$default$6());
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        Object object;
        ObjectRef writer$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Option zoom = parameters.get((Object)"zoom").flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(String p) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final String p$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.p$1)).toInt();
                    }
                    {
                        this.p$1 = p$1;
                    }
                }).toOption();
            }
        });
        Option path = parameters.get((Object)"path").flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<URI> apply(String p) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final String p$2;

                    public final URI apply() {
                        return new URI(this.p$2);
                    }
                    {
                        this.p$2 = p$2;
                    }
                }).toOption();
            }
        });
        Option layerName = parameters.get((Object)"layer");
        Predef$.MODULE$.require(path.isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Valid URI 'path' parameter required.";
            }
        });
        Predef$.MODULE$.require(layerName.isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'layer' parameter for raster layer name required.";
            }
        });
        Predef$.MODULE$.require(zoom.isDefined(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Integer 'zoom' parameter for raster layer zoom level required.";
            }
        });
        Dataset rf = (Dataset)package$.MODULE$.WithDataFrameMethods(data).asRFSafely().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException("Only a valid RasterFrame can be saved as a GeoTrellis layer");
            }
        });
        Option tileColumn = parameters.get((Object)"tileColumn").map((Function1)new Serializable(this, rf){
            public static final long serialVersionUID = 0L;
            private final Dataset rf$1;

            public final Column apply(String c) {
                return this.rf$1.apply(c);
            }
            {
                this.rf$1 = rf$1;
            }
        });
        Option layerId = layerName.flatMap((Function1)new Serializable(this, zoom){
            public static final long serialVersionUID = 0L;
            private final Option zoom$1;

            public final Option<LayerId> apply(String name) {
                return this.zoom$1.map((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final LayerId apply(int z) {
                        return new LayerId(this.name$1, z);
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
            }
            {
                this.zoom$1 = zoom$1;
            }
        });
        if (tileColumn.isDefined() || package$.MODULE$.WithDataFrameMethods(rf).tileColumns().length() == 1) {
            Column tileCol = (Column)tileColumn.getOrElse((Function0)new Serializable(this, rf){
                public static final long serialVersionUID = 0L;
                private final Dataset rf$1;

                public final TypedColumn<Object, Tile> apply() {
                    return (TypedColumn)package$.MODULE$.WithDataFrameMethods(this.rf$1).tileColumns().head();
                }
                {
                    this.rf$1 = rf$1;
                }
            });
            Either eitherRDD = package$.MODULE$.WithRasterFrameMethods(rf).toTileLayerRDD(tileCol);
            object = eitherRDD.fold((Function1)new Serializable(this, path, layerId, writer$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultSource $outer;
                private final Option path$1;
                private final Option layerId$1;
                private final ObjectRef writer$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final void apply(RDD<Tuple2<SpatialKey, Tile>> skLayer) {
                    this.$outer.astraea$spark$rasterframes$datasource$geotrellis$DefaultSource$$writer$1(this.path$1, this.writer$lzy$1, this.bitmap$0$1).write(this.layerId$1.get(), skLayer, ZCurveKeyIndexMethod$.MODULE$.spatialKeyIndexMethod((ZCurveKeyIndexMethod)ZCurveKeyIndexMethod$.MODULE$), geotrellis.spark.io.package$.MODULE$.spatialKeyAvroFormat(), (JsonFormat)geotrellis.spark.io.package$.MODULE$.SpatialKeyFormat(), ClassTag$.MODULE$.apply(SpatialKey.class), (AvroRecordCodec)geotrellis.spark.io.package$.MODULE$.tileUnionCodec(), ClassTag$.MODULE$.apply(Tile.class), (JsonFormat)geotrellis.spark.io.package$.MODULE$.tileLayerMetadataFormat(geotrellis.util.package$.MODULE$.identityComponent(), (JsonFormat)geotrellis.spark.io.package$.MODULE$.SpatialKeyFormat()), (GetComponent)TileLayerMetadata$.MODULE$.boundsComponent(geotrellis.util.package$.MODULE$.identityComponent()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.path$1 = path$1;
                    this.layerId$1 = layerId$1;
                    this.writer$lzy$1 = writer$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }, (Function1)new Serializable(this, path, layerId, writer$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultSource $outer;
                private final Option path$1;
                private final Option layerId$1;
                private final ObjectRef writer$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final void apply(RDD<Tuple2<SpaceTimeKey, Tile>> stkLayer) {
                    this.$outer.astraea$spark$rasterframes$datasource$geotrellis$DefaultSource$$writer$1(this.path$1, this.writer$lzy$1, this.bitmap$0$1).write(this.layerId$1.get(), stkLayer, ZCurveKeyIndexMethod$.MODULE$.byDay(), geotrellis.spark.io.package$.MODULE$.spaceTimeKeyAvroFormat(), (JsonFormat)geotrellis.spark.io.package$.MODULE$.SpaceTimeKeyFormat(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), (AvroRecordCodec)geotrellis.spark.io.package$.MODULE$.tileUnionCodec(), ClassTag$.MODULE$.apply(Tile.class), (JsonFormat)geotrellis.spark.io.package$.MODULE$.tileLayerMetadataFormat(SpaceTimeKey$.MODULE$.spatialComponent(), (JsonFormat)geotrellis.spark.io.package$.MODULE$.SpaceTimeKeyFormat()), (GetComponent)TileLayerMetadata$.MODULE$.boundsComponent(SpaceTimeKey$.MODULE$.spatialComponent()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.path$1 = path$1;
                    this.layerId$1 = layerId$1;
                    this.writer$lzy$1 = writer$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        } else {
            object = package$.MODULE$.WithRasterFrameMethods(rf).toMultibandTileLayerRDD().fold((Function1)new Serializable(this, path, layerId, writer$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultSource $outer;
                private final Option path$1;
                private final Option layerId$1;
                private final ObjectRef writer$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final void apply(RDD<Tuple2<SpatialKey, MultibandTile>> skLayer) {
                    this.$outer.astraea$spark$rasterframes$datasource$geotrellis$DefaultSource$$writer$1(this.path$1, this.writer$lzy$1, this.bitmap$0$1).write(this.layerId$1.get(), skLayer, ZCurveKeyIndexMethod$.MODULE$.spatialKeyIndexMethod((ZCurveKeyIndexMethod)ZCurveKeyIndexMethod$.MODULE$), geotrellis.spark.io.package$.MODULE$.spatialKeyAvroFormat(), (JsonFormat)geotrellis.spark.io.package$.MODULE$.SpatialKeyFormat(), ClassTag$.MODULE$.apply(SpatialKey.class), geotrellis.spark.io.package$.MODULE$.multibandTileCodec(), ClassTag$.MODULE$.apply(MultibandTile.class), (JsonFormat)geotrellis.spark.io.package$.MODULE$.tileLayerMetadataFormat(geotrellis.util.package$.MODULE$.identityComponent(), (JsonFormat)geotrellis.spark.io.package$.MODULE$.SpatialKeyFormat()), (GetComponent)TileLayerMetadata$.MODULE$.boundsComponent(geotrellis.util.package$.MODULE$.identityComponent()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.path$1 = path$1;
                    this.layerId$1 = layerId$1;
                    this.writer$lzy$1 = writer$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }, (Function1)new Serializable(this, path, layerId, writer$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultSource $outer;
                private final Option path$1;
                private final Option layerId$1;
                private final ObjectRef writer$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final void apply(RDD<Tuple2<SpaceTimeKey, MultibandTile>> stkLayer) {
                    this.$outer.astraea$spark$rasterframes$datasource$geotrellis$DefaultSource$$writer$1(this.path$1, this.writer$lzy$1, this.bitmap$0$1).write(this.layerId$1.get(), stkLayer, ZCurveKeyIndexMethod$.MODULE$.byDay(), geotrellis.spark.io.package$.MODULE$.spaceTimeKeyAvroFormat(), (JsonFormat)geotrellis.spark.io.package$.MODULE$.SpaceTimeKeyFormat(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), geotrellis.spark.io.package$.MODULE$.multibandTileCodec(), ClassTag$.MODULE$.apply(MultibandTile.class), (JsonFormat)geotrellis.spark.io.package$.MODULE$.tileLayerMetadataFormat(SpaceTimeKey$.MODULE$.spatialComponent(), (JsonFormat)geotrellis.spark.io.package$.MODULE$.SpaceTimeKeyFormat()), (GetComponent)TileLayerMetadata$.MODULE$.boundsComponent(SpaceTimeKey$.MODULE$.spatialComponent()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.path$1 = path$1;
                    this.layerId$1 = layerId$1;
                    this.writer$lzy$1 = writer$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        }
        return this.createRelation(sqlContext, parameters);
    }

    private final LayerWriter writer$lzycompute$1(Option path$1, ObjectRef writer$lzy$1, VolatileByteRef bitmap$0$1) {
        DefaultSource defaultSource = this;
        synchronized (defaultSource) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                writer$lzy$1.elem = LayerWriter$.MODULE$.apply((URI)path$1.get());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (LayerWriter)writer$lzy$1.elem;
        }
    }

    public final LayerWriter astraea$spark$rasterframes$datasource$geotrellis$DefaultSource$$writer$1(Option path$1, ObjectRef writer$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.writer$lzycompute$1(path$1, writer$lzy$1, bitmap$0$1) : (LayerWriter)writer$lzy$1.elem;
    }
}

