/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasUtil;
import io.atlasmap.v2.ComplexType;
import io.atlasmap.v2.Document;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Fields;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AtlasUtilTest {
    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty(null));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty((String)""));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty((String)"     "));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty((String)"\n\n"));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty((String)"\t\t"));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty((String)"\r\n"));
        Assertions.assertTrue((boolean)AtlasUtil.isEmpty((String)"\f\t\n\r"));
        Assertions.assertFalse((boolean)AtlasUtil.isEmpty((String)"\b"));
    }

    @Test
    public void testAtlasUri() {
        Map params;
        String uriJavaNover = "atlas:java";
        String uriJavaNoverWParm = "atlas:java?foo=bar";
        String uriJavaNoverWParms = "atlas:java?foo=bar&bar=blah";
        String uriJavaVer1 = "atlas:java::1";
        String uriJavaVer2 = "atlas:java::2";
        String uriJavaVer2WParm = "atlas:java::2?foo=bar";
        String uriJavaVer2WParams = "atlas:java::2?foo=bar&bar=blah";
        List<String> javaUris = Arrays.asList(uriJavaNover, uriJavaNoverWParm, uriJavaNoverWParms, uriJavaVer1, uriJavaVer2, uriJavaVer2WParm, uriJavaVer2WParams);
        List<String> noverUris = Arrays.asList(uriJavaNover, uriJavaNoverWParm, uriJavaNoverWParms);
        List<String> javaVer1Uris = Arrays.asList(uriJavaVer1);
        List<String> javaVer2Uris = Arrays.asList(uriJavaVer2, uriJavaVer2WParm, uriJavaVer2WParams);
        List<String> parmUris = Arrays.asList(uriJavaNoverWParm, uriJavaVer2WParm);
        List<String> parmsUris = Arrays.asList(uriJavaNoverWParms, uriJavaVer2WParams);
        for (String uri : javaUris) {
            Assertions.assertEquals((Object)"atlas", (Object)AtlasUtil.getUriScheme((String)uri));
        }
        for (String uri : javaUris) {
            Assertions.assertEquals((Object)"java", (Object)AtlasUtil.getUriModule((String)uri));
        }
        for (String uri : javaUris) {
            Assertions.assertNull((Object)AtlasUtil.getUriDataType((String)uri));
        }
        for (String uri : noverUris) {
            Assertions.assertNull((Object)AtlasUtil.getUriModuleVersion((String)uri));
        }
        for (String uri : javaVer1Uris) {
            Assertions.assertEquals((Object)"1", (Object)AtlasUtil.getUriModuleVersion((String)uri));
        }
        for (String uri : javaVer2Uris) {
            Assertions.assertEquals((Object)"2", (Object)AtlasUtil.getUriModuleVersion((String)uri));
        }
        for (String uri : parmUris) {
            params = AtlasUtil.getUriParameters((String)uri);
            Assertions.assertNotNull((Object)params);
            Assertions.assertEquals((Integer)1, (Integer)params.size());
            Assertions.assertEquals((Object)"bar", params.get("foo"));
            Assertions.assertNull(params.get("bar"));
        }
        for (String uri : parmsUris) {
            params = AtlasUtil.getUriParameters((String)uri);
            Assertions.assertNotNull((Object)params);
            Assertions.assertEquals((Integer)2, (Integer)params.size());
            Assertions.assertEquals((Object)"bar", params.get("foo"));
            Assertions.assertEquals((Object)"blah", params.get("bar"));
            Assertions.assertNull(params.get("blah"));
        }
    }

    @Test
    public void testGetUriDataType() {
        Assertions.assertEquals((Object)"util", (Object)AtlasUtil.getUriDataType((String)"atlas:java:util?param1=value1&param2=value2"));
    }

    @Test
    public void testLoadPropertiesFromURL() throws Exception {
        URL url = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "AtlasUtilTest.properties", new String[0]).toUri().toURL();
        Properties properties = AtlasUtil.loadPropertiesFromURL((URL)url);
        Assertions.assertNotNull((Object)properties);
        Assertions.assertEquals((Object)"value1", (Object)properties.get("key1"));
        Assertions.assertEquals((Object)"value2", (Object)properties.get("key2"));
    }

    @Test
    public void testLoadPropertiesFromURLNullPointerException() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> AtlasUtil.loadPropertiesFromURL(null));
    }

    @Test
    public void testLoadPropertiesFromURLMalformedURLException() throws Exception {
        Assertions.assertThrows(MalformedURLException.class, () -> AtlasUtil.loadPropertiesFromURL((URL)new URL("invalid URL")));
    }

    @Test
    public void testMatchUriModule() {
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule(null, null));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule(null, (String)"atlas:java"));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule((String)"atlas:java", null));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule((String)"", (String)""));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule((String)"atlas:java", (String)""));
        Assertions.assertFalse((boolean)AtlasUtil.matchUriModule((String)"", (String)"atlas:java"));
        Assertions.assertTrue((boolean)AtlasUtil.matchUriModule((String)"atlas:java", (String)"atlas:java"));
    }

    @Test
    public void testValidateUriIllegalStateException() {
        Assertions.assertThrows(IllegalStateException.class, () -> AtlasUtil.validateUri((String)"java:atlas"));
    }

    @Test
    public void testValidateUriIllegalStateExceptionMultipleQuestionMark() {
        Assertions.assertThrows(IllegalStateException.class, () -> AtlasUtil.validateUri((String)"atlas:?java?"));
    }

    @Test
    public void testValidateUriSingleQuestionMark() {
        AtlasUtil.validateUri((String)"atlas:java?");
    }

    @Test
    public void testValidateUri() {
        AtlasUtil.validateUri((String)"atlas:java");
    }

    @Test
    public void testGetUriPartsAsArray() {
        Assertions.assertNull((Object)AtlasUtil.getUriPartsAsArray(null));
        Assertions.assertEquals((int)2, (int)AtlasUtil.getUriPartsAsArray((String)"atlas:?java").size());
        Assertions.assertEquals((int)2, (int)AtlasUtil.getUriPartsAsArray((String)"atlas:?").size());
        Assertions.assertEquals((int)2, (int)AtlasUtil.getUriPartsAsArray((String)"atlas:").size());
    }

    @Test
    public void testGetUriScheme() {
        Assertions.assertNull((Object)AtlasUtil.getUriScheme(null));
    }

    @Test
    public void testGetUriParameters() {
        Assertions.assertNull((Object)AtlasUtil.getUriParameters(null));
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters((String)"").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters((String)"atlas:").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters((String)"atlas:?").size());
        Assertions.assertEquals((int)2, (int)AtlasUtil.getUriParameters((String)"atlas:?param1=value1&param2=value2").size());
        Assertions.assertEquals((int)1, (int)AtlasUtil.getUriParameters((String)"atlas:?param1=value1&param2=").size());
        Assertions.assertEquals((int)1, (int)AtlasUtil.getUriParameters((String)"atlas:?param1=&param2=value2").size());
        Assertions.assertEquals((int)1, (int)AtlasUtil.getUriParameters((String)"atlas:?=&param2=value2").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters((String)"atlas:?=").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters((String)"atlas:?&").size());
        Assertions.assertEquals((int)0, (int)AtlasUtil.getUriParameters((String)"atlas:?p").size());
    }

    @Test
    public void testGetUriParametersIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AtlasUtil.getUriParameters((String)"atlas:?%%XX"));
    }

    @Test
    public void testGetUriParameterValue() {
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?java", (String)"java"));
        Assertions.assertEquals((Object)"value1", (Object)AtlasUtil.getUriParameterValue((String)"atlas:?param1=value1&param2=value2", (String)"param1"));
        Assertions.assertEquals((Object)"value1", (Object)AtlasUtil.getUriParameterValue((String)"atlas:?param1=value1&param2=", (String)"param1"));
        Assertions.assertEquals((Object)"value2", (Object)AtlasUtil.getUriParameterValue((String)"atlas:?param1=&param2=value2", (String)"param2"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?", (String)"java"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?param", (String)"java"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?&", (String)"java"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:?=", (String)"java"));
        Assertions.assertNull((Object)AtlasUtil.getUriParameterValue((String)"atlas:? ", (String)"java"));
    }

    @Test
    public void testToAuditStatus() {
        Assertions.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.ERROR));
        Assertions.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.WARN));
        Assertions.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.INFO));
        Assertions.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.ALL));
        Assertions.assertNotNull((Object)AtlasUtil.toAuditStatus((ValidationStatus)ValidationStatus.NONE));
    }

    @Test
    public void testExcludeNotRequestedFieldsShouldIncludeAllIfIncludePathsNull() {
        Document document = new Document();
        Fields fields = new Fields();
        fields.getField().add(this.newField("/A", this.newField("/A/A", this.newField("/A/A/A", new Field[0]), this.newField("/A/A/B", new Field[0])), this.newField("/A/B", this.newField("/A/B/A", this.newField("/A/B/A/A", new Field[0])))));
        document.setFields(fields);
        AtlasUtil.excludeNotRequestedFields((Document)document, null);
        Assertions.assertEquals((Object)"/A{/A/A{/A/A/A{}, /A/A/B{}, }, /A/B{/A/B/A{/A/B/A/A{}, }, }, }, ", (Object)((Field)fields.getField().get(0)).toString());
    }

    @Test
    public void testExcludeNotRequestedFieldsShouldIncludeAllIfIncludePathsEmpty() {
        Document document = new Document();
        Fields fields = new Fields();
        fields.getField().add(this.newField("/A", this.newField("/A/A", this.newField("/A/A/A", new Field[0]), this.newField("/A/A/B", new Field[0])), this.newField("/A/B", this.newField("/A/B/A", this.newField("/A/B/A/A", new Field[0])))));
        document.setFields(fields);
        AtlasUtil.excludeNotRequestedFields((Document)document, Collections.emptyList());
        Assertions.assertEquals((Object)"/A{/A/A{/A/A/A{}, /A/A/B{}, }, /A/B{/A/B/A{/A/B/A/A{}, }, }, }, ", (Object)((Field)fields.getField().get(0)).toString());
    }

    @Test
    public void testExcludeNotRequestedFieldsShouldIncludeRootLevel() {
        Document document = new Document();
        Fields fields = new Fields();
        fields.getField().add(this.newField("/A", this.newField("/A/A", this.newField("/A/A/A", new Field[0]), this.newField("/A/A/B", new Field[0])), this.newField("/A/B", this.newField("/A/B/A", this.newField("/A/B/A/A", new Field[0])))));
        document.setFields(fields);
        AtlasUtil.excludeNotRequestedFields((Document)document, Arrays.asList("/"));
        Assertions.assertEquals((Object)"/A{}, ", (Object)((Field)fields.getField().get(0)).toString());
    }

    @Test
    public void testExcludeNotRequestedFieldsShouldIncludeOneLevel() {
        Document document = new Document();
        Fields fields = new Fields();
        fields.getField().add(this.newField("/A", this.newField("/A/A", this.newField("/A/A/A", new Field[0]), this.newField("/A/A/B", new Field[0])), this.newField("/A/B", this.newField("/A/B/A", this.newField("/A/B/A/A", new Field[0])))));
        document.setFields(fields);
        AtlasUtil.excludeNotRequestedFields((Document)document, Arrays.asList("/A/"));
        Assertions.assertEquals((Object)"/A{/A/A{}, /A/B{}, }, ", (Object)((Field)fields.getField().get(0)).toString());
    }

    @Test
    public void testExcludeNotRequestedFieldsShouldIncludeTwoLevels() {
        Document document = new Document();
        Fields fields = new Fields();
        fields.getField().add(this.newField("/A", this.newField("/A/A", this.newField("/A/A/A", new Field[0]), this.newField("/A/A/B", new Field[0])), this.newField("/A/B", this.newField("/A/B/A", this.newField("/A/B/A/A", new Field[0])))));
        document.setFields(fields);
        AtlasUtil.excludeNotRequestedFields((Document)document, Arrays.asList("/A/B"));
        Assertions.assertEquals((Object)"/A{/A/A{}, /A/B{/A/B/A{}, }, }, ", (Object)((Field)fields.getField().get(0)).toString());
    }

    @Test
    public void testExcludeNotRequestedFieldsShouldIncludeTwoDifferentLevels() {
        Document document = new Document();
        Fields fields = new Fields();
        fields.getField().add(this.newField("/A", this.newField("/A/A", this.newField("/A/A/A", new Field[0]), this.newField("/A/A/B", new Field[0])), this.newField("/A/B", this.newField("/A/B/A", this.newField("/A/B/A/A", new Field[0])))));
        document.setFields(fields);
        AtlasUtil.excludeNotRequestedFields((Document)document, Arrays.asList("/A/A", "/A/B"));
        Assertions.assertEquals((Object)"/A{/A/A{/A/A/A{}, /A/A/B{}, }, /A/B{/A/B/A{}, }, }, ", (Object)((Field)fields.getField().get(0)).toString());
    }

    @Test
    public void testExcludeNotRequestedFieldsShouldIncludeAllIntermediateLevels() {
        Document document = new Document();
        Fields fields = new Fields();
        fields.getField().add(this.newField("/A", this.newField("/A/A", this.newField("/A/A/A", new Field[0]), this.newField("/A/A/B", new Field[0])), this.newField("/A/B", this.newField("/A/B/A", this.newField("/A/B/A/A", new Field[0])))));
        document.setFields(fields);
        AtlasUtil.excludeNotRequestedFields((Document)document, Arrays.asList("/A/A/B"));
        Assertions.assertEquals((Object)"/A{/A/A{/A/A/A{}, /A/A/B{}, }, /A/B{}, }, ", (Object)((Field)fields.getField().get(0)).toString());
    }

    private Field newField(final String fieldPath, Field ... children) {
        final ArrayList<Field> childFields = new ArrayList<Field>();
        childFields.addAll(Arrays.asList(children));
        return new ComplexField(){

            public String getPath() {
                return fieldPath;
            }

            @Override
            public List<? extends Field> getChildFields() {
                return childFields;
            }

            public String toString() {
                StringBuilder text = new StringBuilder();
                text.append(this.getPath()).append("{");
                for (Field field : this.getChildFields()) {
                    text.append(field.toString());
                }
                text.append("}, ");
                return text.toString();
            }
        };
    }

    public void testValidationToString() {
        Assertions.assertNotNull((Object)AtlasUtil.validationToString(null));
        Validation info = new Validation();
        info.setScope(ValidationScope.MAPPING);
        info.setId("0001");
        info.setMessage("Information message");
        info.setStatus(ValidationStatus.INFO);
        Assertions.assertNotNull((Object)AtlasUtil.validationToString((Validation)info));
    }

    private static class ComplexField
    extends Field
    implements ComplexType {
        private ComplexField() {
        }

        public List<? extends Field> getChildFields() {
            return null;
        }
    }
}

